/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.config;

import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreator;
import com.cyberway.mp.bc.sharding.compatible.DalMultiDatasourceCompatibleHandle;
import com.cyberway.mp.bc.sharding.compatible.LiquibaseCompatibleHandle;
import com.cyberway.mp.bc.sharding.config.ShardingDatasourceFactory;
import com.cyberway.mp.bc.sharding.config.ShardingDatasourceHolder;
import com.cyberway.mp.bc.sharding.tablescanner.DatabaseHandlerFactory;
import com.cyberway.mp.bc.sharding.tablescanner.ShardingTableInitializer;
import com.cyberway.mp.bc.sharding.tablescanner.handler.AbstractDialectDatabaseHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.DmTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.MysqlTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.OracleTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.PostgreSQLTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.SqlServerTableHandler;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.yaml.YamlJDBCConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

@Configuration
@ConditionalOnProperty(prefix="sharding", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ShardingConfiguration {
    private final YamlDataSourceConfigurationSwapper configurationSwapper = new YamlDataSourceConfigurationSwapper();
    @Value(value="${sharding.yaml-path:config/sharding-config.yaml}")
    private String shardingYamlPath;

    @Bean
    public YamlJDBCConfiguration shardingYamlJdbcConfiguration(Environment env) throws Exception {
        ClassPathResource resource = new ClassPathResource(this.shardingYamlPath);
        if (!resource.exists()) {
            throw new IllegalArgumentException("missing file:" + this.shardingYamlPath);
        }
        InputStream inputStream = resource.getInputStream();
        String yamlStr = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        yamlStr = env.resolvePlaceholders(yamlStr);
        return (YamlJDBCConfiguration)YamlEngine.unmarshal((String)yamlStr, YamlJDBCConfiguration.class);
    }

    @Bean
    public ShardingDatasourceHolder shardingDatasourceHolder(YamlJDBCConfiguration properties) {
        Map dataSourceMap = this.configurationSwapper.swapToDataSources(properties.getDataSources());
        return new ShardingDatasourceHolder(dataSourceMap);
    }

    @Bean
    public ShardingDatasourceFactory shardingDatasourceFactory(ShardingDatasourceHolder shardingDatasourceHolder, YamlJDBCConfiguration properties) {
        return new ShardingDatasourceFactory(shardingDatasourceHolder, properties);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public LiquibaseCompatibleHandle liquibaseCompatibleHandle(ShardingDatasourceHolder shardingDatasourceHolder) {
        return new LiquibaseCompatibleHandle(shardingDatasourceHolder);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.dal", name={"use-multi-datasource"}, havingValue="true")
    public DataSourceCreator dalMultiDatasourceCompatibleHandle(ShardingDatasourceFactory shardingDatasourceFactory) {
        return new DalMultiDatasourceCompatibleHandle(shardingDatasourceFactory);
    }

    @Bean
    @ConditionalOnProperty(prefix="sharding.auto-proxy-datasource", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public DataSource shardingDataSource(ShardingDatasourceFactory shardingDatasourceFactory) {
        return shardingDatasourceFactory.createDataSource();
    }

    @Bean
    public ShardingTableInitializer shardingTableInitializer(ShardingDatasourceHolder shardingDatasourceHolder, YamlJDBCConfiguration yamlJDBCConfiguration, DatabaseHandlerFactory databaseHandlerFactory) {
        return new ShardingTableInitializer(shardingDatasourceHolder, yamlJDBCConfiguration, databaseHandlerFactory);
    }

    @Bean
    public MysqlTableHandler mysqlTableStrategy() {
        return new MysqlTableHandler();
    }

    @Bean
    public SqlServerTableHandler sqlServerTableStrategy() {
        return new SqlServerTableHandler();
    }

    @Bean
    public OracleTableHandler oracleTableStrategy() {
        return new OracleTableHandler();
    }

    @Bean
    public DmTableHandler dmTableStrategy() {
        return new DmTableHandler();
    }

    @Bean
    public PostgreSQLTableHandler postgreSQLTableStrategy() {
        return new PostgreSQLTableHandler();
    }

    @Bean
    public DatabaseHandlerFactory databaseStrategyFactory(List<AbstractDialectDatabaseHandler> strategyBeans) {
        return new DatabaseHandlerFactory(strategyBeans);
    }
}

