/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.config;

import com.cyberway.mp.bc.sharding.config.ShardingDatasourceHolder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.yaml.YamlJDBCConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlGlobalRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingDatasourceFactory {
    private static final Logger log = LoggerFactory.getLogger(ShardingDatasourceFactory.class);
    private final YamlRuleConfigurationSwapperEngine swapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final ShardingDatasourceHolder shardingDatasourceHolder;
    private final YamlJDBCConfiguration properties;

    public ShardingDatasourceFactory(ShardingDatasourceHolder shardingDatasourceHolder, YamlJDBCConfiguration properties) {
        this.shardingDatasourceHolder = shardingDatasourceHolder;
        this.properties = properties;
    }

    public DataSource createDataSource() {
        Map<String, DataSource> dataSourceMap = this.shardingDatasourceHolder.getSourceMap();
        try {
            this.rebuildGlobalRuleConfiguration(this.properties);
            ModeConfiguration modeConfig = null == this.properties.getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(this.properties.getMode());
            Collection ruleConfigs = this.swapperEngine.swapToRuleConfigurations(this.properties.getRules());
            return ShardingSphereDataSourceFactory.createDataSource((String)this.properties.getDatabaseName(), (ModeConfiguration)modeConfig, dataSourceMap, (Collection)ruleConfigs, (Properties)this.properties.getProps());
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("ShardingSphere\u6784\u5efa\u6570\u636e\u6e90\u5f02\u5e38");
        }
    }

    private void rebuildGlobalRuleConfiguration(YamlJDBCConfiguration properties) {
        properties.getRules().removeIf(YamlGlobalRuleConfiguration.class::isInstance);
        if (null != properties.getAuthority()) {
            properties.getRules().add(properties.getAuthority());
        }
        if (null != properties.getTransaction()) {
            properties.getRules().add(properties.getTransaction());
        }
        if (null != properties.getGlobalClock()) {
            properties.getRules().add(properties.getGlobalClock());
        }
        if (null != properties.getSqlParser()) {
            properties.getRules().add(properties.getSqlParser());
        }
        if (null != properties.getSqlTranslator()) {
            properties.getRules().add(properties.getSqlTranslator());
        }
        if (null != properties.getLogging()) {
            properties.getRules().add(properties.getLogging());
        }
        if (null != properties.getSqlFederation()) {
            properties.getRules().add(properties.getSqlFederation());
        }
    }
}

