/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.infra.database.dm.connector;

import java.util.Properties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;

public class DmConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = 5236;

    public ConnectionProperties parse(String url, String username, String catalog) {
        JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
        String hostname = jdbcUrl.getHostname();
        int port = -1 == jdbcUrl.getPort() ? 5236 : jdbcUrl.getPort();
        String curCatalog = jdbcUrl.getDatabase();
        return new StandardConnectionProperties(hostname, port, curCatalog, null, jdbcUrl.getQueryProperties(), this.buildDefaultQueryProperties());
    }

    private Properties buildDefaultQueryProperties() {
        Properties defaultQueryProperties = new Properties();
        defaultQueryProperties.setProperty("useServerPrepStmts", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("cachePrepStmts", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("prepStmtCacheSize", "200000");
        defaultQueryProperties.setProperty("prepStmtCacheSqlLimit", "2048");
        defaultQueryProperties.setProperty("useLocalSessionState", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("rewriteBatchedStatements", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("cacheResultSetMetadata", Boolean.FALSE.toString());
        defaultQueryProperties.setProperty("cacheServerConfiguration", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("elideSetAutoCommits", Boolean.TRUE.toString());
        defaultQueryProperties.setProperty("maintainTimeStats", Boolean.FALSE.toString());
        defaultQueryProperties.setProperty("netTimeoutForStreamingResults", "0");
        defaultQueryProperties.setProperty("tinyInt1isBit", Boolean.FALSE.toString());
        defaultQueryProperties.setProperty("useSSL", Boolean.FALSE.toString());
        defaultQueryProperties.setProperty("serverTimezone", "UTC");
        defaultQueryProperties.setProperty("zeroDateTimeBehavior", "round");
        return defaultQueryProperties;
    }

    public String getDatabaseType() {
        return "DM";
    }
}

