/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.rewrite.token.generator.impl;

import com.cyberway.mp.bc.sharding.rewrite.token.pojo.ExtShardingInsertAllInToToken;
import com.cyberway.mp.bc.sharding.rewrite.token.pojo.ExtShardingInsertValuesToken;
import com.cyberway.mp.bc.sharding.rewrite.token.pojo.ExtShardingTableToken;
import com.cyberway.mp.bc.sharding.sql.parser.statement.oracle.dml.ExtOracleInsertStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.aware.CursorAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public class ExtShardingInsertAllIntoTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
RouteContextAware {
    private final ShardingRule rule;
    private final SQLRewriteContext sqlRewriteContext;
    private RouteContext routeContext;

    public ExtShardingInsertAllIntoTokenGenerator(ShardingRule rule, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        this.rule = rule;
        this.sqlRewriteContext = sqlRewriteContext;
        this.routeContext = routeContext;
    }

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return !(sqlStatementContext instanceof CursorAware) && (this.isAllBindingTables(sqlStatementContext) || this.routeContext.containsTableSharding());
    }

    private boolean isAllBindingTables(SQLStatementContext sqlStatementContext) {
        List shardingLogicTableNames = sqlStatementContext instanceof TableAvailable ? this.rule.getShardingLogicTableNames(((TableAvailable)sqlStatementContext).getTablesContext().getTableNames()) : Collections.emptyList();
        return shardingLogicTableNames.size() > 1 && this.rule.isAllConfigBindingTables(shardingLogicTableNames);
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext.getSqlStatement() instanceof ExtOracleInsertStatement && MultiTableInsertType.ALL == ((ExtOracleInsertStatement)sqlStatementContext.getSqlStatement()).getMultiTableInsertType().orElse(null)) {
            return this.generateExtOracleInsertStatementSqlTokens((ExtOracleInsertStatement)sqlStatementContext.getSqlStatement(), sqlStatementContext);
        }
        return Collections.emptyList();
    }

    private Collection<SQLToken> generateExtOracleInsertStatementSqlTokens(ExtOracleInsertStatement extOracleInsertStatement, SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        MultiTableInsertIntoSegment multiTableInsertIntoSegment = extOracleInsertStatement.getMultiTableInsertIntoSegment().orElse(null);
        if (null == multiTableInsertIntoSegment) {
            return Collections.emptyList();
        }
        Iterator dataNodesIterator = this.routeContext.getOriginalDataNodes().isEmpty() ? Collections.emptyIterator() : this.routeContext.getOriginalDataNodes().iterator();
        for (InsertStatement insertStatement : multiTableInsertIntoSegment.getInsertStatements()) {
            TableNameSegment tableNameSegment;
            List<DataNode> dataNodes = dataNodesIterator.hasNext() ? (Collection)dataNodesIterator.next() : Collections.emptyList();
            SimpleTableSegment simpleTableSegment = insertStatement.getTable().orElse(null);
            ExtShardingTableToken extShardingTableToken = null;
            if (simpleTableSegment != null && this.rule.findShardingTable((tableNameSegment = simpleTableSegment.getTableName()).getIdentifier().getValue()).isPresent()) {
                extShardingTableToken = new ExtShardingTableToken(tableNameSegment.getStartIndex(), tableNameSegment.getStopIndex(), tableNameSegment.getIdentifier(), sqlStatementContext, this.rule, dataNodes);
            }
            Collection insertValuesSegments = insertStatement.getValues();
            ExtShardingInsertValuesToken insertValuesToken = new ExtShardingInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
            for (InsertValuesSegment insertValuesSegment : insertValuesSegments) {
                insertValuesToken.getInsertValues().add(new ShardingInsertValue(insertValuesSegment.getValues(), dataNodes));
            }
            ExtOracleInsertStatement subExtOracleInsertStatement = (ExtOracleInsertStatement)insertStatement;
            ExtShardingInsertAllInToToken insertAllInToToken = new ExtShardingInsertAllInToToken(subExtOracleInsertStatement.getIntoStatement(), extShardingTableToken, insertValuesToken, this.sqlRewriteContext.getSql());
            result.add(insertAllInToToken);
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

