/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.rewrite.token.pojo;

import java.util.Collection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingTokenUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public class ExtShardingTableToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue tableName;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;
    private final Collection<DataNode> dataNodes;

    public ExtShardingTableToken(int startIndex, int stopIndex, IdentifierValue tableSegment, SQLStatementContext sqlStatementContext, ShardingRule shardingRule, Collection<DataNode> dataNodes) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.tableName = tableSegment;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
        this.dataNodes = dataNodes;
    }

    public String toString(RouteUnit routeUnit) {
        return this.getActualTableName(routeUnit);
    }

    private String getActualTableName(RouteUnit routeUnit) {
        if (this.isAppend(routeUnit)) {
            String actualTableName = (String)ShardingTokenUtils.getLogicAndActualTableMap((RouteUnit)routeUnit, (SQLStatementContext)this.sqlStatementContext, (ShardingRule)this.shardingRule).get(this.tableName.getValue());
            actualTableName = null == actualTableName ? this.tableName.getValue() : actualTableName;
            return this.tableName.getQuoteCharacter().wrap(actualTableName);
        }
        return "";
    }

    public boolean isAppend(RouteUnit routeUnit) {
        if (null == routeUnit || null == this.dataNodes || this.dataNodes.isEmpty()) {
            return true;
        }
        for (DataNode each : this.dataNodes) {
            if (!routeUnit.findTableMapper(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }
}

