/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.sql.parser.oracle.visitor.statement.type;

import com.cyberway.mp.bc.sharding.sql.parser.statement.oracle.dml.ExtOracleInsertStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.statement.OracleStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.CombineType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CollateExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionWithParamsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.ComplexExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.DatetimeProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.multiset.MultisetExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableConditionalIntoElseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableConditionalIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableConditionalIntoThenSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableConditionalIntoWhenThenSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlElementFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlPiFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlQueryAndExistsFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlSerializeFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.xml.XmlTableFunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ModelSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.PivotSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.CollectionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.FunctionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.oracle.dml.OracleDeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.dml.OracleMergeStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.dml.OracleSelectStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.dml.OracleUpdateStatement;

public class ExtOracleDMLStatementVisitor
extends OracleStatementVisitor
implements DMLStatementVisitor {
    public ASTNode visitUpdate(OracleStatementParser.UpdateContext ctx) {
        OracleUpdateStatement result = new OracleUpdateStatement();
        result.setTable((TableSegment)this.visit((ParseTree)ctx.updateSpecification()));
        if (null != ctx.alias()) {
            result.getTable().setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.updateSetClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    public ASTNode visitUpdateSpecification(OracleStatementParser.UpdateSpecificationContext ctx) {
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause());
        }
        if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause());
            return new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
        }
        SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr());
        return new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
    }

    public ASTNode visitUpdateSetClause(OracleStatementParser.UpdateSetClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        if (null != ctx.updateSetColumnList()) {
            for (OracleStatementParser.UpdateSetColumnClauseContext each : ctx.updateSetColumnList().updateSetColumnClause()) {
                assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
            }
        } else {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)ctx.updateSetValueClause()));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    public ASTNode visitUpdateSetColumnClause(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        return 1 == ctx.columnName().size() ? this.createAssignmentSegmentFromSingleColumnAssignment(ctx) : this.createAssignmentSegmentFromMultiColumnAssignment(ctx);
    }

    private ColumnAssignmentSegment createAssignmentSegmentFromSingleColumnAssignment(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName(0));
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        if (null != ctx.expr()) {
            ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
        }
        if (null != ctx.selectSubquery()) {
            SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())), this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
            SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
            ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
            result.getColumns().add(column);
            return result;
        }
        CommonExpressionSegment value = new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.DEFAULT().getText());
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
        result.getColumns().add(column);
        return result;
    }

    private ColumnAssignmentSegment createAssignmentSegmentFromMultiColumnAssignment(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ColumnNameContext each : ctx.columnName()) {
            columnSegments.add((ColumnSegment)this.visit((ParseTree)each));
        }
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())), this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
        SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
    }

    public ASTNode visitUpdateSetValueClause(OracleStatementParser.UpdateSetValueClauseContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        if (null != ctx.expr()) {
            ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
            result.getColumns().add(column);
            return result;
        }
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())), this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
        SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
        result.getColumns().add(column);
        return result;
    }

    public ASTNode visitInsert(OracleStatementParser.InsertContext ctx) {
        ExtOracleInsertStatement result = (ExtOracleInsertStatement)(null == ctx.insertSingleTable() ? (ASTNode)this.visit((ParseTree)ctx.insertMultiTable()) : (ASTNode)this.visit((ParseTree)ctx.insertSingleTable()));
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        return result;
    }

    public ASTNode visitInsertSingleTable(OracleStatementParser.InsertSingleTableContext ctx) {
        ExtOracleInsertStatement result = (ExtOracleInsertStatement)((Object)this.visit((ParseTree)ctx.insertIntoClause()));
        if (null != ctx.insertValuesClause()) {
            result.getValues().addAll(this.createInsertValuesSegments(ctx.insertValuesClause().assignmentValues()));
        }
        if (null != ctx.selectSubquery()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
            result.setInsertSelect(subquerySegment);
        }
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        result.add((InsertValuesSegment)this.visit((ParseTree)ctx));
        return result;
    }

    public ASTNode visitInsertMultiTable(OracleStatementParser.InsertMultiTableContext ctx) {
        ExtOracleInsertStatement result = new ExtOracleInsertStatement();
        result.setMultiTableInsertType(null != ctx.conditionalInsertClause() && null != ctx.conditionalInsertClause().FIRST() ? MultiTableInsertType.FIRST : MultiTableInsertType.ALL);
        List multiTableElementContexts = ctx.multiTableElement();
        if (null != multiTableElementContexts && !multiTableElementContexts.isEmpty()) {
            MultiTableInsertIntoSegment multiTableInsertIntoSegment = new MultiTableInsertIntoSegment(((OracleStatementParser.MultiTableElementContext)multiTableElementContexts.get(0)).getStart().getStartIndex(), ((OracleStatementParser.MultiTableElementContext)multiTableElementContexts.get(multiTableElementContexts.size() - 1)).getStop().getStopIndex());
            multiTableInsertIntoSegment.getInsertStatements().addAll(this.createInsertIntoSegments(multiTableElementContexts));
            result.setMultiTableInsertIntoSegment(multiTableInsertIntoSegment);
        } else {
            result.setMultiTableConditionalIntoSegment((MultiTableConditionalIntoSegment)this.visit((ParseTree)ctx.conditionalInsertClause()));
        }
        result.setInsertSelect(new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())), this.getOriginalText((ParserRuleContext)ctx.selectSubquery())));
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    private Collection<InsertStatement> createInsertIntoSegments(List<OracleStatementParser.MultiTableElementContext> ctx) {
        LinkedList<InsertStatement> result = new LinkedList<InsertStatement>();
        HashSet<ParameterMarkerSegment> addedSegments = new HashSet<ParameterMarkerSegment>();
        for (OracleStatementParser.MultiTableElementContext each : ctx) {
            ExtOracleInsertStatement extOracleInsertStatement = (ExtOracleInsertStatement)((Object)this.visit((ParseTree)each));
            this.addParameterMarkerSegments(addedSegments, extOracleInsertStatement);
            result.add(extOracleInsertStatement);
            Token start = each.getStart();
            extOracleInsertStatement.setIntoStatement(new ExtOracleInsertStatement.IntoStatement(start.getStartIndex(), start.getStopIndex()));
        }
        return result;
    }

    private void addParameterMarkerSegments(Collection<ParameterMarkerSegment> addedSegments, ExtOracleInsertStatement ExtOracleInsertStatement2) {
        for (ParameterMarkerSegment parameterMarkerSegment : this.popAllStatementParameterMarkerSegments()) {
            if (!addedSegments.add(parameterMarkerSegment)) continue;
            ExtOracleInsertStatement2.addParameterMarkerSegments(Collections.singletonList(parameterMarkerSegment));
        }
    }

    public ASTNode visitInsertValuesClause(OracleStatementParser.InsertValuesClauseContext ctx) {
        ExtOracleInsertStatement result = new ExtOracleInsertStatement();
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    public ASTNode visitInsertIntoClause(OracleStatementParser.InsertIntoClauseContext ctx) {
        ExtOracleInsertStatement result = new ExtOracleInsertStatement();
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause()));
        } else if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            result.setInsertSelect((SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause()));
        } else {
            result.setInsertSelect((SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr()));
        }
        if (null != ctx.columnNames()) {
            OracleStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.stop.getStopIndex() + 1, ctx.stop.getStopIndex() + 1, Collections.emptyList()));
        }
        return result;
    }

    public ASTNode visitDelete(OracleStatementParser.DeleteContext ctx) {
        OracleDeleteStatement result = new OracleDeleteStatement();
        result.setTable((TableSegment)this.visit((ParseTree)ctx.deleteSpecification()));
        if (null != ctx.alias()) {
            result.getTable().setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    public ASTNode visitDeleteSpecification(OracleStatementParser.DeleteSpecificationContext ctx) {
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause());
        }
        if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause());
            return new SubqueryTableSegment(ctx.dmlTableExprClause().dmlSubqueryClause().start.getStartIndex(), ctx.dmlTableExprClause().dmlSubqueryClause().stop.getStopIndex(), subquerySegment);
        }
        SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr());
        return new SubqueryTableSegment(ctx.dmlTableExprClause().tableCollectionExpr().start.getStartIndex(), ctx.dmlTableExprClause().tableCollectionExpr().stop.getStopIndex(), subquerySegment);
    }

    public OracleSelectStatement visitSelectIntoStatement(OracleStatementParser.SelectIntoStatementContext ctx) {
        OracleSelectStatement result = new OracleSelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.selectList()));
        result.setFrom((TableSegment)this.visit((ParseTree)ctx.fromClauseList()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.modelClause()) {
            result.setModelSegment((ModelSegment)this.visit((ParseTree)ctx.modelClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    public ASTNode visitMultiTableElement(OracleStatementParser.MultiTableElementContext ctx) {
        ExtOracleInsertStatement result = (ExtOracleInsertStatement)((Object)this.visit((ParseTree)ctx.insertIntoClause()));
        if (null != ctx.insertValuesClause()) {
            result.getValues().addAll(this.createInsertValuesSegments(ctx.insertValuesClause().assignmentValues()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        return result;
    }

    public ASTNode visitSelect(OracleStatementParser.SelectContext ctx) {
        OracleSelectStatement result = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        if (null != ctx.forUpdateClause()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.forUpdateClause()));
        }
        return result;
    }

    public ASTNode visitPivotClause(OracleStatementParser.PivotClauseContext ctx) {
        ColumnSegment pivotForColumn = (ColumnSegment)this.visitColumnName(ctx.pivotForClause().columnName());
        LinkedList pivotInColumns = new LinkedList();
        if (null != ctx.pivotInClause()) {
            ctx.pivotInClause().pivotInClauseExpr().forEach(each -> {
                ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)each.expr());
                String columnName = null != each.alias() && null != each.alias().identifier() ? each.alias().identifier().IDENTIFIER_().getText() : expr.getText();
                ColumnSegment columnSegment = new ColumnSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), new IdentifierValue(columnName));
                pivotInColumns.add(columnSegment);
            });
        }
        return new PivotSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), pivotForColumn, pivotInColumns);
    }

    public ASTNode visitUnpivotClause(OracleStatementParser.UnpivotClauseContext ctx) {
        ColumnSegment unpivotColumn = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ColumnSegment unpivotForColumn = (ColumnSegment)this.visitColumnName(ctx.pivotForClause().columnName());
        LinkedList unpivotInColumns = new LinkedList();
        if (null != ctx.unpivotInClause()) {
            ctx.unpivotInClause().unpivotInClauseExpr().forEach(each -> unpivotInColumns.add((ColumnSegment)this.visit((ParseTree)each.columnName())));
        }
        PivotSegment result = new PivotSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), unpivotForColumn, unpivotInColumns, true);
        result.setUnpivotColumn(unpivotColumn);
        return result;
    }

    public ASTNode visitDmlTableClause(OracleStatementParser.DmlTableClauseContext ctx) {
        if (null != ctx.AT_() && null != ctx.dbLink()) {
            SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.tableName().name().getText())));
            if (null != ctx.tableName().owner()) {
                result.setOwner(new OwnerSegment(ctx.tableName().owner().start.getStartIndex(), ctx.tableName().owner().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.tableName().owner().identifier())));
            }
            result.setAt(new IdentifierValue(ctx.AT_().getText()));
            result.setDbLink(new IdentifierValue(ctx.dbLink().identifier(0).getText()));
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    public ASTNode visitDmlSubqueryClause(OracleStatementParser.DmlSubqueryClauseContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
    }

    public ASTNode visitTableCollectionExpr(OracleStatementParser.TableCollectionExprContext ctx) {
        if (null != ctx.collectionExpr().selectSubquery()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.collectionExpr().selectSubquery());
            return new SubquerySegment(ctx.collectionExpr().selectSubquery().start.getStartIndex(), ctx.collectionExpr().selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.collectionExpr().selectSubquery()));
        }
        if (null != ctx.collectionExpr().functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.collectionExpr().functionCall());
        }
        if (null != ctx.collectionExpr().columnName()) {
            return (ASTNode)this.visit((ParseTree)ctx.collectionExpr().columnName());
        }
        if (null != ctx.collectionExpr().expr()) {
            return (ASTNode)this.visit((ParseTree)ctx.collectionExpr().expr());
        }
        throw new UnsupportedOperationException("Unhandled table collection expr");
    }

    public ASTNode visitConditionalInsertClause(OracleStatementParser.ConditionalInsertClauseContext ctx) {
        LinkedList<MultiTableConditionalIntoWhenThenSegment> whenThenSegments = new LinkedList<MultiTableConditionalIntoWhenThenSegment>();
        for (OracleStatementParser.ConditionalInsertWhenPartContext each : ctx.conditionalInsertWhenPart()) {
            whenThenSegments.add((MultiTableConditionalIntoWhenThenSegment)this.visit((ParseTree)each));
        }
        MultiTableConditionalIntoSegment result = new MultiTableConditionalIntoSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.getWhenThenSegments().addAll(whenThenSegments);
        if (null != ctx.conditionalInsertElsePart()) {
            result.setElseSegment((MultiTableConditionalIntoElseSegment)this.visit((ParseTree)ctx.conditionalInsertElsePart()));
        }
        return result;
    }

    public ASTNode visitConditionalInsertWhenPart(OracleStatementParser.ConditionalInsertWhenPartContext ctx) {
        List multiTableElementContexts = ctx.multiTableElement();
        MultiTableConditionalIntoThenSegment thenSegment = new MultiTableConditionalIntoThenSegment(((OracleStatementParser.MultiTableElementContext)multiTableElementContexts.get((int)0)).start.getStartIndex(), ((OracleStatementParser.MultiTableElementContext)multiTableElementContexts.get((int)(multiTableElementContexts.size() - 1))).stop.getStopIndex(), this.createInsertIntoSegments(multiTableElementContexts));
        return new MultiTableConditionalIntoWhenThenSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()), thenSegment);
    }

    public ASTNode visitConditionalInsertElsePart(OracleStatementParser.ConditionalInsertElsePartContext ctx) {
        return new MultiTableConditionalIntoElseSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.createInsertIntoSegments(ctx.multiTableElement()));
    }

    public ASTNode visitAssignmentValues(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (OracleStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    public ASTNode visitAssignmentValue(OracleStatementParser.AssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        return null == expr ? new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText()) : (ASTNode)this.visit((ParseTree)expr);
    }

    public ASTNode visitSelectSubquery(OracleStatementParser.SelectSubqueryContext ctx) {
        OracleSelectStatement result;
        if (null != ctx.combineType()) {
            result = new OracleSelectStatement();
            OracleSelectStatement left = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery(0));
            result.setProjections(left.getProjections());
            left.getFrom().ifPresent(arg_0 -> ((OracleSelectStatement)result).setFrom(arg_0));
            left.getWithSegment().ifPresent(arg_0 -> ((OracleSelectStatement)result).setWithSegment(arg_0));
            this.createSelectCombineClause(ctx, result, left);
        } else {
            OracleSelectStatement oracleSelectStatement = result = null != ctx.queryBlock() ? (OracleSelectStatement)this.visit((ParseTree)ctx.queryBlock()) : (OracleSelectStatement)this.visit((ParseTree)ctx.parenthesisSelectSubquery());
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    private void createSelectCombineClause(OracleStatementParser.SelectSubqueryContext ctx, OracleSelectStatement result, OracleSelectStatement left) {
        CombineType combineType = null != ctx.combineType().UNION() && null != ctx.combineType().ALL() ? CombineType.UNION_ALL : (null != ctx.combineType().UNION() ? CombineType.UNION : (null != ctx.combineType().INTERSECT() ? CombineType.INTERSECT : CombineType.MINUS));
        OracleSelectStatement right = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery(1));
        result.setCombine(new CombineSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.createSubquerySegment(ctx.selectSubquery(0), left), combineType, this.createSubquerySegment(ctx.selectSubquery(1), right)));
        result.addParameterMarkerSegments(left.getParameterMarkerSegments());
        result.addParameterMarkerSegments(right.getParameterMarkerSegments());
    }

    private SubquerySegment createSubquerySegment(OracleStatementParser.SelectSubqueryContext ctx, OracleSelectStatement selectStatement) {
        return new SubquerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (SelectStatement)selectStatement, this.getOriginalText((ParserRuleContext)ctx));
    }

    public ASTNode visitQueryBlock(OracleStatementParser.QueryBlockContext ctx) {
        OracleSelectStatement result = new OracleSelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.selectList()));
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.duplicateSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.selectFromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.selectFromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
            if (null != ctx.groupByClause().havingClause()) {
                result.setHaving((HavingSegment)this.visit((ParseTree)ctx.groupByClause().havingClause()));
            }
        }
        if (null != ctx.modelClause()) {
            result.setModelSegment((ModelSegment)this.visit((ParseTree)ctx.modelClause()));
        }
        return result;
    }

    public ASTNode visitHavingClause(OracleStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    public ASTNode visitModelClause(OracleStatementParser.ModelClauseContext ctx) {
        ModelSegment result = new ModelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.referenceModel()) {
            for (OracleStatementParser.ReferenceModelContext each : ctx.referenceModel()) {
                result.getReferenceModelSelects().add((SubquerySegment)this.visit((ParseTree)each));
            }
        }
        if (null != ctx.mainModel().modelRulesClause().orderByClause()) {
            for (OracleStatementParser.ReferenceModelContext each : ctx.mainModel().modelRulesClause().orderByClause()) {
                result.getOrderBySegments().add((OrderBySegment)this.visit((ParseTree)each));
            }
        }
        for (OracleStatementParser.ReferenceModelContext each : ctx.mainModel().modelRulesClause().cellAssignment()) {
            result.getCellAssignmentColumns().add((ColumnSegment)this.visit((ParseTree)each.measureColumn().columnName()));
            if (null != each.singleColumnForLoop()) {
                result.getCellAssignmentColumns().addAll(this.extractColumnValuesFromSingleColumnForLoop(each.singleColumnForLoop()));
                result.getCellAssignmentSelects().addAll(this.extractSelectSubqueryValuesFromSingleColumnForLoop(each.singleColumnForLoop()));
            }
            if (null == each.multiColumnForLoop()) continue;
            result.getCellAssignmentColumns().addAll(this.extractColumnValuesFromMultiColumnForLoop(each.multiColumnForLoop()));
            result.getCellAssignmentSelects().add(this.extractSelectSubqueryValueFromMultiColumnForLoop(each.multiColumnForLoop()));
        }
        return result;
    }

    private Collection<ColumnSegment> extractColumnValuesFromSingleColumnForLoop(List<OracleStatementParser.SingleColumnForLoopContext> ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.SingleColumnForLoopContext each : ctx) {
            result.add((ColumnSegment)this.visit((ParseTree)each.dimensionColumn().columnName()));
        }
        return result;
    }

    private Collection<SubquerySegment> extractSelectSubqueryValuesFromSingleColumnForLoop(List<OracleStatementParser.SingleColumnForLoopContext> ctx) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        for (OracleStatementParser.SingleColumnForLoopContext each : ctx) {
            if (null == each.selectSubquery()) continue;
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)each.selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(each.selectSubquery().start.getStartIndex(), each.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)each.selectSubquery()));
            result.add(subquerySegment);
        }
        return result;
    }

    private Collection<ColumnSegment> extractColumnValuesFromMultiColumnForLoop(OracleStatementParser.MultiColumnForLoopContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.DimensionColumnContext each : ctx.dimensionColumn()) {
            result.add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    private SubquerySegment extractSelectSubqueryValueFromMultiColumnForLoop(OracleStatementParser.MultiColumnForLoopContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
    }

    public ASTNode visitReferenceModel(OracleStatementParser.ReferenceModelContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
    }

    public ASTNode visitParenthesisSelectSubquery(OracleStatementParser.ParenthesisSelectSubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    public ASTNode visitWithClause(OracleStatementParser.WithClauseContext ctx) {
        LinkedList<CommonTableExpressionSegment> commonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        if (null != ctx.subqueryFactoringClause()) {
            for (OracleStatementParser.SubqueryFactoringClauseContext each : ctx.subqueryFactoringClause()) {
                SubquerySegment subquery = new SubquerySegment(each.selectSubquery().start.getStartIndex(), each.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)each)), this.getOriginalText((ParserRuleContext)each));
                CommonTableExpressionSegment commonTableExpression = new CommonTableExpressionSegment(each.start.getStartIndex(), each.stop.getStopIndex(), (AliasSegment)this.visit((ParseTree)each.queryName().alias()), subquery);
                if (null != each.searchClause()) {
                    OracleStatementParser.ColumnNameContext columnName = each.searchClause().orderingColumn().columnName();
                    commonTableExpression.getColumns().add((ColumnSegment)this.visit((ParseTree)columnName));
                }
                commonTableExpressions.add(commonTableExpression);
            }
        }
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressions);
    }

    public ASTNode visitSubqueryFactoringClause(OracleStatementParser.SubqueryFactoringClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    private boolean isDistinct(OracleStatementParser.QueryBlockContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    public ASTNode visitDuplicateSpecification(OracleStatementParser.DuplicateSpecificationContext ctx) {
        if (null != ctx.DISTINCT() || null != ctx.UNIQUE()) {
            return new BooleanLiteralValue(true);
        }
        return new BooleanLiteralValue(false);
    }

    public ASTNode visitSelectList(OracleStatementParser.SelectListContext ctx) {
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
            result.getProjections().addAll(projections);
            return result;
        }
        for (OracleStatementParser.SelectProjectionContext each : ctx.selectProjection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        result.getProjections().addAll(projections);
        return result;
    }

    public ASTNode visitSelectProjection(OracleStatementParser.SelectProjectionContext ctx) {
        if (null != ctx.queryName()) {
            OracleStatementParser.QueryNameContext queryName = ctx.queryName();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(queryName.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(queryName.getText());
            result.setOwner(new OwnerSegment(queryName.getStart().getStartIndex(), queryName.getStop().getStopIndex(), identifier));
            return result;
        }
        if (null != ctx.tableName()) {
            OracleStatementParser.TableNameContext tableName = ctx.tableName();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(tableName.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(tableName.getText());
            result.setOwner(new OwnerSegment(tableName.getStart().getStartIndex(), tableName.getStop().getStopIndex(), identifier));
            return result;
        }
        if (null != ctx.alias()) {
            OracleStatementParser.AliasContext aliasContext = ctx.alias();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(aliasContext.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(aliasContext.getText());
            result.setOwner(new OwnerSegment(aliasContext.getStart().getStartIndex(), aliasContext.getStop().getStopIndex(), identifier));
            return result;
        }
        return this.createProjection(ctx.selectProjectionExprClause());
    }

    public ASTNode visitAlias(OracleStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(OracleStatementParser.SelectProjectionExprClauseContext ctx) {
        AliasSegment alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AliasAvailable) {
            ((AliasAvailable)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ComplexExpressionSegment) {
            return this.createProjectionForComplexExpressionSegment(projection, alias);
        }
        if (projection instanceof SimpleExpressionSegment) {
            return this.createProjectionForSimpleExpressionSegment(projection, alias, ctx);
        }
        if (projection instanceof ExpressionSegment) {
            return this.createProjectionForExpressionSegment(projection, alias);
        }
        throw new UnsupportedOperationException("Unhandled case");
    }

    private ASTNode createProjectionForComplexExpressionSegment(ASTNode projection, AliasSegment alias) {
        if (projection instanceof FunctionSegment) {
            FunctionSegment segment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof XmlQueryAndExistsFunctionSegment || projection instanceof XmlPiFunctionSegment || projection instanceof XmlSerializeFunctionSegment || projection instanceof XmlElementFunctionSegment) {
            return projection;
        }
        throw new UnsupportedOperationException("Unsupported Complex Expression");
    }

    private ASTNode createProjectionForSimpleExpressionSegment(ASTNode projection, AliasSegment alias, OracleStatementParser.SelectProjectionExprClauseContext ctx) {
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
            ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals()), (ExpressionSegment)column) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()), (ExpressionSegment)column);
            result.setAlias(alias);
            return result;
        }
        throw new UnsupportedOperationException("Unsupported Simple Expression");
    }

    private ASTNode createProjectionForExpressionSegment(ASTNode projection, AliasSegment alias) {
        if (projection instanceof ColumnSegment) {
            return this.createColumnProjectionSegment((ColumnSegment)projection, alias);
        }
        if (projection instanceof BinaryOperationExpression) {
            return this.createExpressionProjectionSegment((BinaryOperationExpression)projection, alias);
        }
        if (projection instanceof MultisetExpression) {
            return this.createExpressionProjectionSegment((MultisetExpression)projection, alias);
        }
        if (projection instanceof DatetimeExpression) {
            return this.createDatetimeProjectionSegment((DatetimeExpression)projection);
        }
        if (projection instanceof IntervalExpressionProjection) {
            return this.createIntervalExpressionProjection((IntervalExpressionProjection)projection);
        }
        if (projection instanceof CaseWhenExpression || projection instanceof VariableSegment || projection instanceof BetweenExpression || projection instanceof InExpression || projection instanceof CollateExpression) {
            return this.createExpressionProjectionSegment((ExpressionSegment)projection, alias);
        }
        throw new UnsupportedOperationException("Unsupported Expression");
    }

    private ColumnProjectionSegment createColumnProjectionSegment(ColumnSegment projection, AliasSegment alias) {
        ColumnProjectionSegment result = new ColumnProjectionSegment(projection);
        result.setAlias(alias);
        return result;
    }

    private ExpressionProjectionSegment createExpressionProjectionSegment(BinaryOperationExpression projection, AliasSegment alias) {
        int startIndex = projection.getStartIndex();
        int stopIndex = null == alias ? projection.getStopIndex() : alias.getStopIndex();
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, projection.getText(), (ExpressionSegment)projection);
        result.setAlias(alias);
        return result;
    }

    private ExpressionProjectionSegment createExpressionProjectionSegment(MultisetExpression projection, AliasSegment alias) {
        int startIndex = projection.getStartIndex();
        int stopIndex = null == alias ? projection.getStopIndex() : alias.getStopIndex();
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, projection.getText(), (ExpressionSegment)projection);
        result.setAlias(alias);
        return result;
    }

    private ExpressionProjectionSegment createExpressionProjectionSegment(ExpressionSegment projection, AliasSegment alias) {
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(projection.getStartIndex(), projection.getStopIndex(), projection.getText(), projection);
        result.setAlias(alias);
        return result;
    }

    private DatetimeProjectionSegment createDatetimeProjectionSegment(DatetimeExpression projection) {
        return null == projection.getRight() ? new DatetimeProjectionSegment(projection.getStartIndex(), projection.getStopIndex(), projection.getLeft(), projection.getText()) : new DatetimeProjectionSegment(projection.getStartIndex(), projection.getStopIndex(), projection.getLeft(), projection.getRight(), projection.getText());
    }

    private IntervalExpressionProjection createIntervalExpressionProjection(IntervalExpressionProjection projection) {
        IntervalExpressionProjection result = new IntervalExpressionProjection(projection.getStartIndex(), projection.getStopIndex(), projection.getLeft(), projection.getMinus(), projection.getRight(), projection.getText());
        if (null != projection.getDayToSecondExpression()) {
            result.setDayToSecondExpression(projection.getDayToSecondExpression());
        } else {
            result.setYearToMonthExpression(projection.getYearToMonthExpression());
        }
        return result;
    }

    public ASTNode visitSelectFromClause(OracleStatementParser.SelectFromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.fromClauseList());
    }

    public ASTNode visitFromClauseList(OracleStatementParser.FromClauseListContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.fromClauseOption(0));
        if (ctx.fromClauseOption().size() > 1) {
            for (int i = 1; i < ctx.fromClauseOption().size(); ++i) {
                result = this.generateJoinTableSourceFromFromClauseOption(ctx.fromClauseOption(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromFromClauseOption(OracleStatementParser.FromClauseOptionContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setJoinType(JoinType.COMMA.name());
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    public ASTNode visitFromClauseOption(OracleStatementParser.FromClauseOptionContext ctx) {
        if (null != ctx.joinClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.joinClause());
        }
        if (null != ctx.regularFunction()) {
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)ctx.regularFunction());
            FunctionTableSegment result = new FunctionTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)functionSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.xmlTableFunction()) {
            XmlTableFunctionSegment functionSegment = (XmlTableFunctionSegment)this.visit((ParseTree)ctx.xmlTableFunction());
            FunctionTableSegment result = new FunctionTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)functionSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.selectTableReference());
    }

    public ASTNode visitJoinClause(OracleStatementParser.JoinClauseContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.selectTableReference());
        for (OracleStatementParser.SelectJoinOptionContext each : ctx.selectJoinOption()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    private JoinTableSegment visitJoinedTable(OracleStatementParser.SelectJoinOptionContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setJoinType(this.getJoinType(ctx));
        result.setNatural(this.isNatural(ctx));
        if (null != ctx.innerCrossJoinClause()) {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.innerCrossJoinClause().selectTableReference());
            result.setRight(right);
            if (null != ctx.innerCrossJoinClause().selectJoinSpecification()) {
                this.visitSelectJoinSpecification(ctx.innerCrossJoinClause().selectJoinSpecification(), result);
            }
        } else if (null != ctx.outerJoinClause()) {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.outerJoinClause().selectTableReference());
            result.setRight(right);
            if (null != ctx.outerJoinClause().selectJoinSpecification()) {
                this.visitSelectJoinSpecification(ctx.outerJoinClause().selectJoinSpecification(), result);
            }
        } else {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.crossOuterApplyClause());
            result.setRight(right);
        }
        return result;
    }

    private boolean isNatural(OracleStatementParser.SelectJoinOptionContext ctx) {
        if (null != ctx.innerCrossJoinClause()) {
            return null != ctx.innerCrossJoinClause().NATURAL();
        }
        if (null != ctx.outerJoinClause()) {
            return null != ctx.outerJoinClause().NATURAL();
        }
        return false;
    }

    private String getJoinType(OracleStatementParser.SelectJoinOptionContext ctx) {
        if (null != ctx.innerCrossJoinClause()) {
            return this.getInnerCrossJoinType(ctx.innerCrossJoinClause());
        }
        if (null != ctx.outerJoinClause()) {
            return this.getOuterJoinType(ctx.outerJoinClause());
        }
        if (null != ctx.crossOuterApplyClause()) {
            return this.getCrossOuterApplyType(ctx.crossOuterApplyClause());
        }
        return JoinType.COMMA.name();
    }

    private String getCrossOuterApplyType(OracleStatementParser.CrossOuterApplyClauseContext ctx) {
        if (null != ctx.CROSS()) {
            return JoinType.CROSS.name();
        }
        return JoinType.LEFT.name();
    }

    private String getOuterJoinType(OracleStatementParser.OuterJoinClauseContext ctx) {
        if (null != ctx.outerJoinType().FULL()) {
            return JoinType.FULL.name();
        }
        if (null != ctx.outerJoinType().LEFT()) {
            return JoinType.LEFT.name();
        }
        return JoinType.RIGHT.name();
    }

    private String getInnerCrossJoinType(OracleStatementParser.InnerCrossJoinClauseContext ctx) {
        return null == ctx.CROSS() ? JoinType.INNER.name() : JoinType.CROSS.name();
    }

    private void visitSelectJoinSpecification(OracleStatementParser.SelectJoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
    }

    public ASTNode visitCrossOuterApplyClause(OracleStatementParser.CrossOuterApplyClauseContext ctx) {
        TableSegment result;
        if (null != ctx.selectTableReference()) {
            result = (TableSegment)this.visit((ParseTree)ctx.selectTableReference());
        } else {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.collectionExpr());
            result = new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
        }
        return result;
    }

    public ASTNode visitCollectionExpr(OracleStatementParser.CollectionExprContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.selectSubquery()));
    }

    public ASTNode visitSelectTableReference(OracleStatementParser.SelectTableReferenceContext ctx) {
        TableSegment result = null != ctx.containersClause() ? (TableSegment)this.visit((ParseTree)ctx.containersClause()) : (null != ctx.shardsClause() ? (TableSegment)this.visit((ParseTree)ctx.shardsClause()) : (TableSegment)this.visit((ParseTree)ctx.queryTableExprClause()));
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    public ASTNode visitContainersClause(OracleStatementParser.ContainersClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    public ASTNode visitShardsClause(OracleStatementParser.ShardsClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    public ASTNode visitQueryTableExprClause(OracleStatementParser.QueryTableExprClauseContext ctx) {
        PivotSegment pivotClause;
        ASTNode result = (ASTNode)this.visit((ParseTree)ctx.queryTableExpr());
        if (null != ctx.pivotClause()) {
            pivotClause = (PivotSegment)this.visit((ParseTree)ctx.pivotClause());
            if (result instanceof SubqueryTableSegment) {
                ((SubqueryTableSegment)result).setPivot(pivotClause);
            }
            if (result instanceof SimpleTableSegment) {
                ((SimpleTableSegment)result).setPivot(pivotClause);
            }
        }
        if (null != ctx.unpivotClause()) {
            pivotClause = (PivotSegment)this.visit((ParseTree)ctx.unpivotClause());
            if (result instanceof SubqueryTableSegment) {
                ((SubqueryTableSegment)result).setPivot(pivotClause);
            }
            if (result instanceof SimpleTableSegment) {
                ((SimpleTableSegment)result).setPivot(pivotClause);
            }
        }
        return result;
    }

    public ASTNode visitQueryTableExpr(OracleStatementParser.QueryTableExprContext ctx) {
        SimpleTableSegment result;
        if (null != ctx.queryTableExprSampleClause()) {
            result = (SimpleTableSegment)this.visit((ParseTree)ctx.queryTableExprSampleClause().queryTableExprTableClause().tableName());
        } else if (null != ctx.lateralClause()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.lateralClause().selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.lateralClause().selectSubquery().start.getStartIndex(), ctx.lateralClause().selectSubquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.lateralClause().selectSubquery()));
            result = new SubqueryTableSegment(ctx.lateralClause().LP_().getSymbol().getStartIndex(), ctx.lateralClause().RP_().getSymbol().getStopIndex(), subquerySegment);
        } else if (null != ctx.tableCollectionExpr().collectionExpr().selectSubquery()) {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.tableCollectionExpr());
            result = new SubqueryTableSegment(ctx.tableCollectionExpr().start.getStartIndex(), ctx.tableCollectionExpr().stop.getStopIndex(), subquerySegment);
        } else {
            result = new CollectionTableSegment((ExpressionSegment)this.visit((ParseTree)ctx.tableCollectionExpr()));
        }
        return result;
    }

    public ASTNode visitWhereClause(OracleStatementParser.WhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    public ASTNode visitGroupByClause(OracleStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.GroupByItemContext each : ctx.groupByItem()) {
            items.addAll(this.generateOrderByItemsFromGroupByItem(each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    private Collection<OrderByItemSegment> generateOrderByItemsFromGroupByItem(OracleStatementParser.GroupByItemContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            OrderByItemSegment item = (OrderByItemSegment)this.extractValueFromGroupByItemExpression(ctx.expr());
            result.add(item);
        } else if (null != ctx.rollupCubeClause()) {
            result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(ctx.rollupCubeClause()));
        } else {
            result.addAll(this.generateOrderByItemSegmentsFromGroupingSetsClause(ctx.groupingSetsClause()));
        }
        return result;
    }

    private ASTNode extractValueFromGroupByItemExpression(OracleStatementParser.ExprContext ctx) {
        ASTNode expression = (ASTNode)this.visit((ParseTree)ctx);
        if (expression instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)expression;
            return new ColumnOrderByItemSegment(column, OrderDirection.ASC, null);
        }
        if (expression instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment literalExpression = (LiteralExpressionSegment)expression;
            return new IndexOrderByItemSegment(literalExpression.getStartIndex(), literalExpression.getStopIndex(), SQLUtils.getExactlyNumber((String)literalExpression.getLiterals().toString(), (int)10).intValue(), OrderDirection.ASC, null);
        }
        return new ExpressionOrderByItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText((ParserRuleContext)ctx), OrderDirection.ASC, null, (ExpressionSegment)expression);
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromRollupCubeClause(OracleStatementParser.RollupCubeClauseContext ctx) {
        return new LinkedList<OrderByItemSegment>(this.generateOrderByItemSegmentsFromGroupingExprList(ctx.groupingExprList()));
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingSetsClause(OracleStatementParser.GroupingSetsClauseContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.rollupCubeClause()) {
            for (OracleStatementParser.RollupCubeClauseContext each : ctx.rollupCubeClause()) {
                result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(each));
            }
        }
        if (null != ctx.groupingExprList()) {
            for (OracleStatementParser.RollupCubeClauseContext each : ctx.groupingExprList()) {
                result.addAll(this.generateOrderByItemSegmentsFromGroupingExprList((OracleStatementParser.GroupingExprListContext)each));
            }
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingExprList(OracleStatementParser.GroupingExprListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.ExpressionListContext each : ctx.expressionList()) {
            result.addAll(this.generateOrderByItemSegmentsFromExpressionList(each));
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromExpressionList(OracleStatementParser.ExpressionListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            for (OracleStatementParser.ExprContext each : ctx.expr()) {
                result.add((OrderByItemSegment)this.extractValueFromGroupByItemExpression(each));
            }
        }
        if (null != ctx.exprs()) {
            for (OracleStatementParser.ExprContext each : ctx.exprs().expr()) {
                result.add((OrderByItemSegment)this.extractValueFromGroupByItemExpression(each));
            }
        }
        return result;
    }

    public ASTNode visitSubquery(OracleStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    public ASTNode visitForUpdateClause(OracleStatementParser.ForUpdateClauseContext ctx) {
        LockSegment result = new LockSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.forUpdateClauseList()) {
            result.getTables().addAll(this.generateTablesFromforUpdateClauseOption(ctx.forUpdateClauseList()));
            result.getColumns().addAll(this.generateColumnsFromforUpdateClauseOption(ctx.forUpdateClauseList()));
        }
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.tableName()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)each.tableName()));
        }
        return result;
    }

    private List<ColumnSegment> generateColumnsFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.columnName()) continue;
            result.add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    public ASTNode visitMerge(OracleStatementParser.MergeContext ctx) {
        OracleMergeStatement result = new OracleMergeStatement();
        result.setTarget((TableSegment)this.visit((ParseTree)ctx.intoClause()));
        result.setSource((TableSegment)this.visit((ParseTree)ctx.usingClause()));
        ExpressionWithParamsSegment onExpression = new ExpressionWithParamsSegment(ctx.usingClause().expr().start.getStartIndex(), ctx.usingClause().expr().stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.usingClause().expr()));
        onExpression.getParameterMarkerSegments().addAll(this.popAllStatementParameterMarkerSegments());
        result.setExpression(onExpression);
        if (null != ctx.mergeUpdateClause() && null != ctx.mergeInsertClause() && ctx.mergeUpdateClause().start.getStartIndex() > ctx.mergeInsertClause().start.getStartIndex()) {
            result.setInsert((InsertStatement)this.visitMergeInsertClause(ctx.mergeInsertClause()));
            result.setUpdate((UpdateStatement)this.visitMergeUpdateClause(ctx.mergeUpdateClause()));
            result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
            return result;
        }
        if (null != ctx.mergeUpdateClause()) {
            result.setUpdate((UpdateStatement)this.visitMergeUpdateClause(ctx.mergeUpdateClause()));
        }
        if (null != ctx.mergeInsertClause()) {
            result.setInsert((InsertStatement)this.visitMergeInsertClause(ctx.mergeInsertClause()));
        }
        result.addParameterMarkerSegments(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        return result;
    }

    public ASTNode visitMergeInsertClause(OracleStatementParser.MergeInsertClauseContext ctx) {
        ExtOracleInsertStatement result = new ExtOracleInsertStatement();
        if (null != ctx.mergeInsertColumn()) {
            result.setInsertColumns((InsertColumnsSegment)this.visit((ParseTree)ctx.mergeInsertColumn()));
        }
        if (null != ctx.mergeColumnValue()) {
            result.getValues().addAll(((CollectionValue)this.visit((ParseTree)ctx.mergeColumnValue())).getValue());
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.getParameterMarkerSegments().addAll(this.popAllStatementParameterMarkerSegments());
        return result;
    }

    public ASTNode visitMergeInsertColumn(OracleStatementParser.MergeInsertColumnContext ctx) {
        ArrayList<ColumnSegment> columnSegments = new ArrayList<ColumnSegment>(ctx.columnName().size());
        for (OracleStatementParser.ColumnNameContext each : ctx.columnName()) {
            if (null == each.name()) continue;
            columnSegments.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return new InsertColumnsSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), columnSegments);
    }

    public ASTNode visitMergeColumnValue(OracleStatementParser.MergeColumnValueContext ctx) {
        CollectionValue result = new CollectionValue();
        LinkedList<CommonExpressionSegment> segments = new LinkedList<CommonExpressionSegment>();
        for (OracleStatementParser.ExprContext each : ctx.expr()) {
            segments.add((CommonExpressionSegment)(null == each ? new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText()) : (ExpressionSegment)this.visit((ParseTree)each)));
        }
        result.getValue().add(new InsertValuesSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), segments));
        return result;
    }

    public ASTNode visitIntoClause(OracleStatementParser.IntoClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.viewName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.subquery());
        SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.subquery()));
        SubqueryTableSegment result = new SubqueryTableSegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquerySegment);
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    public ASTNode visitUsingClause(OracleStatementParser.UsingClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.viewName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.subquery());
        SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery, this.getOriginalText((ParserRuleContext)ctx.subquery()));
        subquerySegment.getSelect().getParameterMarkerSegments().addAll(this.popAllStatementParameterMarkerSegments());
        SubqueryTableSegment result = new SubqueryTableSegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquerySegment);
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    public ASTNode visitMergeUpdateClause(OracleStatementParser.MergeUpdateClauseContext ctx) {
        OracleUpdateStatement result = new OracleUpdateStatement();
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.mergeSetAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.deleteWhereClause()) {
            result.setDeleteWhere((WhereSegment)this.visit((ParseTree)ctx.deleteWhereClause()));
        }
        result.getParameterMarkerSegments().addAll(this.popAllStatementParameterMarkerSegments());
        return result;
    }

    public ASTNode visitMergeSetAssignmentsClause(OracleStatementParser.MergeSetAssignmentsClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        for (OracleStatementParser.MergeAssignmentContext each : ctx.mergeAssignment()) {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    public ASTNode visitMergeAssignment(OracleStatementParser.MergeAssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.mergeAssignmentValue());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    public ASTNode visitMergeAssignmentValue(OracleStatementParser.MergeAssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        return null == expr ? new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText()) : (ASTNode)this.visit((ParseTree)expr);
    }

    public ASTNode visitDeleteWhereClause(OracleStatementParser.DeleteWhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.whereClause().expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }
}

