/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.sql.parser.statement.oracle.dml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableConditionalIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.OracleStatement;

public class ExtOracleInsertStatement
extends InsertStatement
implements OracleStatement {
    private MultiTableInsertType multiTableInsertType;
    private MultiTableInsertIntoSegment multiTableInsertIntoSegment;
    private MultiTableConditionalIntoSegment multiTableConditionalIntoSegment;
    private WhereSegment where;
    private IntoStatement intoStatement;

    public Optional<MultiTableInsertType> getMultiTableInsertType() {
        return Optional.ofNullable(this.multiTableInsertType);
    }

    public Optional<MultiTableInsertIntoSegment> getMultiTableInsertIntoSegment() {
        return Optional.ofNullable(this.multiTableInsertIntoSegment);
    }

    public Optional<MultiTableConditionalIntoSegment> getMultiTableConditionalIntoSegment() {
        return Optional.ofNullable(this.multiTableConditionalIntoSegment);
    }

    public Optional<WhereSegment> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public void setMultiTableInsertType(MultiTableInsertType multiTableInsertType) {
        this.multiTableInsertType = multiTableInsertType;
    }

    public void setMultiTableInsertIntoSegment(MultiTableInsertIntoSegment multiTableInsertIntoSegment) {
        this.multiTableInsertIntoSegment = multiTableInsertIntoSegment;
    }

    public void setMultiTableConditionalIntoSegment(MultiTableConditionalIntoSegment multiTableConditionalIntoSegment) {
        this.multiTableConditionalIntoSegment = multiTableConditionalIntoSegment;
    }

    public void setWhere(WhereSegment where) {
        this.where = where;
    }

    public Optional<SimpleTableSegment> getTable() {
        return super.getTable().isEmpty() ? this.multiTableInsertIntoSegment.getInsertStatements().stream().map(InsertStatement::getTable).findFirst().orElse(Optional.empty()) : super.getTable();
    }

    public Optional<SubquerySegment> getInsertSelect() {
        return MultiTableInsertType.ALL == this.multiTableInsertType ? Optional.empty() : super.getInsertSelect();
    }

    public Collection<InsertValuesSegment> getValues() {
        if (MultiTableInsertType.ALL == this.multiTableInsertType && null != this.multiTableInsertIntoSegment.getInsertStatements()) {
            ArrayList<InsertValuesSegment> all = new ArrayList<InsertValuesSegment>();
            for (InsertStatement insertStatement : this.multiTableInsertIntoSegment.getInsertStatements()) {
                all.addAll(insertStatement.getValues());
            }
            return all;
        }
        return super.getValues();
    }

    public Optional<InsertColumnsSegment> getInsertColumns() {
        if (MultiTableInsertType.ALL == this.multiTableInsertType && null != this.multiTableInsertIntoSegment.getInsertStatements()) {
            Collection insertStatements = this.multiTableInsertIntoSegment.getInsertStatements();
            Integer start = null;
            Integer end = null;
            ArrayList allColumnSegment = new ArrayList();
            for (InsertStatement insertStatement : insertStatements) {
                InsertColumnsSegment insertColumnsSegment = insertStatement.getInsertColumns().orElse(null);
                if (null == insertColumnsSegment) continue;
                if (null == start) {
                    start = insertColumnsSegment.getStartIndex();
                }
                end = insertColumnsSegment.getStopIndex();
                allColumnSegment.addAll(insertColumnsSegment.getColumns());
            }
            return Optional.of(new InsertColumnsSegment(start.intValue(), end.intValue(), allColumnSegment));
        }
        return super.getInsertColumns();
    }

    public IntoStatement getIntoStatement() {
        return this.intoStatement;
    }

    public void setIntoStatement(IntoStatement intoStatement) {
        this.intoStatement = intoStatement;
    }

    public static class IntoStatement {
        private final int startIndex;
        private final int stopIndex;

        public IntoStatement(int startIndex, int stopIndex) {
            this.startIndex = startIndex;
            this.stopIndex = stopIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getStopIndex() {
            return this.stopIndex;
        }
    }
}

