/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner;

import com.cyberway.mp.bc.sharding.tablescanner.handler.AbstractDialectDatabaseHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(DatabaseHandlerFactory.class);
    private final Map<String, AbstractDialectDatabaseHandler> handlerMap = new HashMap<String, AbstractDialectDatabaseHandler>();

    public DatabaseHandlerFactory(List<AbstractDialectDatabaseHandler> strategyList) {
        for (AbstractDialectDatabaseHandler strategy : strategyList) {
            String databaseType = strategy.databaseType();
            if (!StringUtils.isNotEmpty((CharSequence)databaseType)) continue;
            this.handlerMap.put(databaseType.toUpperCase(), strategy);
        }
    }

    public AbstractDialectDatabaseHandler getDatabaseTableStrategy(String databaseType) {
        AbstractDialectDatabaseHandler strategy = this.handlerMap.get(databaseType.toUpperCase());
        if (strategy == null) {
            this.logger.error("databaseType not support\uff1a{}", (Object)databaseType);
        }
        return strategy;
    }
}

