/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner;

import com.cyberway.mp.bc.sharding.config.ShardingDatasourceHolder;
import com.cyberway.mp.bc.sharding.tablescanner.AutoCreateTableException;
import com.cyberway.mp.bc.sharding.tablescanner.ContextManagerHolder;
import com.cyberway.mp.bc.sharding.tablescanner.DatabaseHandlerFactory;
import com.cyberway.mp.bc.sharding.tablescanner.handler.AbstractDialectDatabaseHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.DmTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.OracleTableHandler;
import com.cyberway.mp.bc.sharding.tablescanner.handler.SqlServerTableHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.yaml.YamlJDBCConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.transaction.annotation.Transactional;

public class ShardingTableInitializer
implements ContextManagerLifecycleListener,
CommandLineRunner {
    private final Logger logger = LoggerFactory.getLogger(ShardingTableInitializer.class);
    private ShardingDatasourceHolder shardingDatasourceHolder;
    private YamlJDBCConfiguration properties;
    private DatabaseHandlerFactory databaseHandlerFactory;
    private ContextManager contextManager;
    @Value(value="${sharding.auto-create-table.enabled:false}")
    private Boolean autoCreateTable;

    public ShardingTableInitializer() {
    }

    public ShardingTableInitializer(ShardingDatasourceHolder shardingDatasourceHolder, YamlJDBCConfiguration properties, DatabaseHandlerFactory databaseHandlerFactory) {
        this.shardingDatasourceHolder = shardingDatasourceHolder;
        this.properties = properties;
        this.databaseHandlerFactory = databaseHandlerFactory;
        this.contextManager = ContextManagerHolder.getContextManager();
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(String ... args) throws SQLException, IOException {
        Map<String, DataSource> sourceMap = this.shardingDatasourceHolder.getSourceMap();
        if (Boolean.TRUE.equals(this.autoCreateTable)) {
            this.logger.debug("Auto create table enabled, start to create tables...");
            ShardingRuleConfiguration shardingRuleConfiguration = this.getShardingRuleConfiguration();
            ShardingRule shardingRule = new ShardingRule(shardingRuleConfiguration, sourceMap, this.contextManager.getComputeNodeInstanceContext(), Collections.emptyList());
            HashMap<String, List<String>> actualTableMap = this.getActualTableMap(shardingRule);
            this.createShardingTablesIfNotExist(sourceMap, actualTableMap);
        }
    }

    private ShardingRuleConfiguration getShardingRuleConfiguration() {
        return (ShardingRuleConfiguration)ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration((Collection)this.properties.getRules()).orElseThrow(() -> new AutoCreateTableException("No valid sharding rule configuration found."));
    }

    private HashMap<String, List<String>> getActualTableMap(ShardingRule shardingRule) {
        HashMap<String, List<String>> actualTableMap = new HashMap<String, List<String>>();
        for (Map.Entry tableEntry : shardingRule.getShardingTables().entrySet()) {
            String logicTableName = (String)tableEntry.getKey();
            actualTableMap.put(logicTableName, this.getAllActualDataNodes(shardingRule, logicTableName));
        }
        return actualTableMap;
    }

    private void createShardingTablesIfNotExist(Map<String, DataSource> sourceMap, HashMap<String, List<String>> actualTableMap) throws SQLException {
        for (Map.Entry<String, List<String>> entry : actualTableMap.entrySet()) {
            String logicTable = entry.getKey();
            List<String> actualTableNameList = entry.getValue();
            for (String actualTableName : actualTableNameList) {
                String[] split = actualTableName.split("\\.");
                if (split.length != 2) {
                    throw new AutoCreateTableException("Table name parse fail, Invalid table name format: " + actualTableName);
                }
                String dataSourceKey = split[0];
                String tableName = split[1];
                this.createShardingTableIfNotExist(sourceMap, dataSourceKey, tableName, logicTable);
            }
        }
        OracleTableHandler.afterExecuted();
        DmTableHandler.afterExecuted();
        SqlServerTableHandler.afterExecuted();
    }

    private void createShardingTableIfNotExist(Map<String, DataSource> sourceMap, String dataSourceKey, String tableName, String logicTableName) throws SQLException {
        DataSource dataSource = sourceMap.get(dataSourceKey);
        if (dataSource == null) {
            throw new AutoCreateTableException("Create table fail, DataSource not found for logic table: " + logicTableName);
        }
        try (Connection connection = dataSource.getConnection();){
            AbstractDialectDatabaseHandler databaseTableStrategy = this.databaseHandlerFactory.getDatabaseTableStrategy(connection.getMetaData().getDatabaseProductName());
            databaseTableStrategy.handleCreateTable(connection, logicTableName, tableName);
        }
    }

    private List<String> getAllActualDataNodes(ShardingRule shardingRule, String logicTableName) {
        ShardingTable tableRule = shardingRule.getShardingTable(logicTableName);
        if (tableRule == null) {
            throw new IllegalArgumentException("TableRule not found for logic table: " + logicTableName);
        }
        return tableRule.getActualDataNodes().stream().map(dataNode -> dataNode.getDataSourceName() + "." + dataNode.getTableName()).collect(Collectors.toList());
    }

    public void onInitialized(ContextManager contextManager) {
        ContextManagerHolder.setContextManager(contextManager);
    }

    public void onDestroyed(ContextManager contextManager) {
        ContextManagerHolder.setContextManager(null);
    }
}

