/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner.handler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialectDatabaseHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern;
    }

    public String getSchema(Connection connection) throws SQLException {
        return connection.getSchema();
    }

    protected String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    protected boolean existsTable(Connection connection, String tableName) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), this.getSchema(connection), this.formatTableNamePattern(tableName), this.getTableTypes());){
            boolean bl = rs.next();
            return bl;
        }
    }

    public abstract String getCreateTableDDL(String var1, String var2, Connection var3) throws SQLException;

    public abstract String databaseType();

    private void executeUpdate(Connection connection, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    public void handleCreateTable(Connection connection, String logicTableName, String tableName) throws SQLException {
        if (!this.existsTable(connection, tableName)) {
            this.logger.info("\u8868 {} \u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u81ea\u52a8\u521b\u5efa", (Object)tableName);
            String createTableDDL = this.getCreateTableDDL(logicTableName, tableName, connection);
            if (StringUtils.isNotBlank((CharSequence)createTableDDL)) {
                String[] split;
                for (String sql : split = createTableDDL.split(";")) {
                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                    this.executeUpdate(connection, sql.trim());
                }
            }
        }
    }
}

