/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner.handler;

import com.cyberway.mp.bc.sharding.tablescanner.handler.AbstractDialectDatabaseHandler;
import com.cyberway.mp.bc.sharding.tablescanner.util.IndexNameGenerateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OracleTableHandler
extends AbstractDialectDatabaseHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, List<String>> indexDDLMap = new HashMap<String, List<String>>();
    private static final Set<String> indexNameSet = new HashSet<String>();

    @Override
    protected String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern.toUpperCase();
    }

    @Override
    public String getSchema(Connection connection) throws SQLException {
        return Optional.ofNullable(connection.getMetaData().getUserName()).map(String::toUpperCase).orElse(null);
    }

    @Override
    public String getCreateTableDDL(String logicTableName, String tableName, Connection connection) throws SQLException {
        String indexName;
        StringBuilder ddlBuilder = new StringBuilder();
        String ddl = "CREATE TABLE " + tableName + " AS SELECT * FROM " + logicTableName + " WHERE 1=0";
        if (!ddl.endsWith(";")) {
            ddl = ddl + ";";
        }
        ddlBuilder.append(ddl).append("\n");
        List<String> indexDDLList = indexDDLMap.get(logicTableName);
        if (CollectionUtils.isEmpty(indexDDLList)) {
            indexDDLList = new ArrayList<String>();
            String sql = "SELECT INDEX_NAME AS indexName, DBMS_METADATA.GET_DDL('INDEX', INDEX_NAME, ?) AS ddl FROM ALL_INDEXES WHERE TABLE_NAME = ? AND OWNER = ? AND INDEX_TYPE NOT IN ('CLUSTER')";
            try (PreparedStatement indexPstmt = connection.prepareStatement(sql);){
                indexPstmt.setString(1, this.getSchema(connection));
                indexPstmt.setString(2, logicTableName.toUpperCase());
                indexPstmt.setString(3, this.getSchema(connection));
                try (ResultSet indexRs = indexPstmt.executeQuery();){
                    while (indexRs.next()) {
                        Object indexDDL = indexRs.getString("ddl");
                        indexName = indexRs.getString("indexName");
                        if (!((String)indexDDL).endsWith(";")) {
                            indexDDL = (String)indexDDL + ";";
                        }
                        indexDDLList.add(indexName + "=" + (String)indexDDL);
                    }
                    indexDDLMap.put(logicTableName, indexDDLList);
                }
            }
        }
        int i = 0;
        for (String item : indexDDLList) {
            String[] split = item.split("=");
            indexName = split[0];
            String indexDDL = split[1];
            indexDDL = indexDDL.toUpperCase().replaceAll(Pattern.quote(logicTableName.toUpperCase()), tableName.toUpperCase());
            indexName = indexName.toUpperCase().replaceAll(Pattern.quote(logicTableName.toUpperCase()), tableName.toUpperCase());
            Object newIndexName = indexName;
            String suffix = tableName.substring(tableName.lastIndexOf("_"));
            if (!indexName.endsWith(suffix)) {
                newIndexName = (String)newIndexName + suffix;
            }
            newIndexName = IndexNameGenerateUtil.generateIndexNameByFirstLetter((String)newIndexName, "_", "_" + i++);
            newIndexName = IndexNameGenerateUtil.ensureUniqueIndexName(indexNameSet, (String)newIndexName, split[0]);
            IndexNameGenerateUtil.checkIndexNameLength(split[0], (String)newIndexName, 30);
            indexDDL = indexDDL.replaceAll(Pattern.quote(indexName), (String)newIndexName);
            ddlBuilder.append(indexDDL).append("\n");
        }
        this.logger.info("\n" + ddlBuilder);
        return ddlBuilder.toString();
    }

    public static void afterExecuted() {
        indexDDLMap.clear();
        indexNameSet.clear();
    }

    @Override
    public String databaseType() {
        return "Oracle";
    }
}

