/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner.handler;

import com.cyberway.mp.bc.sharding.tablescanner.handler.AbstractDialectDatabaseHandler;
import com.cyberway.mp.bc.sharding.tablescanner.util.IndexNameGenerateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlServerTableHandler
extends AbstractDialectDatabaseHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, List<String>> INDEX_DDL_MAP = new HashMap<String, List<String>>();
    private static final Set<String> INDEX_NAME_SET = new HashSet<String>();

    @Override
    public String getCreateTableDDL(String logicTableName, String tableName, Connection connection) throws SQLException {
        StringBuilder ddlBuilder = new StringBuilder();
        String createTableDDL = "SELECT TOP 0 * INTO " + tableName + " FROM " + logicTableName;
        ddlBuilder.append(createTableDDL).append(";\n");
        List<String> indexDDLList = INDEX_DDL_MAP.get(logicTableName);
        if (CollectionUtils.isEmpty(indexDDLList)) {
            indexDDLList = this.fetchIndexDDL(logicTableName, connection);
            INDEX_DDL_MAP.put(logicTableName, indexDDLList);
        }
        int i = 0;
        for (String item : indexDDLList) {
            String[] split = item.split("=");
            String indexName = split[0];
            Object indexDDL = split[1];
            indexDDL = ((String)indexDDL).replaceAll(Pattern.quote(logicTableName), tableName);
            indexName = indexName.replaceAll(Pattern.quote(logicTableName), tableName);
            Object newIndexName = indexName;
            String suffix = tableName.substring(tableName.lastIndexOf("_"));
            if (!indexName.endsWith(suffix)) {
                newIndexName = (String)newIndexName + suffix;
            }
            newIndexName = (String)newIndexName + "_" + i++;
            IndexNameGenerateUtil.ensureUniqueIndexName(INDEX_NAME_SET, (String)newIndexName, split[0]);
            indexDDL = "CREATE " + ((String)indexDDL).replaceAll(Pattern.quote(indexName), (String)newIndexName);
            ddlBuilder.append((String)indexDDL).append(";\n");
        }
        this.logger.info("\n" + ddlBuilder);
        return ddlBuilder.toString();
    }

    private List<String> fetchIndexDDL(String logicTableName, Connection connection) throws SQLException {
        ArrayList<String> indexDDLList = new ArrayList<String>();
        String sql = "SELECT i.name AS indexName, CASE WHEN i.is_unique = 1 THEN 'UNIQUE ' ELSE '' END + CASE WHEN i.type_desc = 'CLUSTERED' THEN 'CLUSTERED ' ELSE 'NONCLUSTERED ' END + 'INDEX [' + i.name + '] ON [' + OBJECT_SCHEMA_NAME(t.object_id) + '].[' + t.name + '] (' + STUFF((SELECT ', [' + c.name + ']' FROM sys.index_columns ic JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id WHERE ic.object_id = i.object_id AND ic.index_id = i.index_id ORDER BY ic.key_ordinal FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 2, '') + ')' AS ddl FROM sys.indexes i JOIN sys.tables t ON i.object_id = t.object_id WHERE t.name = ?";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            pstmt.setString(1, logicTableName);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    String indexDDL = rs.getString("ddl");
                    String indexName = rs.getString("indexName");
                    indexDDLList.add(indexName + "=" + indexDDL);
                }
            }
        }
        return indexDDLList;
    }

    public static void afterExecuted() {
        INDEX_DDL_MAP.clear();
        INDEX_NAME_SET.clear();
    }

    @Override
    public String databaseType() {
        return "Microsoft SQL Server";
    }
}

