/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.sharding.tablescanner.util;

import com.cyberway.mp.bc.sharding.tablescanner.AutoCreateTableException;
import java.util.Random;
import java.util.Set;

public class IndexNameGenerateUtil {
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Random RANDOM = new Random();

    private IndexNameGenerateUtil() {
    }

    public static String generateIndexNameByFirstLetter(String originalName, String delimiter, String suffix) {
        String[] parts = originalName.split(delimiter);
        StringBuilder newIndexNameBuilder = new StringBuilder();
        String numericPart = "";
        for (String part : parts) {
            if (part.matches("[A-Za-z]+")) {
                newIndexNameBuilder.append(part.charAt(0));
                continue;
            }
            if (!part.matches("[0-9]+")) continue;
            numericPart = part;
        }
        return newIndexNameBuilder + numericPart + suffix;
    }

    public static void checkIndexNameLength(String originalName, String indexName, int maxLength) {
        if (indexName.length() > maxLength) {
            throw new AutoCreateTableException("Index name is too long. Original name: {" + originalName + "}, resulted in index name: {" + indexName + "}. The length exceeds the maximum allowed limit of 30 characters.");
        }
    }

    public static String ensureUniqueIndexName(Set<String> indexNameSet, String newIndexName, String originalName) throws AutoCreateTableException {
        if (!indexNameSet.contains(newIndexName)) {
            indexNameSet.add((String)newIndexName);
        } else {
            String tempNewIndexName = (String)newIndexName + "_" + IndexNameGenerateUtil.generateRandomLetters(4);
            if (!indexNameSet.contains(tempNewIndexName)) {
                indexNameSet.add(tempNewIndexName);
                newIndexName = tempNewIndexName;
            } else {
                throw new AutoCreateTableException("Generated index name is duplicated. Original name: { " + originalName + "}, resulted in index name: {" + (String)newIndexName + "}. Please try to modify the first letter of each word in the index name.");
            }
        }
        return newIndexName;
    }

    private static String generateRandomLetters(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = RANDOM.nextInt(LETTERS.length());
            sb.append(LETTERS.charAt(index));
        }
        return sb.toString();
    }
}

