/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.api.form.dto.req;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ApiElementDto {
    @NotBlank
    @Schema(title="\u8bf7\u6c42\u65b9\u6cd5\uff0c\u5982POST")
    private String method;
    @NotBlank
    @Schema(title="\u8def\u5f84\uff0c\u4e0d\u9700\u8981\u5e26\u670d\u52a1\u524d\u7f00")
    private String path;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public static ApiElementDto of(String wrapPath) {
        if (StringUtils.isNotBlank((CharSequence)wrapPath)) {
            ApiElementDto dto = new ApiElementDto();
            String[] split = wrapPath.split(":");
            if (split.length == 2) {
                dto.setMethod(split[0].toUpperCase());
                dto.setPath(split[1]);
            }
            return dto;
        }
        return null;
    }

    public String toString() {
        String methodStr = null == this.method ? "" : this.method;
        String pathStr = null == this.path ? "" : this.path;
        return methodStr.toUpperCase() + ":" + pathStr;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiElementDto)) {
            return false;
        }
        ApiElementDto that = (ApiElementDto)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path);
    }
}

