/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.client;

import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigCreateDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigModifyDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigPageDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigSaveDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigCreateDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigModifyDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigPageDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigSaveDto;
import com.cyberway.mp.basic.data.api.calendar.dto.WorkingTimeQueryDto;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarConfigListVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarConfigVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarHolidayConfigListVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarHolidayConfigVo;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${mp.basic-data-feign.server-name:bdc-server}", contextId="CalendarConfigClient", path="api/calendarConfig")
public interface CalendarConfigClient {
    @PostMapping
    public ResponseResult<Long> createCalendarConfig(@RequestBody CalendarConfigCreateDto var1);

    @PostMapping(value={"batch"})
    public ResponseResult<Void> createCalendarConfigBatch(@RequestBody List<CalendarConfigCreateDto> var1);

    @PutMapping
    public ResponseResult<Void> modifyCalendarConfig(@RequestBody CalendarConfigModifyDto var1);

    @PutMapping(value={"batch"})
    public ResponseResult<Void> modifyCalendarConfigBatch(@RequestBody List<CalendarConfigModifyDto> var1);

    @GetMapping(value={"{id}"})
    public ResponseResult<CalendarConfigVo> getCalendarConfig(@PathVariable(value="id") long var1);

    @PostMapping(value={"query"})
    public ResponseResult<Page<CalendarConfigListVo>> queryCalendarConfig(@RequestBody CalendarConfigPageDto var1);

    @DeleteMapping(value={"{id}"})
    public ResponseResult<Void> deleteCalendarConfig(@PathVariable(value="id") long var1);

    @DeleteMapping(value={"batch"})
    public ResponseResult<Void> deleteCalendarConfigBatch(@RequestBody List<Long> var1);

    @PostMapping(value={"holiday"})
    public ResponseResult<Long> createCalendarHolidayConfig(@RequestBody CalendarHolidayConfigCreateDto var1);

    @PutMapping(value={"holiday"})
    public ResponseResult<Void> modifyCalendarHolidayConfig(@RequestBody CalendarHolidayConfigModifyDto var1);

    @PutMapping(value={"holiday/batch"})
    public ResponseResult<Void> modifyCalendarHolidayConfigBatch(@RequestBody List<CalendarHolidayConfigModifyDto> var1);

    @PostMapping(value={"holiday/batch"})
    public ResponseResult<Void> createCalendarHolidayConfigBatch(@RequestBody List<CalendarHolidayConfigCreateDto> var1);

    @GetMapping(value={"holiday/{id}"})
    public ResponseResult<CalendarHolidayConfigVo> getCalendarHolidayConfig(@PathVariable(value="id") long var1);

    @PostMapping(value={"holiday/query"})
    public ResponseResult<Page<CalendarHolidayConfigListVo>> queryCalendarHolidayConfig(@RequestBody CalendarHolidayConfigPageDto var1);

    @DeleteMapping(value={"holiday/{id}"})
    public ResponseResult<Void> deleteCalendarHolidayConfig(@PathVariable(value="id") long var1);

    @DeleteMapping(value={"holiday/batch"})
    public ResponseResult<Void> deleteCalendarHolidayConfigBatch(@RequestBody List<Long> var1);

    @GetMapping(value={"workDays"})
    public ResponseResult<Integer> getWorkDays(@RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var1, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2);

    @GetMapping(value={"workHours"})
    public ResponseResult<Long> getWorkHours(@RequestParam(value="startDate") Date var1, @RequestParam(value="endDate") Date var2);

    @GetMapping(value={"activeConfig"})
    public ResponseResult<Void> activeConfig(@RequestParam(value="id") long var1);

    @GetMapping(value={"defaultConfig"})
    public ResponseResult<CalendarConfigVo> getDefaultConfig();

    @PostMapping(value={"isWorkingTime"})
    public ResponseResult<Boolean> isWorkingTime(@RequestBody WorkingTimeQueryDto var1);

    @PutMapping(value={"globalConfig"})
    public ResponseResult<Void> modifyDefaultConfig(@RequestBody CalendarConfigModifyDto var1);

    @PostMapping(value={"globalConfig/holiday"})
    public ResponseResult<Void> saveDefaultConfigHolidays(@RequestBody List<CalendarHolidayConfigSaveDto> var1);

    @DeleteMapping(value={"globalConfig/holiday"})
    public ResponseResult<Void> deleteDefaultConfigHolidays(@RequestBody List<Long> var1);

    @PostMapping(value={"save/batch"})
    public ResponseResult<Void> saveCalendarConfigBatch(@RequestBody List<CalendarConfigSaveDto> var1);

    @PostMapping(value={"holiday/save/batch"})
    public ResponseResult<Void> saveCalendarHolidayConfigBatch(@RequestBody List<CalendarHolidayConfigSaveDto> var1);

    @GetMapping(value={"calculateEndTime"})
    public ResponseResult<Date> calculateEndTime(@RequestParam(value="configCode", required=false) String var1, @RequestParam(value="startTime") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date var2, @RequestParam(value="days") int var3, @RequestParam(value="hours") int var4, @RequestParam(value="minutes") int var5);
}

