/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.client;

import com.cyberway.mp.basic.data.api.metadata.TableInfo;
import com.cyberway.mp.basic.data.api.metadata.dto.BaseEntityCreateDto;
import com.cyberway.mp.basic.data.api.metadata.dto.BaseEntityUpdateDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EnableRelateQueryDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityChangeLogQueryDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityFieldDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityFieldGroupDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityFlowConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityForPageDesignDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityForPageDesignPageDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityPropertyDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityQueryDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityReleaseQueryDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntitySelectConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntitySelf2SystemDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntitySyncConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityVersionDifferenceDto;
import com.cyberway.mp.basic.data.api.metadata.dto.GenerateScriptDto;
import com.cyberway.mp.basic.data.api.metadata.dto.ReleaseCreateDto;
import com.cyberway.mp.basic.data.api.metadata.dto.TableInfoDto;
import com.cyberway.mp.basic.data.api.metadata.vo.BaseEntityEditVo;
import com.cyberway.mp.basic.data.api.metadata.vo.BaseEntityViewReleaseVo;
import com.cyberway.mp.basic.data.api.metadata.vo.DataTypeVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityAiImportResultVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityChangeLogVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityFieldGroupVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityFieldVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityForPageDesignVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityListVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityMetadataVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityPropertyVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityRelateMinVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityReleaseListVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityReleaseVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityViewReleaseFullVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityViewReleaseVo;
import com.cyberway.mp.basic.data.api.metadata.vo.FlowExportSelectVo;
import com.cyberway.mp.basic.data.api.metadata.vo.ScriptInfoVo;
import com.cyberway.mp.basic.data.api.rule.dto.SimilarityRuleDto;
import com.cyberway.mp.basic.data.api.rule.dto.req.RuleExpressionUpdateReqDto;
import com.cyberway.mp.basic.data.api.rule.dto.resp.RuleExpressionListRespDto;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="EntityClient", value="${mp.basic-data-feign.server-name:bdc-server}", path="/api/entity")
public interface EntityClient {
    @PostMapping(value={"/base"})
    public ResponseResult<Long> createBaseEntity(@RequestBody BaseEntityCreateDto var1);

    @PostMapping(value={"/page"})
    public ResponseResult<Page<EntityListVo>> page(@RequestBody EntityQueryDto var1);

    @PostMapping(value={"/release/page"})
    public ResponseResult<Page<EntityReleaseVo>> pageRelease(@RequestBody EntityReleaseQueryDto var1);

    @PostMapping(value={"/release/list"})
    public ResponseResult<List<EntityReleaseVo>> listRelease(@RequestBody EntityReleaseQueryDto var1);

    @GetMapping(value={"/base/editView/{id}"})
    public ResponseResult<BaseEntityEditVo> baseEditView(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/releaseView/{id}"})
    public ResponseResult<EntityViewReleaseVo> entityViewRelease(@PathVariable(value="id") Long var1, @RequestParam(value="version", required=false) String var2);

    @GetMapping(value={"/base/releaseView/{id}"})
    public ResponseResult<BaseEntityViewReleaseVo> baseEntityViewRelease(@PathVariable(value="id") Long var1, @RequestParam(value="version", required=false) String var2);

    @GetMapping(value={"/getReleaseViewByCode"})
    public ResponseResult<EntityViewReleaseVo> getReleaseViewByCode(@RequestParam(value="entityCode") String var1, @RequestParam(value="version", required=false) String var2);

    @GetMapping(value={"/getEntityViewReleaseFullByCode"})
    public ResponseResult<EntityViewReleaseFullVo> getEntityViewReleaseFullByCode(@RequestParam(value="entityCode") String var1, @RequestParam(value="version", required=false) String var2);

    @PostMapping(value={"/listLatestEntityReleaseByCodes"})
    public ResponseResult<List<EntityReleaseListVo>> listLatestEntityReleaseByCodes(@RequestBody List<String> var1);

    @GetMapping(value={"/getEntityField"})
    public ResponseResult<List<EntityFieldVo>> getEntityField(@RequestParam(value="entityCode") String var1, @RequestParam(value="entityVersion") String var2, @RequestParam(value="releaseFlag") boolean var3);

    @GetMapping(value={"/dateTypes"})
    public ResponseResult<List<DataTypeVo>> dataTypeList();

    @PutMapping(value={"/base/{id}"})
    public ResponseResult<Void> modifyBaseEntity(@PathVariable(value="id") Long var1, @RequestBody BaseEntityUpdateDto var2);

    @PutMapping(value={"/modifyEntityProperty/{entityId}"})
    public ResponseResult<Void> modifyEntityProperty(@PathVariable(value="entityId") Long var1, @RequestBody EntityPropertyDto var2);

    @DeleteMapping(value={"/{id}"})
    public ResponseResult<Void> deleteEntity(@PathVariable(value="id") Long var1);

    @DeleteMapping(value={"/batchDeleteEntity"})
    public ResponseResult<Void> batchDeleteEntity(@RequestBody List<Long> var1);

    @PostMapping(value={"/getVersionDifference"})
    public ResponseResult<List<EntityVersionDifferenceDto>> getVersionDifference(@RequestBody List<Long> var1);

    @PostMapping(value={"/release/create"})
    public ResponseResult<Void> createRelease(@RequestBody ReleaseCreateDto var1);

    @PostMapping(value={"/generateScript"})
    public ResponseResult<ScriptInfoVo> generateScript(@RequestBody GenerateScriptDto var1);

    @GetMapping(value={"/getReleaseVersions"})
    public ResponseResult<List<String>> getReleaseVersions(@RequestParam(value="entityCode") String var1);

    @PostMapping(value={"/listEntityForPageDesign"})
    public ResponseResult<List<EntityForPageDesignVo>> listEntityForPageDesign(@RequestBody EntityForPageDesignDto var1);

    @PostMapping(value={"/pageEntityForPageDesign"})
    public ResponseResult<Page<EntityForPageDesignVo>> pageEntityForPageDesign(@RequestBody EntityForPageDesignPageDto var1);

    @GetMapping(value={"/loadReleaseEntityMetadata"})
    public ResponseResult<EntityMetadataVo> loadReleaseEntityMetadata(@RequestParam(value="code") String var1);

    @PostMapping(value={"/batchLoadReleaseEntityMetadata"})
    public ResponseResult<Map<String, EntityMetadataVo>> batchLoadReleaseEntityMetadata(@RequestBody List<String> var1);

    @GetMapping(value={"/loadDefaultFields"})
    public ResponseResult<List<EntityFieldDto>> loadDefaultFields();

    @PostMapping(value={"/continueRelease/{id}"})
    public ResponseResult<Void> continueRelease(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/getLatestEntityReleaseByCode"})
    public ResponseResult<EntityReleaseVo> getLatestEntityReleaseByCode(@RequestParam(value="entityCode") String var1);

    @PostMapping(value={"/entityChangeLogs"})
    public ResponseResult<Page<EntityChangeLogVo>> pageEntityChangeLogVo(@RequestBody EntityChangeLogQueryDto var1);

    @GetMapping(value={"/createApiInfos"})
    public ResponseResult<Void> createApiInfos(@RequestParam(value="entityCode") String var1);

    @GetMapping(value={"/getPropertyByEntityId/{entityId}"})
    public ResponseResult<EntityPropertyVo> getPropertyByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getPropertyByEntityCode/{entityCode}"})
    public ResponseResult<EntityPropertyVo> getPropertyByEntityCode(@PathVariable(value="entityCode") String var1);

    @GetMapping(value={"/getReleasePropertyByEntityId/{entityId}"})
    public ResponseResult<EntityPropertyVo> getReleasePropertyByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @GetMapping(value={"/getReleasePropertyByEntityCode"})
    public ResponseResult<EntityPropertyVo> getReleasePropertyByEntityCode(@RequestParam(value="entityCode") String var1, @RequestParam(name="version", required=false) String var2);

    @PutMapping(value={"/modifyEntityFieldGroup/{entityId}"})
    public ResponseResult<Void> modifyEntityFieldGroup(@PathVariable(value="entityId") Long var1, @RequestBody List<EntityFieldGroupDto> var2);

    @GetMapping(value={"/getFieldGroupByEntityId/{entityId}"})
    public ResponseResult<List<EntityFieldGroupVo>> getFieldGroupByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getReleaseFieldGroupByEntityId/{entityId}"})
    public ResponseResult<List<EntityFieldGroupVo>> getReleaseFieldGroupByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @PutMapping(value={"/modifyEntityRule/{entityId}"})
    public ResponseResult<Void> modifyEntityRule(@PathVariable(value="entityId") Long var1, @RequestBody List<RuleExpressionUpdateReqDto> var2);

    @GetMapping(value={"/getRuleByEntityId/{entityId}"})
    public ResponseResult<List<RuleExpressionListRespDto>> getRuleByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getRuleByEntityCode/{entityCode}"})
    public ResponseResult<List<RuleExpressionListRespDto>> getRuleByEntityCode(@PathVariable(value="entityCode") String var1);

    @GetMapping(value={"/getReleaseRuleByEntityId/{entityId}"})
    public ResponseResult<List<RuleExpressionListRespDto>> getReleaseRuleByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @PutMapping(value={"/modifySelectConfig/{entityId}"})
    public ResponseResult<Void> modifySelectConfig(@PathVariable(value="entityId") Long var1, @RequestBody EntitySelectConfigDto var2);

    @GetMapping(value={"/getSelectConfigByEntityId/{entityId}"})
    public ResponseResult<EntitySelectConfigDto> getSelectConfigByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getReleaseSelectConfigByEntityId/{entityId}"})
    public ResponseResult<EntitySelectConfigDto> getReleaseSelectConfigByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @PutMapping(value={"/modifyFlowConfig/{entityId}"})
    public ResponseResult<Void> modifyFlowConfig(@PathVariable(value="entityId") Long var1, @RequestBody List<EntityFlowConfigDto> var2);

    @GetMapping(value={"/getFlowConfigByEntityId/{entityId}"})
    public ResponseResult<List<EntityFlowConfigDto>> getFlowConfigByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getFlowConfigByEntityCode"})
    public ResponseResult<List<EntityFlowConfigDto>> getFlowConfigByEntityCode(@RequestParam(value="entityCode") String var1, @RequestParam(name="tenantId") Long var2);

    @GetMapping(value={"/loadEntityFlowConfig"})
    public ResponseResult<EntityFlowConfigDto> loadEntityFlowConfig(@RequestParam(value="entityCode") String var1, @RequestParam(name="eventCode") String var2);

    @PostMapping(value={"/queryEnableRelateList"})
    public ResponseResult<List<EntityRelateMinVo>> queryEnableRelateList(@RequestBody EnableRelateQueryDto var1);

    @PutMapping(value={"/modifySimilarityRule/{entityId}"})
    public ResponseResult<Void> modifySimilarityRule(@PathVariable(value="entityId") Long var1, @RequestBody SimilarityRuleDto var2);

    @GetMapping(value={"/getSimilarityRuleByEntityId/{entityId}"})
    public ResponseResult<SimilarityRuleDto> getSimilarityRuleByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getReleaseSimilarityRuleByEntityId/{entityId}"})
    public ResponseResult<SimilarityRuleDto> getReleaseSimilarityRuleByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @PutMapping(value={"/modifySyncConfig/{entityId}"})
    public ResponseResult<Void> modifySyncConfig(@PathVariable(value="entityId") Long var1, @RequestBody EntitySyncConfigDto var2);

    @GetMapping(value={"/getSyncConfigByEntityId/{entityId}"})
    public ResponseResult<EntitySyncConfigDto> getSyncConfigByEntityId(@PathVariable(value="entityId") Long var1);

    @GetMapping(value={"/getReleaseSyncConfigByEntityId/{entityId}"})
    public ResponseResult<EntitySyncConfigDto> getReleaseSyncConfigByEntityId(@PathVariable(value="entityId") Long var1, @RequestParam(name="version", required=false) String var2);

    @GetMapping(value={"/refreshCache"})
    public ResponseResult<Void> refreshCache(@RequestParam(value="entityCode") String var1, @RequestParam(value="tenantId") Long var2);

    @PostMapping(value={"/aiImport"})
    public ResponseResult<EntityAiImportResultVo> aiImport(@RequestBody String var1);

    @GetMapping(value={"/getCenterTables/{centerId}"})
    public ResponseResult<List<TableInfo>> getCenterTables(@PathVariable(value="centerId") Long var1, @RequestParam(value="tableType", required=false) String var2);

    @PostMapping(value={"/listFlowProjectForExport"})
    public ResponseResult<List<FlowExportSelectVo>> listFlowProjectForExport(@RequestBody List<Long> var1);

    @PostMapping(value={"/createSelfEntityByTableInfo"})
    public ResponseResult<Void> createSelfEntityByTableInfo(@RequestBody TableInfoDto var1);

    @PostMapping(value={"/self2System"})
    public ResponseResult<Void> self2System(@RequestBody EntitySelf2SystemDto var1);
}

