/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.client;

import com.cyberway.mp.basic.data.api.form.dto.req.FormCssDto;
import com.cyberway.mp.basic.data.api.form.dto.req.FormPageCreateReqDto;
import com.cyberway.mp.basic.data.api.form.dto.req.FormPageGenForEntityDto;
import com.cyberway.mp.basic.data.api.form.dto.req.FormPageModifyReqDto;
import com.cyberway.mp.basic.data.api.form.dto.req.FormPageQueryReqDto;
import com.cyberway.mp.basic.data.api.form.dto.resp.FormPageMinRespDto;
import com.cyberway.mp.basic.data.api.form.dto.resp.FormPageRespDto;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="FormPageClient", value="${mp.basic-data-feign.server-name:bdc-server}", path="/api/formPage")
public interface FormPageClient {
    @PostMapping(value={"/create"})
    public ResponseResult<Long> create(@RequestBody FormPageCreateReqDto var1);

    @PostMapping(value={"/copy/{id}"})
    public ResponseResult<Long> copy(@PathVariable(value="id") Long var1);

    @PutMapping(value={"/modify"})
    public ResponseResult<Void> modify(@RequestBody FormPageModifyReqDto var1);

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseResult<Void> delete(@PathVariable(value="id") Long var1);

    @DeleteMapping(value={"/deleteByEntityCode"})
    public ResponseResult<Void> deleteByEntityCode(@RequestParam(value="entityCode") String var1, @RequestParam(value="tenantId") Long var2);

    @PostMapping(value={"/page"})
    public ResponseResult<Page<FormPageRespDto>> page(@RequestBody FormPageQueryReqDto var1);

    @PostMapping(value={"/queryBaseInfoList"})
    public ResponseResult<List<FormPageMinRespDto>> queryBaseInfoList(@RequestBody FormPageQueryReqDto var1);

    @GetMapping(value={"/detail/{id}"})
    public ResponseResult<FormPageRespDto> detail(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/hisDetail/{id}"})
    public ResponseResult<FormPageRespDto> hisDetail(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/detailByCode/{code}"})
    public ResponseResult<FormPageRespDto> detailByCode(@PathVariable(value="code") String var1, @RequestParam(name="version", required=false) Integer var2);

    @PutMapping(value={"/enable/{id}"})
    public ResponseResult<Void> enable(@PathVariable(value="id") Long var1);

    @PutMapping(value={"/disable/{id}"})
    public ResponseResult<Void> disable(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/genForEntity"})
    public ResponseResult<Void> genForEntity(@RequestBody FormPageGenForEntityDto var1);

    @PostMapping(value={"/createOrModifyFormCss"})
    public ResponseResult<Long> createOrModifyFormCss(@RequestBody FormCssDto var1);

    @GetMapping(value={"/getGlobalFormCss/{appInstanceId}"})
    public ResponseResult<FormCssDto> getGlobalFormCss(@PathVariable(value="appInstanceId") Long var1);

    @GetMapping(value={"/getCurrentFormCss/{formId}"})
    public ResponseResult<FormCssDto> getCurrentFormCss(@PathVariable(value="formId") Long var1);
}

