/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.metadata.BusinessObjectMetadataApi;
import com.cyberway.mp.basic.data.api.metadata.dto.BusinessObjectCreateDto;
import com.cyberway.mp.basic.data.api.metadata.dto.BusinessObjectModifyDto;
import com.cyberway.mp.basic.data.api.metadata.dto.BusinessObjectQueryDto;
import com.cyberway.mp.basic.data.api.metadata.vo.BusinessObjectFullVo;
import com.cyberway.mp.basic.data.api.metadata.vo.BusinessObjectListVo;
import com.cyberway.mp.basic.data.feign.client.BusinessObjectClient;
import com.cyberway.mp.bc.common.api.Page;
import jakarta.validation.Valid;
import java.util.Set;

public class BusinessObjectMetadataService
implements BusinessObjectMetadataApi {
    private final BusinessObjectClient businessObjectClient;

    public BusinessObjectMetadataService(BusinessObjectClient businessObjectClient) {
        this.businessObjectClient = businessObjectClient;
    }

    public long createBusinessObject(@Valid BusinessObjectCreateDto dto) {
        return (Long)this.businessObjectClient.create(dto).getData();
    }

    public void modifyBusinessObject(long id, @Valid BusinessObjectModifyDto dto) {
        this.businessObjectClient.modifyBusinessObject(id, dto);
    }

    public void bindEntities(long businessObjectId, Set<String> entityCodes) {
        this.businessObjectClient.bindEntities(businessObjectId, entityCodes);
    }

    public void deleteEntityBinding(long businessObjectId, String entityCode) {
        this.businessObjectClient.deleteEntityBinding(businessObjectId, entityCode);
    }

    public void deleteBusinessObject(long id) {
        this.businessObjectClient.deleteBusinessObject(id);
    }

    public Page<BusinessObjectListVo> pageBusinessObject(BusinessObjectQueryDto dto) {
        return (Page)this.businessObjectClient.page(dto).getData();
    }

    public BusinessObjectFullVo getBusinessObject(long businessObjectId) {
        return (BusinessObjectFullVo)this.businessObjectClient.get(businessObjectId).getData();
    }
}

