/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.calendar.CalendarConfigApi;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigCreateDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigModifyDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigPageDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarConfigSaveDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigCreateDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigModifyDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigPageDto;
import com.cyberway.mp.basic.data.api.calendar.dto.CalendarHolidayConfigSaveDto;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarConfigListVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarConfigVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarHolidayConfigListVo;
import com.cyberway.mp.basic.data.api.calendar.vo.CalendarHolidayConfigVo;
import com.cyberway.mp.basic.data.feign.client.CalendarConfigClient;
import com.cyberway.mp.bc.common.api.Page;
import jakarta.validation.Valid;
import java.util.List;

public class CalendarConfigService
implements CalendarConfigApi {
    private final CalendarConfigClient calendarConfigClient;

    public CalendarConfigService(CalendarConfigClient calendarConfigClient) {
        this.calendarConfigClient = calendarConfigClient;
    }

    public long createCalendarConfig(CalendarConfigCreateDto calendarConfigCreateDto) {
        return (Long)this.calendarConfigClient.createCalendarConfig(calendarConfigCreateDto).getData();
    }

    public void branchCreateCalendarConfig(List<CalendarConfigCreateDto> dtoList) {
        this.calendarConfigClient.createCalendarConfigBatch(dtoList);
    }

    public void modifyCalendarConfig(CalendarConfigModifyDto calendarConfigModifyDto) {
        this.calendarConfigClient.modifyCalendarConfig(calendarConfigModifyDto);
    }

    public void batchModifyCalendarConfig(List<CalendarConfigModifyDto> dtoList) {
        this.calendarConfigClient.modifyCalendarConfigBatch(dtoList);
    }

    public CalendarConfigVo getCalendarConfig(long id) {
        return (CalendarConfigVo)this.calendarConfigClient.getCalendarConfig(id).getData();
    }

    public Page<CalendarConfigListVo> queryCalendarConfig(CalendarConfigPageDto calendarConfigPageDto) {
        return (Page)this.calendarConfigClient.queryCalendarConfig(calendarConfigPageDto).getData();
    }

    public void deleteCalendarConfig(long id) {
        this.calendarConfigClient.deleteCalendarConfig(id);
    }

    public void batchDeleteCalendarConfig(List<Long> ids) {
        this.calendarConfigClient.deleteCalendarConfigBatch(ids);
    }

    public long createCalendarHolidayConfig(CalendarHolidayConfigCreateDto calendarHolidayConfigCreateDto) {
        return (Long)this.calendarConfigClient.createCalendarHolidayConfig(calendarHolidayConfigCreateDto).getData();
    }

    public void modifyCalendarHolidayConfig(CalendarHolidayConfigModifyDto calendarHolidayConfigModifyDto) {
        this.calendarConfigClient.modifyCalendarHolidayConfig(calendarHolidayConfigModifyDto);
    }

    public void modifyCalendarHolidayConfigBatch(List<@Valid CalendarHolidayConfigModifyDto> calendarHolidayConfigModifyDtoList) {
        this.calendarConfigClient.modifyCalendarHolidayConfigBatch(calendarHolidayConfigModifyDtoList);
    }

    public CalendarHolidayConfigVo getCalendarHolidayConfig(long id) {
        return (CalendarHolidayConfigVo)this.calendarConfigClient.getCalendarHolidayConfig(id).getData();
    }

    public Page<CalendarHolidayConfigListVo> queryCalendarHolidayConfig(CalendarHolidayConfigPageDto calendarHolidayConfigPageDto) {
        return (Page)this.calendarConfigClient.queryCalendarHolidayConfig(calendarHolidayConfigPageDto).getData();
    }

    public void deleteCalendarHolidayConfig(long id) {
        this.calendarConfigClient.deleteCalendarHolidayConfig(id);
    }

    public void batchDeleteCalendarHolidayConfig(List<Long> ids) {
        this.calendarConfigClient.deleteCalendarHolidayConfigBatch(ids);
    }

    public void activeConfig(long id) {
        this.calendarConfigClient.activeConfig(id);
    }

    public CalendarConfigVo getDefaultConfig() {
        return (CalendarConfigVo)this.calendarConfigClient.getDefaultConfig().getData();
    }

    public void createCalendarHolidayConfigBatch(List<CalendarHolidayConfigCreateDto> calendarHolidayConfigCreateDtoList) {
        this.calendarConfigClient.createCalendarHolidayConfigBatch(calendarHolidayConfigCreateDtoList);
    }

    public void modifyDefaultConfig(CalendarConfigModifyDto calendarConfigModifyDto) {
        this.calendarConfigClient.modifyDefaultConfig(calendarConfigModifyDto);
    }

    public void saveDefaultConfigHolidays(List<@Valid CalendarHolidayConfigSaveDto> dtoList) {
        this.calendarConfigClient.saveDefaultConfigHolidays(dtoList);
    }

    public void deleteDefaultConfigHolidays(List<Long> ids) {
        this.calendarConfigClient.deleteDefaultConfigHolidays(ids);
    }

    public void saveCalendarConfigBatch(List<@Valid CalendarConfigSaveDto> dtoList) {
        this.calendarConfigClient.saveCalendarConfigBatch(dtoList);
    }

    public void saveCalendarHolidayConfigBatch(List<@Valid CalendarHolidayConfigSaveDto> dtoList) {
        this.calendarConfigClient.saveCalendarHolidayConfigBatch(dtoList);
    }
}

