/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.calendar.CalendarApi;
import com.cyberway.mp.basic.data.api.calendar.dto.WorkingTimeQueryDto;
import com.cyberway.mp.basic.data.feign.client.CalendarConfigClient;
import java.time.LocalDate;
import java.util.Date;

public class CalendarService
implements CalendarApi {
    private final CalendarConfigClient calendarConfigClient;

    public CalendarService(CalendarConfigClient calendarConfigClient) {
        this.calendarConfigClient = calendarConfigClient;
    }

    public int getWorkDays(LocalDate startDate, LocalDate endDate) {
        return (Integer)this.calendarConfigClient.getWorkDays(startDate, endDate).getData();
    }

    public long getWorkHours(Date startDate, Date endDate) {
        return (Long)this.calendarConfigClient.getWorkHours(startDate, endDate).getData();
    }

    public boolean isWorkingTime(Date time, boolean ignoreTimeRange) {
        WorkingTimeQueryDto dto = new WorkingTimeQueryDto();
        dto.setTime(time);
        dto.setIgnoreTimeRange(ignoreTimeRange);
        return Boolean.TRUE.equals(this.calendarConfigClient.isWorkingTime(dto).getData());
    }

    public Date calculateEndTime(String configCode, Date startTime, int days, int hours, int minutes) {
        return (Date)this.calendarConfigClient.calculateEndTime(configCode, startTime, days, hours, minutes).getData();
    }
}

