/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.BasicStatus;
import com.cyberway.mp.basic.data.api.center.CenterApi;
import com.cyberway.mp.basic.data.api.center.DataSourceType;
import com.cyberway.mp.basic.data.api.center.dto.CenterCreateDto;
import com.cyberway.mp.basic.data.api.center.dto.CenterDomainQueryDto;
import com.cyberway.mp.basic.data.api.center.dto.CenterModifyDto;
import com.cyberway.mp.basic.data.api.center.dto.CenterQueryDto;
import com.cyberway.mp.basic.data.api.center.vo.CenterDetailVo;
import com.cyberway.mp.basic.data.api.center.vo.CenterDomainVo;
import com.cyberway.mp.basic.data.api.center.vo.CenterSimpleVo;
import com.cyberway.mp.basic.data.api.center.vo.CenterVo;
import com.cyberway.mp.basic.data.api.center.vo.CenterVoWithPassword;
import com.cyberway.mp.basic.data.feign.client.CenterClient;
import com.cyberway.mp.basic.data.feign.client.CenterDomainClient;
import com.cyberway.mp.bc.common.api.Page;
import jakarta.validation.Valid;
import java.util.List;

public class CenterService
implements CenterApi {
    private final CenterClient centerClient;
    private final CenterDomainClient centerDomainClient;

    public CenterService(CenterClient centerClient, CenterDomainClient centerDomainClient) {
        this.centerClient = centerClient;
        this.centerDomainClient = centerDomainClient;
    }

    public List<CenterVo> listCenter(BasicStatus status) {
        return (List)this.centerClient.list(status).getData();
    }

    public Page<CenterDomainVo> pageCenterDomain(@Valid CenterDomainQueryDto dto) {
        return (Page)this.centerDomainClient.page(dto).getData();
    }

    public Page<CenterSimpleVo> pageCenter(CenterQueryDto dto) {
        return (Page)this.centerClient.pageCenter(dto).getData();
    }

    public CenterVo queryById(Long id) {
        return (CenterVo)this.centerClient.queryById(id).getData();
    }

    public CenterVoWithPassword getByCodeWithPassword(String code) {
        return (CenterVoWithPassword)this.centerClient.getByCodeWithPassword(code).getData();
    }

    public long create(@Valid CenterCreateDto dto) {
        return (Long)this.centerClient.create(dto).getData();
    }

    public void modify(@Valid CenterModifyDto dto) {
        this.centerClient.modify(dto.getId(), dto);
    }

    public void enable(long centerId) {
        this.centerClient.enable(centerId);
    }

    public void disable(long centerId) {
        this.centerClient.disable(centerId);
    }

    public void delete(long centerId) {
        this.centerClient.delete(centerId);
    }

    public CenterDetailVo detail(long centerId) {
        return (CenterDetailVo)this.centerClient.detail(centerId).getData();
    }

    public void enableCenterDomain(long centerDomainId) {
        this.centerDomainClient.enable(centerDomainId);
    }

    public void disableCenterDomain(long centerDomainId) {
        this.centerDomainClient.disable(centerDomainId);
    }

    public List<DataSourceType> listAllDataSourceType() {
        return (List)this.centerClient.listAllDataSourceType().getData();
    }
}

