/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.BasicStatus;
import com.cyberway.mp.basic.data.api.dict.DictApi;
import com.cyberway.mp.basic.data.api.dict.dto.DictCategoryCreateDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictCategoryModifyDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictCategoryQueryDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictItemCreateDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictItemModifyDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictItemQueryDto;
import com.cyberway.mp.basic.data.api.dict.dto.DictItemTreeQueryDto;
import com.cyberway.mp.basic.data.api.dict.vo.DictCategoryVo;
import com.cyberway.mp.basic.data.api.dict.vo.DictItemMinVo;
import com.cyberway.mp.basic.data.api.dict.vo.DictItemTreeVo;
import com.cyberway.mp.basic.data.api.dict.vo.DictItemVo;
import com.cyberway.mp.basic.data.feign.client.DictClient;
import com.cyberway.mp.bc.common.api.Page;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DictService
implements DictApi {
    private final DictClient dictClient;

    public DictService(DictClient dictClient) {
        this.dictClient = dictClient;
    }

    public Long createDictCategory(Long tenantId, DictCategoryCreateDto dto) {
        return (Long)this.dictClient.createDictCategory(tenantId, dto).getData();
    }

    public Long createDictItem(Long tenantId, DictItemCreateDto dto) {
        return (Long)this.dictClient.createDictItem(tenantId, dto).getData();
    }

    public void modifyDictItem(Long id, DictItemModifyDto dto) {
        this.dictClient.modifyDictItem(id, dto);
    }

    public void modifyDictCategory(Long id, DictCategoryModifyDto dto) {
        this.dictClient.modifyDictCategory(id, dto);
    }

    public void deleteDictItem(Long id) {
        this.dictClient.deleteDictItem(id);
    }

    public void deleteDictCategory(Long id) {
        this.dictClient.deleteDictCategory(id);
    }

    public List<DictItemVo> listDictItem(Long tenantId, DictItemQueryDto dto) {
        return (List)this.dictClient.listDictItem(tenantId, dto).getData();
    }

    public List<DictCategoryVo> listDictCategory(Long tenantId, DictCategoryQueryDto dto) {
        return (List)this.dictClient.listDictCategory(tenantId, dto).getData();
    }

    public List<DictItemMinVo> getByCode(Long tenantId, String code) {
        return (List)this.dictClient.getByCode(tenantId, true, code).getData();
    }

    public Map<String, String> getMapByCode(Long tenantId, String code, boolean onlyEnabledFlag, @Nullable Long parentId) {
        return (Map)this.dictClient.getMapByCode(tenantId, onlyEnabledFlag, code, parentId).getData();
    }

    public Map<String, String> getMapByCode(Long tenantId, String code, boolean onlyEnabledFlag) {
        return this.getMapByCode(tenantId, code, onlyEnabledFlag, null);
    }

    public List<DictItemMinVo> getByCode(Long tenantId, String code, boolean onlyEnabledFlag) {
        return (List)this.dictClient.getByCode(tenantId, onlyEnabledFlag, code).getData();
    }

    public Map<String, List<DictItemMinVo>> getByCodes(Long tenantId, Collection<String> codes, boolean onlyEnabledFlag) {
        return (Map)this.dictClient.getByCodes(tenantId, onlyEnabledFlag, codes).getData();
    }

    public String translateDictItem(Long tenantId, String code, String itemValue) {
        return this.translateDictItem(tenantId, code, itemValue, null);
    }

    public String translateDictItem(Long tenantId, String code, String itemValue, @Nullable Long parentId) {
        return (String)this.dictClient.translateDictItem(tenantId, code, itemValue, parentId).getData();
    }

    public Page<DictItemVo> pageDictItem(Long tenantId, DictItemQueryDto dto) {
        return (Page)this.dictClient.pageDictItem(tenantId, dto).getData();
    }

    public Page<DictCategoryVo> pageDictCategory(Long tenantId, DictCategoryQueryDto dto) {
        return (Page)this.dictClient.pageDictCategory(tenantId, dto).getData();
    }

    public void modifyDictItemStatus(Long id, BasicStatus status) {
        this.dictClient.modifyDictItemStatus(id, status);
    }

    public void initDict(Long targetTenantId, List<String> dictCodes) {
        this.dictClient.initDict(targetTenantId, dictCodes);
    }

    public List<DictItemTreeVo> dictItemTree(DictItemTreeQueryDto queryDto) {
        return (List)this.dictClient.dictItemTree(queryDto).getData();
    }

    public void sort(List<Long> ids) {
        this.dictClient.sort(ids);
    }

    public List<List<DictItemTreeVo>> dictItemTrees(List<DictItemTreeQueryDto> queryDtoList) {
        return (List)this.dictClient.dictItemTrees(queryDtoList).getData();
    }
}

