/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.feign.service;

import com.cyberway.mp.basic.data.api.systemsetting.PasswordComplexityVo;
import com.cyberway.mp.basic.data.api.systemsetting.SystemSettingApi;
import com.cyberway.mp.basic.data.api.systemsetting.dto.PasswordSettingModifyDto;
import com.cyberway.mp.basic.data.api.systemsetting.dto.SystemSettingModifyDto;
import com.cyberway.mp.basic.data.api.systemsetting.vo.PasswordSettingVo;
import com.cyberway.mp.basic.data.api.systemsetting.vo.SystemSettingsVo;
import com.cyberway.mp.basic.data.feign.client.PasswordSettingClient;
import com.cyberway.mp.basic.data.feign.client.SystemSettingClient;
import java.util.List;

public class SystemSettingService
implements SystemSettingApi {
    private final PasswordSettingClient passwordSettingClient;
    private final SystemSettingClient systemSettingClient;

    public SystemSettingService(PasswordSettingClient passwordSettingClient, SystemSettingClient systemSettingClient) {
        this.passwordSettingClient = passwordSettingClient;
        this.systemSettingClient = systemSettingClient;
    }

    public SystemSettingsVo getInstanceSystemSetting(Long appInstanceId) {
        return (SystemSettingsVo)this.systemSettingClient.getTenantSystemSetting(appInstanceId).getData();
    }

    public SystemSettingsVo getTenantSystemSetting(Long tenantId) {
        return (SystemSettingsVo)this.systemSettingClient.getTenantSystemSetting(tenantId).getData();
    }

    public void modifySystemSetting(Long id, SystemSettingModifyDto dto) {
        this.systemSettingClient.modifySystemSetting(id, dto);
    }

    public PasswordSettingVo getPasswordPolicy(Long tenantId) {
        return (PasswordSettingVo)this.passwordSettingClient.getPasswordPolicy(tenantId).getData();
    }

    public PasswordSettingVo getDefaultPasswordPolicy() {
        return (PasswordSettingVo)this.passwordSettingClient.getDefaultPasswordPolicy().getData();
    }

    public List<PasswordComplexityVo> getPasswordComplexityList() {
        return (List)this.passwordSettingClient.getPasswordComplexityList().getData();
    }

    public void modifyPasswordSettingVo(Long id, PasswordSettingModifyDto dto) {
        this.passwordSettingClient.modifyPasswordSettingVo(id, dto);
    }
}

