/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.common;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import com.cyberway.mp.file.api.file.StoreType;
import com.cyberway.mp.file.api.file.dto.FileMetadataDto;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.common.config.BaseFileProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileService {
    private static final Logger log = LoggerFactory.getLogger(BaseFileService.class);
    private final BaseFileProperties properties;
    private Set<String> allowExtensions;

    protected BaseFileService(BaseFileProperties properties) {
        this.properties = properties;
    }

    protected abstract StoreType getStoreType();

    protected FileMetadataDto buildFileMetadata(InputStreamUploadDto dto) {
        FileMetadataDto fileMetadataDto = new FileMetadataDto();
        fileMetadataDto.setBusinessType(dto.getBusinessType());
        fileMetadataDto.setStoreType(this.getStoreType());
        fileMetadataDto.setOriginalFileName(dto.getOriginalFileName());
        fileMetadataDto.setFileSize(dto.getSize());
        fileMetadataDto.setContentType(dto.getContentType());
        fileMetadataDto.setExternalId(dto.getExternalId());
        fileMetadataDto.setExternalSource(dto.getExternalSource());
        fileMetadataDto.setExternalType(dto.getExternalType());
        if (StringUtils.isNotBlank((CharSequence)dto.getDisplayName())) {
            fileMetadataDto.setDisplayName(dto.getDisplayName());
        } else {
            fileMetadataDto.setDisplayName(dto.getOriginalFileName());
        }
        fileMetadataDto.setExtension(FilenameUtils.getExtension((String)dto.getOriginalFileName()));
        StringBuilder fileName = new StringBuilder();
        if (Boolean.TRUE.equals(dto.getUseOriginFileName())) {
            fileName.append(dto.getOriginalFileName());
        } else {
            fileName.append(UUID.randomUUID().toString().replace("-", ""));
            if (StringUtils.isNotBlank((CharSequence)fileMetadataDto.getExtension())) {
                fileName.append('.');
                fileName.append(fileMetadataDto.getExtension());
            }
        }
        fileMetadataDto.setFileName(fileName.toString());
        return fileMetadataDto;
    }

    protected String getContentTypeByFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        switch (extension = extension == null ? "" : extension.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "gif": {
                return "image/gif";
            }
            case "png": {
                return "image/png";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "pdf": {
                return "application/pdf";
            }
        }
        return "application/octet-stream";
    }

    protected void validateFile(InputStream is, FileMetadataDto metadata) {
        try {
            if (metadata.getFileSize() == null) {
                metadata.setFileSize(Long.valueOf(is.available()));
            }
            this.validateFileSize(metadata.getFileSize());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u6587\u4ef6\u6821\u9a8c\u5f02\u5e38");
        }
        this.validateExtension(metadata.getExtension());
    }

    protected void validateExtension(String extension) {
        Set<String> extensionSet = this.getAllowExtensions();
        if (CollectionUtils.isNotEmpty(extensionSet) && StringUtils.isNotBlank((CharSequence)extension) && !extensionSet.contains(extension.toLowerCase())) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.INVALID_FILE_EXTENSION);
        }
    }

    protected void validateFileSize(long fileSize) {
        if (this.properties.getMaxFileSize() > 0L && this.properties.getMaxFileSize() < fileSize) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.INVALID_FILE_SIZE);
        }
    }

    protected Set<String> getAllowExtensions() {
        if (this.allowExtensions == null) {
            if (CollectionUtils.isNotEmpty(this.properties.getAllowExtensions())) {
                this.allowExtensions = new HashSet<String>(this.properties.getAllowExtensions().size());
                for (String allowExtension : this.properties.getAllowExtensions()) {
                    this.allowExtensions.add(allowExtension.toLowerCase());
                }
            } else {
                this.allowExtensions = Collections.emptySet();
            }
        }
        return this.allowExtensions;
    }
}

