/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.application.service;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import com.cyberway.mp.file.api.file.FileApi;
import com.cyberway.mp.file.api.file.dto.FileMetadataDto;
import com.cyberway.mp.file.api.file.dto.SignatureCreateDto;
import com.cyberway.mp.file.api.file.dto.UploadSignatureDto;
import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataCreateDto;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataQueryDto;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.api.filemanager.dto.ThumbnailDto;
import com.cyberway.mp.file.api.filemanager.dto.UploadDto;
import com.cyberway.mp.file.api.filemanager.enums.ExternalType;
import com.cyberway.mp.file.api.filemanager.enums.ThumbnailFitMode;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import com.cyberway.mp.file.application.service.BaseApplicationService;
import com.cyberway.mp.file.domain.filemetadata.entity.FileMetadata;
import com.cyberway.mp.file.domain.filemetadata.service.FileMetadataService;
import com.cyberway.mp.file.infra.config.FileManagerProperties;
import com.cyberway.mp.file.infra.utils.FileUtil;
import com.cyberway.mp.file.interceptor.FilePermissionInterceptor;
import jakarta.validation.Valid;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.LaxRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Validated
public class FileManagerApplicationService
extends BaseApplicationService
implements FileMangerApi {
    private static final RestTemplate THUMBNAIL_SOURCE_REST_TEMPLATE = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().build()).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(20L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofMinutes(5L).toMillis());
        return requestFactory;
    }).build();
    private static final Set<String> ALLOW_PIC_EXT = Set.of("png", "jpg", "jpeg", "gif", "bmp");
    private static final String THUMBNAIL_BUSINESS_TYPE = "GEN_THUMBNAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileApi fileApi;
    private final FileMetadataService fileMetadataService;
    private final FileManagerProperties fileManagerProperties;
    private final List<FilePermissionInterceptor> filePermissionInterceptors;
    private final Tika tika = new Tika();
    private final StringRedisTemplate redisTemplate;
    private static final String TEMP_DOWNLOAD_LINK_KEY = "tempDownloadLink:";
    private static final String TEMP_DOWNLOAD_COUNT_KEY = "tempDownloadCount:";
    private final IdWorker idWorker;

    public FileManagerApplicationService(FileApi fileApi, FileMetadataService fileMetadataService, FileManagerProperties fileManagerProperties, List<FilePermissionInterceptor> filePermissionInterceptors, StringRedisTemplate redisTemplate, IdWorker idWorker) {
        this.fileApi = fileApi;
        this.fileMetadataService = fileMetadataService;
        this.fileManagerProperties = fileManagerProperties;
        this.filePermissionInterceptors = filePermissionInterceptors;
        this.redisTemplate = redisTemplate;
        this.idWorker = idWorker;
    }

    public Long createFileMetadata(FileMetadataCreateDto dto) {
        return this.createAndGetFileMetadata(dto).getId();
    }

    public FileMetadataVo createAndGetFileMetadata(FileMetadataCreateDto dto) {
        FileMetadataVo fileMetadataVo = this.fileApi.getFileMetadata(dto);
        dto.setContentType(fileMetadataVo.getContentType());
        dto.setStoreType(fileMetadataVo.getStoreType());
        dto.setAccessUrl(fileMetadataVo.getAccessUrl());
        dto.setFileSize(fileMetadataVo.getFileSize());
        dto.setExtendMsg(fileMetadataVo.getExtendMsg());
        if (StringUtils.isBlank((CharSequence)dto.getDisplayName())) {
            dto.setDisplayName(fileMetadataVo.getDisplayName());
        }
        if (StringUtils.isBlank((CharSequence)dto.getFileName())) {
            dto.setFileName(fileMetadataVo.getFileName());
        }
        if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
            dto.setExtension(fileMetadataVo.getExtension());
        }
        return this.fileMetadataService.createFileMetadata(dto).toVo();
    }

    public Page<FileMetadataVo> pageFileMetadata(Long tenantId, FileMetadataQueryDto dto) {
        tenantId = this.getNullableTenantId(tenantId);
        return this.fileMetadataService.pageQuery(tenantId, dto);
    }

    public List<FileMetadataVo> listFileMetadata(Long tenantId, FileMetadataQueryDto dto) {
        tenantId = this.getNullableTenantId(tenantId);
        return this.fileMetadataService.list(tenantId, dto);
    }

    private Long getNullableTenantId(Long tenantId) {
        if (null == tenantId) {
            tenantId = ServiceContext.getContext().getRequestTenantId();
        }
        return tenantId;
    }

    public InputStream download(Long id) {
        FileMetadata metadata = this.fileMetadataService.get(id);
        if (null == metadata) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_NOT_FOUND);
        }
        this.checkDownloadPermission(metadata);
        return this.fileApi.download(metadata.toDto());
    }

    private void checkDownloadPermission(FileMetadata metadata) {
        if (!CollectionUtils.isEmpty(this.filePermissionInterceptors)) {
            for (FilePermissionInterceptor filePermissionInterceptor : this.filePermissionInterceptors) {
                filePermissionInterceptor.checkPermission(metadata);
            }
        }
    }

    public FileMetadataVo getFileMetadata(Long id) {
        FileMetadata metadata = this.fileMetadataService.get(id);
        if (null == metadata) {
            return null;
        }
        return metadata.toVo();
    }

    public void deleteFile(Long id) {
        FileMetadata metadata = this.fileMetadataService.get(id);
        if (null == metadata) {
            return;
        }
        this.fileMetadataService.delete(id);
        this.fileApi.delete(metadata.toDto());
    }

    public FileMetadataVo upload(MultipartFile file, @Valid UploadDto dto) {
        InputStreamUploadDto inputStreamUploadDto = this.buildInputStreamUploadDto(file, dto);
        try {
            return this.upload(file.getInputStream(), inputStreamUploadDto);
        }
        catch (IOException e) {
            this.logger.error("MultipartFile.getInputStream() error", (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.GET_INPUT_STREAM_ERROR);
        }
    }

    public FileMetadataVo upload(InputStream is, @Valid InputStreamUploadDto dto) {
        FileMetadataDto metadataDto = this.fileApi.upload(is, dto);
        Long id = null;
        if (metadataDto.isNeedAppendId()) {
            id = this.idWorker.nextId();
            metadataDto.setAccessUrl(metadataDto.getAccessUrl().contains("?") ? metadataDto.getAccessUrl() + "&id=" + id : metadataDto.getAccessUrl() + "?id=" + id);
        }
        FileMetadata fileMetadata = this.fileMetadataService.createFileMetadata(id, metadataDto, dto);
        return fileMetadata.toVo();
    }

    public UploadSignatureDto getSignature(SignatureCreateDto signatureCreateDto) {
        return this.fileApi.getSignature(signatureCreateDto);
    }

    public FileMetadataVo createOrGetThumbnail(ThumbnailDto dto) {
        String externalId = dto.genExternalId();
        FileMetadataVo thumbnail = this.getNullableThumbnail(dto, externalId);
        if (thumbnail != null) {
            return thumbnail;
        }
        String accessUrl = this.calThumbSourceUrl(dto);
        try {
            File thumbSource = FileUtil.downloadNotNullFile(accessUrl, "thumb_source_", ALLOW_PIC_EXT, this.fileManagerProperties.getThumbSourceLimit(), THUMBNAIL_SOURCE_REST_TEMPLATE);
            Pair<Integer, Integer> imageSize = this.calImageSize(thumbSource);
            ThumbnailDto resizeDto = dto.getHeight() == null && dto.getWidth() == null ? this.fileManagerProperties.getDefaultThumbnail() : dto;
            Pair<Integer, Integer> resultSize = this.calThumbnailSize(resizeDto, imageSize);
            if (this.noNeedThumbnail(Boolean.TRUE.equals(dto.getUpscale()), imageSize, resultSize)) {
                return this.uploadThumbFile(thumbSource, dto, externalId);
            }
            File thumbFile = File.createTempFile("thumb_result_", "." + FileNameUtil.getSuffix((File)thumbSource));
            Thumbnails.of((File[])new File[]{thumbSource}).forceSize(((Integer)resultSize.getLeft()).intValue(), ((Integer)resultSize.getRight()).intValue()).toFile(thumbFile);
            return this.uploadThumbFile(thumbFile, dto, externalId);
        }
        catch (Exception e) {
            if (Boolean.TRUE.equals(dto.getReturnSourceWhenError())) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                FileMetadataVo vo = new FileMetadataVo();
                vo.setAccessUrl(accessUrl);
                return vo;
            }
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.THUMB_IMAGE_CREATE_ERROR);
        }
    }

    private FileMetadataVo getNullableThumbnail(ThumbnailDto dto, String externalId) {
        FileMetadataQueryDto queryDto = new FileMetadataQueryDto();
        queryDto.setExternalId(externalId);
        queryDto.setExternalType(ExternalType.PIC_THUMB);
        Long tenantId = (Long)ObjectUtils.defaultIfNull((Object)ServiceContext.getContext().getRequestTenantId(), (Object)0L);
        List<FileMetadataVo> list = this.listFileMetadata(tenantId, queryDto);
        Optional<FileMetadataVo> matchVo = list.stream().filter(vo -> vo.getExternalSource().equals(dto.getSourceId() == null ? dto.getSourceUrl() : dto.getSourceId().toString())).findFirst();
        return matchVo.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Integer, Integer> calImageSize(File image) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(image);
            Pair pair = Pair.of((Object)bufferedImage.getWidth(), (Object)bufferedImage.getHeight());
            return pair;
        }
        finally {
            if (bufferedImage != null) {
                bufferedImage.getGraphics().dispose();
            }
        }
    }

    private Pair<Integer, Integer> calThumbnailSize(ThumbnailDto resizeDto, Pair<Integer, Integer> imageSize) {
        int h;
        int w;
        ThumbnailFitMode fitMode = (ThumbnailFitMode)ObjectUtils.defaultIfNull((Object)resizeDto.getFitMode(), (Object)ThumbnailFitMode.FIXED);
        int imageWidth = (Integer)imageSize.getLeft();
        int imageHeight = (Integer)imageSize.getRight();
        if (resizeDto.getHeight() != null && resizeDto.getWidth() != null && ThumbnailFitMode.FIXED.equals((Object)fitMode)) {
            w = resizeDto.getWidth();
            h = resizeDto.getHeight();
        } else if (resizeDto.getHeight() == null) {
            w = resizeDto.getWidth();
            h = w * imageHeight / imageWidth;
        } else if (resizeDto.getWidth() == null) {
            h = resizeDto.getHeight();
            w = h * imageWidth / imageHeight;
        } else if (ThumbnailFitMode.LIMIT_MAX.equals((Object)fitMode)) {
            h = Math.min(resizeDto.getHeight(), resizeDto.getWidth() * imageHeight / imageWidth);
            w = h * imageWidth / imageHeight;
        } else {
            h = Math.max(resizeDto.getHeight(), resizeDto.getWidth() * imageHeight / imageWidth);
            w = h * imageWidth / imageHeight;
        }
        return Pair.of((Object)w, (Object)h);
    }

    private boolean noNeedThumbnail(boolean upscale, Pair<Integer, Integer> imageSize, Pair<Integer, Integer> resultSize) {
        if (((Integer)resultSize.getLeft()).equals(imageSize.getLeft()) && ((Integer)resultSize.getRight()).equals(imageSize.getRight())) {
            return true;
        }
        return !upscale && (Integer)resultSize.getLeft() >= (Integer)imageSize.getLeft() && (Integer)resultSize.getRight() >= (Integer)imageSize.getRight();
    }

    private String calThumbSourceUrl(ThumbnailDto dto) {
        String accessUrl;
        if (dto.getSourceId() != null) {
            FileMetadata fileMetadata = this.fileMetadataService.get(dto.getSourceId());
            if (fileMetadata == null) {
                throw new BaseException((ErrorCode)FileServiceErrorCode.THUMBNAIL_SOURCE_ID_NOT_EXISTED);
            }
            accessUrl = fileMetadata.getAccessUrl();
        } else if (StringUtils.isNotBlank((CharSequence)dto.getSourceUrl())) {
            accessUrl = dto.getSourceUrl();
        } else {
            throw new BaseException((ErrorCode)FileServiceErrorCode.THUMBNAIL_EMPTY_SOURCE);
        }
        return accessUrl;
    }

    private FileMetadataVo uploadThumbFile(File target, ThumbnailDto dto, String externalId) {
        FileMetadataVo fileMetadataVo;
        String contentType;
        try {
            contentType = this.tika.detect(target);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.UPLOAD_ERROR);
        }
        FileInputStream fis = new FileInputStream(target);
        try {
            InputStreamUploadDto uploadDto = new InputStreamUploadDto();
            uploadDto.setSize(Long.valueOf(target.length()));
            uploadDto.setContentType(contentType);
            uploadDto.setBusinessType(THUMBNAIL_BUSINESS_TYPE);
            uploadDto.setDisplayName(target.getName());
            uploadDto.setOriginalFileName(target.getName());
            uploadDto.setExternalId(externalId);
            uploadDto.setExternalSource(dto.getSourceId() == null ? dto.getSourceUrl() : dto.getSourceId().toString());
            uploadDto.setExternalType(ExternalType.PIC_THUMB);
            uploadDto.setInline(Boolean.valueOf(true));
            fileMetadataVo = this.upload(fis, uploadDto);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new BaseException((ErrorCode)FileServiceErrorCode.UPLOAD_ERROR);
            }
        }
        fis.close();
        return fileMetadataVo;
    }

    public String generateTempDownloadLink(String fileUrl, Integer maxDownloads, Long expirationSeconds) {
        String tempDownloadId = UUID.randomUUID().toString();
        String linkKey = TEMP_DOWNLOAD_LINK_KEY + tempDownloadId;
        HashMap<String, String> value = new HashMap<String, String>();
        Long appInstanceId = ServiceContext.getContext().getRequestAppInstanceId();
        String token = ServiceContext.getContext().getRequestToken();
        value.put("appInstanceId", Optional.ofNullable(appInstanceId).map(Object::toString).orElse(null));
        value.put("token", (String)StringUtils.getIfEmpty((CharSequence)token, null));
        value.put("fileUrl", fileUrl);
        value.put("maxDownloads", maxDownloads.toString());
        value.put("expirationSeconds", expirationSeconds.toString());
        this.redisTemplate.opsForValue().set((Object)linkKey, (Object)JSON.toJSONString(value), expirationSeconds.longValue(), TimeUnit.SECONDS);
        return tempDownloadId;
    }

    public File tempDownload(String tempDownloadId) {
        String linkKey = TEMP_DOWNLOAD_LINK_KEY + tempDownloadId;
        String value = (String)this.redisTemplate.opsForValue().get((Object)linkKey);
        if (value == null) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.TEMP_DOWNLOAD_LINK_INVALID);
        }
        Map downloadInfo = (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String countKey = TEMP_DOWNLOAD_COUNT_KEY + tempDownloadId;
        Long downloadCount = this.redisTemplate.opsForValue().increment((Object)countKey);
        this.redisTemplate.expire((Object)countKey, Long.parseLong((String)downloadInfo.get("expirationSeconds")), TimeUnit.SECONDS);
        int maxDownloads = Integer.parseInt((String)downloadInfo.get("maxDownloads"));
        if (downloadCount != null && downloadCount > (long)maxDownloads) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.TEMP_DOWNLOAD_LINK_INVALID);
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)downloadInfo.get("token")))) {
            requestHeaders.put("token", (String)downloadInfo.get("token"));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)downloadInfo.get("appInstanceId")))) {
            requestHeaders.put("appInstanceId", (String)downloadInfo.get("appInstanceId"));
        }
        return FileUtil.downloadNotNullFile((String)downloadInfo.get("fileUrl"), requestHeaders);
    }
}

