/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.application.service;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.api.filemanager.dto.UploadDto;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import com.cyberway.mp.file.api.watermark.WaterMarkApi;
import com.cyberway.mp.file.api.watermark.dto.FontWaterMarkParamDto;
import com.cyberway.mp.file.api.watermark.dto.PicWaterMarkParamDto;
import com.cyberway.mp.file.api.watermark.dto.WaterMarkParamDto;
import com.cyberway.mp.file.application.service.BaseApplicationService;
import com.cyberway.mp.file.infra.utils.FileUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Validated
public class WaterMarkApplicationService
extends BaseApplicationService
implements WaterMarkApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mp.file.water-mark-output-format:jpg}")
    private String imageOutputFormat;
    private static final Set<String> ENABLE_FILE_TYPE = Set.of("png", "jpg", "jpeg", "bmp");
    private static final int TRUE_VAL = 1;
    private final FileMangerApi fileMangerApi;

    public WaterMarkApplicationService(FileMangerApi fileMangerApi) {
        this.fileMangerApi = fileMangerApi;
    }

    public InputStream addFontWaterMark(InputStream inputStream, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        try {
            BufferedImage src = ImageIO.read(inputStream);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            for (FontWaterMarkParamDto fontWaterMarkParamDto : fontWaterMarkParamDtoList) {
                if (fontWaterMarkParamDtoList.size() > 1) {
                    fontWaterMarkParamDto.setFill(0);
                }
                String text = this.decodeBase64(fontWaterMarkParamDto.getText());
                Font font = new Font(this.decodeBase64(fontWaterMarkParamDto.getType()), 1, fontWaterMarkParamDto.getMarkSize());
                Color fontColor = new Color(this.hex2Integer(fontWaterMarkParamDto.getColor()));
                Color showColor = null;
                if (0 != fontWaterMarkParamDto.getShadow()) {
                    double rgb = (double)(100 - fontWaterMarkParamDto.getShadow()) / 100.0 * 255.0;
                    showColor = new Color((int)rgb, (int)rgb, (int)rgb);
                }
                JLabel label = new JLabel(text);
                FontMetrics metrics = label.getFontMetrics(font);
                int contentWidth = metrics.stringWidth(label.getText());
                int contentHeight = metrics.getHeight();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.rotate(Math.toRadians(fontWaterMarkParamDto.getRotate()), (double)contentWidth / 2.0, (double)contentHeight / 2.0);
                font = font.deriveFont(affineTransform);
                metrics = label.getFontMetrics(font);
                contentWidth = metrics.stringWidth(label.getText());
                contentHeight = metrics.getHeight();
                g.setComposite(AlphaComposite.getInstance(10, (float)fontWaterMarkParamDto.getT() / 100.0f));
                List<Integer[]> positionList = this.getWaterMarkPosition((WaterMarkParamDto)fontWaterMarkParamDto, width, height, contentWidth, contentHeight, 0);
                g.setFont(font);
                for (Integer[] position : positionList) {
                    int x = position[0];
                    int y = position[1];
                    if (null != showColor) {
                        g.setPaint(showColor);
                        g.drawString(text, x + 3, y + 3);
                    }
                    g.setPaint(fontColor);
                    g.drawString(text, x, y);
                }
            }
            g.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, this.imageOutputFormat, outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
        }
    }

    private List<Integer[]> getWaterMarkPosition(WaterMarkParamDto waterMarkParamDto, int srcWidth, int srcHeight, int contentWidth, int contentHeight, int offsetContentHeight) {
        ArrayList<Integer[]> positionList = new ArrayList<Integer[]>();
        if (1 == waterMarkParamDto.getFill()) {
            int startX;
            int x = startX = 0;
            int y = 0;
            while (y < srcHeight) {
                while (x < srcWidth) {
                    positionList.add(new Integer[]{x, y});
                    x = x + contentWidth + waterMarkParamDto.getPadx();
                }
                x = startX;
                y = y + contentHeight + waterMarkParamDto.getPady();
            }
        } else {
            int x = 0;
            int y = 0;
            switch (waterMarkParamDto.getG()) {
                case nw: {
                    y = contentHeight + offsetContentHeight;
                    x += waterMarkParamDto.getX();
                    y += waterMarkParamDto.getY();
                    break;
                }
                case north: {
                    x = srcWidth / 2 - contentWidth / 2;
                    y = contentHeight + offsetContentHeight;
                    y += waterMarkParamDto.getY();
                    break;
                }
                case ne: {
                    x = srcWidth - contentWidth;
                    y = contentHeight + offsetContentHeight;
                    x -= waterMarkParamDto.getX();
                    y += waterMarkParamDto.getY();
                    break;
                }
                case west: {
                    y = srcHeight / 2 + contentHeight / 2 + offsetContentHeight;
                    x += waterMarkParamDto.getX();
                    y += waterMarkParamDto.getVoffset();
                    break;
                }
                case center: {
                    x = srcWidth / 2 - contentWidth / 2;
                    y = srcHeight / 2 + contentHeight / 2 + offsetContentHeight;
                    y += waterMarkParamDto.getVoffset();
                    break;
                }
                case east: {
                    x = srcWidth - contentWidth;
                    y = srcHeight / 2 + contentHeight / 2 + offsetContentHeight;
                    x -= waterMarkParamDto.getX();
                    y += waterMarkParamDto.getVoffset();
                    break;
                }
                case sw: {
                    y = srcHeight + offsetContentHeight;
                    x += waterMarkParamDto.getX();
                    y -= waterMarkParamDto.getY();
                    break;
                }
                case south: {
                    x = srcWidth / 2 - contentWidth / 2;
                    y = srcHeight + offsetContentHeight;
                    y -= waterMarkParamDto.getY();
                    break;
                }
                case se: {
                    x = srcWidth - contentWidth;
                    y = srcHeight + offsetContentHeight;
                    x -= waterMarkParamDto.getX();
                    y -= waterMarkParamDto.getY();
                }
            }
            positionList.add(new Integer[]{x, y});
        }
        return positionList;
    }

    public InputStream addFontWaterMark(MultipartFile file, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        try {
            return this.addFontWaterMark(file.getInputStream(), fontWaterMarkParamDtoList);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream addFontWaterMark(String fileUrl, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        InputStream inputStream;
        File tempFile = FileUtil.downloadNotNullFile(fileUrl, "", ENABLE_FILE_TYPE);
        FileInputStream fis = new FileInputStream(tempFile);
        try {
            inputStream = this.addFontWaterMark(fis, fontWaterMarkParamDtoList);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    if (null != tempFile) {
                        tempFile.deleteOnExit();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (null != tempFile) {
                    tempFile.deleteOnExit();
                }
                throw throwable3;
            }
        }
        fis.close();
        if (null != tempFile) {
            tempFile.deleteOnExit();
        }
        return inputStream;
        throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
    }

    public InputStream addPicWaterMark(InputStream inputStream, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        try {
            BufferedImage src = ImageIO.read(inputStream);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            for (PicWaterMarkParamDto picWaterMarkParamDto : picWaterMarkParamDtoList) {
                if (picWaterMarkParamDtoList.size() > 1) {
                    picWaterMarkParamDto.setFill(0);
                }
                InputStream waterMarkInputStream = this.downloadPicWaterMark(picWaterMarkParamDto.getWatermarkFileId(), width, height, picWaterMarkParamDto.getP());
                BufferedImage waterMark = ImageIO.read(waterMarkInputStream);
                int contentWidth = ((Image)waterMark).getWidth(null);
                int contentHeight = ((Image)waterMark).getHeight(null);
                g.setComposite(AlphaComposite.getInstance(10, (float)picWaterMarkParamDto.getT() / 100.0f));
                List<Integer[]> positionList = this.getWaterMarkPosition((WaterMarkParamDto)picWaterMarkParamDto, width, height, contentWidth, contentHeight, -contentHeight);
                for (Integer[] position : positionList) {
                    int x = position[0];
                    int y = position[1];
                    g.drawImage((Image)waterMark, x, y, null);
                }
            }
            g.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, this.imageOutputFormat, outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
        }
    }

    public InputStream addPicWaterMark(MultipartFile file, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        try {
            return this.addPicWaterMark(file.getInputStream(), picWaterMarkParamDtoList);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream addPicWaterMark(String fileUrl, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        InputStream inputStream;
        File tempFile = FileUtil.downloadNotNullFile(fileUrl, "", ENABLE_FILE_TYPE);
        FileInputStream fis = new FileInputStream(tempFile);
        try {
            inputStream = this.addPicWaterMark(fis, picWaterMarkParamDtoList);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    if (null != tempFile) {
                        tempFile.deleteOnExit();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (null != tempFile) {
                    tempFile.deleteOnExit();
                }
                throw throwable3;
            }
        }
        fis.close();
        if (null != tempFile) {
            tempFile.deleteOnExit();
        }
        return inputStream;
        throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
    }

    public FileMetadataVo addFontWaterMarkAndUpload(InputStream inputStream, InputStreamUploadDto inputStreamUploadDto, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        InputStream is = this.addFontWaterMark(inputStream, fontWaterMarkParamDtoList);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    public FileMetadataVo addFontWaterMarkAndUpload(MultipartFile file, UploadDto uploadDto, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        InputStream is = this.addFontWaterMark(file, fontWaterMarkParamDtoList);
        InputStreamUploadDto inputStreamUploadDto = this.buildInputStreamUploadDto(file, uploadDto);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    public FileMetadataVo addFontWaterMarkAndUpload(String fileUrl, InputStreamUploadDto inputStreamUploadDto, List<FontWaterMarkParamDto> fontWaterMarkParamDtoList) {
        InputStream is = this.addFontWaterMark(fileUrl, fontWaterMarkParamDtoList);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    public FileMetadataVo addPicWaterMarkAndUpload(InputStream inputStream, InputStreamUploadDto inputStreamUploadDto, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        InputStream is = this.addPicWaterMark(inputStream, picWaterMarkParamDtoList);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    public FileMetadataVo addPicWaterMarkAndUpload(MultipartFile file, UploadDto uploadDto, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        InputStream is = this.addPicWaterMark(file, picWaterMarkParamDtoList);
        InputStreamUploadDto inputStreamUploadDto = this.buildInputStreamUploadDto(file, uploadDto);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    public FileMetadataVo addPicWaterMarkAndUpload(String fileUrl, InputStreamUploadDto inputStreamUploadDto, List<PicWaterMarkParamDto> picWaterMarkParamDtoList) {
        InputStream is = this.addPicWaterMark(fileUrl, picWaterMarkParamDtoList);
        return this.fileMangerApi.upload(is, inputStreamUploadDto);
    }

    private String decodeBase64(String base64Str) {
        return new String(Base64.decodeBase64((String)base64Str));
    }

    private int hex2Integer(String hexNum) {
        return Integer.parseInt(hexNum, 16);
    }

    private InputStream downloadPicWaterMark(Long watermarkFileId, int srcWidth, int srcHeight, int p) throws Exception {
        FileMetadataVo fileMetadataVo = this.fileMangerApi.getFileMetadata(watermarkFileId);
        String key = "@" + watermarkFileId + "@" + srcWidth + "@" + srcHeight + "@" + p;
        File parent = new File(System.getProperty("java.io.tmpdir"));
        File file = new File(parent, key + "." + fileMetadataVo.getExtension());
        if (!file.exists()) {
            InputStream inputStream = this.fileMangerApi.download(watermarkFileId);
            double scale = (double)p / 100.0;
            double targetWidth = (double)srcWidth * scale;
            double targetHeight = (double)srcHeight * scale;
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size((int)targetWidth, (int)targetHeight).toFile(file);
        }
        return new FileInputStream(file);
    }
}

