/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.domain.filemetadata.service;

import com.cyberway.mp.bbc.remotejob.dto.TenantCopyItemDto;
import com.cyberway.mp.bbc.remotejob.dto.TenantCopyJobDto;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.file.api.file.dto.FileMetadataDto;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataCreateDto;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataQueryDto;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import com.cyberway.mp.file.domain.filemetadata.entity.FileMetadata;
import com.cyberway.mp.file.domain.filemetadata.repository.FileMetadataRepository;
import com.cyberway.mp.file.domain.filemetadata.repository.query.FileMetadataQueryBean;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class FileMetadataService {
    private final FileMetadataRepository repository;

    public FileMetadataService(FileMetadataRepository repository) {
        this.repository = repository;
    }

    public FileMetadata createFileMetadata(Long id, FileMetadataDto metadataDto, InputStreamUploadDto inputStreamUploadDto) {
        metadataDto.setShareFile(inputStreamUploadDto.isShareFile());
        FileMetadata metadata = FileMetadata.fromMetadataDto(metadataDto, inputStreamUploadDto.getSystemDefault());
        metadata.setId(id);
        this.repository.save((Object)metadata);
        return metadata;
    }

    public FileMetadata createFileMetadata(FileMetadataCreateDto dto) {
        FileMetadata metadata = FileMetadata.fromMetadataCreateDto(dto);
        this.repository.save((Object)metadata);
        return metadata;
    }

    public FileMetadata get(Long id) {
        return this.repository.findById(id);
    }

    public void delete(Long id) {
        this.repository.delete(id);
    }

    public Page<FileMetadataVo> pageQuery(Long tenantId, FileMetadataQueryDto dto) {
        FileMetadataQueryBean queryBean = this.buildQueryBean(tenantId, dto);
        long count = this.repository.countByQueryBean(queryBean);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<FileMetadata> metadataList = this.repository.searchPageByQueryBean(queryBean, (PageParam)dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, metadataList.stream().map(FileMetadata::toVo).collect(Collectors.toList()));
    }

    public List<FileMetadataVo> list(Long tenantId, FileMetadataQueryDto dto) {
        FileMetadataQueryBean queryBean = this.buildQueryBean(tenantId, dto);
        return this.repository.searchListByQueryBean(queryBean).stream().map(FileMetadata::toVo).collect(Collectors.toList());
    }

    private FileMetadataQueryBean buildQueryBean(Long tenantId, FileMetadataQueryDto dto) {
        FileMetadataQueryBean fileMetadataQueryBean = new FileMetadataQueryBean();
        fileMetadataQueryBean.setTenantId(tenantId);
        fileMetadataQueryBean.setBusinessType(dto.getBusinessType());
        fileMetadataQueryBean.setBusinessTypeLike(dto.getBusinessTypeLike());
        fileMetadataQueryBean.setDisplayNameLike(dto.getDisplayNameLike());
        fileMetadataQueryBean.setFileNameLike(dto.getFileNameLike());
        fileMetadataQueryBean.setFileSizeGreaterThanEqual(dto.getFileSizeGreaterThanEqual());
        fileMetadataQueryBean.setFileSizeLessThanEqual(dto.getFileSizeLessThanEqual());
        fileMetadataQueryBean.setStoreType(dto.getStoreType());
        fileMetadataQueryBean.setExtension(dto.getExtension());
        fileMetadataQueryBean.setOriginalFileName(dto.getOriginalFileName());
        fileMetadataQueryBean.setOriginalFileName(dto.getOriginalFileName());
        fileMetadataQueryBean.setExternalId(dto.getExternalId());
        fileMetadataQueryBean.setExternalType(dto.getExternalType());
        fileMetadataQueryBean.setExternalIdIn(dto.getExternalIdIn());
        return fileMetadataQueryBean;
    }

    @Transactional(rollbackFor={Exception.class})
    public void copyTenantData(TenantCopyJobDto copyJobDto) {
        FileMetadataQueryBean queryBean = new FileMetadataQueryBean();
        queryBean.setTenantId(copyJobDto.getSourceTenantId());
        queryBean.setBusinessType("icon");
        Map copyAppInstances = copyJobDto.getCopyAppInstances();
        List copyList = this.repository.searchListByQueryBean(queryBean).stream().filter(m -> copyAppInstances.containsKey(m.getAppInstanceId())).map(source -> {
            FileMetadata copy = new FileMetadata();
            copy.setAppInstanceId(((TenantCopyItemDto)copyAppInstances.get(source.getAppInstanceId())).getId());
            copy.setAccessUrl(source.getAccessUrl());
            copy.setBusinessType(source.getBusinessType());
            copy.setContentType(source.getContentType());
            copy.setDisplayName(source.getDisplayName());
            copy.setDownloadCount(0L);
            copy.setExtension(source.getExtension());
            copy.setExtendMsg(source.getExtendMsg());
            copy.setExternalId(source.getExternalId());
            copy.setExternalSource(source.getExternalSource());
            copy.setExternalType(source.getExternalType());
            copy.setFileSize(source.getFileSize());
            copy.setFileName(source.getFileName());
            copy.setOriginalFileName(source.getOriginalFileName());
            copy.setStoreLocation(source.getStoreLocation());
            copy.setStoreType(source.getStoreType());
            copy.setSystemDefault(source.getSystemDefault());
            copy.setTenantId(copyJobDto.getTargetTenantId());
            return copy;
        }).collect(Collectors.toList());
        if (!copyList.isEmpty()) {
            this.repository.batchInsert(copyList);
        }
    }
}

