/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.config;

import com.cyberway.mp.bc.dal.config.EnableDAL;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.file.api.file.FileApi;
import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.api.filemanager.dto.ThumbnailDto;
import com.cyberway.mp.file.api.filemanager.enums.ThumbnailFitMode;
import com.cyberway.mp.file.api.watermark.WaterMarkApi;
import com.cyberway.mp.file.application.service.FileManagerApplicationService;
import com.cyberway.mp.file.application.service.WaterMarkApplicationService;
import com.cyberway.mp.file.domain.filemetadata.repository.FileMetadataRepository;
import com.cyberway.mp.file.domain.filemetadata.service.FileMetadataService;
import com.cyberway.mp.file.infra.config.FileManagerLiquibaseConfiguration;
import com.cyberway.mp.file.infra.config.FileManagerProperties;
import com.cyberway.mp.file.infra.config.OfficeViewConfiguration;
import com.cyberway.mp.file.infra.handler.TenantCopyIconHandler;
import com.cyberway.mp.file.interceptor.FilePermissionInterceptor;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.StringRedisTemplate;

@MapperScan(value={"com.cyberway.mp.file.domain"})
@EnableDAL
@Import(value={FileManagerLiquibaseConfiguration.class, OfficeViewConfiguration.class})
public class FileManagerContextConfiguration {
    @Bean
    public FileMetadataService fileMetadataService(FileMetadataRepository fileMetadataRepository) {
        return new FileMetadataService(fileMetadataRepository);
    }

    @Bean
    public FileMangerApi fileMangerApplicationService(FileApi fileApi, FileMetadataService fileMetadataService, FileManagerProperties fileManagerProperties, List<FilePermissionInterceptor> filePermissionInterceptors, StringRedisTemplate redisTemplate, IdWorker idWorker) {
        return new FileManagerApplicationService(fileApi, fileMetadataService, fileManagerProperties, filePermissionInterceptors, redisTemplate, idWorker);
    }

    @Bean
    public WaterMarkApi waterMarkApplicationService(FileMangerApi fileMangerApi) {
        return new WaterMarkApplicationService(fileMangerApi);
    }

    @Bean
    public TenantCopyIconHandler tenantCopyIconHandler(FileMetadataService fileMetadataService) {
        return new TenantCopyIconHandler(fileMetadataService);
    }

    @Bean
    @ConfigurationProperties(prefix="mp.file-manager")
    public FileManagerProperties fileManagerProperties() {
        FileManagerProperties fileManagerProperties = new FileManagerProperties();
        ThumbnailDto defaultThumbnail = new ThumbnailDto();
        defaultThumbnail.setWidth(Integer.valueOf(240));
        defaultThumbnail.setHeight(Integer.valueOf(240));
        defaultThumbnail.setFitMode(ThumbnailFitMode.LIMIT_MAX);
        fileManagerProperties.setDefaultThumbnail(defaultThumbnail);
        return fileManagerProperties;
    }
}

