/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.config;

import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FileManagerLiquibaseConfiguration {
    @Bean(name={"fileManagerLiquibase"})
    public SpringLiquibase fileManagerLiquibase(DataSource dataSource, ResourceLoader resourceLoader) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setResourceLoader(resourceLoader);
        liquibase.setChangeLog("classpath:cc-fm-liquibase-master.xml");
        liquibase.setDatabaseChangeLogTable("cc_fm_database_change_log");
        liquibase.setDatabaseChangeLogLockTable("cc_fm_database_change_log_lock");
        return liquibase;
    }
}

