/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.config;

import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.application.service.OfficeViewApplicationService;
import com.cyberway.mp.file.infra.office.OfficeConverter;
import com.cyberway.mp.file.infra.office.OfficeConverterFactory;
import com.cyberway.mp.file.infra.office.OfficeConverterProperties;
import com.cyberway.mp.file.infra.office.libreoffice.LibreofficeConverter;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OfficeViewConfiguration {
    @Bean
    @ConfigurationProperties(prefix="mp.office")
    public OfficeConverterProperties officeConverterProperties() {
        return new OfficeConverterProperties();
    }

    @Bean
    @ConditionalOnProperty(name={"mp.office.convert-type"}, havingValue="libreoffice")
    public OfficeConverter libreofficeConverter(FileMangerApi fileMangerApi, OfficeConverterProperties officeConverterProperties) {
        return new LibreofficeConverter(fileMangerApi, officeConverterProperties.getLibreoffice());
    }

    @Bean
    public OfficeConverterFactory officeConverterFactory(List<OfficeConverter> converters, OfficeConverterProperties officeConverterProperties) {
        return new OfficeConverterFactory(converters, officeConverterProperties);
    }

    @Bean
    public OfficeViewApplicationService officeViewApplicationService(OfficeConverterFactory officeConverterFactory) {
        return new OfficeViewApplicationService(officeConverterFactory);
    }
}

