/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.office;

import com.cyberway.mp.file.api.office.ConvertType;
import com.cyberway.mp.file.infra.office.OfficeConverter;
import com.cyberway.mp.file.infra.office.OfficeConverterProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OfficeConverterFactory {
    private final List<OfficeConverter> converters;
    private final OfficeConverterProperties properties;

    public OfficeConverterFactory(List<OfficeConverter> converters, OfficeConverterProperties properties) {
        this.converters = converters;
        this.properties = properties;
    }

    public OfficeConverter generateNotNullConverter() {
        String typeName = this.properties.getConvertType();
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException("missing config[mp.office.convert-type]");
        }
        ConvertType convertType = ConvertType.ofName((String)typeName);
        if (null == convertType) {
            throw new IllegalArgumentException("Illegal config[mp.office.convert-type] value:{" + typeName + "}");
        }
        return this.converters.stream().filter(c -> convertType == c.supportType()).findFirst().orElseThrow(() -> new IllegalArgumentException("missing OfficeConverter for {" + typeName + "}"));
    }
}

