/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.office.libreoffice;

import cn.hutool.crypto.digest.DigestUtil;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataQueryDto;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.api.filemanager.enums.ExternalType;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import com.cyberway.mp.file.api.office.ConvertType;
import com.cyberway.mp.file.api.office.dto.OfficeConvertParamDto;
import com.cyberway.mp.file.api.office.vo.OfficeConvertResultVo;
import com.cyberway.mp.file.infra.office.OfficeConverter;
import com.cyberway.mp.file.infra.office.OfficeConverterProperties;
import com.cyberway.mp.file.infra.office.libreoffice.LibreofficeLocalProperties;
import com.cyberway.mp.file.infra.office.libreoffice.LibreofficeRemoteProperties;
import com.cyberway.mp.file.infra.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.remote.RemoteConverter;
import org.jodconverter.remote.office.RemoteOfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibreofficeConverter
implements OfficeConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REMOTE_TYPE = "remote";
    private static final String LOCAL_TYPE = "local";
    private static final String SPLIT_SYMBOL = "@@@%###";
    private final FileMangerApi fileMangerApi;
    private final OfficeConverterProperties.Libreoffice libreofficeProperties;
    private final OfficeManager officeManager;
    private final DocumentConverter documentConverter;

    public LibreofficeConverter(FileMangerApi fileMangerApi, OfficeConverterProperties.Libreoffice libreofficeProperties) {
        this.fileMangerApi = fileMangerApi;
        this.libreofficeProperties = libreofficeProperties;
        this.officeManager = this.initOfficeManager();
        this.documentConverter = this.initDocumentConverter();
    }

    private DocumentConverter initDocumentConverter() {
        if (REMOTE_TYPE.equalsIgnoreCase(this.libreofficeProperties.getType())) {
            return RemoteConverter.make((OfficeManager)this.officeManager);
        }
        if (LOCAL_TYPE.equalsIgnoreCase(this.libreofficeProperties.getType())) {
            LibreofficeLocalProperties localProperties = this.libreofficeProperties.getLocal();
            HashMap<String, Short> loadProperties = new HashMap<String, Short>(16);
            if (localProperties.isApplyDefaultLoadProperties()) {
                loadProperties.putAll(LocalConverter.DEFAULT_LOAD_PROPERTIES);
                if (localProperties.isUseUnsafeQuietUpdate()) {
                    loadProperties.put("UpdateDocMode", (short)1);
                }
            }
            return ((LocalConverter.Builder)LocalConverter.builder().officeManager(this.officeManager)).loadProperties(loadProperties).build();
        }
        throw new IllegalArgumentException("Unsupported Libreoffice type: " + this.libreofficeProperties.getType());
    }

    private OfficeManager initOfficeManager() {
        if (REMOTE_TYPE.equalsIgnoreCase(this.libreofficeProperties.getType())) {
            LibreofficeRemoteProperties remoteProperties = this.libreofficeProperties.getRemote();
            RemoteOfficeManager.Builder remoteBuilder = (RemoteOfficeManager.Builder)((RemoteOfficeManager.Builder)((RemoteOfficeManager.Builder)RemoteOfficeManager.builder().urlConnection(remoteProperties.getUrl()).connectTimeout(Long.valueOf(remoteProperties.getConnectTimeout())).socketTimeout(Long.valueOf(remoteProperties.getSocketTimeout())).poolSize(Integer.valueOf(remoteProperties.getPoolSize())).workingDir(remoteProperties.getWorkingDir())).taskQueueTimeout(Long.valueOf(remoteProperties.getTaskQueueTimeout()))).taskExecutionTimeout(Long.valueOf(remoteProperties.getTaskExecutionTimeout()));
            return remoteBuilder.build();
        }
        if (LOCAL_TYPE.equalsIgnoreCase(this.libreofficeProperties.getType())) {
            LibreofficeLocalProperties localProperties = this.libreofficeProperties.getLocal();
            LocalOfficeManager.Builder localBuilder = ((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().officeHome(localProperties.getOfficeHome()).hostName(localProperties.getHostName()).portNumbers(localProperties.getPortNumbers()).workingDir(localProperties.getWorkingDir())).templateProfileDir(localProperties.getTemplateProfileDir()).existingProcessAction(localProperties.getExistingProcessAction()).processTimeout(Long.valueOf(localProperties.getProcessTimeout())).processRetryInterval(Long.valueOf(localProperties.getProcessRetryInterval())).afterStartProcessDelay(Long.valueOf(localProperties.getAfterStartProcessDelay())).disableOpengl(Boolean.valueOf(localProperties.isDisableOpengl())).startFailFast(Boolean.valueOf(localProperties.isStartFailFast())).keepAliveOnShutdown(Boolean.valueOf(localProperties.isKeepAliveOnShutdown())).taskQueueTimeout(Long.valueOf(localProperties.getTaskQueueTimeout()))).taskExecutionTimeout(Long.valueOf(localProperties.getTaskExecutionTimeout()))).maxTasksPerProcess(Integer.valueOf(localProperties.getMaxTasksPerProcess()));
            if (StringUtils.isBlank((CharSequence)localProperties.getProcessManagerClass())) {
                localBuilder.processManager(LocalOfficeUtils.findBestProcessManager());
            } else {
                localBuilder.processManager(localProperties.getProcessManagerClass());
            }
            return localBuilder.build();
        }
        throw new IllegalArgumentException("unsupported libreoffice type");
    }

    @Override
    public ConvertType supportType() {
        return ConvertType.LIBREOFFICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfficeConvertResultVo convert(OfficeConvertParamDto dto) {
        File tempSouceFile = null;
        File tempTargetFile = null;
        try {
            FileMetadataVo fileMetadataVo;
            if (!this.officeManager.isRunning()) {
                this.officeManager.start();
            }
            if (null != (fileMetadataVo = this.getNullableConvertedFile(dto.getFileUrl()))) {
                OfficeConvertResultVo officeConvertResultVo = new OfficeConvertResultVo(fileMetadataVo.getAccessUrl(), this.supportType());
                return officeConvertResultVo;
            }
            tempSouceFile = FileUtil.downloadNotNullFile(dto.getFileUrl(), System.currentTimeMillis() + SPLIT_SYMBOL, this.libreofficeProperties.getEnableFileTypes());
            tempTargetFile = File.createTempFile(FilenameUtils.getBaseName((String)tempSouceFile.getName()), ".pdf", new File(System.getProperty("java.io.tmpdir")));
            this.documentConverter.convert(tempSouceFile).to(tempTargetFile).execute();
            fileMetadataVo = this.uploadFile(tempTargetFile, dto.getFileUrl());
            tempSouceFile.deleteOnExit();
            tempTargetFile.deleteOnExit();
            OfficeConvertResultVo officeConvertResultVo = new OfficeConvertResultVo(fileMetadataVo.getAccessUrl(), this.supportType());
            return officeConvertResultVo;
        }
        catch (Exception e) {
            this.logger.error("convert file error", (Throwable)e);
        }
        finally {
            if (null != tempSouceFile) {
                tempSouceFile.deleteOnExit();
            }
            if (null != tempTargetFile) {
                tempTargetFile.deleteOnExit();
            }
        }
        throw new BaseException((ErrorCode)FileServiceErrorCode.BASE_EXCEPTION);
    }

    private FileMetadataVo uploadFile(File target, String fileOriginUrl) {
        FileMetadataVo fileMetadataVo;
        FileInputStream fis = new FileInputStream(target);
        try {
            InputStreamUploadDto uploadDto = new InputStreamUploadDto();
            uploadDto.setSize(Long.valueOf(target.length()));
            uploadDto.setContentType("application/pdf");
            String fileName = target.getName();
            String sourceFileName = fileName.split(SPLIT_SYMBOL)[1];
            uploadDto.setBusinessType("office_converter");
            uploadDto.setDisplayName(sourceFileName);
            uploadDto.setOriginalFileName(sourceFileName);
            uploadDto.setExternalId(DigestUtil.sha256Hex((String)fileOriginUrl));
            uploadDto.setExternalSource(fileOriginUrl);
            uploadDto.setExternalType(ExternalType.OFFICE);
            uploadDto.setInline(Boolean.valueOf(true));
            fileMetadataVo = this.fileMangerApi.upload((InputStream)fis, uploadDto);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error("uploadFile error", (Throwable)e);
                throw new BaseException((ErrorCode)FileServiceErrorCode.UPLOAD_ERROR);
            }
        }
        fis.close();
        return fileMetadataVo;
    }

    private FileMetadataVo getNullableConvertedFile(String fileUrl) {
        FileMetadataQueryDto queryDto = new FileMetadataQueryDto();
        queryDto.setExternalId(DigestUtil.sha256Hex((String)fileUrl));
        queryDto.setExternalType(ExternalType.OFFICE);
        List list = this.fileMangerApi.listFileMetadata(null, queryDto);
        Optional<FileMetadataVo> matchVo = list.stream().filter(vo -> StringUtils.isBlank((CharSequence)vo.getExternalSource()) || fileUrl.equals(vo.getExternalSource())).findFirst();
        return matchVo.orElse(null);
    }
}

