/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.infra.utils;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.LaxRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestTemplate;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final RestTemplate REST_TEMPLATE = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().build()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(30L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofHours(1L).toMillis());
        return requestFactory;
    }).build();
    private static final Set<String> FILE_NAME_PARAM_NAME = Set.of("originalFileName", "fileName");

    private FileUtil() {
    }

    public static File downloadNotNullFile(String fileUrl, String filePrefix, Set<String> enableFileType) {
        return FileUtil.downloadNotNullFile(fileUrl, filePrefix, enableFileType, 0L, REST_TEMPLATE, null);
    }

    public static File downloadNotNullFile(String fileUrl, Map<String, String> requestHeaders) {
        return FileUtil.downloadNotNullFile(fileUrl, "", Collections.emptySet(), 0L, REST_TEMPLATE, requestHeaders);
    }

    public static File downloadNotNullFile(String fileUrl, String filePrefix, Set<String> enableFileType, long sizeLimit, RestTemplate restTemplate) {
        return FileUtil.downloadNotNullFile(fileUrl, filePrefix, enableFileType, sizeLimit, restTemplate, null);
    }

    public static File downloadNotNullFile(String fileUrl, String filePrefix, Set<String> enableFileType, long sizeLimit, RestTemplate restTemplate, Map<String, String> requestHeaders) {
        RequestCallback requestCallback = request -> {
            request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
            if (requestHeaders != null) {
                for (Map.Entry entry : requestHeaders.entrySet()) {
                    request.getHeaders().add((String)entry.getKey(), (String)entry.getValue());
                }
            }
        };
        File downloadFile = null;
        try {
            downloadFile = (File)restTemplate.execute(new URI(fileUrl), HttpMethod.GET, requestCallback, clientHttpResponse -> {
                HttpHeaders headers = clientHttpResponse.getHeaders();
                long contentLength = headers.getContentLength();
                if (sizeLimit > 0L && contentLength > sizeLimit) {
                    throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_SIZE_LIMIT);
                }
                String fileName = FileUtil.getFileName(headers, fileUrl);
                FileUtil.validateFileType(enableFileType, fileName);
                File parent = new File(System.getProperty("java.io.tmpdir"));
                File file = new File(parent, (String)StringUtils.getIfBlank((CharSequence)filePrefix, () -> "") + URLDecoder.decode(FilenameUtils.getBaseName((String)fileName), StandardCharsets.UTF_8) + "." + FilenameUtils.getExtension((String)fileName));
                try (FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)fos);
                }
                return file;
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (null == downloadFile || downloadFile.length() == 0L) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_DOWNLOAD_ERROR);
        }
        return downloadFile;
    }

    private static String getFileName(HttpHeaders headers, String fileUrl) {
        ContentDisposition contentDisposition = headers.getContentDisposition();
        String fileName = contentDisposition.getFilename();
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName;
        }
        fileName = FileUtil.getFileNameFromFileUrl(fileUrl);
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".")) {
            return fileName;
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null) {
            return fileName;
        }
        try {
            MimeType mimeType = MimeTypes.getDefaultMimeTypes().forName(contentType.toString());
            if (mimeType == null) {
                return fileName;
            }
            String ext = mimeType.getExtension();
            if (StringUtils.isBlank((CharSequence)ext)) {
                return fileName;
            }
            return (String)StringUtils.defaultIfBlank((CharSequence)fileName, (CharSequence)"temp") + ext;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return fileName;
        }
    }

    private static void validateFileType(Set<String> enableFileType, String fileName) {
        if (!CollectionUtils.isEmpty(enableFileType)) {
            boolean isContains = false;
            String ext = FilenameUtils.getExtension((String)fileName);
            for (String enableType : enableFileType) {
                if (!enableType.equalsIgnoreCase(ext)) continue;
                isContains = true;
                break;
            }
            if (!isContains) {
                throw new BaseException((ErrorCode)FileServiceErrorCode.NOT_SUPPORT_FILE_TYPE, new Object[]{ext});
            }
        }
    }

    private static String getFileNameFromFileUrl(String fileUrl) {
        if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
            try {
                URL url = new URL(fileUrl);
                String query = url.getQuery();
                if (StringUtils.isNotBlank((CharSequence)query)) {
                    for (String param : query.split("&")) {
                        String[] pair = param.split("=");
                        String key = pair[0];
                        if (pair.length <= 1 || !FILE_NAME_PARAM_NAME.contains(key)) continue;
                        return pair[1];
                    }
                }
                return FilenameUtils.getName((String)url.getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Illegal fileUrl");
            }
        }
        throw new IllegalArgumentException("fileUrl is blank");
    }
}

