/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.controller;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.file.api.FileServiceErrorCode;
import com.cyberway.mp.file.api.file.dto.SignatureCreateDto;
import com.cyberway.mp.file.api.file.dto.UploadSignatureDto;
import com.cyberway.mp.file.api.filemanager.FileMangerApi;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataCreateDto;
import com.cyberway.mp.file.api.filemanager.dto.FileMetadataQueryDto;
import com.cyberway.mp.file.api.filemanager.dto.ThumbnailDto;
import com.cyberway.mp.file.api.filemanager.dto.UploadDto;
import com.cyberway.mp.file.api.filemanager.enums.ThumbnailFitMode;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/fileManager"})
@ConditionalOnProperty(prefix="mp.file", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="fileManager")
public class FileManagerController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileMangerApi api;

    public FileManagerController(FileMangerApi api) {
        this.api = api;
    }

    @PostMapping(value={"/upload"})
    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20")
    public ResponseResult<FileMetadataVo> uploadFile(@RequestParam(value="file") MultipartFile file, UploadDto dto) {
        return ResponseResult.successResult((Object)this.api.upload(file, dto));
    }

    @PostMapping(value={"/createFileMetadata"})
    @Operation(summary="\u521b\u5efa\u6587\u4ef6\u5143\u6570\u636e\uff0c\u524d\u7aef\u76f4\u63a5\u5bf9\u63a5OSS\u3001COS\u7b49\u4e91\u5b58\u50a8\u670d\u52a1\uff0c\u4e0a\u4f20\u6210\u529f\u540e\u56de\u8c03\u63d0\u4ea4\u6587\u4ef6\u4fe1\u606f")
    public ResponseResult<Long> createFileMetadata(@RequestBody FileMetadataCreateDto dto) {
        return ResponseResult.successResult((Object)this.api.createFileMetadata(dto));
    }

    @PostMapping(value={"/createAndGetFileMetadata"})
    @Operation(summary="\u521b\u5efa\u6587\u4ef6\u5143\u6570\u636e\uff0c\u524d\u7aef\u76f4\u63a5\u5bf9\u63a5OSS\u3001COS\u7b49\u4e91\u5b58\u50a8\u670d\u52a1\uff0c\u4e0a\u4f20\u6210\u529f\u540e\u56de\u8c03\u63d0\u4ea4\u6587\u4ef6\u4fe1\u606f\uff0c\u8fd4\u56de\u5143\u6570\u636e\u4fe1\u606f")
    public ResponseResult<FileMetadataVo> createAndGetFileMetadata(@RequestBody FileMetadataCreateDto dto) {
        return ResponseResult.successResult((Object)this.api.createAndGetFileMetadata(dto));
    }

    @Operation(summary="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/download/{id}"})
    public void download(@PathVariable(value="id") Long id, HttpServletResponse response) {
        FileMetadataVo vo = this.api.getFileMetadata(id);
        if (null == vo || !StringUtils.hasLength((String)vo.getAccessUrl())) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_NOT_FOUND);
        }
        try {
            response.sendRedirect(vo.getAccessUrl());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_DOWNLOAD_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/downloadByPermission/{id}"})
    public void downloadByPermission(@PathVariable(value="id") Long id, HttpServletResponse response) {
        FileMetadataVo vo = this.api.getFileMetadata(id);
        InputStream is = this.api.download(id);
        String filename = vo.getFileName();
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        byte[] buffer = new byte[1024];
        try (BufferedInputStream bis = new BufferedInputStream(this.api.download(id));){
            ServletOutputStream os = response.getOutputStream();
            int i = bis.read(buffer);
            while (i != -1) {
                os.write(buffer, 0, i);
                i = bis.read(buffer);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Operation(summary="\u6587\u4ef6\u5143\u6570\u636e\u8be6\u60c5")
    @GetMapping(value={"/metadata/{id}"})
    public ResponseResult<FileMetadataVo> getFileMetadata(@PathVariable(value="id") Long id) {
        return ResponseResult.successResult((Object)this.api.getFileMetadata(id));
    }

    @PostMapping(value={"/metadata/page"})
    @Operation(summary="\u6587\u4ef6\u5143\u6570\u636e\u5206\u9875\u67e5\u8be2")
    public ResponseResult<Page<FileMetadataVo>> pageFileMetadata(@RequestParam(name="tenantId", required=false) Long tenantId, @RequestBody FileMetadataQueryDto dto) {
        return ResponseResult.successResult((Object)this.api.pageFileMetadata(tenantId, dto));
    }

    @Operation(summary="\u6587\u4ef6\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ResponseResult<Void> deleteFile(@PathVariable(value="id") Long id) {
        this.api.deleteFile(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u4e0a\u4f20\u7b7e\u540d\u4fe1\u606f")
    @GetMapping(value={"/getSignature"})
    public ResponseResult<UploadSignatureDto> getSignature(@Valid SignatureCreateDto signatureCreateDto) {
        return ResponseResult.successResult((Object)this.api.getSignature(signatureCreateDto));
    }

    @Operation(summary="\u751f\u6210/\u67e5\u770b\u7f29\u7565\u56fe")
    @GetMapping(value={"/thumbnail"})
    public void thumbnail(@RequestParam(required=false) String sourceUrl, @RequestParam(required=false) Long sourceId, @RequestParam(required=false) Integer w, @RequestParam(required=false) Integer h, @RequestParam(required=false) ThumbnailFitMode fm, @RequestParam(required=false) Boolean up, HttpServletResponse response) throws IOException {
        ThumbnailDto dto = new ThumbnailDto();
        dto.setSourceUrl(sourceUrl);
        dto.setSourceId(sourceId);
        dto.setWidth(w);
        dto.setHeight(h);
        dto.setFitMode(fm);
        dto.setUpscale(up);
        FileMetadataVo thumbnail = this.api.createOrGetThumbnail(dto);
        response.sendRedirect(thumbnail.getAccessUrl());
    }

    @PostMapping(value={"/generateTempDownloadLink"})
    @Operation(summary="\u751f\u6210\u4e34\u65f6\u4e0b\u8f7d\u94fe\u63a5")
    public ResponseResult<String> generateTempDownloadLink(@RequestParam(value="fileUrl") String fileUrl, @RequestParam(value="maxDownloads", required=false, defaultValue="1") Integer maxDownloads, @RequestParam(value="expirationSeconds", required=false, defaultValue="300") Long expirationSeconds) {
        return ResponseResult.successResult((Object)this.api.generateTempDownloadLink(fileUrl, maxDownloads, expirationSeconds));
    }

    @GetMapping(value={"/tempDownload/{tempDownloadId}"})
    @Operation(summary="\u4e34\u65f6\u4e0b\u8f7d\u6587\u4ef6")
    public void tempDownload(@PathVariable(value="tempDownloadId") String tempDownloadId, HttpServletResponse response) {
        File file = this.api.tempDownload(tempDownloadId);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
        response.setContentLength((int)file.length());
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            bos.flush();
        }
        catch (IOException e) {
            throw new BaseException((ErrorCode)FileServiceErrorCode.FILE_DOWNLOAD_ERROR);
        }
    }
}

