/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.controller;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.file.api.filemanager.dto.InputStreamUploadDto;
import com.cyberway.mp.file.api.filemanager.dto.UploadDto;
import com.cyberway.mp.file.api.filemanager.vo.FileMetadataVo;
import com.cyberway.mp.file.api.watermark.WaterMarkApi;
import com.cyberway.mp.file.api.watermark.dto.FontWaterMarkParamDto;
import com.cyberway.mp.file.api.watermark.dto.PicWaterMarkParamDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

@RestController
@RequestMapping(value={"/api/waterMark"})
@ConditionalOnProperty(prefix="mp.file", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="waterMark")
public class WaterMarkController {
    private static final Logger log = LoggerFactory.getLogger(WaterMarkController.class);
    private final WaterMarkApi api;

    public WaterMarkController(WaterMarkApi api) {
        this.api = api;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/addFontWaterMarkForPostFile"})
    @Operation(summary="\u7ed9\u4e0a\u4f20\u7684\u6587\u4ef6\u6dfb\u52a0\u591a\u4e2a\u6587\u5b57\u6c34\u5370")
    public ResponseEntity<Void> addFontWaterMarkForPostFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="param") String[] paramArr, HttpServletResponse response) {
        List dtoList = FontWaterMarkParamDto.toParamDtoList((String[])paramArr);
        String fileName = file.getOriginalFilename();
        this.buildContentType(response, fileName);
        try (InputStream is = this.api.addFontWaterMark(file, dtoList);){
            ResponseEntity responseEntity;
            block14: {
                ServletOutputStream os = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u6587\u5b57\u6c34\u5370\u6dfb\u52a0\u5f02\u5e38");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"/addFontWaterMarkForFileUrl"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u6587\u4ef6url\u6dfb\u52a0\u6587\u5b57\u6c34\u5370")
    public ResponseEntity<Void> addFontWaterMarkForFileUrl(@RequestParam(value="fileUrl") String fileUrl, @RequestParam(value="param") String[] paramArr, HttpServletResponse response) {
        List dtoList = FontWaterMarkParamDto.toParamDtoList((String[])paramArr);
        try (InputStream is = this.api.addFontWaterMark(fileUrl, dtoList);){
            ResponseEntity responseEntity;
            block14: {
                ServletOutputStream os = response.getOutputStream();
                try {
                    URL url = new URL(fileUrl);
                    String fileName = FilenameUtils.getName((String)url.getPath());
                    this.buildContentType(response, fileName);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u6587\u5b57\u6c34\u5370\u6dfb\u52a0\u5f02\u5e38");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/addPicWaterMarkForPostFile"})
    @Operation(summary="\u7ed9\u4e0a\u4f20\u7684\u6587\u4ef6\u6dfb\u52a0\u56fe\u7247\u6c34\u5370")
    public ResponseEntity<Void> addPicWaterMarkForPostFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="param") String[] paramArr, HttpServletResponse response) {
        String fileName = file.getOriginalFilename();
        this.buildContentType(response, fileName);
        try (InputStream is = this.api.addPicWaterMark(file, PicWaterMarkParamDto.toParamDtoList((String[])paramArr));){
            ResponseEntity responseEntity;
            block14: {
                ServletOutputStream os = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u6c34\u5370\u6dfb\u52a0\u5f02\u5e38");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"/addPicWaterMarkForFileUrl"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u6587\u4ef6url\u6dfb\u52a0\u56fe\u7247\u6c34\u5370")
    public ResponseEntity<Void> addPicWaterMarkForFileUrl(@RequestParam(value="fileUrl") String fileUrl, @RequestParam(value="param") String[] paramArr, HttpServletResponse response) {
        try (InputStream is = this.api.addPicWaterMark(fileUrl, PicWaterMarkParamDto.toParamDtoList((String[])paramArr));){
            ResponseEntity responseEntity;
            block14: {
                ServletOutputStream os = response.getOutputStream();
                try {
                    URL url = new URL(fileUrl);
                    String fileName = FilenameUtils.getName((String)url.getPath());
                    this.buildContentType(response, fileName);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u6c34\u5370\u6dfb\u52a0\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/addFontWaterMarkAndUploadForPostFile"})
    @Operation(summary="\u7ed9\u4e0a\u4f20\u7684\u6587\u4ef6\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\uff0c\u6dfb\u52a0\u5b8c\u6c34\u5370\u540e\u4e0a\u4f20\u6587\u4ef6")
    public ResponseResult<FileMetadataVo> addFontWaterMarkAndUploadForPostFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="param") String[] paramArr, UploadDto uploadDto) {
        return ResponseResult.successResult((Object)this.api.addFontWaterMarkAndUpload(file, uploadDto, FontWaterMarkParamDto.toParamDtoList((String[])paramArr)));
    }

    @PostMapping(value={"/addFontWaterMarkAndUploadForFileUrl"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u6587\u4ef6url\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\uff0c\u6dfb\u52a0\u5b8c\u6c34\u5370\u540e\u4e0a\u4f20\u6587\u4ef6")
    public ResponseResult<FileMetadataVo> addFontWaterMarkAndUploadForFileUrl(@RequestParam(value="fileUrl") String fileUrl, @RequestParam(value="param") String[] paramArr, InputStreamUploadDto inputStreamUploadDto) {
        return ResponseResult.successResult((Object)this.api.addFontWaterMarkAndUpload(fileUrl, inputStreamUploadDto, FontWaterMarkParamDto.toParamDtoList((String[])paramArr)));
    }

    @PostMapping(value={"/addPicWaterMarkAndUploadForPostFile"})
    @Operation(summary="\u7ed9\u4e0a\u4f20\u7684\u6587\u4ef6\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\uff0c\u6dfb\u52a0\u5b8c\u6c34\u5370\u540e\u4e0a\u4f20\u6587\u4ef6")
    public ResponseResult<FileMetadataVo> addPicWaterMarkAndUploadForPostFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="param") String[] paramArr, UploadDto uploadDto) {
        return ResponseResult.successResult((Object)this.api.addPicWaterMarkAndUpload(file, uploadDto, PicWaterMarkParamDto.toParamDtoList((String[])paramArr)));
    }

    @PostMapping(value={"/addPicWaterMarkAndUploadForFileUrl"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u6587\u4ef6url\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\uff0c\u6dfb\u52a0\u5b8c\u6c34\u5370\u540e\u4e0a\u4f20\u6587\u4ef6")
    public ResponseResult<FileMetadataVo> addPicWaterMarkAndUploadForFileUrl(@RequestParam(value="fileUrl") String fileUrl, @RequestParam(value="param") String[] paramArr, InputStreamUploadDto inputStreamUploadDto) {
        return ResponseResult.successResult((Object)this.api.addPicWaterMarkAndUpload(fileUrl, inputStreamUploadDto, PicWaterMarkParamDto.toParamDtoList((String[])paramArr)));
    }

    private void buildContentType(HttpServletResponse response, String fileName) {
        String ext;
        switch (ext = FilenameUtils.getExtension((String)fileName)) {
            case "jpg": 
            case "jpeg": {
                response.setContentType("image/jpeg");
                break;
            }
            case "bmp": {
                response.setContentType("image/bmp");
                break;
            }
            case "gif": {
                response.setContentType("image/gif");
                break;
            }
            case "png": {
                response.setContentType("image/png");
                break;
            }
            case "svg": {
                response.setContentType("image/svg+xml");
                break;
            }
            case "pdf": {
                response.setContentType("application/pdf");
                break;
            }
            default: {
                response.setContentType("application/octet-stream");
            }
        }
        response.setHeader("Content-Disposition", "attachment;fileName=" + UriUtils.encode((String)fileName, (Charset)StandardCharsets.UTF_8));
        response.setCharacterEncoding("UTF-8");
    }
}

