/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.file.api.watermark.dto;

import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.cyberway.mp.file.api.watermark.enums.Position;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class WaterMarkParamDto {
    @Min(value=0L)
    @Max(value=100L)
    private @Min(value=0L) @Max(value=100L) int t = 100;
    private Position g = Position.se;
    @Min(value=0L)
    @Max(value=4096L)
    private @Min(value=0L) @Max(value=4096L) int x = 10;
    @Min(value=0L)
    @Max(value=4096L)
    private @Min(value=0L) @Max(value=4096L) int y = 10;
    @Min(value=-1000L)
    @Max(value=1000L)
    private @Min(value=-1000L) @Max(value=1000L) int voffset = 0;
    @Min(value=0L)
    @Max(value=1L)
    private @Min(value=0L) @Max(value=1L) int fill = 0;
    @Min(value=0L)
    @Max(value=4096L)
    private @Min(value=0L) @Max(value=4096L) int padx = 10;
    @Min(value=0L)
    @Max(value=4096L)
    private @Min(value=0L) @Max(value=4096L) int pady = 10;

    public static <T> List<T> toParamDtoList(String[] paramArr, String requireParam, Class<T> clazz) {
        LinkedHashMap<Integer, List> paramMap = new LinkedHashMap<Integer, List>(paramArr.length);
        int position = 0;
        ArrayList temp = new ArrayList();
        for (String s : paramArr) {
            List sub;
            if (s.contains(requireParam)) {
                sub = paramMap.getOrDefault(position, new ArrayList());
                sub.add(s);
                sub.addAll(temp);
                temp.clear();
                paramMap.put(position, sub);
                ++position;
                continue;
            }
            sub = (List)paramMap.get(position - 1);
            ((List)Objects.requireNonNullElse(sub, temp)).add(s);
        }
        ArrayList<Object> dtoList = new ArrayList<Object>();
        for (List value : paramMap.values()) {
            String p = StringUtils.join((Iterable)value, (String)",");
            if (!StringUtils.isNotBlank((CharSequence)p)) continue;
            String[] items = p.split(",");
            HashMap<String, String> valueMap = new HashMap<String, String>(items.length);
            for (String item : items) {
                String[] map = item.split("_");
                if (map.length != 2 || !StringUtils.isNotBlank((CharSequence)map[0]) || !StringUtils.isNotBlank((CharSequence)map[1])) continue;
                valueMap.put(map[0], map[1]);
            }
            Object dto = JsonUtils.toObject((String)JsonUtils.toJson(valueMap), clazz);
            dtoList.add(dto);
        }
        return dtoList;
    }

    public static String[] toParamArr(List<?> dtoList) {
        Assert.notEmpty(dtoList, (String)"dtoList is not allow empty");
        String[] paramArr = new String[dtoList.size()];
        for (int i = 0; i < dtoList.size(); ++i) {
            Object o = dtoList.get(i);
            Map map = (Map)JsonUtils.toObject((String)JsonUtils.toJson(o), Map.class);
            ArrayList paramItem = new ArrayList(map.size());
            map.forEach((key, val) -> {
                if (val instanceof String && "text".equals(key)) {
                    val = URLDecoder.decode((String)val, StandardCharsets.UTF_8);
                }
                if (null != val) {
                    paramItem.add(key + "_" + val);
                }
            });
            paramArr[i] = StringUtils.join(paramItem, (String)",");
        }
        return paramArr;
    }

    public int getT() {
        return this.t;
    }

    public void setT(int t) {
        this.t = t;
    }

    public Position getG() {
        return this.g;
    }

    public void setG(Position g) {
        this.g = g;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getVoffset() {
        return this.voffset;
    }

    public void setVoffset(int voffset) {
        this.voffset = voffset;
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int fill) {
        this.fill = fill;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPadx(int padx) {
        this.padx = padx;
    }

    public int getPady() {
        return this.pady;
    }

    public void setPady(int pady) {
        this.pady = pady;
    }
}

