/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.api.model.enums;

import java.util.HashMap;
import java.util.Map;

public enum FlowModelNodeType {
    START("node-start"),
    END("node-end"),
    APPROVAL("node-approval"),
    SERVICE("node-server"),
    SCRIPT("node-script"),
    RECEIVE("node-signal"),
    MANUAL("node-manual"),
    EXCLUSIVE_GATEWAY("exclusive-gateway"),
    PARALLEL_GATEWAY("parallel-gateway");

    private final String frontType;
    private static final Map<String, FlowModelNodeType> FRONT_TYPE_MAP;

    private FlowModelNodeType(String frontType) {
        this.frontType = frontType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static FlowModelNodeType findByFrontType(String frontType) {
        return FRONT_TYPE_MAP.get(frontType);
    }

    public boolean allowMultiOut() {
        return this == EXCLUSIVE_GATEWAY || this == PARALLEL_GATEWAY;
    }

    static {
        FRONT_TYPE_MAP = new HashMap<String, FlowModelNodeType>();
        for (FlowModelNodeType value : FlowModelNodeType.values()) {
            FRONT_TYPE_MAP.put(value.getFrontType(), value);
        }
    }
}

