/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.condition.ConditionMatrixApi;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixCreateDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixModifyDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixPageDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixRuleDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixStatusChangeDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueAddDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueBatchAddDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueBatchAddItemDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueModifyDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValuePageDto;
import com.cyberway.mp.flow.api.condition.vo.ConditionMatrixListVo;
import com.cyberway.mp.flow.api.condition.vo.ConditionMatrixValueVo;
import com.cyberway.mp.flow.api.condition.vo.ConditionMatrixVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrix;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrixRule;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrixValue;
import com.cyberway.mp.flow.domain.condition.repository.query.ConditionMatrixMainValueQuery;
import com.cyberway.mp.flow.domain.condition.repository.query.ConditionMatrixQuery;
import com.cyberway.mp.flow.domain.condition.service.ConditionMatrixService;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class ConditionMatrixApplicationService
implements ConditionMatrixApi {
    private static final int VALUE_BATCH_ADD_PAGE_SIZE = 1000;
    private final ConditionMatrixService conditionMatrixService;
    private final IdWorker idWorker;

    public ConditionMatrixApplicationService(ConditionMatrixService conditionMatrixService, IdWorker idWorker) {
        this.conditionMatrixService = conditionMatrixService;
        this.idWorker = idWorker;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createConditionMatrix(ConditionMatrixCreateDto dto) {
        this.validateRules(dto.getRules());
        if (this.conditionMatrixService.checkMatrixCodeExisted(dto.getMatrixCode(), null)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_CODE_EXISTED);
        }
        ConditionMatrix conditionMatrix = ConditionMatrix.fromConditionMatrixCreateDto(dto);
        this.conditionMatrixService.saveConditionMatrix(conditionMatrix, dto.getRules().stream().map(ConditionMatrixRule::fromConditionMatrixRuleDto).collect(Collectors.toList()));
        return (Long)conditionMatrix.getId();
    }

    private void validateRules(List<ConditionMatrixRuleDto> rules) {
        HashSet codes = new HashSet();
        rules.forEach(rule -> {
            if (codes.contains(rule.getRuleCode())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_RULE_CODE_DUPLICATE, new Object[]{rule.getRuleCode()});
            }
            codes.add(rule.getRuleCode());
        });
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyConditionMatrix(ConditionMatrixModifyDto dto) {
        this.validateRules(dto.getRules());
        ConditionMatrix conditionMatrix = this.conditionMatrixService.getConditionMatrix(dto.getId());
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_NOT_EXISTED);
        }
        if (!conditionMatrix.getMatrixCode().equals(dto.getMatrixCode()) && this.conditionMatrixService.checkMatrixCodeExisted(dto.getMatrixCode(), (Long)conditionMatrix.getId())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_CODE_EXISTED);
        }
        HashSet<String> needCleanRuleCodes = new HashSet<String>();
        if (this.conditionMatrixService.alreadyHasValue((Long)conditionMatrix.getId())) {
            List<ConditionMatrixRule> oldRules = this.conditionMatrixService.listConditionMatrixRules((Long)conditionMatrix.getId());
            Map newRuleMap = dto.getRules().stream().collect(Collectors.toMap(ConditionMatrixRuleDto::getRuleCode, Function.identity()));
            oldRules.forEach(oldRule -> {
                if (!newRuleMap.containsKey(oldRule.getRuleCode())) {
                    needCleanRuleCodes.add(oldRule.getRuleCode());
                    return;
                }
                if (dto.isSkipRuleModifyCheck()) {
                    return;
                }
                ConditionMatrixRuleDto newRule = (ConditionMatrixRuleDto)newRuleMap.get(oldRule.getRuleCode());
                if (!newRule.getValueType().equals((Object)oldRule.getValueType()) || !newRule.getConditionType().equals((Object)oldRule.getConditionType())) {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_RULE_TYPE_MODIFIED, new Object[]{oldRule.getRuleCode()});
                }
            });
        }
        conditionMatrix.updateByConditionMatrixCreateDto((ConditionMatrixCreateDto)dto);
        this.conditionMatrixService.updateConditionMatrix(conditionMatrix, dto.getRules().stream().map(ConditionMatrixRule::fromConditionMatrixRuleDto).collect(Collectors.toList()));
        if (!needCleanRuleCodes.isEmpty()) {
            this.conditionMatrixService.fixValue((Long)conditionMatrix.getId(), needCleanRuleCodes);
        }
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteConditionMatrix(long id) {
        this.conditionMatrixService.deleteConditionMatrix(id);
    }

    public Page<ConditionMatrixListVo> queryConditionMatrix(ConditionMatrixPageDto dto) {
        ConditionMatrixQuery query = ConditionMatrixQuery.fromConditionMatrixPageDto(dto);
        long total = this.conditionMatrixService.countConditionMatrix(query);
        if (total == 0L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<ConditionMatrix> dataList = this.conditionMatrixService.pageConditionMatrix(query, (PageParam)dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), total, dataList.stream().map(ConditionMatrix::toConditionMatrixListVo).collect(Collectors.toList()));
    }

    public ConditionMatrixVo getConditionMatrix(long id) {
        ConditionMatrix conditionMatrix = this.conditionMatrixService.getConditionMatrix(id);
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_NOT_EXISTED);
        }
        ConditionMatrixVo vo = conditionMatrix.toConditionMatrixVo();
        vo.setRules(this.conditionMatrixService.listConditionMatrixRules(id).stream().map(ConditionMatrixRule::toConditionMatrixRuleDto).collect(Collectors.toList()));
        return vo;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void changeConditionMatrixStatus(ConditionMatrixStatusChangeDto dto) {
        ConditionMatrix conditionMatrix = this.conditionMatrixService.getConditionMatrix(dto.getId());
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_NOT_EXISTED);
        }
        conditionMatrix.setStatus(dto.getStatus());
        this.conditionMatrixService.updateConditionMatrix(conditionMatrix);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long addConditionMatrixValue(ConditionMatrixValueAddDto dto) {
        ConditionMatrix conditionMatrix = this.conditionMatrixService.getConditionMatrix(dto.getMatrixId());
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_NOT_EXISTED);
        }
        List<ConditionMatrixRule> rules = this.conditionMatrixService.listConditionMatrixRules((Long)conditionMatrix.getId());
        this.validateValueMatchRule(dto.getRuleValues(), rules);
        long mainValueId = this.idWorker.nextId();
        List<ConditionMatrixValue> values = ConditionMatrixValue.fromAddDto(dto, mainValueId);
        this.conditionMatrixService.batchAddConditionMatrixValue(values);
        return mainValueId;
    }

    private void validateValueMatchRule(Map<String, String[]> ruleValues, List<ConditionMatrixRule> rules) {
        block4: for (ConditionMatrixRule rule : rules) {
            if (!ruleValues.containsKey(rule.getRuleCode())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_VALUE_MISS_RULE, new Object[]{rule.getRuleCode()});
            }
            String[] ruleValue = ruleValues.get(rule.getRuleCode());
            switch (rule.getConditionType()) {
                case BETWEEN: {
                    if (ruleValue.length == 2) continue block4;
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_VALUE_LENGTH_NOT_MATCH, new Object[]{rule.getRuleCode()});
                }
                case IN: 
                case NOT_IN: {
                    if (ruleValue.length >= 1) continue block4;
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_VALUE_LENGTH_NOT_MATCH, new Object[]{rule.getRuleCode()});
                }
            }
            if (ruleValue.length == 1) continue;
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_VALUE_LENGTH_NOT_MATCH, new Object[]{rule.getRuleCode()});
        }
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyConditionMatrixValue(ConditionMatrixValueModifyDto dto) {
        ConditionMatrixValue mainValue = this.conditionMatrixService.getConditionMatrixValue(dto.getId());
        if (mainValue == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_VALUE_ID_NOT_EXISTED);
        }
        List<ConditionMatrixRule> rules = this.conditionMatrixService.listConditionMatrixRules(mainValue.getMatrixId());
        this.validateValueMatchRule(dto.getRuleValues(), rules);
        this.conditionMatrixService.cleanConditionMatrixValueByMainValue(dto.getId());
        List<ConditionMatrixValue> values = ConditionMatrixValue.fromModifyDto(dto, mainValue);
        this.conditionMatrixService.batchAddConditionMatrixValue(values);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteConditionMatrixValue(List<Long> ids) {
        this.conditionMatrixService.cleanConditionMatrixValueByMainValues(ids);
    }

    public Page<ConditionMatrixValueVo> queryConditionMatrixValue(ConditionMatrixValuePageDto dto) {
        ConditionMatrixMainValueQuery query = ConditionMatrixMainValueQuery.fromConditionMatrixValuePageDto(dto);
        long total = this.conditionMatrixService.countConditionMatrixMainValue(query);
        if (total == 0L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<ConditionMatrixValue> mainValues = this.conditionMatrixService.pageConditionMatrixMainValue(query, (PageParam)dto);
        Set<Long> notMainValueIds = mainValues.stream().filter(v -> Boolean.FALSE.equals(v.getMainValue())).map(ConditionMatrixValue::getMainValueId).collect(Collectors.toSet());
        if (!notMainValueIds.isEmpty()) {
            Map mainValueMap = this.conditionMatrixService.batchGetValue(notMainValueIds).stream().collect(Collectors.toMap(Entity::getId, Function.identity()));
            mainValues = mainValues.stream().map(v -> mainValueMap.getOrDefault(v.getMainValueId(), v)).collect(Collectors.toList());
        }
        List<ConditionMatrixValue> values = this.conditionMatrixService.batchGetValueByMainValue(mainValues.stream().map(Entity::getId).collect(Collectors.toSet()));
        Map userMap = values.stream().collect(Collectors.groupingBy(ConditionMatrixValue::getMainValueId, Collectors.mapping(v -> new IdNameDto(v.getUserId(), v.getUserName()), Collectors.toList())));
        return new Page(dto.getCurrent(), dto.getPageSize(), total, mainValues.stream().map(v -> v.toVo(userMap)).collect(Collectors.toList()));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void batchAddConditionMatrixValues(ConditionMatrixValueBatchAddDto dto) {
        ConditionMatrix conditionMatrix;
        if (dto.getMatrixId() != null) {
            conditionMatrix = this.conditionMatrixService.getConditionMatrix(dto.getMatrixId());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getMatrixCode())) {
            conditionMatrix = this.conditionMatrixService.getConditionMatrixByCode(dto.getMatrixCode());
        } else {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_AND_CODE_ALL_EMPTY);
        }
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_NOT_EXISTED);
        }
        if (Boolean.TRUE.equals(dto.getCleanOld())) {
            this.conditionMatrixService.cleanConditionMatrixValueByMatrix((Long)conditionMatrix.getId());
        }
        ArrayList<ConditionMatrixValue> values = new ArrayList<ConditionMatrixValue>();
        List<ConditionMatrixRule> rules = this.conditionMatrixService.listConditionMatrixRules((Long)conditionMatrix.getId());
        for (ConditionMatrixValueBatchAddItemDto item : dto.getItems()) {
            this.validateValueMatchRule(item.getRuleValues(), rules);
            values.addAll(ConditionMatrixValue.fromItemAddDto(item, (Long)conditionMatrix.getId(), this.idWorker.nextId()));
            if (values.size() <= 1000) continue;
            this.conditionMatrixService.batchAddConditionMatrixValue(values);
            values.clear();
        }
        if (!values.isEmpty()) {
            this.conditionMatrixService.batchAddConditionMatrixValue(values);
        }
    }

    public ConditionMatrixValueVo getConditionMatrixValue(long id) {
        List<ConditionMatrixValue> values = this.conditionMatrixService.batchGetValueByMainValue(Collections.singletonList(id));
        if (values.isEmpty()) {
            return null;
        }
        Optional<ConditionMatrixValue> mainValue = values.stream().filter(v -> Boolean.TRUE.equals(v.getMainValue())).findFirst();
        if (mainValue.isEmpty()) {
            return null;
        }
        Map<Long, List<IdNameDto>> userMap = values.stream().collect(Collectors.groupingBy(ConditionMatrixValue::getMainValueId, Collectors.mapping(v -> new IdNameDto(v.getUserId(), v.getUserName()), Collectors.toList())));
        return mainValue.get().toVo(userMap);
    }
}

