/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.delegation.DelegationApi;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleCreateDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleModifyBaseDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleModifyDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRulePageDto;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleInfoVo;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleListVo;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRuleItem;
import com.cyberway.mp.flow.domain.delegation.repository.query.DelegationRuleQuery;
import com.cyberway.mp.flow.domain.delegation.service.DelegationRuleService;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class DelegationApplicationService
implements DelegationApi {
    private final DelegationRuleService delegationRuleService;

    public DelegationApplicationService(DelegationRuleService delegationRuleService) {
        this.delegationRuleService = delegationRuleService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createDelegationRule(DelegationRuleCreateDto dto) {
        DelegationRule delegationRule = DelegationRule.fromDelegationRuleCreateDto(dto);
        boolean hasItem = Boolean.FALSE.equals(delegationRule.getDelegateAll()) && dto.getProjects() != null && !dto.getProjects().isEmpty();
        List<DelegationRuleItem> items = hasItem ? dto.getProjects().stream().map(DelegationRuleItem::fromIdNameDto).collect(Collectors.toList()) : Collections.emptyList();
        this.delegationRuleService.createDelegationRule(delegationRule, items);
        return (Long)delegationRule.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyDelegationRule(DelegationRuleModifyDto dto) {
        DelegationRule delegationRule = this.delegationRuleService.getDelegationRule(dto.getId());
        if (delegationRule == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_ID_NOT_EXISTED);
        }
        delegationRule.update((DelegationRuleModifyBaseDto)dto);
        boolean hasItem = Boolean.FALSE.equals(delegationRule.getDelegateAll()) && dto.getProjects() != null && !dto.getProjects().isEmpty();
        List<DelegationRuleItem> items = hasItem ? dto.getProjects().stream().map(d -> DelegationRuleItem.fromIdNameDtoWithRuleId((Long)delegationRule.getId(), d)).collect(Collectors.toList()) : Collections.emptyList();
        this.delegationRuleService.modifyDelegationRule(delegationRule, items);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteDelegationRule(long id) {
        this.delegationRuleService.deleteDelegationRule(id);
    }

    public Page<DelegationRuleListVo> queryDelegationRule(DelegationRulePageDto dto) {
        DelegationRuleQuery delegationRuleQuery = DelegationRuleQuery.fromDelegationRulePageDto(dto);
        long count = this.delegationRuleService.countDelegationRule(delegationRuleQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<DelegationRule> delegationRules = this.delegationRuleService.pageQueryDelegationRule(dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, delegationRules.stream().map(DelegationRule::toDelegationRuleListVo).collect(Collectors.toList()));
    }

    public DelegationRuleInfoVo getDelegationRule(long id) {
        DelegationRule delegationRule = this.delegationRuleService.getDelegationRule(id);
        if (delegationRule == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_ID_NOT_EXISTED);
        }
        List<DelegationRuleItem> items = Boolean.FALSE.equals(delegationRule.getDelegateAll()) ? this.delegationRuleService.listItemInRule(id) : Collections.emptyList();
        return delegationRule.toDelegationRuleInfoVo(items);
    }

    public void enableDelegationRule(long id) {
        this.delegationRuleService.enableDelegationRule(id);
    }

    public void disableDelegationRule(long id) {
        this.delegationRuleService.disableDelegationRule(id);
    }
}

