/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.category.FlowCategoryApi;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryCreateDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryModifyDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryPageDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryTreePageDto;
import com.cyberway.mp.flow.api.category.vo.FlowCategoryListVo;
import com.cyberway.mp.flow.api.category.vo.FlowCategoryTreeVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.category.entity.FlowCategory;
import com.cyberway.mp.flow.domain.category.entity.FlowCategoryWithParentName;
import com.cyberway.mp.flow.domain.category.repository.query.FlowCategoryWithParentNameQuery;
import com.cyberway.mp.flow.domain.category.service.FlowCategoryService;
import com.cyberway.mp.flow.domain.model.service.FlowModelService;
import com.cyberway.mp.flow.infra.config.FlowBaseContextProperties;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowCategoryApplicationService
implements FlowCategoryApi {
    private final FlowCategoryService flowCategoryService;
    private final FlowModelService flowModelService;
    private final FlowBaseContextProperties flowBaseContextProperties;

    public FlowCategoryApplicationService(FlowCategoryService flowCategoryService, FlowModelService flowModelService, FlowBaseContextProperties flowBaseContextProperties) {
        this.flowCategoryService = flowCategoryService;
        this.flowModelService = flowModelService;
        this.flowBaseContextProperties = flowBaseContextProperties;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createFlowCategory(FlowCategoryCreateDto dto) {
        FlowCategory flowCategory = FlowCategory.fromFlowCategoryCreateDto(dto);
        this.flowCategoryService.createFlowCategory(flowCategory);
        return (Long)flowCategory.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyFlowCategory(FlowCategoryModifyDto dto) {
        this.flowCategoryService.modifyFlowCategory(dto);
    }

    public FlowCategoryListVo getFlowCategory(long id) {
        FlowCategoryWithParentName flowCategory = this.flowCategoryService.getFlowCategoryWithParentName(id);
        if (flowCategory == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_CATEGORY_ID_NOT_EXISTED);
        }
        return flowCategory.toFlowCategoryListVo();
    }

    public Page<FlowCategoryListVo> queryFlowCategory(FlowCategoryPageDto dto) {
        dto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        FlowCategoryWithParentNameQuery flowCategoryQuery = FlowCategoryWithParentNameQuery.fromFlowCategoryPageDto(dto);
        long count = this.flowCategoryService.countFlowCategory(flowCategoryQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowCategoryWithParentName> flowCategories = this.flowCategoryService.pageQueryFlowCategory(dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, flowCategories.stream().map(FlowCategoryWithParentName::toFlowCategoryListVo).collect(Collectors.toList()));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteFlowCategory(long id) {
        FlowCategory flowCategory = this.flowCategoryService.getFlowCategory(id);
        if (flowCategory == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_CATEGORY_ID_NOT_EXISTED);
        }
        if (this.flowBaseContextProperties.getDefaultCategoryCode().equals(flowCategory.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DEFAULT_FLOW_CATEGORY_CANNOT_DELETED);
        }
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(id);
        ids.addAll(this.flowCategoryService.listAllChildrenId(flowCategory));
        Long newCategoryId = flowCategory.getParentId();
        if (CodeUtils.isEmptyId(newCategoryId)) {
            FlowCategory defaultFlowCategory = this.flowCategoryService.getByCodeName(this.flowBaseContextProperties.getDefaultCategoryCode());
            if (defaultFlowCategory == null) {
                defaultFlowCategory = new FlowCategory();
                defaultFlowCategory.setCodeName(this.flowBaseContextProperties.getDefaultCategoryCode());
                defaultFlowCategory.setName("\u9ed8\u8ba4");
                defaultFlowCategory.setAppInstanceId(flowCategory.getAppInstanceId());
                defaultFlowCategory.setBusinessZoneId(flowCategory.getBusinessZoneId());
                defaultFlowCategory.setTenantId(flowCategory.getTenantId());
                this.flowCategoryService.createFlowCategory(defaultFlowCategory);
            }
            newCategoryId = (Long)defaultFlowCategory.getId();
        }
        this.flowModelService.moveCategory(ids, newCategoryId);
        this.flowCategoryService.batchDeleteFlowCategory(ids);
    }

    public List<FlowCategoryTreeVo> tree() {
        ArrayList<FlowCategoryTreeVo> result = new ArrayList<FlowCategoryTreeVo>();
        List<FlowCategory> flowCategories = this.flowCategoryService.listAll();
        HashMap map = MapUtil.newHashMap((int)flowCategories.size());
        for (FlowCategory flowCategory : flowCategories) {
            FlowCategoryTreeVo vo = flowCategory.toFlowCategoryTreeVo();
            if (map.containsKey(vo.getId())) {
                vo.setChildren(((FlowCategoryTreeVo)map.get(vo.getId())).getChildren());
            }
            map.put((Long)flowCategory.getId(), vo);
            if (CodeUtils.isEmptyId(flowCategory.getParentId())) {
                result.add(vo);
                continue;
            }
            if (map.containsKey(flowCategory.getParentId())) {
                ((FlowCategoryTreeVo)map.get(flowCategory.getParentId())).getChildren().add(vo);
                continue;
            }
            FlowCategoryTreeVo parentVo = new FlowCategoryTreeVo();
            ArrayList<FlowCategoryTreeVo> children = new ArrayList<FlowCategoryTreeVo>();
            parentVo.setChildren(children);
            children.add(vo);
            map.put(flowCategory.getParentId(), parentVo);
        }
        Comparator<FlowCategoryTreeVo> comparator = Comparator.comparing(FlowCategoryTreeVo::getSortOrder, Comparator.nullsLast(Integer::compareTo));
        result.sort(comparator);
        for (FlowCategoryTreeVo vo : map.values()) {
            if (vo.getChildren() == null) continue;
            vo.getChildren().sort(comparator);
        }
        return result;
    }

    public Page<FlowCategoryListVo> queryFlowCategoryTreeStructure(FlowCategoryTreePageDto dto) {
        List<FlowCategory> allCategories = this.flowCategoryService.listAll();
        Map<Long, FlowCategory> categoryMap = allCategories.stream().collect(Collectors.toMap(Entity::getId, category -> category));
        HashSet<Long> categoryIds = new HashSet<Long>();
        block0: for (FlowCategory category2 : allCategories) {
            boolean matchName = true;
            boolean matchCode = true;
            if (StringUtils.hasText((String)dto.getName())) {
                matchName = category2.getName().contains(dto.getName());
            }
            if (StringUtils.hasText((String)dto.getCodeName())) {
                matchCode = category2.getCodeName().contains(dto.getCodeName());
            }
            if (!matchName || !matchCode) continue;
            categoryIds.add((Long)category2.getId());
            Long parentId = category2.getParentId();
            while (parentId != null && parentId != 0L) {
                categoryIds.add(parentId);
                FlowCategory parent = categoryMap.get(parentId);
                if (parent == null) continue block0;
                parentId = parent.getParentId();
            }
        }
        List filteredCategories = allCategories.stream().filter(category -> categoryIds.contains(category.getId())).collect(Collectors.toList());
        long totalCount = filteredCategories.stream().filter(category -> category.getParentId() == null || category.getParentId() == 0L).count();
        if (totalCount < 1L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        HashMap<Long, FlowCategoryListVo> map = new HashMap<Long, FlowCategoryListVo>();
        ArrayList<FlowCategoryListVo> result = new ArrayList<FlowCategoryListVo>();
        for (Object category3 : filteredCategories) {
            FlowCategoryListVo vo = ((FlowCategory)((Object)category3)).toFlowCategoryListVo();
            vo.setId((Long)category3.getId());
            if (map.containsKey(vo.getId())) {
                vo.setChildren(((FlowCategoryListVo)map.get(vo.getId())).getChildren());
            }
            map.put((Long)category3.getId(), vo);
            if (((FlowCategory)((Object)category3)).getParentId() == null || ((FlowCategory)((Object)category3)).getParentId() == 0L) {
                result.add(vo);
                continue;
            }
            if (map.containsKey(((FlowCategory)((Object)category3)).getParentId())) {
                FlowCategoryListVo parent = (FlowCategoryListVo)map.get(((FlowCategory)((Object)category3)).getParentId());
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList());
                }
                parent.getChildren().add(vo);
                continue;
            }
            FlowCategoryListVo parentVo = new FlowCategoryListVo();
            ArrayList<FlowCategoryListVo> children = new ArrayList<FlowCategoryListVo>();
            parentVo.setChildren(children);
            children.add(vo);
            map.put(((FlowCategory)((Object)category3)).getParentId(), parentVo);
        }
        Comparator<FlowCategoryListVo> comparator = Comparator.comparing(FlowCategoryListVo::getSortOrder, Comparator.nullsLast(Integer::compareTo));
        result.sort(comparator);
        for (FlowCategoryListVo vo : map.values()) {
            if (vo.getChildren() == null) continue;
            vo.getChildren().sort(comparator);
        }
        int fromIndex = dto.getOffset();
        int toIndex = Math.min(fromIndex + dto.getPageSize(), result.size());
        if (fromIndex >= result.size()) {
            return new Page(dto.getCurrent(), dto.getPageSize(), totalCount, Collections.emptyList());
        }
        List pageResult = result.subList(fromIndex, toIndex);
        return new Page(dto.getCurrent(), dto.getPageSize(), totalCount, pageResult);
    }
}

