/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.communicate.FlowCommunicateApi;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateAddDto;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateListDto;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateTreeDto;
import com.cyberway.mp.flow.api.communicate.vo.FlowCommunicateTreeVo;
import com.cyberway.mp.flow.api.communicate.vo.FlowCommunicateVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.communicate.entity.FlowCommunicate;
import com.cyberway.mp.flow.domain.communicate.repository.query.FlowCommunicateQuery;
import com.cyberway.mp.flow.domain.communicate.service.FlowCommunicateService;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowCommunicateApplicationService
implements FlowCommunicateApi {
    private final FlowCommunicateService flowCommunicateService;
    private final FlowInstanceService flowInstanceService;
    private final FlowNodeService flowNodeService;
    private final FlowTaskService flowTaskService;

    public FlowCommunicateApplicationService(FlowCommunicateService flowCommunicateService, FlowInstanceService flowInstanceService, FlowNodeService flowNodeService, FlowTaskService flowTaskService) {
        this.flowCommunicateService = flowCommunicateService;
        this.flowInstanceService = flowInstanceService;
        this.flowNodeService = flowNodeService;
        this.flowTaskService = flowTaskService;
    }

    public long addCommunicate(FlowCommunicateAddDto dto) {
        FlowCommunicate flowCommunicate;
        if (dto.getReplyId() != null) {
            FlowCommunicate reply = this.flowCommunicateService.getFlowCommunicate(dto.getReplyId());
            if (reply == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_COMMUNICATE_ID_NOT_EXISTED);
            }
            flowCommunicate = FlowCommunicate.fromReply(reply, dto);
        } else if (dto.getFlowTaskId() != null) {
            FlowTask flowTask = this.flowTaskService.getFlowTask(dto.getFlowTaskId());
            if (flowTask == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
            }
            flowCommunicate = FlowCommunicate.fromFlowTask(flowTask, dto);
        } else if (dto.getFlowNodeId() != null) {
            FlowNode flowNode = this.flowNodeService.getFlowNode(dto.getFlowNodeId());
            if (flowNode == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_NODE_ID_NOT_EXISTED);
            }
            flowCommunicate = FlowCommunicate.fromFlowNode(flowNode, dto);
        } else if (dto.getFlowInstanceId() != null) {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
            if (flowInstance == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
            }
            flowCommunicate = FlowCommunicate.fromFlowInstance(flowInstance, dto);
        } else {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.EMPTY_REQUIRED_PARAM);
        }
        this.flowCommunicateService.createFlowCommunicate(flowCommunicate);
        return (Long)flowCommunicate.getId();
    }

    public List<FlowCommunicateVo> listFlowCommunicate(FlowCommunicateListDto dto) {
        return this.flowCommunicateService.listFlowCommunicate(FlowCommunicateQuery.fromFlowCommunicateListDto(dto)).stream().map(FlowCommunicate::toFlowCommunicateVo).collect(Collectors.toList());
    }

    public List<FlowCommunicateTreeVo> treeFlowCommunicate(FlowCommunicateTreeDto dto) {
        List<FlowCommunicate> flowCommunicates = this.flowCommunicateService.listFlowCommunicate(FlowCommunicateQuery.fromFlowCommunicateTreeDto(dto));
        ArrayList<FlowCommunicateTreeVo> result = new ArrayList<FlowCommunicateTreeVo>();
        HashMap voMap = MapUtil.newHashMap((int)flowCommunicates.size());
        for (FlowCommunicate flowCommunicate : flowCommunicates) {
            FlowCommunicateTreeVo vo = flowCommunicate.toFlowCommunicateTreeVo();
            if (vo.getReplyId() != null) {
                if (voMap.containsKey(vo.getReplyId())) {
                    ((FlowCommunicateTreeVo)voMap.get(vo.getReplyId())).getReplies().add(vo);
                }
            } else {
                result.add(vo);
            }
            voMap.put(vo.getId(), vo);
        }
        return result;
    }
}

