/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.customapi.FlowCustomApiApi;
import com.cyberway.mp.flow.api.customapi.dto.FlowCustomApiCreateDto;
import com.cyberway.mp.flow.api.customapi.dto.FlowCustomApiModifyBaseDto;
import com.cyberway.mp.flow.api.customapi.dto.FlowCustomApiModifyDto;
import com.cyberway.mp.flow.api.customapi.dto.FlowCustomApiPageDto;
import com.cyberway.mp.flow.api.customapi.vo.FlowCustomApiInfoVo;
import com.cyberway.mp.flow.api.customapi.vo.FlowCustomApiListVo;
import com.cyberway.mp.flow.domain.customapi.entity.FlowCustomApi;
import com.cyberway.mp.flow.domain.customapi.entity.SimpleFlowCustomApi;
import com.cyberway.mp.flow.domain.customapi.repository.query.SimpleFlowCustomApiQuery;
import com.cyberway.mp.flow.domain.customapi.service.FlowCustomApiService;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowCustomApiApplicationService
implements FlowCustomApiApi {
    private final FlowCustomApiService flowCustomApiService;

    public FlowCustomApiApplicationService(FlowCustomApiService flowCustomApiService) {
        this.flowCustomApiService = flowCustomApiService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createFlowCustomApi(FlowCustomApiCreateDto dto) {
        FlowCustomApi flowCustomApi = FlowCustomApi.fromFlowCustomApiCreateDto(dto);
        this.flowCustomApiService.createFlowCustomApi(flowCustomApi);
        return (Long)flowCustomApi.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyFlowCustomApi(FlowCustomApiModifyDto dto) {
        FlowCustomApi flowCustomApi = this.flowCustomApiService.getFlowCustomApi(dto.getId());
        flowCustomApi.update((FlowCustomApiModifyBaseDto)dto);
        this.flowCustomApiService.modifyFlowCustomApi(flowCustomApi);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteFlowCustomApi(long id) {
        this.flowCustomApiService.deleteFlowCustomApi(id);
    }

    public Page<FlowCustomApiListVo> pageQueryFlowCustomApi(FlowCustomApiPageDto dto) {
        SimpleFlowCustomApiQuery query = SimpleFlowCustomApiQuery.fromFlowCustomApiPageDto(dto);
        long count = this.flowCustomApiService.countFlowCustomApi(query);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<SimpleFlowCustomApi> customApis = this.flowCustomApiService.pageQuerySimpleCustomFlowApi(dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, customApis.stream().map(SimpleFlowCustomApi::toFlowCustomApiListVo).collect(Collectors.toList()));
    }

    public FlowCustomApiInfoVo getFlowCustomApi(long id) {
        FlowCustomApi flowCustomApi = this.flowCustomApiService.getFlowCustomApi(id);
        if (flowCustomApi == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_CUSTOM_API_ID_NOT_EXISTED);
        }
        return flowCustomApi.toFlowCustomApiInfoVo();
    }
}

