/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.flow.api.function.FlowFunctionApi;
import com.cyberway.mp.flow.api.function.annotation.FlowVariable;
import com.cyberway.mp.flow.api.function.annotation.Function;
import com.cyberway.mp.flow.api.function.annotation.FunctionBean;
import com.cyberway.mp.flow.api.function.annotation.FunctionParam;
import com.cyberway.mp.flow.api.function.dto.FlowFunctionDto;
import com.cyberway.mp.flow.api.function.dto.FlowFunctionParamDto;
import com.cyberway.mp.flow.api.function.vo.FlowFunctionVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class FlowFunctionApplicationService
implements FlowFunctionApi {
    private final Map<String, List<FlowFunctionDto>> cachedRegisteredFunctions = new LinkedHashMap<String, List<FlowFunctionDto>>();
    private final List<FlowFunctionParamDto> cachedGlobalVariables = new ArrayList<FlowFunctionParamDto>();
    private final Set<String> cachedRegisteredFunctionKeys = new HashSet<String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowEngineService flowEngineService;
    private boolean isInitialized = false;

    public FlowFunctionApplicationService(FlowEngineService flowEngineService) {
        this.flowEngineService = flowEngineService;
    }

    public Map<String, List<FlowFunctionDto>> loadRegisteredFunctions() {
        if (!this.isInitialized) {
            this.initFunction();
            this.initGlobalVariables();
            this.isInitialized = true;
        }
        return new LinkedHashMap<String, List<FlowFunctionDto>>(this.cachedRegisteredFunctions);
    }

    private void initGlobalVariables() {
        List<Class<FlowInfoVariables>> flowableConstantClasses = List.of(FlowInfoVariables.class);
        for (Class<FlowInfoVariables> clazz : flowableConstantClasses) {
            Field[] allFields;
            for (Field field : allFields = FieldUtils.getAllFields(clazz)) {
                FlowVariable flowVariable = (FlowVariable)AnnotationUtils.findAnnotation((AnnotatedElement)field, FlowVariable.class);
                if (flowVariable == null) continue;
                this.cachedGlobalVariables.add(new FlowFunctionParamDto(flowVariable.key(), flowVariable.type().getSimpleName(), flowVariable.description()));
            }
        }
    }

    public FlowFunctionVo getFunctionVo() {
        FlowFunctionVo flowFunctionVo = new FlowFunctionVo();
        Map<String, List<FlowFunctionDto>> functions = this.loadRegisteredFunctions();
        flowFunctionVo.setFunctionMap(functions);
        flowFunctionVo.setGlobalVariables(new ArrayList<FlowFunctionParamDto>(this.cachedGlobalVariables));
        return flowFunctionVo;
    }

    private void initFunction() {
        Map<Object, Object> beans = this.flowEngineService.getBeans();
        if (null == beans || beans.isEmpty()) {
            this.logger.warn("No beans found in FlowEngineService.");
            return;
        }
        beans.forEach((key, bean) -> this.registerBean((String)key, bean));
    }

    private void registerBean(String key, Object bean) {
        Method[] allDeclaredMethods;
        if (this.cachedRegisteredFunctionKeys.contains(key)) {
            throw new IllegalCallerException("function bean [" + key + "] already exists");
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        String functionBeanName = this.getFunctionBeanName(targetClass);
        if (StringUtils.isBlank((CharSequence)functionBeanName)) {
            this.logger.warn("function bean [{}] name is blank or not support", (Object)targetClass.getName());
            return;
        }
        List functionList = this.cachedRegisteredFunctions.computeIfAbsent(functionBeanName, k -> new ArrayList());
        for (Method method : allDeclaredMethods = ReflectionUtils.getAllDeclaredMethods((Class)targetClass)) {
            Parameter[] parameters;
            boolean isDefineByObjectClass;
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            Function function = (Function)AnnotationUtils.findAnnotation((Method)method, Function.class);
            boolean isIgnore = function != null && function.ignore();
            boolean bl = isDefineByObjectClass = method.getDeclaringClass() == Object.class;
            if (!isPublic || isIgnore || isDefineByObjectClass) continue;
            FlowFunctionDto functionDto = new FlowFunctionDto();
            functionDto.setName(method.getName());
            functionDto.setScript(key + "." + method.getName());
            if (null != function) {
                functionDto.setDescription(function.description());
                functionDto.setExample(function.example());
            } else {
                functionDto.setDescription("\u65e0");
                functionDto.setExample("\u65e0");
            }
            Class<?> returnType = method.getReturnType();
            functionDto.setReturnType(returnType.getSimpleName());
            ArrayList<FlowFunctionParamDto> params = new ArrayList<FlowFunctionParamDto>();
            for (Parameter parameter : parameters = method.getParameters()) {
                FlowFunctionParamDto paramDto = new FlowFunctionParamDto();
                paramDto.setName(parameter.getName());
                FunctionParam functionParam = (FunctionParam)AnnotationUtils.findAnnotation((AnnotatedElement)parameter, FunctionParam.class);
                if (null != functionParam) {
                    paramDto.setDescription(functionParam.description());
                }
                Class<?> type = parameter.getType();
                paramDto.setType(type.getSimpleName());
                params.add(paramDto);
            }
            List<Parameter> parameterList = Arrays.asList(parameters);
            String paramStr = parameterList.stream().map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining(","));
            functionDto.setScript(functionDto.getScript() + "(" + paramStr + ")");
            functionDto.setParams(params);
            functionList.add(functionDto);
        }
        this.cachedRegisteredFunctionKeys.add(key);
    }

    private String getFunctionBeanName(Class<?> clazz) {
        FunctionBean functionBean = (FunctionBean)AnnotationUtils.findAnnotation(clazz, FunctionBean.class);
        if (null == functionBean) {
            return clazz.getSimpleName();
        }
        return functionBean.ignore() ? null : functionBean.name();
    }
}

