/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.BeanUtils;
import com.cyberway.mp.bc.dal.model.BusinessEntity;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.GetVariablesDto;
import com.cyberway.mp.flow.api.common.dto.SetVariablesDto;
import com.cyberway.mp.flow.api.common.vo.BatchActionResultVo;
import com.cyberway.mp.flow.api.common.vo.ErrorInfoVo;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.common.vo.KeyNameVo;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.FlowInstanceApi;
import com.cyberway.mp.flow.api.instance.dto.FlowDraftInstanceBaseDto;
import com.cyberway.mp.flow.api.instance.dto.FlowDraftInstanceDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceActionDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceAdminActionDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceAdminUrgeDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceApproveDetailDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceBatchStartDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceChangeDueTimeDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceComprehensiveDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceDuePageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtModifyDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceInfoListDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceJumpDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceMigrationDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceMyHandledPageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstancePageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceStartBaseDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceStartDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceTriggerDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceVariableRemoveDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceVariableSetDto;
import com.cyberway.mp.flow.api.instance.dto.FlowNodeLogListDto;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.instance.vo.FlowCcVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceApproveDetailVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceApproveTaskVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceApproveVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBaseVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBatchStartResultVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceComprehensiveVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceDetailListVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceDueVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceInfoVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceJumpInfoVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceMyHandledPageVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceMyStartedPageVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceNodeInfoVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceVariableVo;
import com.cyberway.mp.flow.api.instance.vo.FlowNodeComprehensiveVo;
import com.cyberway.mp.flow.api.instance.vo.FlowNodeLogVo;
import com.cyberway.mp.flow.api.instance.vo.FlowTaskComprehensiveVo;
import com.cyberway.mp.flow.api.instance.vo.FlowTaskLogVo;
import com.cyberway.mp.flow.api.instance.vo.JumpNodeAssigneeInfo;
import com.cyberway.mp.flow.api.instance.vo.JumpNodeInfoVo;
import com.cyberway.mp.flow.api.log.enums.FlowActionType;
import com.cyberway.mp.flow.api.log.enums.UrgeLogType;
import com.cyberway.mp.flow.api.log.enums.UrgeSourceType;
import com.cyberway.mp.flow.api.log.vo.FlowLogVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventTemplateDto;
import com.cyberway.mp.flow.api.project.dto.GatewayLineConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.dto.OpinionCheckActionDto;
import com.cyberway.mp.flow.api.project.dto.VariableDefineDto;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.project.enums.FlowProjectStatus;
import com.cyberway.mp.flow.api.project.enums.FlowVariableType;
import com.cyberway.mp.flow.api.project.enums.OpinionValidationType;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.api.task.enums.MdmFlowTaskOperateEnum;
import com.cyberway.mp.flow.api.task.vo.StarterFillTaskCustomInfoVo;
import com.cyberway.mp.flow.domain.his.entity.FlowHisActivity;
import com.cyberway.mp.flow.domain.his.service.FlowHisService;
import com.cyberway.mp.flow.domain.instance.entity.FlowCc;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceAddNode;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExt;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExtArray;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceWithCategory;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceQuery;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceWithCategoryQuery;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.log.entity.FlowLog;
import com.cyberway.mp.flow.domain.log.entity.FlowUrgeLog;
import com.cyberway.mp.flow.domain.log.service.FlowLogService;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.domain.opinion.service.OpinionAssociationService;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.project.service.FlowProjectService;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.repository.query.FlowTaskQuery;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.infra.config.FlowBaseContextProperties;
import com.cyberway.mp.flow.infra.dto.FlowEdgeInfo;
import com.cyberway.mp.flow.infra.dto.FlowInstanceBatchActionParam;
import com.cyberway.mp.flow.infra.dto.FlowInstanceBatchVarActionParam;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import com.cyberway.mp.flow.infra.service.FlowDefinitionGenerateService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.FlowExpressionExecutor;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import com.cyberway.mp.flow.infra.util.FlowUtils;
import com.cyberway.mp.flow.infra.util.OpinionUtils;
import com.cyberway.mp.mc.api.push.dto.EventPushDto;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.spring.annotation.GlobalTransactional;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowInstanceApplicationService
implements FlowInstanceApi {
    private static final String NODE_POSITION = "position";
    private static final String NODE_TARGET = "target";
    private static final String NODE_ITEMS = "items";
    private static final String NODE_SOURCE = "source";
    private static final String NODE_PORTS = "ports";
    private static final String NODE_ATTRS = "attrs";
    private static final String NODE_SHAPE = "shape";
    private static final String NODE_CELL = "cell";
    private static final String NODE_PORT = "port";
    private static final String NODE_DATA = "data";
    private static final String NODE_STROKE = "stroke";
    private static final String NODE_EDGE = "edge";
    private static final String NODE_APPROVAL = "node-approval";
    private static final String NODE_EXCLUSIVE_GATEWAY = "exclusive-gateway";
    private static final String FUTURE_LINE_COLOR = "#0074FF";
    private static final String FIN_LINE_COLOR = "#86C166";
    private static final String EXPRESSION_FAIL_MSG = "Execute expression [{}] failed";
    public static final Set<FlowTaskDeleteReason> NOT_SHOW_ASSIGNEE_DELETE_REASONS = Set.of(FlowTaskDeleteReason.TASK_APPROVAL_WITHDRAW, FlowTaskDeleteReason.DELETE_BY_ADD_SIGN);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowInstanceService flowInstanceService;
    private final FlowProjectService flowProjectService;
    private final FlowEngineService flowEngineService;
    private final FlowNodeService flowNodeService;
    private final FlowTaskService flowTaskService;
    private final FlowLogService flowLogService;
    private final FlowHisService flowHisService;
    private final FlowDataHelperService flowDataHelperService;
    private final FrameworkEventService frameworkEventService;
    private final FlowBaseContextProperties flowBaseContextProperties;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final ObjectMapper objectMapper;
    private final UserHelperService userHelperService;
    private final FlowDefinitionGenerateService flowDefinitionGenerateService;
    private final OpinionAssociationService opinionAssociationService;

    public FlowInstanceApplicationService(FlowInstanceService flowInstanceService, FlowProjectService flowProjectService, FlowEngineService flowEngineService, FlowNodeService flowNodeService, FlowTaskService flowTaskService, FlowLogService flowLogService, FlowHisService flowHisService, FlowDataHelperService flowDataHelperService, FrameworkEventService frameworkEventService, FlowBaseContextProperties flowBaseContextProperties, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, ObjectMapper objectMapper, UserHelperService userHelperService, FlowDefinitionGenerateService flowDefinitionGenerateService, OpinionAssociationService opinionAssociationService) {
        this.flowInstanceService = flowInstanceService;
        this.flowProjectService = flowProjectService;
        this.flowEngineService = flowEngineService;
        this.flowNodeService = flowNodeService;
        this.flowTaskService = flowTaskService;
        this.flowLogService = flowLogService;
        this.flowHisService = flowHisService;
        this.flowDataHelperService = flowDataHelperService;
        this.frameworkEventService = frameworkEventService;
        this.flowBaseContextProperties = flowBaseContextProperties;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.objectMapper = objectMapper;
        this.userHelperService = userHelperService;
        this.flowDefinitionGenerateService = flowDefinitionGenerateService;
        this.opinionAssociationService = opinionAssociationService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    public Long createOrModifyFlowDraftInstance(FlowDraftInstanceDto dto) {
        FlowInstanceStartBaseDto baseDto = new FlowInstanceStartBaseDto();
        baseDto.setFlowProjectId(dto.getFlowProjectId());
        baseDto.setFlowProjectCodeName(dto.getFlowProjectCodeName());
        FlowProject flowProject = this.findFlowProject(baseDto);
        Long instanceId = this.flowInstanceService.createOrModifyFlowDraftInstance(flowProject, dto);
        this.flowTaskService.createFlowDraftTaskIfMissing(instanceId, flowProject);
        return instanceId;
    }

    public void removeFlowDraftInstance(FlowDraftInstanceBaseDto dto) {
        FlowInstanceStartBaseDto baseDto = new FlowInstanceStartBaseDto();
        baseDto.setFlowProjectId(dto.getFlowProjectId());
        baseDto.setFlowProjectCodeName(dto.getFlowProjectCodeName());
        FlowProject flowProject = this.findFlowProject(baseDto);
        this.removeFlowDraftInstance(flowProject, dto.getBusinessKey());
    }

    private void removeFlowDraftInstance(FlowProject flowProject, Long businessKey) {
        List<Long> instanceIds = this.flowInstanceService.removeFlowDraftInstance(flowProject, businessKey);
        this.flowTaskService.removeFlowDraftTask(instanceIds);
    }

    public Long startFlowInstance(FlowInstanceStartDto dto) {
        HashMap variables = dto.getAppendVariables();
        if (variables == null) {
            variables = new HashMap(16);
            dto.setAppendVariables(variables);
        }
        FlowProject flowProject = this.findFlowProject((FlowInstanceStartBaseDto)dto);
        return this.flowEngineService.startProcessInstance(flowProject, dto);
    }

    public FlowInstanceBatchStartResultVo batchStartFlowInstance(FlowInstanceBatchStartDto dto) {
        FlowProject flowProject = this.findFlowProject((FlowInstanceStartBaseDto)dto);
        return this.flowEngineService.batchStartProcessInstance(flowProject, dto.getItems(), dto.getNodeFormUrl(), dto.getAppendEventConfigs());
    }

    private FlowProject findFlowProject(FlowInstanceStartBaseDto dto) {
        FlowProject flowProject;
        if (dto.getFlowProjectId() != null) {
            flowProject = this.flowProjectService.getFlowProject(dto.getFlowProjectId());
            if (flowProject == null || !FlowProjectStatus.ENABLED.equals((Object)flowProject.getStatus())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.PROJECT_NOT_EXISTED_AND_ENABLED);
            }
        } else if (StringUtils.isNotBlank((CharSequence)dto.getFlowProjectCodeName())) {
            flowProject = dto.getVersionNo() == null ? this.flowProjectService.getLastEnabledVersionFlowProject(dto.getFlowProjectCodeName()) : this.flowProjectService.getEnabledFlowProject(dto.getFlowProjectCodeName(), dto.getVersionNo());
            if (flowProject == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.PROJECT_NOT_EXISTED_AND_ENABLED);
            }
        } else {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.NEED_PROJECT_ID_OR_CODE);
        }
        return flowProject;
    }

    public void suspendFlowInstance(FlowInstanceActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        switch (flowInstance.getStatus()) {
            case RUNNING: {
                this.flowEngineService.suspendProcessInstances(Collections.singletonList(new FlowInstanceBatchActionParam(flowInstance, dto)));
                break;
            }
            case SUSPENDED: {
                break;
            }
            default: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
            }
        }
    }

    public BatchActionResultVo batchSuspendFlowInstanceWithOpinion(List<FlowInstanceActionDto> dtoList) {
        BatchActionResultVo batchActionResultVo;
        Set<Long> idSet = dtoList.stream().map(FlowInstanceActionDto::getFlowInstanceId).collect(Collectors.toSet());
        Map<Long, FlowInstanceActionDto> flowInstanceActionDtoMap = dtoList.stream().collect(Collectors.toMap(FlowInstanceActionDto::getFlowInstanceId, dto -> dto));
        List<FlowInstance> flowInstances = this.flowInstanceService.batchGetFlowInstance(idSet);
        ArrayList<FlowInstanceBatchActionParam> params = new ArrayList<FlowInstanceBatchActionParam>();
        HashMap<Long, ErrorInfoVo> errorInfoVoMap = new HashMap<Long, ErrorInfoVo>();
        block4: for (FlowInstance flowInstance : flowInstances) {
            idSet.remove(flowInstance.getId());
            switch (flowInstance.getStatus()) {
                case RUNNING: {
                    params.add(new FlowInstanceBatchActionParam(flowInstance, flowInstanceActionDtoMap.get(flowInstance.getId())));
                    continue block4;
                }
                case SUSPENDED: {
                    continue block4;
                }
            }
            errorInfoVoMap.put((Long)flowInstance.getId(), new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR));
        }
        for (Long id : idSet) {
            errorInfoVoMap.put(id, new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED));
        }
        if (params.isEmpty()) {
            batchActionResultVo = new BatchActionResultVo();
            batchActionResultVo.setFailCount(Integer.valueOf(errorInfoVoMap.size()));
            batchActionResultVo.setErrorInfoMap(errorInfoVoMap);
            return batchActionResultVo;
        }
        batchActionResultVo = this.flowEngineService.suspendProcessInstances(params);
        batchActionResultVo.setFailCount(Integer.valueOf(batchActionResultVo.getFailCount() + errorInfoVoMap.size()));
        batchActionResultVo.getErrorInfoMap().putAll(errorInfoVoMap);
        return batchActionResultVo;
    }

    public void activeFlowInstance(FlowInstanceActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        switch (flowInstance.getStatus()) {
            case RUNNING: {
                break;
            }
            case SUSPENDED: {
                this.flowEngineService.activeProcessInstances(Collections.singletonList(new FlowInstanceBatchActionParam(flowInstance, dto)));
                break;
            }
            default: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
            }
        }
    }

    public BatchActionResultVo batchActiveFlowInstanceWithOpinion(List<FlowInstanceActionDto> dtoList) {
        BatchActionResultVo batchActionResultVo;
        Set<Long> idSet = dtoList.stream().map(FlowInstanceActionDto::getFlowInstanceId).collect(Collectors.toSet());
        Map<Long, FlowInstanceActionDto> flowInstanceActionDtoMap = dtoList.stream().collect(Collectors.toMap(FlowInstanceActionDto::getFlowInstanceId, dto -> dto));
        List<FlowInstance> flowInstances = this.flowInstanceService.batchGetFlowInstance(idSet);
        ArrayList<FlowInstanceBatchActionParam> params = new ArrayList<FlowInstanceBatchActionParam>();
        HashMap<Long, ErrorInfoVo> errorInfoVoMap = new HashMap<Long, ErrorInfoVo>();
        block4: for (FlowInstance flowInstance : flowInstances) {
            idSet.remove(flowInstance.getId());
            switch (flowInstance.getStatus()) {
                case RUNNING: {
                    continue block4;
                }
                case SUSPENDED: {
                    params.add(new FlowInstanceBatchActionParam(flowInstance, flowInstanceActionDtoMap.get(flowInstance.getId())));
                    continue block4;
                }
            }
            errorInfoVoMap.put((Long)flowInstance.getId(), new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR));
        }
        for (Long id : idSet) {
            errorInfoVoMap.put(id, new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED));
        }
        if (params.isEmpty()) {
            batchActionResultVo = new BatchActionResultVo();
            batchActionResultVo.setFailCount(Integer.valueOf(errorInfoVoMap.size()));
            batchActionResultVo.setErrorInfoMap(errorInfoVoMap);
            return batchActionResultVo;
        }
        batchActionResultVo = this.flowEngineService.activeProcessInstances(params);
        batchActionResultVo.setFailCount(Integer.valueOf(batchActionResultVo.getFailCount() + errorInfoVoMap.size()));
        batchActionResultVo.getErrorInfoMap().putAll(errorInfoVoMap);
        return batchActionResultVo;
    }

    private void opinionVerification(FlowInstanceActionDto dto, Function<OpinionCheckActionDto, Boolean> getConfigFunction) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInstance.getFlowProjectId());
        if (globalConfig == null || globalConfig.getUseOpinionCheck() == null || globalConfig.getOpinionValidationType() == null) {
            return;
        }
        Boolean isCheck = globalConfig.getUseOpinionCheck();
        if (!Boolean.TRUE.equals(isCheck) || OpinionValidationType.ALL_NOT_REQUIRED.equals((Object)globalConfig.getOpinionValidationType())) {
            return;
        }
        if (OpinionValidationType.ALL_REQUIRED.equals((Object)globalConfig.getOpinionValidationType()) && StringUtils.isBlank((CharSequence)dto.getOpinion())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_OPINION_CHECK);
        }
        if (OpinionValidationType.CONDITIONAL_REQUIRED.equals((Object)globalConfig.getOpinionValidationType())) {
            if (globalConfig.getOpinionCheckAction() == null || getConfigFunction == null) {
                return;
            }
            Boolean isAssigneeApproveRequired = getConfigFunction.apply(globalConfig.getOpinionCheckAction());
            if (StringUtils.isBlank((CharSequence)dto.getOpinion()) && Boolean.TRUE.equals(isAssigneeApproveRequired)) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_OPINION_CHECK);
            }
        }
    }

    public void withdrawFlowInstance(FlowInstanceActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        this.checkOperatePermitThrowException(flowInstance.getStartUserId());
        this.opinionVerification(dto, OpinionCheckActionDto::getStarterRollback);
        this.checkWithdrawPermitThrowException(flowInstance);
        this.flowEngineService.withdrawProcessInstance(flowInstance.getProcessInstanceId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminWithdrawFlowInstance(FlowInstanceAdminActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        this.flowEngineService.withdrawProcessInstance(flowInstance.getProcessInstanceId(), (FlowInstanceActionDto)dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void cancelFlowInstance(FlowInstanceActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeCancel);
        this.checkCancelPermitThrowException(flowInstance);
        this.flowEngineService.cancelProcessInstance(flowInstance.getProcessInstanceId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminCancelFlowInstance(FlowInstanceAdminActionDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        this.flowEngineService.cancelProcessInstance(flowInstance.getProcessInstanceId(), (FlowInstanceActionDto)dto);
    }

    private void checkCancelPermitThrowException(FlowInstance flowInstance) {
        Long currentUserId = ServiceContext.getContext().getRequestUserId();
        if (!this.flowBaseContextProperties.isSkipUserPermitCheck() && !Objects.equals(flowInstance.getStartUserId(), currentUserId)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPERATE_HAS_NOT_AUTHORIZED);
        }
        if (this.flowBaseContextProperties.isSkipActionPermitCheckFlow()) {
            return;
        }
        List<FlowTask> flowTasks = this.flowTaskService.listRunningTasksForInstances(Collections.singletonList((Long)flowInstance.getId()));
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInstance.getFlowProjectId());
        for (FlowTask flowTask : flowTasks) {
            ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask, flowInstance.getFlowProjectId());
            if (!(Boolean.TRUE.equals(approvalNodeConfig.getUseGlobalStarterConfig()) ? !Boolean.TRUE.equals(globalConfig.getStarterCancel()) : !Boolean.TRUE.equals(approvalNodeConfig.getStarterCancel()))) continue;
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_CANCEL_NOT_ALLOWED);
        }
    }

    public BatchActionResultVo batchCancelFlowInstance(List<@Valid FlowInstanceActionDto> dtoList) {
        if (dtoList.isEmpty()) {
            BatchActionResultVo vo = new BatchActionResultVo();
            vo.setFailCount(Integer.valueOf(0));
            vo.setErrorInfoMap(Collections.emptyMap());
            return vo;
        }
        for (FlowInstanceActionDto dto2 : dtoList) {
            this.opinionVerification(dto2, OpinionCheckActionDto::getStarterCancel);
            OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto2.getOpinion(), dto2.getSavaOpinion());
        }
        HashSet duplicateIds = new HashSet();
        HashMap errorInfoVoMap = new HashMap();
        Set<Long> flowInstanceIds = dtoList.stream().map(FlowInstanceActionDto::getFlowInstanceId).collect(Collectors.toSet());
        Map processIdMap = this.flowInstanceService.batchGetFlowInstance(flowInstanceIds).stream().collect(Collectors.toMap(Entity::getId, Function.identity()));
        Map paramMap = dtoList.stream().filter(dto -> {
            FlowInstance flowInstance = (FlowInstance)((Object)((Object)processIdMap.get(dto.getFlowInstanceId())));
            if (flowInstance == null) {
                errorInfoVoMap.put(dto.getFlowInstanceId(), new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED));
                return false;
            }
            if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus()) && !FlowInstanceStatus.SUSPENDED.equals((Object)flowInstance.getStatus())) {
                errorInfoVoMap.put(dto.getFlowInstanceId(), new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR));
                return false;
            }
            return true;
        }).map(dto -> new FlowInstanceBatchVarActionParam((FlowInstance)((Object)((Object)processIdMap.get(dto.getFlowInstanceId()))), dto.getOpinion(), dto.getVariables(), dto.getAttachmentInfo())).collect(Collectors.toMap(item -> (Long)item.getFlowInstance().getId(), Function.identity(), (a, b) -> {
            duplicateIds.add((Long)a.getFlowInstance().getId());
            return a;
        }));
        duplicateIds.forEach(id -> {
            paramMap.remove(id);
            errorInfoVoMap.put(id, new ErrorInfoVo(FlowErrorCode.FLOW_INSTANCE_ID_DUPLICATE));
        });
        if (paramMap.isEmpty()) {
            BatchActionResultVo vo = new BatchActionResultVo();
            vo.setFailCount(Integer.valueOf(errorInfoVoMap.size()));
            vo.setErrorInfoMap(errorInfoVoMap);
            return vo;
        }
        BatchActionResultVo batchActionResultVo = this.flowEngineService.batchCancelProcessInstance(paramMap.values());
        batchActionResultVo.setFailCount(Integer.valueOf(batchActionResultVo.getFailCount() + errorInfoVoMap.size()));
        batchActionResultVo.getErrorInfoMap().putAll(errorInfoVoMap);
        return batchActionResultVo;
    }

    public Page<FlowInstanceMyHandledPageVo> pageQueryFlowInstanceListVo(FlowInstancePageDto dto) {
        Date now = new Date();
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstancePageDto(dto);
        FlowInstanceMyHandledPageDto param = new FlowInstanceMyHandledPageDto();
        param.setCurrent(dto.getCurrent());
        param.setPageSize(dto.getPageSize());
        return this.queryMyInstance(query, param, (flowInstance, nodeMap, runningTaskMap, completedTaskMap) -> {
            FlowInstanceMyHandledPageVo vo = flowInstance.toFlowInstanceMyHandledPageVo(now);
            this.initFlowInstanceMyHandledPageVo(vo, flowInstance, nodeMap, runningTaskMap);
            return vo;
        });
    }

    public Page<FlowInstanceDueVo> pageQueryFlowInstanceDueVo(FlowInstanceDuePageDto dto) {
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstanceDuePageDto(dto);
        long now = System.currentTimeMillis();
        return this.pageQueryFlowInstance(query, (PageParam)dto, i -> i.toFlowInstanceDueVo(now));
    }

    private <R extends FlowInstanceBaseVo> Page<R> pageQueryFlowInstance(FlowInstanceWithCategoryQuery query, PageParam pageParam, Function<FlowInstanceWithCategory, R> toVoFunction) {
        long count = this.flowInstanceService.countFlowInstanceWithCategory(query);
        if (count < 1L) {
            return new Page(0, pageParam.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowInstanceWithCategory> instances = this.flowInstanceService.pageQueryFlowInstanceWithCategory(query, pageParam);
        List list = instances.stream().map(toVoFunction).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(pageParam.getCurrent(), pageParam.getPageSize(), count, list);
    }

    public Page<FlowInstanceDetailListVo> pageQueryFlowInstanceDetailListVo(FlowInstancePageDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        dto.setStartUserId(requestUserId);
        dto.setAppInstanceId(ServiceContext.getContext().getRequestAppInstanceId());
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstancePageDto(dto);
        long count = this.flowInstanceService.countFlowInstanceWithCategory(query);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowInstanceWithCategory> instances = this.flowInstanceService.pageQueryFlowInstanceWithCategory(query, (PageParam)dto);
        List<FlowInstanceDetailListVo> flowInstanceDetailListVos = instances.stream().map(FlowInstanceWithCategory::toFlowInstanceDetailListVo).collect(Collectors.toList());
        this.setExtInfo(flowInstanceDetailListVos);
        this.setOtherRelateInfo(flowInstanceDetailListVos);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, flowInstanceDetailListVos);
    }

    private void setOtherRelateInfo(List<FlowInstanceDetailListVo> flowInstanceDetailListVos) {
        if (flowInstanceDetailListVos.isEmpty()) {
            return;
        }
        Set<Long> flowInstanceIds = flowInstanceDetailListVos.stream().map(FlowInstanceBaseVo::getId).collect(Collectors.toSet());
        List<FlowTask> flowTasks = this.flowTaskService.batchGetFlowTaskByFlowInstanceIds(flowInstanceIds);
        if (CollectionUtils.isEmpty(flowTasks)) {
            return;
        }
        List runningFlowTasks = flowTasks.stream().filter(flowTask -> FlowTaskStatus.RUNNING.equals((Object)flowTask.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(runningFlowTasks)) {
            return;
        }
        if (CollectionUtils.isEmpty(flowTasks)) {
            return;
        }
        Map<Long, List<FlowTask>> runningFlowTaskGroup = runningFlowTasks.stream().collect(Collectors.groupingBy(FlowTask::getFlowInstanceId));
        this.setInstanceCurrentHandleUsers(flowInstanceDetailListVos, runningFlowTaskGroup);
        this.setCanWithdrawFlag(flowInstanceDetailListVos, runningFlowTaskGroup);
    }

    private void setCanWithdrawFlag(List<FlowInstanceDetailListVo> flowInstanceDetailListVos, Map<Long, List<FlowTask>> runningFlowTaskGroup) {
        flowInstanceDetailListVos.forEach(flowInstanceDetailListVo -> {
            if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstanceDetailListVo.getStatus())) {
                flowInstanceDetailListVo.setCanWithdrawFlag(Boolean.valueOf(false));
                return;
            }
            Set<String> runningNodeKeys = runningFlowTaskGroup.getOrDefault(flowInstanceDetailListVo.getId(), Collections.emptyList()).stream().map(FlowTask::getNodeKey).collect(Collectors.toSet());
            flowInstanceDetailListVo.setCanWithdrawFlag(Boolean.valueOf(this.checkCanWithdraw(flowInstanceDetailListVo.getId(), flowInstanceDetailListVo.getFlowProjectId(), runningNodeKeys)));
        });
    }

    private void setInstanceCurrentHandleUsers(List<FlowInstanceDetailListVo> flowInstanceDetailListVos, Map<Long, List<FlowTask>> runningFlowTaskGroup) {
        flowInstanceDetailListVos.forEach(flowInstanceDetailListVo -> {
            List task = (List)runningFlowTaskGroup.get(flowInstanceDetailListVo.getId());
            if (!CollectionUtils.isEmpty((Collection)task)) {
                ArrayList currentHandleUsers = new ArrayList();
                task.forEach(flowTask -> {
                    currentHandleUsers.add(new IdNameVo(flowTask.getAssigneeUserId(), flowTask.getAssigneeUserName()));
                    if (Boolean.TRUE.equals(flowTask.getAllowOwnerApprove()) && null != flowTask.getOwnerUserId()) {
                        currentHandleUsers.add(new IdNameVo(flowTask.getOwnerUserId(), flowTask.getOwnerUserName()));
                    }
                });
                flowInstanceDetailListVo.setCurrentHandleUsers(currentHandleUsers);
            }
        });
    }

    public List<FlowInstanceInfoVo> listFlowInstanceInfo(FlowInstanceInfoListDto dto) {
        List<FlowInstance> flowInstances = this.flowInstanceService.listFlowInstance(FlowInstanceQuery.fromFlowInstanceInfoListDto(dto));
        if (flowInstances.isEmpty()) {
            return Collections.emptyList();
        }
        List<FlowInstanceInfoVo> list = flowInstances.stream().map(FlowInstance::toFlowInstanceInfoVo).collect(Collectors.toList());
        this.setExtInfo(list);
        return list;
    }

    public FlowInstanceInfoVo getFlowInstanceInfo(long id) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(id);
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        this.flowDataHelperService.validateViewPermission(flowInstance);
        FlowInstanceInfoVo vo = flowInstance.toFlowInstanceInfoVo();
        this.setExtInfo(Collections.singletonList(vo));
        return vo;
    }

    public void triggerReceiveNode(FlowInstanceTriggerDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
        }
        this.flowEngineService.triggerReceiveTask(flowInstance.getProcessInstanceId(), dto.getNodeKey(), dto.getVariables());
    }

    private FlowInstance getRunningFlowInstance(long id) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(id);
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
        }
        return flowInstance;
    }

    public FlowInstanceJumpInfoVo getFlowInstanceJumpInfoVo(long id) {
        FlowInstance flowInstance = this.getRunningFlowInstance(id);
        this.flowDataHelperService.validateViewPermission(flowInstance);
        return this.getFlowInstanceJumpInfoVo(flowInstance);
    }

    public FlowInstanceJumpInfoVo adminGetFlowInstanceJumpInfoVo(long id) {
        FlowInstance flowInstance = this.getRunningFlowInstance(id);
        return this.getFlowInstanceJumpInfoVo(flowInstance);
    }

    public FlowInstanceJumpInfoVo getFlowInstanceJumpInfoVo(FlowInstance flowInstance) {
        FlowInstanceJumpInfoVo vo = this.getFlowInstanceCommonVo(flowInstance, false);
        HashSet<String> runningNodes = new HashSet<String>(vo.getRunningNodes());
        runningNodes.addAll(vo.getWaitStarterNodes());
        vo.setAllowJumpNodes(this.flowEngineService.getAllowJumpNodes((long)((Long)flowInstance.getId()), (long)flowInstance.getFlowProjectId(), runningNodes).stream().map(KeyNameVo::getKey).collect(Collectors.toSet()));
        return vo;
    }

    private FlowInstanceJumpInfoVo getFlowInstanceCommonVo(FlowInstance flowInstance, boolean calFuture) {
        FlowInstanceJumpInfoVo vo = new FlowInstanceJumpInfoVo();
        List<FlowNode> flowNodes = this.flowNodeService.listByFlowInstanceId((Long)flowInstance.getId());
        List<FlowInstanceAddNode> addNodes = this.flowInstanceService.listAddNodes((Long)flowInstance.getId());
        Map<Long, List<FlowTask>> taskMap = this.flowTaskService.listByFlowInstance((Long)flowInstance.getId()).stream().collect(Collectors.groupingBy(FlowTask::getFlowNodeId));
        HashSet<String> runningNodes = new HashSet<String>();
        HashSet<String> waitStarterNodes = new HashSet<String>();
        HashMap<String, JumpNodeInfoVo> nodeInfoVos = new HashMap<String, JumpNodeInfoVo>();
        for (FlowNode flowNode : flowNodes) {
            if (nodeInfoVos.containsKey(flowNode.getNodeKey()) || FlowTaskStatus.DELETED.equals((Object)flowNode.getStatus())) continue;
            JumpNodeInfoVo infoVo = new JumpNodeInfoVo();
            infoVo.setStatus(flowNode.getStatus());
            infoVo.setStartTime(flowNode.getStartTime());
            infoVo.setEndTime(CodeUtils.formatNullableMinTime(flowNode.getEndTime()));
            infoVo.setNodeName(flowNode.getNodeName());
            ArrayList<JumpNodeAssigneeInfo> assignees = new ArrayList<JumpNodeAssigneeInfo>();
            infoVo.setAssignees(assignees);
            if (taskMap.containsKey(flowNode.getId())) {
                for (FlowTask flowTask : taskMap.get(flowNode.getId())) {
                    if (NOT_SHOW_ASSIGNEE_DELETE_REASONS.contains(flowTask.getDeleteReason())) continue;
                    JumpNodeAssigneeInfo assigneeInfo = new JumpNodeAssigneeInfo();
                    assigneeInfo.setId(flowTask.getAssigneeUserId());
                    assigneeInfo.setName(flowTask.getAssigneeUserName());
                    assigneeInfo.setOpinion(flowTask.getOpinion());
                    assigneeInfo.setStatus(flowTask.getStatus());
                    assignees.add(assigneeInfo);
                }
            }
            nodeInfoVos.put(flowNode.getNodeKey(), infoVo);
            if (FlowTaskStatus.RUNNING.equals((Object)flowNode.getStatus())) {
                runningNodes.add(flowNode.getNodeKey());
                continue;
            }
            if (!FlowTaskStatus.WAIT_STARTER_FILL.equals((Object)flowNode.getStatus()) && !FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE.equals((Object)flowNode.getStatus())) continue;
            waitStarterNodes.add(flowNode.getNodeKey());
        }
        vo.setRunningNodes(runningNodes);
        vo.setWaitStarterNodes(waitStarterNodes);
        vo.setNodeInfoVos(nodeInfoVos);
        this.handleDesignContent(vo, flowInstance, addNodes, calFuture);
        return vo;
    }

    private void handleDesignContent(FlowInstanceJumpInfoVo vo, FlowInstance flowInstance, List<FlowInstanceAddNode> addNodes, boolean calFuture) {
        String designContent = this.flowInstanceService.getDesignContentForFlowInstance((Long)flowInstance.getId());
        if (StringUtils.isBlank((CharSequence)designContent)) {
            vo.setDesignContent(designContent);
            return;
        }
        JSONArray designJson = JSON.parseArray((String)designContent);
        if (!addNodes.isEmpty()) {
            this.handleDesignContentAddNode(addNodes, flowInstance, designJson);
        }
        List<String> hisNodeKeys = this.loadHisNodeKeys(flowInstance);
        FlowUtils.ModelDesignContentInfo designContentInfo = FlowUtils.extractModelDesignContent(designJson);
        if (designContentInfo.getStartNode() == null) {
            vo.setDesignContent(JSON.toJSONString((Object)designJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            return;
        }
        if (calFuture && vo.needCalFuture()) {
            this.handleFutureLineAndNode(vo, flowInstance, designContentInfo.edgeOutMap, designContentInfo.designNodeMap);
        }
        HashSet<String> handledNodes = new HashSet<String>();
        this.handleFinishLineAndNode(designContentInfo.getStartNode(), hisNodeKeys, vo, designContentInfo.edgeOutMap, designContentInfo.designNodeMap, handledNodes);
        HashSet<String> notHandleRunningNodes = new HashSet<String>(vo.getRunningNodes());
        notHandleRunningNodes.removeAll(handledNodes);
        this.markNodesStatus(notHandleRunningNodes, designContentInfo.designNodeMap, FlowConstant.DESIGN_NODE_RUN_STATUS_RUNNING);
        HashSet<String> notHandleWaitStarterNodes = new HashSet<String>(vo.getWaitStarterNodes());
        notHandleWaitStarterNodes.removeAll(handledNodes);
        this.markNodesStatus(notHandleWaitStarterNodes, designContentInfo.designNodeMap, FlowConstant.DESIGN_NODE_RUN_STATUS_WAIT_STARTER);
        vo.setDesignContent(JSON.toJSONString((Object)designJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private void markNodesStatus(Set<String> notHandleNodes, Map<String, JSONObject> designNodeMap, int runStatus) {
        for (String nodeId : notHandleNodes) {
            JSONObject node = designNodeMap.get(nodeId);
            if (node == null) continue;
            this.markNodeRunStatus(node, runStatus);
        }
    }

    private List<String> loadHisNodeKeys(FlowInstance flowInstance) {
        List<String> hisNodeKeys = Collections.emptyList();
        if (flowInstance.alreadyFinish()) {
            hisNodeKeys = this.flowHisService.listActivityByFlowInstanceId((Long)flowInstance.getId()).stream().map(FlowHisActivity::getNodeKey).collect(Collectors.toList());
        }
        if (hisNodeKeys.isEmpty()) {
            hisNodeKeys = this.flowEngineService.listHisNodeKeyOrdered(flowInstance.getProcessInstanceId());
        }
        return hisNodeKeys;
    }

    private void handleDesignContentAddNode(List<FlowInstanceAddNode> addNodes, FlowInstance flowInstance, JSONArray designJson) {
        AtomicInteger idCounter = new AtomicInteger();
        HashMap<String, Map<String, String>> edgeIdMap = new HashMap<String, Map<String, String>>();
        for (FlowEdgeInfo info : this.flowEngineService.listFlowEdgeInfo(flowInstance.getProcessInstanceId())) {
            edgeIdMap.computeIfAbsent(info.getSourceId(), k -> new HashMap(16)).put(info.getTargetId(), info.getId());
        }
        HashMap<String, List<JSONObject>> edgeOutMap = new HashMap<String, List<JSONObject>>(16);
        HashMap<String, List<JSONObject>> edgeInMap = new HashMap<String, List<JSONObject>>(16);
        Map<String, List<FlowInstanceAddNode>> addNodeMap = addNodes.stream().collect(Collectors.groupingBy(FlowInstanceAddNode::getActionNodeKey));
        List<JSONObject> nodes = FlowInstanceApplicationService.sortModelNodesByX(designJson, edgeOutMap, edgeInMap);
        AtomicInteger moveX = new AtomicInteger();
        for (JSONObject node : nodes) {
            this.handleModelNode(edgeIdMap, idCounter, designJson, edgeOutMap, edgeInMap, addNodeMap, moveX, node);
        }
    }

    private void handleFutureLineAndNode(FlowInstanceJumpInfoVo vo, FlowInstance flowInstance, Map<String, List<JSONObject>> edgeOutMap, Map<String, JSONObject> designNodeMap) {
        HashSet<String> handledNodes = new HashSet<String>();
        FlowExpressionExecutor expressionExecutor = this.flowEngineService.getFlowExpressionExecutor(flowInstance.getProcessInstanceId());
        ArrayList<JumpNodeAssigneeInfo> needGetNameAssignees = new ArrayList<JumpNodeAssigneeInfo>();
        HashSet calFutureNodes = new HashSet(vo.getRunningNodes());
        calFutureNodes.addAll(vo.getWaitStarterNodes());
        for (String runningNodeId : calFutureNodes) {
            if (!designNodeMap.containsKey(runningNodeId)) continue;
            JSONObject runningNode = designNodeMap.get(runningNodeId);
            FutureCalParams futureCalParams = new FutureCalParams();
            futureCalParams.flowInstance = flowInstance;
            futureCalParams.vo = vo;
            futureCalParams.expressionExecutor = expressionExecutor;
            futureCalParams.edgeOutMap = edgeOutMap;
            futureCalParams.designNodeMap = designNodeMap;
            futureCalParams.handledNodes = handledNodes;
            futureCalParams.needGetNameAssignees = needGetNameAssignees;
            this.handleFutureNode(runningNode, futureCalParams);
        }
        if (!needGetNameAssignees.isEmpty()) {
            Set<Long> userIdSet = needGetNameAssignees.stream().map(IdNameVo::getId).collect(Collectors.toSet());
            Map<Long, String> userNameMap = this.userHelperService.getUserNameMap(userIdSet);
            for (JumpNodeAssigneeInfo needGetNameAssignee : needGetNameAssignees) {
                needGetNameAssignee.setName(userNameMap.getOrDefault(needGetNameAssignee.getId(), ""));
            }
        }
    }

    private void handleFutureNode(JSONObject node, FutureCalParams futureCalParams) {
        String nodeId = node.getString("id");
        if (futureCalParams.handledNodes.contains(nodeId)) {
            return;
        }
        futureCalParams.handledNodes.add(nodeId);
        if (NODE_APPROVAL.equals(node.getString(NODE_SHAPE)) && !futureCalParams.vo.getNodeInfoVos().containsKey(nodeId)) {
            JumpNodeInfoVo nodeInfoVo = new JumpNodeInfoVo();
            nodeInfoVo.setStatus(FlowTaskStatus.FUTURE);
            nodeInfoVo.setNodeName(this.getApprovalNodeName(node));
            ArrayList<JumpNodeAssigneeInfo> assignees = new ArrayList<JumpNodeAssigneeInfo>();
            nodeInfoVo.setAssignees(assignees);
            this.calFutureAssignee(futureCalParams, nodeId, assignees);
            futureCalParams.vo.getNodeInfoVos().put(nodeId, nodeInfoVo);
        }
        if (!futureCalParams.edgeOutMap.containsKey(nodeId)) {
            return;
        }
        List<JSONObject> outEdges = futureCalParams.edgeOutMap.get(nodeId);
        for (JSONObject outEdge : outEdges) {
            this.changeEdgeColor(outEdge, FUTURE_LINE_COLOR);
            String targetId = outEdge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
            this.handleFutureTargetNode(futureCalParams, targetId);
        }
    }

    private void calFutureAssignee(FutureCalParams futureCalParams, String nodeId, ArrayList<JumpNodeAssigneeInfo> assignees) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(futureCalParams.flowInstance.getFlowProjectId(), (Long)futureCalParams.flowInstance.getId(), nodeId);
        if (approvalNodeConfig == null || approvalNodeConfig.getAssigneeType() == null) {
            return;
        }
        if (AssigneeType.USER.equals((Object)approvalNodeConfig.getAssigneeType()) && !Boolean.TRUE.equals(approvalNodeConfig.getUseConditionMatrix())) {
            if (approvalNodeConfig.getAssignees() == null) {
                return;
            }
            assignees.addAll(approvalNodeConfig.getAssignees().stream().map(a -> {
                JumpNodeAssigneeInfo info = new JumpNodeAssigneeInfo();
                info.setId(a.getId());
                info.setName(StringUtils.defaultString((String)a.getName()));
                info.setOpinion("");
                info.setStatus(FlowTaskStatus.FUTURE);
                info.setAssigneeType(AssigneeType.USER);
                return info;
            }).collect(Collectors.toList()));
            return;
        }
        if (Boolean.TRUE.equals(futureCalParams.calFutureActualExecutor) || Boolean.TRUE.equals(approvalNodeConfig.getUseConditionMatrix()) || AssigneeType.FORMULA.equals((Object)approvalNodeConfig.getAssigneeType()) || AssigneeType.CONDITION_MATRIX.equals((Object)approvalNodeConfig.getAssigneeType())) {
            this.calFutureAssigneeFormula(futureCalParams, assignees, approvalNodeConfig, nodeId);
        } else {
            String namePrefix = this.formatAssigneeTypeName(approvalNodeConfig.getAssigneeType());
            assignees.addAll(approvalNodeConfig.getAssignees().stream().map(a -> {
                JumpNodeAssigneeInfo info = new JumpNodeAssigneeInfo();
                info.setId(a.getId());
                info.setName(namePrefix + StringUtils.defaultString((String)a.getName()));
                info.setOpinion("");
                info.setStatus(FlowTaskStatus.FUTURE);
                info.setAssigneeType(approvalNodeConfig.getAssigneeType());
                return info;
            }).collect(Collectors.toList()));
        }
    }

    private void calFutureAssigneeFormula(FutureCalParams futureCalParams, ArrayList<JumpNodeAssigneeInfo> assignees, ApprovalNodeConfigDto approvalNodeConfig, String nodeId) {
        String formula = this.flowDefinitionGenerateService.buildAssigneeCollectionExpression(approvalNodeConfig, nodeId);
        this.calFutureAssignee(futureCalParams, assignees, formula);
    }

    private void calFutureAssignee(FutureCalParams futureCalParams, ArrayList<JumpNodeAssigneeInfo> assignees, String formula) {
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            Object expressionResult = null;
            try {
                expressionResult = futureCalParams.expressionExecutor.execute(formula);
            }
            catch (Exception e) {
                this.logger.info(EXPRESSION_FAIL_MSG, (Object)formula);
            }
            if (expressionResult instanceof Collection) {
                ((Collection)expressionResult).forEach(id -> {
                    JumpNodeAssigneeInfo nodeAssigneeInfo = this.buildJumpNodeAssigneeInfo(id);
                    nodeAssigneeInfo.setAssigneeType(AssigneeType.USER);
                    assignees.add(nodeAssigneeInfo);
                    futureCalParams.needGetNameAssignees.add(nodeAssigneeInfo);
                });
            } else if (expressionResult != null) {
                JumpNodeAssigneeInfo nodeAssigneeInfo = this.buildJumpNodeAssigneeInfo(expressionResult);
                nodeAssigneeInfo.setAssigneeType(AssigneeType.USER);
                assignees.add(nodeAssigneeInfo);
                futureCalParams.needGetNameAssignees.add(nodeAssigneeInfo);
            }
        }
    }

    private void handleFutureTargetNode(FutureCalParams futureCalParams, String targetId) {
        if (futureCalParams.vo.getRunningNodes().contains(targetId) || futureCalParams.vo.getWaitStarterNodes().contains(targetId)) {
            return;
        }
        JSONObject target = futureCalParams.designNodeMap.get(targetId);
        if (target != null && NODE_EXCLUSIVE_GATEWAY.equals(target.getString(NODE_SHAPE))) {
            this.markNodeRunStatus(target, FlowConstant.DESIGN_NODE_RUN_STATUS_RUN_FUTURE);
            this.handleFutureGateway(target, futureCalParams);
        } else if (target != null) {
            this.markNodeRunStatus(target, FlowConstant.DESIGN_NODE_RUN_STATUS_RUN_FUTURE);
            this.handleFutureNode(target, futureCalParams);
        }
    }

    private String formatAssigneeTypeName(AssigneeType assigneeType) {
        switch (assigneeType) {
            case DUTY: {
                return "\u5c97\u4f4d: ";
            }
            case ROLE: {
                return "\u89d2\u8272: ";
            }
            case ORG_UNIT: {
                return "\u7ec4\u7ec7\u5355\u5143: ";
            }
        }
        return "";
    }

    private JumpNodeAssigneeInfo buildJumpNodeAssigneeInfo(Object id) {
        JumpNodeAssigneeInfo info = new JumpNodeAssigneeInfo();
        info.setId(Long.valueOf(Long.parseLong(id.toString())));
        info.setOpinion("");
        info.setStatus(FlowTaskStatus.FUTURE);
        return info;
    }

    private String getApprovalNodeName(JSONObject node) {
        if (!node.containsKey((Object)NODE_DATA)) {
            return "";
        }
        return StringUtils.defaultString((String)node.getJSONObject(NODE_DATA).getString("description"));
    }

    private void handleFutureGateway(JSONObject node, FutureCalParams futureCalParams) {
        String nodeId = node.getString("id");
        if (futureCalParams.handledNodes.contains(nodeId)) {
            return;
        }
        GatewayNodeConfigDto gatewayNodeConfig = this.flowProjectConfigCacheRepository.getGatewayNodeConfig(futureCalParams.flowInstance.getFlowProjectId(), nodeId);
        if (gatewayNodeConfig == null || gatewayNodeConfig.getLineConfigs() == null) {
            this.handleFutureNode(node, futureCalParams);
            return;
        }
        futureCalParams.handledNodes.add(nodeId);
        if (!futureCalParams.edgeOutMap.containsKey(nodeId)) {
            return;
        }
        Map lineConfigMap = gatewayNodeConfig.getLineConfigs().stream().collect(Collectors.toMap(GatewayLineConfigDto::getTargetNodeKey, Function.identity(), (a, b) -> a));
        List<JSONObject> outEdges = futureCalParams.edgeOutMap.get(nodeId);
        for (JSONObject outEdge : outEdges) {
            String targetId = outEdge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
            GatewayLineConfigDto gatewayLineConfigDto = (GatewayLineConfigDto)lineConfigMap.get(targetId);
            if (!this.calFutureGatewayLine(gatewayLineConfigDto, futureCalParams)) continue;
            this.changeEdgeColor(outEdge, FUTURE_LINE_COLOR);
            this.handleFutureTargetNode(futureCalParams, targetId);
        }
    }

    private boolean calFutureGatewayLine(GatewayLineConfigDto gatewayLineConfigDto, FutureCalParams futureCalParams) {
        if (gatewayLineConfigDto != null && StringUtils.isNotBlank((CharSequence)gatewayLineConfigDto.getFormula())) {
            Object expressionResult = true;
            try {
                expressionResult = futureCalParams.expressionExecutor.execute(gatewayLineConfigDto.getFormula());
            }
            catch (Exception e) {
                this.logger.info(EXPRESSION_FAIL_MSG, (Object)gatewayLineConfigDto.getFormula());
            }
            return Boolean.TRUE.equals(expressionResult);
        }
        return false;
    }

    private void handleFinishLineAndNode(JSONObject node, List<String> hisNodeKeys, FlowInstanceJumpInfoVo vo, Map<String, List<JSONObject>> edgeOutMap, Map<String, JSONObject> designNodeMap, Set<String> handledNodes) {
        String nodeId = node.getString("id");
        if (handledNodes.contains(nodeId)) {
            return;
        }
        handledNodes.add(nodeId);
        if (vo.getRunningNodes().contains(nodeId)) {
            this.markNodeRunStatus(node, FlowConstant.DESIGN_NODE_RUN_STATUS_RUNNING);
        } else if (vo.getWaitStarterNodes().contains(nodeId)) {
            this.markNodeRunStatus(node, FlowConstant.DESIGN_NODE_RUN_STATUS_WAIT_STARTER);
        } else {
            this.markNodeRunStatus(node, FlowConstant.DESIGN_NODE_RUN_STATUS_RUN_FIN);
            if (!edgeOutMap.containsKey(nodeId)) {
                return;
            }
            List<JSONObject> outEdges = edgeOutMap.get(nodeId);
            for (JSONObject outEdge : outEdges) {
                String edgeId = outEdge.getString("id");
                if (!hisNodeKeys.contains(edgeId)) continue;
                this.changeEdgeColor(outEdge, FIN_LINE_COLOR);
                String targetId = outEdge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
                this.handleFinishLineAndNode(designNodeMap.get(targetId), hisNodeKeys, vo, edgeOutMap, designNodeMap, handledNodes);
            }
        }
    }

    private void changeEdgeColor(JSONObject edge, String color) {
        edge.getJSONObject(NODE_ATTRS).getJSONObject("line").put(NODE_STROKE, (Object)color);
    }

    private void markNodeRunStatus(JSONObject node, int runStatus) {
        JSONObject data;
        if (node.containsKey((Object)NODE_DATA)) {
            data = node.getJSONObject(NODE_DATA);
        } else {
            data = new JSONObject();
            node.put(NODE_DATA, (Object)data);
        }
        data.put("runStatus", (Object)runStatus);
    }

    private void handleModelNode(Map<String, Map<String, String>> edgeIdMap, AtomicInteger idCounter, JSONArray designJson, Map<String, List<JSONObject>> edgeOutMap, Map<String, List<JSONObject>> edgeInMap, Map<String, List<FlowInstanceAddNode>> addNodeMap, AtomicInteger moveX, JSONObject node) {
        String nodeKey = node.getString("id");
        if (addNodeMap.containsKey(nodeKey)) {
            List<FlowInstanceAddNode> addNodeList = addNodeMap.get(nodeKey);
            this.handleAddNodeList(edgeIdMap, idCounter, designJson, edgeOutMap, edgeInMap, moveX, node, addNodeList);
        } else if (moveX.get() > 0) {
            JSONObject position = node.getJSONObject(NODE_POSITION);
            position.put("x", (Object)(position.getInteger("x") + moveX.get()));
        }
    }

    private void handleAddNodeList(Map<String, Map<String, String>> edgeIdMap, AtomicInteger idCounter, JSONArray designJson, Map<String, List<JSONObject>> edgeOutMap, Map<String, List<JSONObject>> edgeInMap, AtomicInteger moveX, JSONObject node, List<FlowInstanceAddNode> addNodeList) {
        String nodeKey = node.getString("id");
        JSONObject position = node.getJSONObject(NODE_POSITION);
        Integer x = position.getInteger("x");
        Map<Integer, List> map = addNodeList.stream().collect(Collectors.groupingBy(FlowInstanceAddNode::getAddType, Collectors.collectingAndThen(Collectors.toList(), r -> {
            r.sort(Comparator.comparing(BusinessEntity::getCreatedTime));
            return r;
        })));
        if (map.containsKey(FlowConstant.ADD_NODE_TYPE_PREV)) {
            List addPrevNodes = map.get(FlowConstant.ADD_NODE_TYPE_PREV);
            for (FlowInstanceAddNode addNode : addPrevNodes) {
                JSONObject newNode = this.buildAddNodeModel(addNode, x + moveX.get(), position.getInteger("y"), idCounter);
                designJson.add((Object)newNode);
                List<JSONObject> edges = edgeInMap.remove(nodeKey);
                this.replaceLineNode(newNode, edges, NODE_TARGET, 0);
                JSONObject newEdge = this.buildNewEdge(newNode, node, edgeIdMap, idCounter);
                designJson.add((Object)newEdge);
                edgeInMap.put(nodeKey, Collections.singletonList(newEdge));
                moveX.addAndGet(300);
            }
        }
        if (moveX.get() > 0) {
            position.put("x", (Object)(x + moveX.get()));
        }
        if (map.containsKey(FlowConstant.ADD_NODE_TYPE_NEXT)) {
            List addNextNodes = map.get(FlowConstant.ADD_NODE_TYPE_NEXT);
            List<JSONObject> edges = edgeOutMap.remove(nodeKey);
            JSONObject newEdgeSourceNode = node;
            for (int i = addNextNodes.size() - 1; i >= 0; --i) {
                FlowInstanceAddNode addNode = (FlowInstanceAddNode)((Object)addNextNodes.get(i));
                moveX.addAndGet(300);
                JSONObject newNode = this.buildAddNodeModel(addNode, x + moveX.get(), position.getInteger("y"), idCounter);
                designJson.add((Object)newNode);
                this.replaceLineNode(newNode, edges, NODE_SOURCE, 1);
                JSONObject newEdge = this.buildNewEdge(newEdgeSourceNode, newNode, edgeIdMap, idCounter);
                designJson.add((Object)newEdge);
                newEdgeSourceNode = newNode;
            }
        }
    }

    private void replaceLineNode(JSONObject newNode, List<JSONObject> edges, String nodeType, int positionIndex) {
        JSONObject lineNode = new JSONObject();
        lineNode.put(NODE_CELL, (Object)newNode.getString("id"));
        lineNode.put(NODE_PORT, (Object)newNode.getJSONObject(NODE_PORTS).getJSONArray(NODE_ITEMS).getJSONObject(positionIndex).getString("id"));
        for (JSONObject edge : edges) {
            edge.put(nodeType, (Object)lineNode);
        }
    }

    private static List<JSONObject> sortModelNodesByX(JSONArray designJson, Map<String, List<JSONObject>> edgeOutMap, Map<String, List<JSONObject>> edgeInMap) {
        ArrayList<JSONObject> nodes = new ArrayList<JSONObject>();
        for (int i = 0; i < designJson.size(); ++i) {
            JSONObject jsonObject = designJson.getJSONObject(i);
            String shape = jsonObject.getString(NODE_SHAPE);
            if (NODE_EDGE.equals(shape)) {
                edgeInMap.computeIfAbsent(jsonObject.getJSONObject(NODE_TARGET).getString(NODE_CELL), key -> new ArrayList()).add(jsonObject);
                edgeOutMap.computeIfAbsent(jsonObject.getJSONObject(NODE_SOURCE).getString(NODE_CELL), key -> new ArrayList()).add(jsonObject);
                continue;
            }
            int x = jsonObject.getJSONObject(NODE_POSITION).getInteger("x");
            AtomicInteger insertIndex = new AtomicInteger(nodes.size());
            for (int j = nodes.size() - 1; j >= 0 && ((JSONObject)nodes.get(j)).getJSONObject(NODE_POSITION).getInteger("x") > x; --j) {
                insertIndex.decrementAndGet();
            }
            nodes.add(insertIndex.get(), jsonObject);
        }
        return nodes;
    }

    private JSONObject buildNewEdge(JSONObject fromNode, JSONObject toNode, Map<String, Map<String, String>> edgeIdMap, AtomicInteger idCounter) {
        JSONObject newEdge = new JSONObject();
        newEdge.put(NODE_SHAPE, (Object)NODE_EDGE);
        JSONObject attrs = new JSONObject();
        JSONObject line = new JSONObject();
        line.put(NODE_STROKE, (Object)"#CACCD8");
        JSONObject targetMarker = new JSONObject();
        targetMarker.put("name", (Object)"block");
        targetMarker.put("width", (Object)7);
        targetMarker.put("height", (Object)8);
        line.put("targetMarker", (Object)targetMarker);
        attrs.put("line", (Object)line);
        newEdge.put(NODE_ATTRS, (Object)attrs);
        JSONArray labels = new JSONArray();
        JSONObject label = new JSONObject();
        JSONObject labelAttrs = new JSONObject();
        JSONObject attrLabel = new JSONObject();
        attrLabel.put("text", (Object)"");
        labelAttrs.put("label", (Object)attrLabel);
        label.put(NODE_ATTRS, (Object)labelAttrs);
        labels.add((Object)label);
        newEdge.put("labels", (Object)labels);
        newEdge.put("zIndex", (Object)0);
        newEdge.put(NODE_SOURCE, (Object)this.buildLineNodeModel(fromNode, "right"));
        newEdge.put(NODE_TARGET, (Object)this.buildLineNodeModel(toNode, "left"));
        String fromNodeId = fromNode.getString("id");
        String toNodeId = toNode.getString("id");
        if (edgeIdMap.containsKey(fromNodeId) && edgeIdMap.get(fromNodeId).containsKey(toNodeId)) {
            newEdge.put("id", (Object)edgeIdMap.get(fromNodeId).get(toNodeId));
        } else {
            newEdge.put("id", (Object)("ID--" + idCounter.incrementAndGet()));
        }
        return newEdge;
    }

    private JSONObject buildLineNodeModel(JSONObject node, String position) {
        JSONObject lineNode = new JSONObject();
        lineNode.put(NODE_CELL, (Object)node.getString("id"));
        JSONArray items = node.getJSONObject(NODE_PORTS).getJSONArray(NODE_ITEMS);
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            if (!position.equals(item.getString("group"))) continue;
            lineNode.put(NODE_PORT, (Object)item.getString("id"));
            break;
        }
        return lineNode;
    }

    private JSONObject buildAddNodeModel(FlowInstanceAddNode addNode, int x, int y, AtomicInteger idCounter) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)addNode.getNodeKey());
        jsonObject.put("view", (Object)"vue-shape-view");
        jsonObject.put(NODE_SHAPE, (Object)NODE_APPROVAL);
        jsonObject.put("zIndex", (Object)1);
        jsonObject.put(NODE_PORTS, (Object)this.buildModelPorts(idCounter));
        JSONObject position = new JSONObject();
        position.put("x", (Object)x);
        position.put("y", (Object)y);
        jsonObject.put(NODE_POSITION, (Object)position);
        JSONObject size = new JSONObject();
        size.put("width", (Object)200);
        size.put("height", (Object)82);
        jsonObject.put("size", (Object)size);
        JSONObject data = new JSONObject();
        data.put("title", (Object)addNode.getNodeName());
        data.put("description", (Object)addNode.getNodeName());
        data.put("isSelected", (Object)false);
        data.put("editMode", (Object)false);
        jsonObject.put(NODE_DATA, (Object)data);
        return jsonObject;
    }

    private JSONObject buildModelPorts(AtomicInteger idCounter) {
        JSONObject ports = new JSONObject();
        JSONObject groups = new JSONObject();
        JSONArray items = new JSONArray();
        this.addModelGroupAndItems(groups, items, "left", idCounter);
        this.addModelGroupAndItems(groups, items, "right", idCounter);
        this.addModelGroupAndItems(groups, items, "top", idCounter);
        this.addModelGroupAndItems(groups, items, "bottom", idCounter);
        ports.put("groups", (Object)groups);
        ports.put(NODE_ITEMS, (Object)items);
        return ports;
    }

    private void addModelGroupAndItems(JSONObject groups, JSONArray items, String position, AtomicInteger idCounter) {
        JSONObject group = new JSONObject();
        group.put(NODE_POSITION, (Object)position);
        JSONObject attrs = new JSONObject();
        JSONObject circle = new JSONObject();
        circle.put("r", (Object)4);
        circle.put("magnet", (Object)true);
        circle.put(NODE_STROKE, (Object)"#C2C8D5");
        circle.put("strokeWidth", (Object)1);
        circle.put("fill", (Object)"#fff");
        attrs.put("circle", (Object)circle);
        group.put(NODE_ATTRS, (Object)attrs);
        groups.put(position, (Object)group);
        JSONObject item = new JSONObject();
        item.put("group", (Object)position);
        item.put("id", (Object)("ID--" + idCounter.incrementAndGet()));
        items.add((Object)item);
    }

    public List<KeyNameVo> getAllowJumpNodes(long id) {
        FlowInstance flowInstance = this.getRunningFlowInstance(id);
        return this.flowEngineService.getAllowJumpNodes((long)((Long)flowInstance.getId()), (long)flowInstance.getFlowProjectId(), this.flowNodeService.listRunningNodes(id));
    }

    public void jumpFlow(FlowInstanceJumpDto dto) {
        FlowInstance flowInstance = this.getRunningFlowInstance(dto.getFlowInstanceId());
        this.opinionVerification((FlowInstanceActionDto)dto, OpinionCheckActionDto::getAssigneeJump);
        this.flowEngineService.jumpFlow(flowInstance.getProcessInstanceId(), dto.getTargetNodeKey(), dto.getOpinion(), dto.getVariables(), dto.getAttachmentInfo());
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public FlowInstanceJumpInfoVo getFlowInstanceDiagram(long id) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(id);
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        this.flowDataHelperService.validateViewPermission(flowInstance);
        return this.getFlowInstanceCommonVo(flowInstance, true);
    }

    public FlowInstanceJumpInfoVo adminGetFlowInstanceDiagram(long id) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(id);
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        return this.getFlowInstanceCommonVo(flowInstance, true);
    }

    private void checkOperatePermitThrowException(Long checkUserId) {
        if (this.flowBaseContextProperties.isSkipUserPermitCheck()) {
            return;
        }
        Long currentUserId = ServiceContext.getContext().getRequestUserId();
        if (!checkUserId.equals(currentUserId)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPERATE_HAS_NOT_AUTHORIZED);
        }
    }

    public FlowInstanceApproveDetailVo getFlowInstanceApproveDetail(long id) {
        FlowInstanceApproveDetailDto dto = new FlowInstanceApproveDetailDto();
        dto.setId(id);
        return this.getFlowInstanceApproveDetailWithVar(dto);
    }

    public FlowInstanceApproveDetailVo getFlowInstanceApproveDetailWithVar(FlowInstanceApproveDetailDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getId());
        this.flowDataHelperService.validateViewPermission(flowInstance);
        FlowTaskQuery query = new FlowTaskQuery();
        query.setFlowInstanceId((Long)flowInstance.getId());
        query.setNotStatus(List.of(FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED, FlowTaskStatus.WAIT_STARTER_FILL, FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE, FlowTaskStatus.DELETED));
        query.setOrderFragment(List.of(new OrderFragment("t.end_time", "ASC")));
        List<FlowTaskWithBusinessKey> flowTasks = this.flowTaskService.listFlowTaskWithBusinessKey(query);
        FlowInstanceApproveDetailVo approveDetail = new FlowInstanceApproveDetailVo();
        FlowInstanceApproveVo instanceApprove = new FlowInstanceApproveVo();
        instanceApprove.setId(Long.valueOf(dto.getId()));
        instanceApprove.setInstanceName(flowInstance.getInstanceName());
        instanceApprove.setStartUserId(flowInstance.getStartUserId());
        instanceApprove.setStartUserName(flowInstance.getStartUserName());
        instanceApprove.setStartTime(flowInstance.getStartTime());
        instanceApprove.setInstanceCode(flowInstance.getInstanceCode());
        if (dto.isLoadAllVariables()) {
            instanceApprove.setVariables(this.getFlowInstanceVariables(flowInstance));
        } else if (dto.getLoadVariables() != null && !dto.getLoadVariables().isEmpty()) {
            instanceApprove.setVariables(this.getFlowInstanceVariables(flowInstance, dto.getLoadVariables()));
        } else {
            instanceApprove.setVariables(Collections.emptyMap());
        }
        FlowInstanceExt ext = this.flowInstanceService.getExtFieldsByFlowInstanceId(dto.getId());
        List<FlowInstanceExtArray> extArray = this.flowInstanceService.getExtArrayFieldsByFlowInstanceId(dto.getId());
        if (ext != null) {
            instanceApprove.setExtFields(ext.toFlowInstanceExtDto(extArray));
        }
        approveDetail.setInstanceApprove(instanceApprove);
        ArrayList<FlowInstanceApproveTaskVo> approveItems = new ArrayList<FlowInstanceApproveTaskVo>();
        if (!CollectionUtils.isEmpty(flowTasks)) {
            int i;
            List flowLogs = this.flowLogService.listFlowLog((Long)flowInstance.getId()).stream().map(FlowLog::toFlowLogVo).collect(Collectors.toList());
            Map<Long, List<FlowLogVo>> logMap = flowLogs.stream().collect(Collectors.groupingBy(FlowLogVo::getFlowTaskId));
            FlowProject flowProject = this.flowProjectService.getFlowProject(flowInstance.getFlowProjectId());
            NodesConfigDto nodesConfig = (NodesConfigDto)JSON.parseObject((String)flowProject.getNodeConfigs(), NodesConfigDto.class);
            boolean skipFirstTask = Boolean.TRUE.equals(nodesConfig.getGlobal().getSkipFirstTask());
            int n = i = skipFirstTask ? 1 : 0;
            while (i < flowTasks.size()) {
                this.addApproveTaskVo(approveItems, flowTasks.get(i), logMap);
                ++i;
            }
        }
        approveDetail.setTasks(approveItems);
        return approveDetail;
    }

    private void addApproveTaskVo(List<FlowInstanceApproveTaskVo> approveItems, FlowTask flowTask, Map<Long, List<FlowLogVo>> logMap) {
        FlowInstanceApproveTaskVo approveItem = new FlowInstanceApproveTaskVo();
        approveItem.setId((Long)flowTask.getId());
        approveItem.setTaskName(flowTask.getTaskName());
        if (null != flowTask.getActionUserId() && flowTask.getActionUserId() != 0L) {
            approveItem.setOperateUserId(flowTask.getActionUserId());
            approveItem.setOperateUserName(flowTask.getActionUserName());
        } else {
            approveItem.setOperateUserId(flowTask.getAssigneeUserId());
            approveItem.setOperateUserName(flowTask.getAssigneeUserName());
        }
        approveItem.setResubmit(flowTask.getReSubmit());
        approveItem.setOpinion(flowTask.getOpinion());
        approveItem.setStatus(flowTask.getStatus());
        approveItem.setFlowTaskDeleteReason(flowTask.getDeleteReason());
        MdmFlowTaskOperateEnum flowTaskOperateEnum = MdmFlowTaskOperateEnum.getFlowTaskOperateEnum((FlowTaskStatus)flowTask.getStatus(), (FlowTaskDeleteReason)flowTask.getDeleteReason());
        approveItem.setOperateTitle(flowTaskOperateEnum.getName());
        approveItem.setAlreadyFinish(Boolean.valueOf(flowTask.alreadyFinish()));
        approveItem.setOperateTime(flowTask.getEndTime());
        List<FlowLogVo> taskLogs = logMap.get(flowTask.getId());
        if (taskLogs != null && !taskLogs.isEmpty()) {
            taskLogs.sort(Comparator.comparing(FlowLogVo::getActionTime).reversed());
            Optional<FlowLogVo> targetLog = taskLogs.stream().filter(log -> {
                FlowActionType actionType = log.getActionType();
                return actionType == FlowActionType.APPROVE_TASK || actionType == FlowActionType.REJECT_TASK || actionType == FlowActionType.ROLLBACK || actionType == FlowActionType.ROLLBACK_PREV || actionType == FlowActionType.ROLLBACK_START || actionType == FlowActionType.JUMP || actionType == FlowActionType.ADD_PREV_NODE;
            }).findFirst();
            if (targetLog.isPresent() && targetLog.get().getAttachmentInfo() != null) {
                approveItem.setAttachmentInfo(targetLog.get().getAttachmentInfo());
            } else {
                approveItem.setAttachmentInfo(Collections.emptyList());
            }
        } else {
            approveItem.setAttachmentInfo(Collections.emptyList());
        }
        approveItems.add(approveItem);
    }

    public Map<String, Object> getVariables(GetVariablesDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getId());
        if (flowInstance == null) {
            return Collections.emptyMap();
        }
        Map variables = this.getFlowInstanceVariables(flowInstance);
        if (!dto.getKeys().isEmpty()) {
            variables = variables.entrySet().stream().filter(entry -> dto.getKeys().contains(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        }
        return variables;
    }

    private Map<String, Object> getFlowInstanceVariables(FlowInstance flowInstance) {
        return this.getFlowInstanceVariables(flowInstance, null);
    }

    private Map<String, Object> getFlowInstanceVariables(FlowInstance flowInstance, Set<String> filterVarNames) {
        Map<String, Object> variables = Collections.emptyMap();
        if (flowInstance.alreadyFinish()) {
            variables = this.flowHisService.getVariableMapByFlowInstanceId((Long)flowInstance.getId(), filterVarNames);
        }
        if (variables.isEmpty()) {
            if (filterVarNames == null || filterVarNames.isEmpty()) {
                variables = this.flowEngineService.getVariablesByProcessInstanceId(flowInstance.getProcessInstanceId());
            } else {
                Map<String, Map<String, Object>> varMap = this.flowEngineService.batchGetVarByProcessInstances(Collections.singleton(flowInstance.getProcessInstanceId()), filterVarNames);
                if (varMap.containsKey(flowInstance.getProcessInstanceId())) {
                    variables = varMap.get(flowInstance.getProcessInstanceId());
                }
            }
        }
        return variables;
    }

    public void setVariables(SetVariablesDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getId());
        if (null == flowInstance || null == dto.getVariables() || dto.getVariables().isEmpty()) {
            return;
        }
        if (FlowInstanceStatus.COMPLETED.equals((Object)flowInstance.getStatus()) || FlowInstanceStatus.CANCELED.equals((Object)flowInstance.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
        }
        this.flowEngineService.setVariablesByProcessInstanceId(flowInstance.getProcessInstanceId(), dto.getVariables());
    }

    public void changeDueTime(FlowInstanceChangeDueTimeDto dto) {
        if (dto.getNewDueTime() != null && dto.getNewDueTime().before(new Date())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DUE_TIME_BEFORE_NOW);
        }
        FlowInstance flowInstance = this.getRunningFlowInstance(dto.getFlowInstanceId());
        if (dto.getNewDueTime() == null) {
            flowInstance.setDueTime(FlowConstant.EMPTY_MAX_TIME);
        } else {
            flowInstance.setDueTime(dto.getNewDueTime());
        }
        this.flowInstanceService.modifyFlowInstance(flowInstance);
    }

    public void adminUrge(FlowInstanceAdminUrgeDto dto) {
        FlowInstance flowInstance = this.getRunningFlowInstance(dto.getFlowInstanceId());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByProcessInstanceId(flowInstance.getProcessInstanceId()));
        paramsMap.put("flowInstance", (Object)flowInstance);
        EventPushDto eventPushDto = new EventPushDto();
        eventPushDto.setTenantId(flowInstance.getTenantId());
        eventPushDto.setInstanceId(flowInstance.getAppInstanceId());
        eventPushDto.setEventCode("FLOW_URGE");
        List messageTemplateCodes = dto.getTemplateDtoList().stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
        eventPushDto.setMessageTemplateCodes(messageTemplateCodes);
        eventPushDto.setParamsMap(paramsMap);
        eventPushDto.setUserId(flowInstance.getStartUserId());
        eventPushDto.setUserName(flowInstance.getStartUserName());
        this.frameworkEventService.pushEvent((FrameworkEvent)eventPushDto);
        FlowUrgeLog flowUrgeLog = new FlowUrgeLog();
        flowUrgeLog.setFlowInstanceId((Long)flowInstance.getId());
        flowUrgeLog.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
        flowUrgeLog.setLogType(UrgeLogType.INSTANCE);
        flowUrgeLog.setSourceType(UrgeSourceType.ADMIN);
        flowUrgeLog.setTemplateCodes(String.join((CharSequence)",", messageTemplateCodes));
        flowUrgeLog.setUrgeAssignee(false);
        flowUrgeLog.setAssigneeId(FlowConstant.EMPTY_ID_VALUE);
        flowUrgeLog.setAssigneeName("");
        flowUrgeLog.setUrgeStarter(true);
        flowUrgeLog.setStarterId(flowInstance.getStartUserId());
        flowUrgeLog.setStarterName(flowInstance.getStartUserName());
        flowUrgeLog.setUrgeSpecialUser(false);
        flowUrgeLog.setSpecialUsers("");
        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
        FlowLog flowLog = new FlowLog();
        flowLog.setFlowInstanceId((Long)flowInstance.getId());
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.URGE_INSTANCE);
        flowLog.setOpinion("");
        flowLog.setAdminFlag(true);
        this.flowLogService.createFlowLog(flowLog);
        this.flowInstanceService.addUrgeTimes((Long)flowInstance.getId());
    }

    public List<FlowInstanceVariableVo> listVariableVo(long flowInstanceId) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId);
        if (flowInstance == null) {
            return Collections.emptyList();
        }
        HashMap nameMap = new HashMap(16);
        FlowProject flowProject = this.flowProjectService.getFlowProject(flowInstance.getFlowProjectId());
        if (StringUtils.isNotBlank((CharSequence)flowProject.getVariableConfigs())) {
            JSON.parseArray((String)flowProject.getVariableConfigs(), VariableDefineDto.class).forEach(config -> nameMap.put(config.getKey(), config.getName()));
        }
        return this.getFlowInstanceVariables(flowInstance).entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith("_")) {
                return null;
            }
            FlowInstanceVariableVo vo = new FlowInstanceVariableVo();
            vo.setKey(key);
            vo.setName(nameMap.getOrDefault(key, ""));
            this.convertVariableValue(vo, entry.getValue());
            return vo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void convertVariableValue(FlowInstanceVariableVo vo, Object value) {
        if (value == null) {
            vo.setVariableType(FlowVariableType.NULL);
        } else if (value instanceof CharSequence) {
            vo.setVariableType(FlowVariableType.STRING);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof Short) {
            vo.setVariableType(FlowVariableType.SHORT);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof Integer) {
            vo.setVariableType(FlowVariableType.INTEGER);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof Long) {
            vo.setVariableType(FlowVariableType.LONG);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof Double) {
            vo.setVariableType(FlowVariableType.DOUBLE);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof BigDecimal) {
            vo.setVariableType(FlowVariableType.BIG_DECIMAL);
            vo.setValue(((BigDecimal)value).toPlainString());
            vo.setSupportEdit(true);
        } else if (value instanceof Boolean) {
            vo.setVariableType(FlowVariableType.BOOLEAN);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else if (value instanceof Date) {
            vo.setVariableType(FlowVariableType.DATE);
            vo.setValue(String.valueOf(((Date)value).getTime()));
            vo.setSupportEdit(true);
        } else if (value instanceof LocalDate) {
            vo.setVariableType(FlowVariableType.DATE);
            vo.setValue(String.valueOf(((LocalDate)value).toEpochDay()));
            vo.setSupportEdit(true);
        } else if (value instanceof LocalDateTime) {
            vo.setVariableType(FlowVariableType.DATE);
            vo.setValue(String.valueOf(((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli()));
            vo.setSupportEdit(true);
        } else if (value instanceof JsonNode) {
            vo.setVariableType(FlowVariableType.JSON);
            vo.setValue(value.toString());
            vo.setSupportEdit(true);
        } else {
            vo.setVariableType(FlowVariableType.UNKNOWN);
            vo.setValue(value.toString());
        }
    }

    public void setRunningVariable(FlowInstanceVariableSetDto dto) {
        FlowInstance flowInstance = this.getRunningFlowInstance(dto.getFlowInstanceId());
        Map<String, Map<String, Object>> map = this.flowEngineService.batchGetVarByProcessInstances(Collections.singleton(flowInstance.getProcessInstanceId()), Collections.singleton(dto.getKey()));
        if (FlowVariableType.UNKNOWN.equals((Object)dto.getVariableType())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_NOT_EDITABLE);
        }
        try {
            if (map.containsKey(flowInstance.getProcessInstanceId()) && map.get(flowInstance.getProcessInstanceId()).containsKey(dto.getKey())) {
                Object oldValue = map.get(flowInstance.getProcessInstanceId()).get(dto.getKey());
                FlowInstanceVariableVo vo = new FlowInstanceVariableVo();
                this.convertVariableValue(vo, oldValue);
                if (!vo.getVariableType().equals((Object)dto.getVariableType())) {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_TYPE_DIFF);
                }
                if (!vo.isSupportEdit()) {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_NOT_EDITABLE);
                }
                this.setRunningVariable(dto, flowInstance, oldValue);
            } else {
                this.setRunningVariable(dto, flowInstance);
            }
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_SET_FAILED, new Object[]{dto.getKey()});
        }
    }

    private void setRunningVariable(FlowInstanceVariableSetDto dto, FlowInstance flowInstance) {
        HashMap variables = MapUtil.newHashMap((int)1);
        FlowUtils.putVariable(variables, this.objectMapper, dto.getVariableType(), dto.getKey(), dto.getValue());
        this.flowEngineService.setVariablesByProcessInstanceId(flowInstance.getProcessInstanceId(), variables);
    }

    private void setRunningVariable(FlowInstanceVariableSetDto dto, FlowInstance flowInstance, Object oldValue) {
        HashMap variables = MapUtil.newHashMap((int)1);
        if (oldValue instanceof Date) {
            variables.put(dto.getKey(), new Date(Long.parseLong(dto.getValue())));
        } else if (oldValue instanceof LocalDate) {
            variables.put(dto.getKey(), LocalDate.ofEpochDay(Long.parseLong(dto.getValue())));
        } else if (oldValue instanceof LocalDateTime) {
            variables.put(dto.getKey(), LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(dto.getValue())), ZoneOffset.UTC));
        }
        if (variables.isEmpty()) {
            this.setRunningVariable(dto, flowInstance);
            return;
        }
        this.flowEngineService.setVariablesByProcessInstanceId(flowInstance.getProcessInstanceId(), variables);
    }

    public void removeRunningVariables(FlowInstanceVariableRemoveDto dto) {
        FlowInstance flowInstance = this.getRunningFlowInstance(dto.getFlowInstanceId());
        this.flowEngineService.removeVariablesByProcessInstanceId(flowInstance.getProcessInstanceId(), dto.getVariableKeys());
    }

    public Page<FlowInstanceMyHandledPageVo> myHandled(FlowInstanceMyHandledPageDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        Date now = new Date();
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstanceMyHandledPageDto(dto);
        query.setExistedActionUserId(requestUserId);
        return this.queryMyInstance(query, dto, (flowInstance, nodeMap, runningTaskMap, completedTaskMap) -> {
            FlowInstanceMyHandledPageVo vo = flowInstance.toFlowInstanceMyHandledPageVo(now);
            this.initFlowInstanceMyHandledPageVo(vo, flowInstance, nodeMap, runningTaskMap);
            return vo;
        });
    }

    public Page<FlowInstanceMyStartedPageVo> myStarted(FlowInstanceMyHandledPageDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        Date now = new Date();
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstanceMyHandledPageDto(dto);
        query.setStartUserId(requestUserId);
        query.setStatusNotIn(List.of(FlowInstanceStatus.DRAFT));
        return this.queryMyInstance(query, dto, (flowInstance, nodeMap, runningTaskMap, completedTaskMap) -> {
            FlowInstanceMyStartedPageVo vo = flowInstance.toFlowInstanceMyStartedPageVo(now);
            this.initFlowInstanceMyHandledPageVo((FlowInstanceMyHandledPageVo)vo, flowInstance, nodeMap, runningTaskMap);
            vo.setCanWithdrawFlag(Boolean.valueOf(this.checkCanWithdraw(flowInstance, vo.getCurrentNodes().stream().map(FlowInstanceNodeInfoVo::getNodeKey).collect(Collectors.toList()))));
            vo.setCanCancelFlag(Boolean.valueOf(this.checkCanCancel(flowInstance, vo.getCurrentNodes().stream().map(FlowInstanceNodeInfoVo::getNodeKey).collect(Collectors.toList()))));
            if (Boolean.TRUE.equals(dto.getCheckHasPassAudit())) {
                List noAutoCompletedTasks = completedTaskMap.getOrDefault(flowInstance.getId(), Collections.emptyList()).stream().filter(flowTask -> FlowConstant.AUTO_COMPLETE_FLAG_NO.equals(flowTask.getAutoCompleteFlag())).collect(Collectors.toList());
                vo.setHasPassAudit(Boolean.valueOf(!noAutoCompletedTasks.isEmpty()));
            }
            return vo;
        });
    }

    private void initFlowInstanceMyHandledPageVo(FlowInstanceMyHandledPageVo vo, FlowInstanceWithCategory flowInstance, Map<Long, List<FlowNode>> nodeMap, Map<Long, List<FlowTask>> taskMap) {
        if (nodeMap.containsKey(flowInstance.getId())) {
            vo.setCurrentNodes(nodeMap.get(flowInstance.getId()).stream().map(node -> {
                FlowInstanceNodeInfoVo nodeInfoVo = new FlowInstanceNodeInfoVo();
                nodeInfoVo.setNodeKey(node.getNodeKey());
                nodeInfoVo.setNodeName(node.getNodeName());
                nodeInfoVo.setStatus(node.getStatus());
                if (taskMap.containsKey(node.getId())) {
                    nodeInfoVo.setAssignees(((List)taskMap.get(node.getId())).stream().map(task -> new IdNameVo(task.getAssigneeUserId(), task.getAssigneeUserName())).collect(Collectors.toList()));
                } else {
                    nodeInfoVo.setAssignees(Collections.emptyList());
                }
                return nodeInfoVo;
            }).collect(Collectors.toList()));
        } else {
            vo.setCurrentNodes(Collections.emptyList());
        }
    }

    private <T extends FlowInstanceBaseVo> Page<T> queryMyInstance(FlowInstanceWithCategoryQuery query, FlowInstanceMyHandledPageDto param, MyInstanceVoFunction<T> function) {
        long count = this.flowInstanceService.countFlowInstanceWithCategory(query);
        if (count < 1L) {
            return new Page(param.getCurrent(), param.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowInstanceWithCategory> instances = this.flowInstanceService.pageQueryFlowInstanceWithCategory(query, (PageParam)param);
        if (instances.isEmpty()) {
            return new Page(param.getCurrent(), param.getPageSize(), count, Collections.emptyList());
        }
        List<Long> instanceIds = instances.stream().map(Entity::getId).collect(Collectors.toList());
        Map<Long, List<FlowNode>> nodeMap = this.flowNodeService.listRunningNodesForInstances(instanceIds).stream().collect(Collectors.groupingBy(FlowNode::getFlowInstanceId));
        Map<Long, List<FlowTask>> runningTaskMap = this.flowTaskService.listRunningTasksForInstances(instanceIds).stream().collect(Collectors.groupingBy(flowTask -> {
            if (FlowTaskType.STARTER_FILL.equals((Object)flowTask.getTaskType())) {
                List flowNodes = nodeMap.computeIfAbsent(flowTask.getFlowInstanceId(), k -> new ArrayList());
                if (flowNodes.isEmpty() || !"".equals(((FlowNode)((Object)((Object)flowNodes.get(flowNodes.size() - 1)))).getNodeKey())) {
                    FlowNode starterFillNode = new FlowNode();
                    starterFillNode.setNodeKey("");
                    starterFillNode.setId(Long.valueOf(-1L * flowTask.getFlowInstanceId()));
                    starterFillNode.setFlowInstanceId(flowTask.getFlowInstanceId());
                    starterFillNode.setNodeName("\u53d1\u8d77\u4eba\u8865\u5f55");
                    starterFillNode.setStatus(FlowTaskStatus.RUNNING);
                    flowNodes.add(starterFillNode);
                }
                return -1L * flowTask.getFlowInstanceId();
            }
            return flowTask.getFlowNodeId();
        }));
        Map<Long, List<FlowTask>> completedTaskMap = this.flowTaskService.listCompletedTasksForInstances(instanceIds).stream().collect(Collectors.groupingBy(FlowTask::getFlowInstanceId));
        List list = instances.stream().map(i -> (FlowInstanceBaseVo)function.convertToVo((FlowInstanceWithCategory)((Object)i), nodeMap, runningTaskMap, completedTaskMap)).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(param.getCurrent(), param.getPageSize(), count, list);
    }

    private boolean checkCanWithdraw(FlowInstance flowInstance, Collection<String> nodeKeys) {
        if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus())) {
            return false;
        }
        return this.checkCanWithdraw((Long)flowInstance.getId(), flowInstance.getFlowProjectId(), nodeKeys);
    }

    public boolean checkCanWithdraw(Long flowInstanceId, Long flowProjectId, Collection<String> nodeKeys) {
        if (nodeKeys.isEmpty()) {
            return true;
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowProjectId);
        for (String nodeKey : nodeKeys) {
            ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, nodeKey);
            if (approvalNodeConfig == null) {
                return false;
            }
            if (!(Boolean.TRUE.equals(approvalNodeConfig.getUseGlobalStarterConfig()) ? !Boolean.TRUE.equals(globalConfig.getStarterRollback()) : !Boolean.TRUE.equals(approvalNodeConfig.getStarterRollback()))) continue;
            return false;
        }
        return true;
    }

    private boolean checkCanCancel(FlowInstance flowInstance, Collection<String> nodeKeys) {
        if (!FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus())) {
            return false;
        }
        return this.checkCanCancel((Long)flowInstance.getId(), flowInstance.getFlowProjectId(), nodeKeys);
    }

    public boolean checkCanCancel(Long flowInstanceId, Long flowProjectId, Collection<String> nodeKeys) {
        if (nodeKeys.isEmpty()) {
            return true;
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowProjectId);
        for (String nodeKey : nodeKeys) {
            ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, nodeKey);
            if (approvalNodeConfig == null) {
                return false;
            }
            if (!(Boolean.TRUE.equals(approvalNodeConfig.getUseGlobalStarterConfig()) ? !Boolean.TRUE.equals(globalConfig.getStarterCancel()) : !Boolean.TRUE.equals(approvalNodeConfig.getStarterCancel()))) continue;
            return false;
        }
        return true;
    }

    private void setExtInfo(List<? extends FlowInstanceBaseVo> voList) {
        if (voList.isEmpty()) {
            return;
        }
        Set<Long> flowInstanceIds = voList.stream().map(FlowInstanceBaseVo::getId).collect(Collectors.toSet());
        Map<Long, List<FlowInstanceExtArray>> extArrayMap = this.flowInstanceService.getExtArrayFieldsByFlowInstanceIds(flowInstanceIds).stream().collect(Collectors.groupingBy(FlowInstanceExtArray::getFlowInstanceId));
        Map<Long, FlowInstanceExtDto> extMap = this.flowInstanceService.getExtFieldsByFlowInstanceIds(flowInstanceIds).stream().collect(Collectors.toMap(FlowInstanceExt::getFlowInstanceId, e -> e.toFlowInstanceExtDto((List)extArrayMap.get(e.getFlowInstanceId())), (a, b) -> a));
        if (!extMap.isEmpty()) {
            voList.forEach(vo -> vo.setExtFields((FlowInstanceExtDto)extMap.get(vo.getId())));
        }
    }

    public List<FlowNodeLogVo> listFlowNodeLog(FlowNodeLogListDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        this.flowDataHelperService.validateViewPermission(flowInstance);
        List<FlowNode> flowNodes = this.flowNodeService.listByFlowInstanceId(dto.getFlowInstanceId());
        List<FlowTask> flowTasks = this.flowTaskService.listByFlowInstance(dto.getFlowInstanceId());
        List<FlowInstanceAddNode> addNodes = this.flowInstanceService.listAddNodes(dto.getFlowInstanceId());
        Map<String, FlowInstanceAddNode> addNodeMap = addNodes.stream().collect(Collectors.toMap(FlowInstanceAddNode::getNodeKey, Function.identity()));
        Map<Long, List<FlowTask>> taskMap = flowTasks.stream().collect(Collectors.groupingBy(FlowTask::getFlowNodeId));
        ArrayList<FlowNodeLogVo> result = new ArrayList<FlowNodeLogVo>();
        ArrayList<FlowNodeLogVo> runningNodes = new ArrayList<FlowNodeLogVo>();
        for (FlowNode flowNode : flowNodes) {
            FlowNodeLogVo nodeVo = this.buildFlowNodeLogVo(flowNode, runningNodes, addNodeMap, flowInstance, taskMap);
            result.add(nodeVo);
        }
        this.calFutureFlowNodeLog(dto, flowInstance, result, runningNodes, taskMap, addNodes, false);
        return result;
    }

    private void calFutureFlowNodeLog(FlowNodeLogListDto dto, FlowInstance flowInstance, List<FlowNodeLogVo> result, List<FlowNodeLogVo> runningNodes, Map<Long, List<FlowTask>> taskMap, List<FlowInstanceAddNode> addNodes, Boolean calFutureActualExecutor) {
        if (runningNodes.isEmpty() || !Boolean.TRUE.equals(dto.getCalFuture())) {
            return;
        }
        ArrayList<FlowTaskLogVo> futureTasks = new ArrayList<FlowTaskLogVo>();
        String designContent = this.flowInstanceService.getDesignContentForFlowInstance(dto.getFlowInstanceId());
        FlowExpressionExecutor expressionExecutor = this.flowEngineService.getFlowExpressionExecutor(flowInstance.getProcessInstanceId());
        JSONArray designJson = JSON.parseArray((String)designContent);
        if (!addNodes.isEmpty()) {
            this.handleDesignContentAddNode(addNodes, flowInstance, designJson);
        }
        FutureCalParams futureCalParams = new FutureCalParams();
        futureCalParams.flowInstance = flowInstance;
        futureCalParams.edgeOutMap = new HashMap<String, List<JSONObject>>(16);
        futureCalParams.designNodeMap = new HashMap<String, JSONObject>(16);
        futureCalParams.expressionExecutor = expressionExecutor;
        futureCalParams.needGetNameAssignees = new ArrayList<JumpNodeAssigneeInfo>();
        futureCalParams.calFutureActualExecutor = calFutureActualExecutor;
        for (int i = 0; i < designJson.size(); ++i) {
            JSONObject designObj = designJson.getJSONObject(i);
            if (NODE_EDGE.equals(designObj.getString(NODE_SHAPE))) {
                futureCalParams.edgeOutMap.computeIfAbsent(designObj.getJSONObject(NODE_SOURCE).getString(NODE_CELL), k -> new ArrayList()).add(designObj);
                continue;
            }
            futureCalParams.designNodeMap.put(designObj.getString("id"), designObj);
        }
        HashSet<String> calledNodeKey = new HashSet<String>();
        int startIndex = result.size();
        for (FlowNodeLogVo runningNode : runningNodes) {
            this.calCurrentSequentialFuture(runningNode, taskMap, futureTasks);
            calledNodeKey.add(runningNode.getNodeKey());
            List outEdges = futureCalParams.edgeOutMap.getOrDefault(runningNode.getNodeKey(), Collections.emptyList());
            for (int i = outEdges.size() - 1; i >= 0; --i) {
                this.calNextFutureNode((JSONObject)outEdges.get(i), startIndex, calledNodeKey, result, futureCalParams, futureTasks, dto.getCalFailHandle());
            }
        }
        if (!futureTasks.isEmpty()) {
            Set<Long> futureUserIds = futureTasks.stream().map(FlowTaskLogVo::getAssigneeUserId).collect(Collectors.toSet());
            Map<Long, String> userNameMap = this.userHelperService.getUserNameMap(futureUserIds);
            if (Boolean.FALSE.equals(calFutureActualExecutor)) {
                futureTasks.stream().filter(t -> t.getAssigneeType() == AssigneeType.USER || t.getAssigneeType() == AssigneeType.FORMULA).forEach(t -> {
                    t.setAssigneeUserName(userNameMap.getOrDefault(t.getAssigneeUserId(), ""));
                    t.setOwnerUserName(t.getAssigneeUserName());
                });
            } else {
                futureTasks.forEach(t -> {
                    t.setAssigneeUserName(userNameMap.getOrDefault(t.getAssigneeUserId(), ""));
                    t.setOwnerUserName(t.getAssigneeUserName());
                });
            }
        }
    }

    private void calCurrentSequentialFuture(FlowNodeLogVo runningNode, Map<Long, List<FlowTask>> taskMap, List<FlowTaskLogVo> futureTasks) {
        FlowTask runningTask;
        if (TaskExecuteType.SEQUENTIAL.equals((Object)runningNode.getTaskExecuteType()) && (runningTask = (FlowTask)taskMap.getOrDefault(runningNode.getId(), Collections.emptyList()).stream().filter(t -> FlowTaskStatus.RUNNING.equals((Object)t.getStatus()) || FlowTaskStatus.SUSPENDED.equals((Object)t.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL.equals((Object)t.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE.equals((Object)t.getStatus())).findFirst().orElse(null)) != null) {
            List<Long> waitAssigneeIds = this.flowEngineService.listWaitSequenceAssignees(runningTask.getTaskId());
            waitAssigneeIds.forEach(uid -> {
                FlowTaskLogVo taskLogVo = new FlowTaskLogVo();
                taskLogVo.setAssigneeUserId(uid);
                taskLogVo.setOwnerUserId(taskLogVo.getAssigneeUserId());
                taskLogVo.setFutureFlag(FlowConstant.FUTURE_FLAG_FUTURE);
                runningNode.getTasks().add(taskLogVo);
                futureTasks.add(taskLogVo);
            });
        }
    }

    private void calNextFutureNode(JSONObject outEdge, int insertIndex, Set<String> calledNodeKey, List<FlowNodeLogVo> result, FutureCalParams futureCalParams, List<FlowTaskLogVo> futureTasks, Integer calFailHandle) {
        String targetId = outEdge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
        JSONObject node = futureCalParams.designNodeMap.get(targetId);
        String nodeId = node.getString("id");
        if (calledNodeKey.contains(nodeId)) {
            return;
        }
        calledNodeKey.add(nodeId);
        String shape = node.getString(NODE_SHAPE);
        if (NODE_APPROVAL.equals(shape)) {
            result.add(insertIndex, this.buildFutureFlowNodeLogVo(node, futureCalParams, futureTasks));
            ++insertIndex;
        } else if (NODE_EXCLUSIVE_GATEWAY.equals(shape)) {
            this.calFutureGateway(insertIndex, calledNodeKey, result, futureCalParams, futureTasks, calFailHandle, nodeId);
            return;
        }
        List outNodes = futureCalParams.edgeOutMap.getOrDefault(nodeId, Collections.emptyList());
        for (int i = outNodes.size() - 1; i >= 0; --i) {
            JSONObject outNode = (JSONObject)outNodes.get(i);
            this.calNextFutureNode(outNode, insertIndex, calledNodeKey, result, futureCalParams, futureTasks, calFailHandle);
        }
    }

    private void calFutureGateway(int insertIndex, Set<String> calledNodeKey, List<FlowNodeLogVo> result, FutureCalParams futureCalParams, List<FlowTaskLogVo> futureTasks, Integer calFailHandle, String nodeId) {
        GatewayNodeConfigDto gatewayNodeConfig = this.flowProjectConfigCacheRepository.getGatewayNodeConfig(futureCalParams.flowInstance.getFlowProjectId(), nodeId);
        List<JSONObject> outEdges = futureCalParams.edgeOutMap.get(nodeId);
        if (outEdges.size() == 1) {
            this.calNextFutureNode(outEdges.get(0), insertIndex, calledNodeKey, result, futureCalParams, futureTasks, calFailHandle);
            return;
        }
        if (gatewayNodeConfig != null && gatewayNodeConfig.getLineConfigs() != null) {
            Map lineConfigMap = gatewayNodeConfig.getLineConfigs().stream().collect(Collectors.toMap(GatewayLineConfigDto::getTargetNodeKey, Function.identity(), (a, b) -> a));
            for (JSONObject edge : outEdges) {
                String edgeTargetId = edge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
                GatewayLineConfigDto gatewayLineConfigDto = (GatewayLineConfigDto)lineConfigMap.get(edgeTargetId);
                if (!this.calFutureGatewayLine(gatewayLineConfigDto, futureCalParams)) continue;
                this.calNextFutureNode(edge, insertIndex, calledNodeKey, result, futureCalParams, futureTasks, calFailHandle);
                return;
            }
        }
        if (!outEdges.isEmpty() && FlowConstant.FUTURE_CAL_FAIL_HANDLE_RANDOM.equals(calFailHandle)) {
            this.calNextFutureNode(outEdges.get(0), insertIndex, calledNodeKey, result, futureCalParams, futureTasks, calFailHandle);
        }
    }

    private FlowNodeLogVo buildFlowNodeLogVo(FlowNode flowNode, List<FlowNodeLogVo> runningNodes, Map<String, FlowInstanceAddNode> addNodeMap, FlowInstance flowInstance, Map<Long, List<FlowTask>> taskMap) {
        FlowNodeLogVo nodeVo = new FlowNodeLogVo();
        nodeVo.setId((Long)flowNode.getId());
        nodeVo.setNodeKey(flowNode.getNodeKey());
        nodeVo.setNodeName(flowNode.getNodeName());
        nodeVo.setCountersign(flowNode.getCountersign());
        nodeVo.setStartTime(flowNode.getStartTime());
        nodeVo.setEndTime(CodeUtils.formatNullableMinTime(flowNode.getEndTime()));
        nodeVo.setStatus(flowNode.getStatus());
        if (FlowTaskStatus.RUNNING.equals((Object)flowNode.getStatus()) || FlowTaskStatus.SUSPENDED.equals((Object)flowNode.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL.equals((Object)flowNode.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE.equals((Object)flowNode.getStatus())) {
            nodeVo.setFutureFlag(FlowConstant.FUTURE_FLAG_CURRENT);
            runningNodes.add(nodeVo);
        } else {
            nodeVo.setFutureFlag(FlowConstant.FUTURE_FLAG_FINISH);
        }
        ApprovalNodeConfigDto approvalNodeConfig = addNodeMap.containsKey(flowNode.getNodeKey()) ? (ApprovalNodeConfigDto)JSON.parseObject((String)addNodeMap.get(flowNode.getNodeKey()).getApproveNodeConfig(), ApprovalNodeConfigDto.class) : this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInstance.getFlowProjectId(), flowNode.getNodeKey());
        nodeVo.setCountersignType(approvalNodeConfig.getCountersignType());
        nodeVo.setCountersignNumType(approvalNodeConfig.getCountersignNumType());
        nodeVo.setCountersignNum(approvalNodeConfig.getCountersignNum());
        nodeVo.setTaskExecuteType(approvalNodeConfig.getTaskExecuteType());
        List<FlowTask> nodeTasks = taskMap.getOrDefault(flowNode.getId(), Collections.emptyList());
        ArrayList tasks = new ArrayList();
        nodeTasks.forEach(task -> {
            FlowTaskLogVo taskLogVo = new FlowTaskLogVo();
            taskLogVo.setId((Long)task.getId());
            taskLogVo.setTaskName(task.getTaskName());
            taskLogVo.setTaskType(task.getTaskType());
            taskLogVo.setAssigneeUserId(task.getAssigneeUserId());
            taskLogVo.setAssigneeType(approvalNodeConfig.getAssigneeType());
            taskLogVo.setAssigneeUserName(task.getAssigneeUserName());
            taskLogVo.setOwnerUserId(task.getOwnerUserId());
            taskLogVo.setOwnerUserName(task.getOwnerUserName());
            taskLogVo.setActionUserId(task.getActionUserId());
            taskLogVo.setActionUserName(task.getActionUserName());
            taskLogVo.setStatus(task.getStatus());
            taskLogVo.setStartTime(CodeUtils.formatNullableMinTime(task.getStartTime()));
            taskLogVo.setLastStartTime(CodeUtils.formatNullableMinTime(task.getLastStartTime()));
            taskLogVo.setEndTime(CodeUtils.formatNullableMinTime(task.getEndTime()));
            taskLogVo.setDueTime(CodeUtils.formatNullableMaxTime(task.getDueTime()));
            taskLogVo.setAutoCompleteFlag(task.getAutoCompleteFlag());
            taskLogVo.setCountersignResult(task.getCountersignResult());
            taskLogVo.setDeleteReason(task.getDeleteReason());
            taskLogVo.setFormUrl(task.getFormUrl());
            taskLogVo.setOpinion(task.getOpinion());
            taskLogVo.setFutureFlag(FlowTaskStatus.RUNNING.equals((Object)task.getStatus()) || FlowTaskStatus.SUSPENDED.equals((Object)task.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL.equals((Object)task.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE.equals((Object)task.getStatus()) ? FlowConstant.FUTURE_FLAG_CURRENT : FlowConstant.FUTURE_FLAG_FINISH);
            tasks.add(taskLogVo);
        });
        nodeVo.setTasks(tasks);
        nodeVo.setReSubmit(Boolean.valueOf(nodeTasks.stream().anyMatch(t -> Boolean.TRUE.equals(t.getReSubmit()))));
        return nodeVo;
    }

    private FlowNodeLogVo buildFutureFlowNodeLogVo(JSONObject approvalNode, FutureCalParams futureCalParams, List<FlowTaskLogVo> futureTasks) {
        String nodeId = approvalNode.getString("id");
        FlowNodeLogVo nodeLogVo = new FlowNodeLogVo();
        nodeLogVo.setNodeKey(nodeId);
        nodeLogVo.setNodeName(this.getApprovalNodeName(approvalNode));
        nodeLogVo.setReSubmit(Boolean.valueOf(false));
        nodeLogVo.setFutureFlag(FlowConstant.FUTURE_FLAG_FUTURE);
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(futureCalParams.flowInstance.getFlowProjectId(), (Long)futureCalParams.flowInstance.getId(), nodeId);
        nodeLogVo.setCountersignType(approvalNodeConfig.getCountersignType());
        nodeLogVo.setCountersignNumType(approvalNodeConfig.getCountersignNumType());
        nodeLogVo.setCountersignNum(approvalNodeConfig.getCountersignNum());
        nodeLogVo.setTaskExecuteType(approvalNodeConfig.getTaskExecuteType());
        ArrayList<JumpNodeAssigneeInfo> assignees = new ArrayList<JumpNodeAssigneeInfo>();
        this.calFutureAssignee(futureCalParams, nodeId, assignees);
        ArrayList tasks = new ArrayList();
        assignees.forEach(assignee -> {
            FlowTaskLogVo taskLogVo = new FlowTaskLogVo();
            taskLogVo.setAssigneeUserId(assignee.getId());
            taskLogVo.setAssigneeUserName(assignee.getName());
            taskLogVo.setAssigneeType(assignee.getAssigneeType());
            taskLogVo.setOwnerUserId(taskLogVo.getAssigneeUserId());
            taskLogVo.setFutureFlag(FlowConstant.FUTURE_FLAG_FUTURE);
            tasks.add(taskLogVo);
            futureTasks.add(taskLogVo);
        });
        nodeLogVo.setTasks(tasks);
        return nodeLogVo;
    }

    public void migration(FlowInstanceMigrationDto dto) {
        FlowProject targetFlowProject = this.flowProjectService.getFlowProject(dto.getTargetFlowProjectId());
        if (targetFlowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        if (dto.getFlowInstanceId() != null) {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
            if (flowInstance == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
            }
            if (flowInstance.alreadyFinish()) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_SOURCE_FINISH);
            }
            if (!targetFlowProject.getCodeName().equals(flowInstance.getFlowProjectCode())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_DIFF_PROJECT);
            }
            if (((Long)targetFlowProject.getId()).equals(flowInstance.getFlowProjectId())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_SAME_PROJECT);
            }
            if (!this.flowInstanceService.listAddNodes((Long)flowInstance.getId()).isEmpty()) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_ADD_NODE);
            }
            this.flowEngineService.migrationByInstance(flowInstance.getProcessInstanceId(), targetFlowProject.getDefinitionId(), (Long)targetFlowProject.getId());
            flowInstance.setFlowProjectId((Long)targetFlowProject.getId());
            this.flowInstanceService.modifyFlowInstance(flowInstance);
        } else if (dto.getFlowProjectId() != null) {
            FlowProject sourceFlowProject = this.flowProjectService.getFlowProject(dto.getFlowProjectId());
            if (sourceFlowProject == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
            }
            if (!targetFlowProject.getCodeName().equals(sourceFlowProject.getCodeName())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_DIFF_PROJECT);
            }
            if (((Long)targetFlowProject.getId()).equals(sourceFlowProject.getId())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_SAME_PROJECT);
            }
            this.flowEngineService.migrationByProject(sourceFlowProject.getDefinitionId(), targetFlowProject.getDefinitionId(), (Long)targetFlowProject.getId());
            this.flowInstanceService.changeRunningProjectId((Long)sourceFlowProject.getId(), (Long)targetFlowProject.getId());
        } else {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_SOURCE_EMPTY);
        }
    }

    public void modifyExt(FlowInstanceExtModifyDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        if (flowInstance == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        this.flowInstanceService.addOrUpdateExtFields((Long)flowInstance.getId(), flowInstance.getProcessInstanceId(), flowInstance.getStartTime(), (FlowInstanceExtDto)dto);
    }

    public Page<FlowInstanceMyHandledPageVo> myCc(FlowInstanceMyHandledPageDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        Date now = new Date();
        FlowInstanceWithCategoryQuery query = FlowInstanceWithCategoryQuery.fromFlowInstanceMyHandledPageDto(dto);
        query.setExistedCcUserId(requestUserId);
        return this.queryMyInstance(query, dto, (flowInstance, nodeMap, runningTaskMap, completedTaskMap) -> {
            FlowInstanceMyHandledPageVo vo = flowInstance.toFlowInstanceMyHandledPageVo(now);
            this.initFlowInstanceMyHandledPageVo(vo, flowInstance, nodeMap, runningTaskMap);
            return vo;
        });
    }

    public FlowInstanceComprehensiveVo getComprehensiveLog(FlowInstanceComprehensiveDto dto) {
        FlowInstance flowInstance;
        if (dto.getInstanceId() != null) {
            flowInstance = this.flowInstanceService.getFlowInstance(dto.getInstanceId());
        } else {
            if (dto.getTaskId() == null) {
                return null;
            }
            flowInstance = this.flowInstanceService.getFlowInstance(this.flowTaskService.getFlowTask(dto.getTaskId()).getFlowInstanceId());
        }
        this.flowDataHelperService.validateViewPermission(flowInstance);
        FlowNodeLogListDto flowNodeLogListDto = new FlowNodeLogListDto();
        flowNodeLogListDto.setFlowInstanceId((Long)flowInstance.getId());
        flowNodeLogListDto.setCalFuture(dto.getCalFuture());
        flowNodeLogListDto.setCalFailHandle(dto.getCalFailHandle());
        List<FlowNode> flowNodes = this.flowNodeService.listByFlowInstanceIdAsc((Long)flowInstance.getId());
        List<FlowTask> flowTasks = this.flowTaskService.listByFlowInstanceAsc((Long)flowInstance.getId());
        List<FlowInstanceAddNode> addNodes = this.flowInstanceService.listAddNodes((Long)flowInstance.getId());
        Map<String, FlowInstanceAddNode> addNodeMap = addNodes.stream().collect(Collectors.toMap(FlowInstanceAddNode::getNodeKey, Function.identity()));
        Map<Long, List<FlowTask>> taskMap = flowTasks.stream().collect(Collectors.groupingBy(FlowTask::getFlowNodeId));
        FlowInstanceComprehensiveVo result = new FlowInstanceComprehensiveVo();
        ArrayList<FlowNodeLogVo> flowNodeLogVoList = new ArrayList<FlowNodeLogVo>();
        ArrayList<FlowNodeLogVo> runningNodes = new ArrayList<FlowNodeLogVo>();
        for (FlowNode flowNode : flowNodes) {
            FlowNodeLogVo nodeVo = this.buildFlowNodeLogVo(flowNode, runningNodes, addNodeMap, flowInstance, taskMap);
            flowNodeLogVoList.add(nodeVo);
        }
        this.calFutureFlowNodeLog(flowNodeLogListDto, flowInstance, flowNodeLogVoList, runningNodes, taskMap, addNodes, Optional.ofNullable(dto.getCalFutureActualExecutor()).orElse(false));
        result.setStartUserId(flowInstance.getStartUserId());
        result.setStartUserName(flowInstance.getStartUserName());
        result.setStartTime(flowInstance.getStartTime());
        result.setEndTime(CodeUtils.formatNullableMinTime(flowInstance.getEndTime()));
        Map<Long, List<FlowTask>> customInfoMap = flowTasks.stream().filter(task -> task.getCustomTaskInfo() != null).collect(Collectors.groupingBy(task -> {
            StarterFillTaskCustomInfoVo customInfo = (StarterFillTaskCustomInfoVo)JSON.parseObject((String)task.getCustomTaskInfo(), StarterFillTaskCustomInfoVo.class);
            return customInfo.getActionTaskId();
        }));
        List flowLogs = this.flowLogService.listFlowLog((Long)flowInstance.getId()).stream().map(FlowLog::toFlowLogVo).collect(Collectors.toList());
        Map<Long, List<FlowLogVo>> logMap = flowLogs.stream().collect(Collectors.groupingBy(FlowLogVo::getFlowTaskId));
        if (logMap.containsKey(0L)) {
            result.setLogs(logMap.get(0L));
        }
        FlowInstanceComprehensiveVo vo = this.toFlowInstanceComprehensiveVo(result, flowNodeLogVoList, logMap, customInfoMap, addNodeMap, dto.isFilterDeletedTask());
        if (!Boolean.FALSE.equals(dto.getNodeSortByEndTime())) {
            vo.getNodes().sort((a, b) -> {
                if (a.getEndTime() == null && b.getEndTime() == null) {
                    if (a.getStartTime() == null && b.getStartTime() == null) {
                        return 0;
                    }
                    if (a.getStartTime() == null) {
                        return 1;
                    }
                    if (b.getStartTime() == null) {
                        return -1;
                    }
                    return a.getStartTime().compareTo(b.getStartTime());
                }
                if (a.getEndTime() == null) {
                    return 1;
                }
                if (b.getEndTime() == null) {
                    return -1;
                }
                return a.getEndTime().compareTo(b.getEndTime());
            });
        }
        if (Boolean.TRUE.equals(dto.getFilterEmptyNode())) {
            vo.setNodes(vo.getNodes().stream().filter(node -> node.getTasks() != null && !node.getTasks().isEmpty()).collect(Collectors.toList()));
        }
        return vo;
    }

    private FlowInstanceComprehensiveVo toFlowInstanceComprehensiveVo(FlowInstanceComprehensiveVo result, List<FlowNodeLogVo> nodeList, Map<Long, List<FlowLogVo>> logMap, Map<Long, List<FlowTask>> customInfoMap, Map<String, FlowInstanceAddNode> addNodeMap, boolean filterDeletedTask) {
        result.setNodes(new ArrayList());
        List nodes = result.getNodes();
        for (FlowNodeLogVo node : nodeList) {
            FlowNodeComprehensiveVo nodeVo = new FlowNodeComprehensiveVo();
            nodeVo.setId(node.getId());
            nodeVo.setNodeKey(node.getNodeKey());
            nodeVo.setNodeName(node.getNodeName());
            nodeVo.setFutureFlag(node.getFutureFlag());
            nodeVo.setStatus(node.getStatus());
            nodeVo.setReSubmit(node.getReSubmit());
            nodeVo.setStartTime(node.getStartTime());
            nodeVo.setEndTime(node.getEndTime());
            nodeVo.setAddNode(Boolean.valueOf(addNodeMap.containsKey(node.getNodeKey())));
            List tasks = BeanUtils.copyList((List)node.getTasks(), FlowTaskComprehensiveVo.class);
            List resultTasks = tasks.stream().filter(task -> !filterDeletedTask || !FlowTaskStatus.DELETED.equals((Object)task.getStatus())).map(task -> {
                this.calResidenceTime((FlowTaskComprehensiveVo)task);
                task.setEndTime(CodeUtils.formatNullableMinTime(task.getEndTime()));
                FlowInstanceApplicationService.handleTaskLog(logMap, task);
                if (customInfoMap.containsKey(task.getId())) {
                    for (FlowTask infoVo : (List)customInfoMap.get(task.getId())) {
                        if (task.getChildren() == null) {
                            task.setChildren(new ArrayList());
                        }
                        FlowTaskComprehensiveVo flowTaskComprehensiveVo = (FlowTaskComprehensiveVo)BeanUtils.copyProperties((Object)new FlowTaskComprehensiveVo(), (Object)((Object)infoVo));
                        MdmFlowTaskOperateEnum flowTaskOperateEnum = MdmFlowTaskOperateEnum.getFlowTaskOperateEnum((FlowTaskStatus)infoVo.getStatus(), (FlowTaskDeleteReason)infoVo.getDeleteReason());
                        flowTaskComprehensiveVo.setOperateTitle(flowTaskOperateEnum.getName());
                        flowTaskComprehensiveVo.setId((Long)infoVo.getId());
                        flowTaskComprehensiveVo.setStartTime(CodeUtils.formatNullableMinTime(infoVo.getStartTime()));
                        flowTaskComprehensiveVo.setLastStartTime(CodeUtils.formatNullableMinTime(infoVo.getLastStartTime()));
                        flowTaskComprehensiveVo.setEndTime(CodeUtils.formatNullableMinTime(infoVo.getEndTime()));
                        flowTaskComprehensiveVo.setDueTime(CodeUtils.formatNullableMaxTime(infoVo.getDueTime()));
                        FlowInstanceApplicationService.handleTaskLog(logMap, flowTaskComprehensiveVo);
                        task.getChildren().add(flowTaskComprehensiveVo);
                    }
                }
                MdmFlowTaskOperateEnum flowTaskOperateEnum = MdmFlowTaskOperateEnum.getFlowTaskOperateEnum((FlowTaskStatus)task.getStatus(), (FlowTaskDeleteReason)task.getDeleteReason());
                task.setOperateTitle(flowTaskOperateEnum.getName());
                return task;
            }).collect(Collectors.toList());
            nodeVo.setTasks(resultTasks);
            nodes.add(nodeVo);
        }
        return result;
    }

    private static void handleTaskLog(Map<Long, List<FlowLogVo>> logMap, FlowTaskComprehensiveVo task) {
        if (logMap.containsKey(task.getId())) {
            List<FlowLogVo> taskLogs = logMap.get(task.getId());
            task.setLogs(taskLogs);
            Optional<FlowLogVo> targetLog = taskLogs.stream().filter(log -> {
                FlowActionType actionType = log.getActionType();
                return actionType == FlowActionType.APPROVE_TASK || actionType == FlowActionType.REJECT_TASK || actionType == FlowActionType.ROLLBACK || actionType == FlowActionType.ROLLBACK_PREV || actionType == FlowActionType.ROLLBACK_START || actionType == FlowActionType.JUMP || actionType == FlowActionType.ADD_PREV_NODE;
            }).max(Comparator.comparing(FlowLogVo::getActionTime));
            if (targetLog.isPresent() && targetLog.get().getAttachmentInfo() != null) {
                task.setAttachmentInfo(targetLog.get().getAttachmentInfo());
            } else {
                task.setAttachmentInfo(Collections.emptyList());
            }
        } else {
            task.setAttachmentInfo(Collections.emptyList());
        }
    }

    private void calResidenceTime(FlowTaskComprehensiveVo task) {
        if (task.getEndTime() != null && task.getStartTime() != null && task.getEndTime().after(task.getStartTime())) {
            long durationInMillis = task.getEndTime().getTime() - task.getStartTime().getTime();
            long days = durationInMillis / 86400000L;
            long hours = durationInMillis / 3600000L % 24L;
            long minutes = durationInMillis / 60000L % 60L;
            task.setResidenceTime(String.format("%d\u5929%02d\u65f6%02d\u5206", days, hours, minutes));
        }
    }

    public void ccToUsers(FlowInstanceCcDto dto) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId());
        if (Objects.isNull((Object)flowInstance)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        this.flowEngineService.ccInstance(flowInstance, dto);
    }

    public List<FlowCcVo> listCcLogs(long id) {
        List<FlowCc> list = this.flowInstanceService.listFlowCc(id);
        Map<Long, String> taskNameMap = this.flowTaskService.batchGetFlowTask(list.stream().map(FlowCc::getFlowTaskId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(Entity::getId, FlowTask::getTaskName));
        return list.stream().map(cc -> cc.toVo(taskNameMap)).collect(Collectors.toList());
    }

    private void checkWithdrawPermitThrowException(FlowInstance flowInstance) {
        if (this.flowBaseContextProperties.isSkipActionPermitCheckFlow()) {
            return;
        }
        List<FlowTask> flowTasks = this.flowTaskService.listRunningTasksForInstances(Collections.singletonList((Long)flowInstance.getId()));
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInstance.getFlowProjectId());
        for (FlowTask flowTask : flowTasks) {
            ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask, flowInstance.getFlowProjectId());
            if (!(Boolean.TRUE.equals(approvalNodeConfig.getUseGlobalStarterConfig()) ? !Boolean.TRUE.equals(globalConfig.getStarterRollback()) : !Boolean.TRUE.equals(approvalNodeConfig.getStarterRollback()))) continue;
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ROLLBACK_NOT_ALLOWED);
        }
    }

    public void adminSuspendFlowInstance(FlowInstanceAdminActionDto dto) {
        this.suspendFlowInstance((FlowInstanceActionDto)dto);
    }

    public void adminActiveFlowInstance(FlowInstanceAdminActionDto dto) {
        this.activeFlowInstance((FlowInstanceActionDto)dto);
    }

    private static interface MyInstanceVoFunction<T> {
        public T convertToVo(FlowInstanceWithCategory var1, Map<Long, List<FlowNode>> var2, Map<Long, List<FlowTask>> var3, Map<Long, List<FlowTask>> var4);
    }

    private static class FutureCalParams {
        private FlowInstance flowInstance;
        private FlowInstanceJumpInfoVo vo;
        private FlowExpressionExecutor expressionExecutor;
        private Map<String, List<JSONObject>> edgeOutMap;
        private Map<String, JSONObject> designNodeMap;
        private Set<String> handledNodes;
        private List<JumpNodeAssigneeInfo> needGetNameAssignees;
        private Boolean calFutureActualExecutor;

        private FutureCalParams() {
        }
    }
}

