/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.FlowModelApi;
import com.cyberway.mp.flow.api.model.dto.FlowModelCreateDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelDesignDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelModifyDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelPageDto;
import com.cyberway.mp.flow.api.model.enums.FlowModelStatus;
import com.cyberway.mp.flow.api.model.vo.FlowModelInfoVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelListVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelSimpleVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelStatusInfoVo;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.model.entity.SimpleFlowModel;
import com.cyberway.mp.flow.domain.model.entity.SimpleFlowModelWithCategoryName;
import com.cyberway.mp.flow.domain.model.repository.query.FlowModelWithCategoryNameQuery;
import com.cyberway.mp.flow.domain.model.service.FlowModelService;
import com.cyberway.mp.flow.domain.project.service.FlowProjectService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowModelApplicationService
implements FlowModelApi {
    private final FlowModelService flowModelService;
    private final FlowProjectService flowProjectService;

    public FlowModelApplicationService(FlowModelService flowModelService, FlowProjectService flowProjectService) {
        this.flowModelService = flowModelService;
        this.flowProjectService = flowProjectService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createModel(FlowModelCreateDto dto) {
        FlowModel flowModel = FlowModel.fromFlowModelCreateDto(dto);
        this.flowModelService.createFlowModel(flowModel);
        return (Long)flowModel.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public FlowModelStatusInfoVo modifyModel(FlowModelModifyDto dto) {
        boolean needNewVersion;
        boolean alreadyReleased;
        FlowModel flowModel = this.flowModelService.getFlowModel(dto.getId());
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        boolean changeCode = !dto.getCodeName().equals(flowModel.getCodeName());
        boolean changeName = !dto.getName().equals(flowModel.getName());
        boolean changeCategory = !dto.getFlowCategoryId().equals(flowModel.getFlowCategoryId());
        boolean bl = alreadyReleased = !CodeUtils.isEmptyId(flowModel.getFirstVersionId());
        if (alreadyReleased) {
            if (changeCode) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_MODEL_CANT_CHANGE_CODE);
            }
            if (changeName) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_MODEL_CANT_CHANGE_NAME);
            }
        }
        boolean bl2 = needNewVersion = alreadyReleased && changeCategory && !FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus());
        if (!needNewVersion) {
            if (changeCode && this.flowModelService.checkCodeExisted(dto.getCodeName())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CODE_ALREADY_EXISTED);
            }
            flowModel.update((FlowModelCreateDto)dto);
            this.flowModelService.modifyFlowModel(flowModel);
            return flowModel.toFlowModelStatusInfoVo();
        }
        FlowModel newVersionModel = FlowModel.fromOldVersion(flowModel);
        newVersionModel.update((FlowModelCreateDto)dto);
        this.flowModelService.createFlowModel(newVersionModel);
        return newVersionModel.toFlowModelStatusInfoVo();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public FlowModelStatusInfoVo saveModelDesign(FlowModelDesignDto dto) {
        FlowModel flowModel = this.flowModelService.getFlowModel(dto.getId());
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        if (FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus())) {
            flowModel.setDesignContent(dto.getDesignContent());
            flowModel.setImageBase64(dto.getImageBase64());
            this.flowModelService.modifyFlowModel(flowModel);
            return flowModel.toFlowModelStatusInfoVo();
        }
        FlowModel newVersionModel = FlowModel.fromOldVersion(flowModel);
        newVersionModel.setDesignContent(dto.getDesignContent());
        newVersionModel.setImageBase64(dto.getImageBase64());
        this.flowModelService.createFlowModel(newVersionModel);
        return newVersionModel.toFlowModelStatusInfoVo();
    }

    public String getModelDesign(long id) {
        FlowModel flowModel = this.flowModelService.getFlowModel(id);
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        return flowModel.getDesignContent();
    }

    public FlowModelInfoVo getModel(long id) {
        SimpleFlowModelWithCategoryName flowModel = this.flowModelService.getSimpleFlowModelWithCategoryName(id);
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        return flowModel.toFlowModelInfoVo();
    }

    public Page<FlowModelListVo> queryModel(FlowModelPageDto dto) {
        FlowModelWithCategoryNameQuery flowModelQuery = FlowModelWithCategoryNameQuery.fromFlowModelPageDto(dto);
        long count = this.flowModelService.countFlowModel(flowModelQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<SimpleFlowModelWithCategoryName> flowModels = this.flowModelService.pageQueryFlowModel(dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, flowModels.stream().map(SimpleFlowModelWithCategoryName::toFlowModelListVo).collect(Collectors.toList()));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void releaseModel(long id) {
        this.flowModelService.releaseFlowModel(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void enableModel(long id) {
        this.flowModelService.enableModel(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void disableModel(long id) {
        this.flowModelService.disableModel(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteModel(long id) {
        if (this.flowProjectService.checkUsedModel(id)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ALREADY_USED);
        }
        this.flowModelService.deleteFlowModel(id);
    }

    public List<FlowModelSimpleVo> listEnabledModelInCategory(long categoryId) {
        return this.flowModelService.listEnabledInCategory(categoryId).stream().map(SimpleFlowModel::toFlowModelSimpleVo).collect(Collectors.toList());
    }

    public FlowModelNodesVo loadModelNodes(long id) {
        FlowModel flowModel = this.flowModelService.getFlowModel(id);
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        if (FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DRAFT_MODEL_NOT_ALLOW_ACTION);
        }
        return (FlowModelNodesVo)JSON.parseObject((String)flowModel.getModelNodes(), FlowModelNodesVo.class);
    }
}

