/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.condition.vo.ConditionMatrixVo;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.dto.FlowModelCreateDto;
import com.cyberway.mp.flow.api.model.enums.FlowModelStatus;
import com.cyberway.mp.flow.api.project.FlowProjectApi;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.AutoCcActionConfig;
import com.cyberway.mp.flow.api.project.dto.BaseNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventConfigDto;
import com.cyberway.mp.flow.api.project.dto.FirstNodeFormFieldQueryDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleModifyDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundlePageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateBaseDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectModifyDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectPageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectTestDto;
import com.cyberway.mp.flow.api.project.dto.GatewayLineConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.InternalHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.ModifyEntityProjectDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.dto.NoticeConfigDto;
import com.cyberway.mp.flow.api.project.dto.NoticeTargetDto;
import com.cyberway.mp.flow.api.project.dto.NoticeUserDto;
import com.cyberway.mp.flow.api.project.enums.ActionCallType;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.project.enums.EventActionType;
import com.cyberway.mp.flow.api.project.enums.EventType;
import com.cyberway.mp.flow.api.project.enums.FlowProjectStatus;
import com.cyberway.mp.flow.api.project.enums.NoticeTargetType;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleVersionVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectFullInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectSimpleInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectStatusInfoVo;
import com.cyberway.mp.flow.api.task.vo.NodeFormFieldConfigVo;
import com.cyberway.mp.flow.domain.category.entity.FlowCategory;
import com.cyberway.mp.flow.domain.category.service.FlowCategoryService;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrix;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrixRule;
import com.cyberway.mp.flow.domain.condition.service.ConditionMatrixService;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.model.entity.FlowModelWithCategoryName;
import com.cyberway.mp.flow.domain.model.service.FlowModelService;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.entity.SimpleFlowProject;
import com.cyberway.mp.flow.domain.project.repository.query.SimpleFlowProjectQuery;
import com.cyberway.mp.flow.domain.project.service.FlowProjectService;
import com.cyberway.mp.flow.infra.dto.FlowProjectData;
import com.cyberway.mp.flow.infra.service.FlowDefinitionGenerateService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.FlowExpressionExecutor;
import com.cyberway.mp.flow.infra.service.RoleFieldAuthHelperService;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import com.cyberway.mp.flow.infra.util.FlowUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.spring.annotation.GlobalTransactional;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Validated
public class FlowProjectApplicationService
implements FlowProjectApi {
    private static final String NODE_ID = "id";
    private static final String NODE_SHAPE = "shape";
    private static final String NODE_CELL = "cell";
    private static final String NODE_TARGET = "target";
    private static final String NODE_EXCLUSIVE_GATEWAY = "exclusive-gateway";
    private static final String NODE_PARALLEL_GATEWAY = "parallel-gateway";
    private static final String NODE_APPROVAL = "node-approval";
    private static final String NODE_END = "node-end";
    private static final String NODE_DATA = "data";
    private static final String NODE_TEST_FAIL_MSG = "testFailMsg";
    private static final String NODE_TEST_STATUS = "testStatus";
    private static final String NODE_TEST_STATUS_RUN = "RUN";
    private static final String NODE_TEST_STATUS_ERR = "ERR";
    private static final String FIN_COLOR = "#86C166";
    private static final String ERR_COLOR = "#EC808D";
    private static final String TEST_FAIL_MULTI_OUT = "\u8282\u70b9\u5b58\u5728\u591a\u6761\u51fa\u53bb\u7684\u7ebf, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_PARALLEL_NOT_ENOUGH_IN = "\u5e76\u884c\u7f51\u5173\u7684\u8fdb\u5165\u7684\u7ebf\u4e2d\u6709\u672a\u7ecf\u8fc7\u7684\u7ebf, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_NO_OUT = "\u8282\u70b9\u6ca1\u6709\u51fa\u53bb\u7684\u7ebf, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_END_HAS_OUT = "\u7ed3\u675f\u8282\u70b9\u5b58\u5728\u51fa\u53bb\u7684\u7ebf, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_NO_GATEWAY_CONFIG = "\u7f51\u5173\u7f3a\u5c11\u6761\u4ef6\u914d\u7f6e, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_GATEWAY_SINGLE_LINE_CONFIG = "\u5355\u51fa\u53e3\u7f51\u5173\u4e0d\u80fd\u914d\u7f6e\u6761\u4ef6, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_LINE_NO_CONFIG = "\u7ebf\u672a\u914d\u7f6e\u6761\u4ef6, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_LINE_NO_MATCH = "\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u51fa\u53bb\u7684\u7ebf, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_LINE_NO_TARGET = "\u7ebf\u7f3a\u5c11\u6307\u5411\u76ee\u6807\u8282\u70b9, \u8bf7\u68c0\u67e5\u4fee\u6b63";
    private static final String TEST_FAIL_CYCLE = "\u6d41\u7a0b\u8d70\u5411\u51fa\u73b0\u5faa\u73af\u6216\u5e76\u884c\u4ea4\u53c9, \u65e0\u6cd5\u7ee7\u7eed\u6d4b\u8bd5, \u8bf7\u81ea\u884c\u786e\u8ba4\u6d41\u7a0b\u6b63\u786e";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowProjectService flowProjectService;
    private final FlowModelService flowModelService;
    private final FlowCategoryService flowCategoryService;
    private final FlowInstanceService flowInstanceService;
    private final FlowEngineService flowEngineService;
    private final ConditionMatrixService conditionMatrixService;
    private final RoleFieldAuthHelperService roleFieldAuthHelperService;
    private final UserHelperService userHelperService;
    private final ObjectMapper objectMapper;
    private final FlowDefinitionGenerateService flowDefinitionGenerateService;

    public FlowProjectApplicationService(FlowProjectService flowProjectService, FlowModelService flowModelService, FlowCategoryService flowCategoryService, FlowInstanceService flowInstanceService, FlowEngineService flowEngineService, ConditionMatrixService conditionMatrixService, RoleFieldAuthHelperService roleFieldAuthHelperService, UserHelperService userHelperService, ObjectMapper objectMapper, FlowDefinitionGenerateService flowDefinitionGenerateService) {
        this.flowProjectService = flowProjectService;
        this.flowModelService = flowModelService;
        this.flowCategoryService = flowCategoryService;
        this.flowInstanceService = flowInstanceService;
        this.flowEngineService = flowEngineService;
        this.conditionMatrixService = conditionMatrixService;
        this.roleFieldAuthHelperService = roleFieldAuthHelperService;
        this.userHelperService = userHelperService;
        this.objectMapper = objectMapper;
        this.flowDefinitionGenerateService = flowDefinitionGenerateService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createFlowProject(FlowProjectCreateDto dto) {
        this.validateFlowModel(dto.getFlowModelId());
        FlowProject flowProject = FlowProject.fromFlowProjectCreateDto(dto);
        this.flowProjectService.createFlowProject(flowProject, false);
        if (Boolean.TRUE.equals(dto.getRelease())) {
            this.flowProjectService.releaseFlowProject(flowProject);
        }
        return (Long)flowProject.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public FlowProjectStatusInfoVo modifyFlowProject(FlowProjectModifyDto dto) {
        this.validateFlowModel(dto.getFlowModelId());
        FlowProject flowProject = this.flowProjectService.getFlowProject(dto.getId());
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        boolean neverReleased = CodeUtils.isEmptyId(flowProject.getFirstVersionId());
        if (neverReleased) {
            if (!flowProject.getCodeName().equals(dto.getCodeName()) && this.flowProjectService.checkCodeExisted(dto.getCodeName())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_ALREADY_EXISTED);
            }
            return this.updateSameVersion(flowProject, dto);
        }
        if (!flowProject.getCodeName().equals(dto.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_CANT_CHANGE_CODE);
        }
        if (!flowProject.getName().equals(dto.getName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_CANT_CHANGE_NAME);
        }
        if (FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            return this.updateSameVersion(flowProject, dto);
        }
        FlowProject newFlowProject = FlowProject.fromOldVersion(flowProject);
        newFlowProject.update((FlowProjectCreateDto)dto);
        this.flowProjectService.createFlowProject(newFlowProject, false);
        if (Boolean.TRUE.equals(dto.getRelease())) {
            this.flowProjectService.releaseFlowProject(newFlowProject);
        }
        return newFlowProject.toFlowProjectStatusInfoVo();
    }

    private void validateFlowModel(Long flowModelId) {
        if (flowModelId == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        FlowModel flowModel = this.flowModelService.getFlowModel(flowModelId);
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        if (!FlowModelStatus.ENABLED.equals((Object)flowModel.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NOT_ENABLED);
        }
    }

    public FlowProjectFullInfoVo getFlowProjectFullInfo(long id) {
        FlowProject flowProject = this.flowProjectService.getFlowProject(id);
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        FlowModelWithCategoryName flowModel = this.flowModelService.getFlowModelWithCategoryName(flowProject.getFlowModelId());
        return flowProject.toFlowProjectFullInfoVo(flowModel);
    }

    public Page<FlowProjectListVo> queryFlowProject(FlowProjectPageDto dto) {
        SimpleFlowProjectQuery simpleFlowProjectQuery = SimpleFlowProjectQuery.fromFlowProjectPageDto(dto);
        long count = this.flowProjectService.countFlowProject(simpleFlowProjectQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<SimpleFlowProject> projects = this.flowProjectService.pageQueryFlowProject(simpleFlowProjectQuery, (PageParam)dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, projects.stream().map(SimpleFlowProject::toFlowProjectListVo).collect(Collectors.toList()));
    }

    public void export(List<Long> ids, HttpServletResponse response) {
        String exportStr = this.getExportData(ids);
        String exportFileName = "\u6d41\u7a0b\u65b9\u6848_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".flow";
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("content-type", "application/octet-stream");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(exportFileName, StandardCharsets.UTF_8));
            IOUtils.write((String)exportStr, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.logger.info("\u6d41\u7a0b\u65b9\u6848\u5bfc\u51fa\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_EXPORT_ERROR);
        }
        this.logger.info("\u6d41\u7a0b\u65b9\u6848\u5bfc\u51fa\u5b8c\u6bd5\uff1a{}", (Object)exportFileName);
    }

    public String getExportData(List<Long> ids) {
        List<FlowProject> flowProjects = this.flowProjectService.batchGetFlowProject(ids);
        Set<Long> modelIds = flowProjects.stream().map(FlowProject::getFlowModelId).collect(Collectors.toSet());
        List<FlowModel> flowModels = this.flowModelService.listByIds(modelIds);
        Set<Long> categoryIds = flowModels.stream().map(FlowModel::getFlowCategoryId).collect(Collectors.toSet());
        List<FlowCategory> flowCategories = this.flowCategoryService.batchGetRelationFlowCategory(categoryIds);
        if (CollectionUtils.isEmpty(flowCategories) || CollectionUtils.isEmpty(flowModels) || CollectionUtils.isEmpty(flowProjects)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_EXPORT_NOT_COMPLETE);
        }
        FlowProjectData flowProjectData = new FlowProjectData();
        this.sortFlowCategories(flowCategories);
        flowProjectData.setCategories(flowCategories);
        flowProjectData.setModels(flowModels);
        flowProjectData.setProjects(flowProjects);
        Set<Long> matrixIdSet = flowProjects.stream().map(FlowProject::getNodeConfigs).filter(StringUtils::isNotBlank).map(c -> (NodesConfigDto)JSON.parseObject((String)c, NodesConfigDto.class)).filter(c -> c.getApprovalNodes() != null && !c.getApprovalNodes().isEmpty()).flatMap(c -> c.getApprovalNodes().stream()).flatMap(a -> {
            HashSet<Long> matrixIds = new HashSet<Long>();
            if (Boolean.TRUE.equals(a.getUseConditionMatrix()) && a.getConditionMatrixId() != null) {
                matrixIds.add(a.getConditionMatrixId());
            }
            if (AssigneeType.CONDITION_MATRIX.equals((Object)a.getAssigneeType()) && a.getAssigneeConditionMatrixId() != null) {
                matrixIds.add(a.getAssigneeConditionMatrixId());
            }
            return matrixIds.stream();
        }).collect(Collectors.toSet());
        flowProjectData.setConditionMatrices(this.conditionMatrixService.batchGetConditionMatrix(matrixIdSet).stream().map(m -> {
            ConditionMatrixVo vo = m.toConditionMatrixVo();
            vo.setRules(this.conditionMatrixService.listConditionMatrixRules(vo.getId()).stream().map(ConditionMatrixRule::toConditionMatrixRuleDto).collect(Collectors.toList()));
            return vo;
        }).collect(Collectors.toList()));
        this.initExportMemberData(flowProjectData);
        return JSON.toJSONString((Object)flowProjectData);
    }

    private void initExportMemberData(FlowProjectData flowProjectData) {
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> roleIds = new HashSet<Long>();
        HashSet<Long> unitIds = new HashSet<Long>();
        HashSet<Long> dutyIds = new HashSet<Long>();
        flowProjectData.getProjects().forEach(project -> {
            if (StringUtils.isBlank((CharSequence)project.getNodeConfigs())) {
                return;
            }
            NodesConfigDto nodesConfigDto = (NodesConfigDto)JSON.parseObject((String)project.getNodeConfigs(), NodesConfigDto.class);
            this.initExportMemberDataGlobal(nodesConfigDto.getGlobal(), userIds, roleIds, unitIds, dutyIds);
            this.initExportMemberDataApprovalNodes(nodesConfigDto.getApprovalNodes(), userIds, roleIds, unitIds, dutyIds);
        });
        flowProjectData.setUserLoginNameMap(this.userHelperService.getUserLoginNameMap(userIds));
        flowProjectData.setRoleCodeMap(this.userHelperService.getRoleCodeMap(roleIds));
        flowProjectData.setOrgUnitCodeMap(this.userHelperService.getOrgUnitCodeMap(unitIds));
        flowProjectData.setDutyCodeMap(this.userHelperService.getDutyCodeMap(dutyIds));
    }

    private void initExportMemberDataApprovalNodes(List<ApprovalNodeConfigDto> approvalNodes, Set<Long> userIds, Set<Long> roleIds, Set<Long> unitIds, Set<Long> dutyIds) {
        if (approvalNodes == null || approvalNodes.isEmpty()) {
            return;
        }
        approvalNodes.forEach(approvalNode -> this.initExportMemberDataApprovalNode((ApprovalNodeConfigDto)approvalNode, userIds, roleIds, unitIds, dutyIds));
    }

    private void initExportMemberDataApprovalNode(ApprovalNodeConfigDto approvalNode, Set<Long> userIds, Set<Long> roleIds, Set<Long> unitIds, Set<Long> dutyIds) {
        this.initExportMemberDataNotice(approvalNode.getNotices(), userIds, roleIds);
        this.initExportMemberDataEvent(approvalNode.getEvents(), userIds, roleIds, unitIds, dutyIds);
        this.initExportMemberDataAssignee(approvalNode.getAssigneeType(), approvalNode.getAssignees(), userIds, roleIds, unitIds, dutyIds);
        this.initExportMemberDataUser(approvalNode.getAllowTransferUsers(), userIds);
        this.initExportMemberDataUser(approvalNode.getAllowCcUsers(), userIds);
        this.initExportMemberDataUser(approvalNode.getAllowAddSignUsers(), userIds);
        this.initExportMemberDataUser(approvalNode.getAllowAddNodeUsers(), userIds);
        this.initExportMemberDataAssignee(approvalNode.getAuditMailCcUserType(), approvalNode.getAuditMailCcUsers(), userIds, roleIds, unitIds, dutyIds);
    }

    private void initExportMemberDataUser(List<IdNameDto> allowTransferUsers, Set<Long> userIds) {
        if (allowTransferUsers == null || allowTransferUsers.isEmpty()) {
            return;
        }
        allowTransferUsers.stream().map(IdNameDto::getId).filter(Objects::nonNull).forEach(userIds::add);
    }

    private void initExportMemberDataAssignee(AssigneeType assigneeType, List<IdNameDto> assignees, Set<Long> userIds, Set<Long> roleIds, Set<Long> unitIds, Set<Long> dutyIds) {
        if (assignees == null || assignees.isEmpty()) {
            return;
        }
        switch (assigneeType) {
            case USER: {
                assignees.forEach(assignee -> userIds.add(assignee.getId()));
                break;
            }
            case ROLE: {
                assignees.forEach(assignee -> roleIds.add(assignee.getId()));
                break;
            }
            case DUTY: {
                assignees.forEach(assignee -> dutyIds.add(assignee.getId()));
                break;
            }
            case ORG_UNIT: {
                assignees.forEach(assignee -> unitIds.add(assignee.getId()));
                break;
            }
        }
    }

    private void initExportMemberDataGlobal(GlobalConfigDto global, Set<Long> userIds, Set<Long> roleIds, Set<Long> unitIds, Set<Long> dutyIds) {
        if (global == null) {
            return;
        }
        if (global.getNoticeSpecialUsers() != null) {
            global.getNoticeSpecialUsers().stream().map(IdNameDto::getId).forEach(userIds::add);
        }
        this.initExportMemberDataEvent(global.getEvents(), userIds, roleIds, unitIds, dutyIds);
        this.initExportMemberDataNotice(global.getNotices(), userIds, roleIds);
    }

    private void initExportMemberDataNotice(List<NoticeConfigDto> notices, Set<Long> userIds, Set<Long> roleIds) {
        if (notices == null || notices.isEmpty()) {
            return;
        }
        notices.forEach(notice -> {
            if (notice.getNoticeTargets() == null || notice.getNoticeTargets().isEmpty()) {
                return;
            }
            notice.getNoticeTargets().stream().filter(target -> target.getId() != null).forEach(target -> {
                if (NoticeTargetType.USER.equals((Object)target.getType())) {
                    userIds.add(target.getId());
                } else if (NoticeTargetType.ROLE.equals((Object)target.getType())) {
                    roleIds.add(target.getId());
                }
            });
        });
    }

    private void initExportMemberDataEvent(List<EventConfigDto> events, Set<Long> userIds, Set<Long> roleIds, Set<Long> unitIds, Set<Long> dutyIds) {
        if (events == null || events.isEmpty()) {
            return;
        }
        events.forEach(event -> {
            AutoCcActionConfig autoCcActionConfig = event.getAutoCcActionConfig();
            if (autoCcActionConfig == null) {
                return;
            }
            if (autoCcActionConfig.getAssigneeType() == null || autoCcActionConfig.getNoticeTargets() == null || autoCcActionConfig.getNoticeTargets().isEmpty()) {
                return;
            }
            switch (autoCcActionConfig.getAssigneeType()) {
                case USER: {
                    autoCcActionConfig.getNoticeTargets().stream().map(NoticeUserDto::getId).filter(Objects::nonNull).forEach(userIds::add);
                    break;
                }
                case ROLE: {
                    autoCcActionConfig.getNoticeTargets().stream().map(NoticeUserDto::getId).filter(Objects::nonNull).forEach(roleIds::add);
                    break;
                }
                case DUTY: {
                    autoCcActionConfig.getNoticeTargets().stream().map(NoticeUserDto::getId).filter(Objects::nonNull).forEach(dutyIds::add);
                    break;
                }
                case ORG_UNIT: {
                    autoCcActionConfig.getNoticeTargets().stream().map(NoticeUserDto::getId).filter(Objects::nonNull).forEach(unitIds::add);
                    break;
                }
            }
        });
    }

    private void sortFlowCategories(List<FlowCategory> flowCategories) {
        ArrayList<FlowCategory> result = new ArrayList<FlowCategory>();
        HashMap<Long, List<FlowCategory>> childrenMap = new HashMap<Long, List<FlowCategory>>(16);
        for (FlowCategory category : flowCategories) {
            if (CodeUtils.isEmptyId(category.getParentId())) {
                result.add(category);
                continue;
            }
            childrenMap.computeIfAbsent(category.getParentId(), k -> new ArrayList()).add(category);
        }
        if (childrenMap.isEmpty()) {
            return;
        }
        int rootSize = result.size();
        for (int i = 0; i < rootSize; ++i) {
            FlowCategory category = (FlowCategory)((Object)result.get(i));
            this.addCategoryChildren(result, childrenMap, category);
        }
        flowCategories.clear();
        flowCategories.addAll(result);
    }

    private void addCategoryChildren(List<FlowCategory> result, Map<Long, List<FlowCategory>> childrenMap, FlowCategory category) {
        if (childrenMap.containsKey(category.getId())) {
            List<FlowCategory> children = childrenMap.remove(category.getId());
            for (FlowCategory child : children) {
                result.add(child);
                this.addCategoryChildren(result, childrenMap, child);
            }
        }
    }

    public void importFlowProject(MultipartFile file) {
        try {
            String flowProjectData = new String(file.getBytes(), StandardCharsets.UTF_8);
            this.doImportFlowProject(flowProjectData);
        }
        catch (IOException e) {
            this.logger.info("\u6d41\u7a0b\u65b9\u6848\u5bfc\u5165\u89e3\u6790\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_IMPORT_ERROR);
        }
    }

    private void doImportFlowProject(String flowProjectDataString) {
        FlowProjectData flowProjectData = (FlowProjectData)JSON.parseObject((String)flowProjectDataString, FlowProjectData.class);
        ImportIdData importIdData = this.buildImportIdData(flowProjectData);
        Map<Long, Long> categoryIdMap = this.importCategories(flowProjectData.getCategories());
        Map<Long, Long> modelIdMap = this.importModels(flowProjectData.getModels(), categoryIdMap);
        Map<Long, Long> conditionMatrixIdMap = this.importConditionMatrix(flowProjectData.getConditionMatrices());
        this.importProjects(flowProjectData.getProjects(), modelIdMap, conditionMatrixIdMap, importIdData);
    }

    private ImportIdData buildImportIdData(FlowProjectData flowProjectData) {
        ImportIdData importIdData = new ImportIdData();
        importIdData.userIdMap = this.buildImportIdDataUser(flowProjectData.getUserLoginNameMap());
        importIdData.roleIdMap = this.buildImportIdDataRole(flowProjectData.getRoleCodeMap());
        importIdData.unitIdMap = this.buildImportIdDataUnit(flowProjectData.getOrgUnitCodeMap());
        importIdData.dutyIdMap = this.buildImportIdDataDuty(flowProjectData.getDutyCodeMap());
        return importIdData;
    }

    private Map<Long, Long> buildImportIdDataUser(Map<Long, String> userLoginNameMap) {
        if (userLoginNameMap == null || userLoginNameMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Long> idMap = this.userHelperService.getUserLoginNameIdMap(userLoginNameMap.values());
        return this.buildImportIdDataResultMap(userLoginNameMap, idMap);
    }

    private Map<Long, Long> buildImportIdDataResultMap(Map<Long, String> codeMap, Map<String, Long> idMap) {
        if (idMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = MapUtil.newHashMap((int)idMap.size());
        codeMap.forEach((k, v) -> {
            if (idMap.containsKey(v)) {
                result.put(k, (Long)idMap.get(v));
            }
        });
        return result;
    }

    private Map<Long, Long> buildImportIdDataRole(Map<Long, String> roleCodeMap) {
        if (roleCodeMap == null || roleCodeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Long> idMap = this.userHelperService.getRoleCodeIdMap(roleCodeMap.values());
        return this.buildImportIdDataResultMap(roleCodeMap, idMap);
    }

    private Map<Long, Long> buildImportIdDataUnit(Map<Long, String> orgUnitCodeMap) {
        if (orgUnitCodeMap == null || orgUnitCodeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Long> idMap = this.userHelperService.getOrgUnitCodeIdMap(orgUnitCodeMap.values());
        return this.buildImportIdDataResultMap(orgUnitCodeMap, idMap);
    }

    private Map<Long, Long> buildImportIdDataDuty(Map<Long, String> dutyCodeMap) {
        if (dutyCodeMap == null || dutyCodeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Long> idMap = this.userHelperService.getDutyCodeIdMap(dutyCodeMap.values());
        return this.buildImportIdDataResultMap(dutyCodeMap, idMap);
    }

    private Map<Long, Long> importConditionMatrix(List<ConditionMatrixVo> conditionMatrices) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        if (conditionMatrices == null) {
            return result;
        }
        conditionMatrices.forEach(matrix -> {
            ConditionMatrix existedMatrix = this.conditionMatrixService.getConditionMatrixByCode(matrix.getMatrixCode());
            if (existedMatrix != null) {
                result.put(matrix.getId(), (Long)existedMatrix.getId());
                return;
            }
            ConditionMatrix conditionMatrix = ConditionMatrix.fromConditionMatrixVo(matrix);
            this.conditionMatrixService.saveConditionMatrix(conditionMatrix, matrix.getRules().stream().map(ConditionMatrixRule::fromConditionMatrixRuleDto).collect(Collectors.toList()));
            result.put(matrix.getId(), (Long)conditionMatrix.getId());
        });
        return result;
    }

    private Map<Long, Long> importCategories(List<FlowCategory> categories) {
        HashMap idMap = MapUtil.newHashMap((int)categories.size());
        for (FlowCategory category : categories) {
            boolean hasParentId;
            Long oldId = (Long)category.getId();
            Long oldParentId = category.getParentId();
            FlowCategory existedCategory = this.flowCategoryService.getByCodeName(category.getCodeName());
            if (existedCategory != null) {
                existedCategory.setName(category.getName());
                existedCategory.setDescription(category.getDescription());
                this.flowCategoryService.updateFlowCategory(existedCategory);
                idMap.put(oldId, (Long)existedCategory.getId());
                continue;
            }
            this.cleanNotImportDate(category);
            boolean bl = hasParentId = !CodeUtils.isEmptyId(oldParentId);
            if (hasParentId && !idMap.containsKey(oldParentId)) {
                this.logger.error("\u5bfc\u5165\u5931\u8d25: \u7236ID[{}]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u65b0ID", (Object)oldParentId);
                throw new BaseI18nException((ErrorCode)FlowErrorCode.PARENT_CATEGORY_NOT_EXISTED);
            }
            if (hasParentId) {
                category.setParentId((Long)idMap.get(oldParentId));
            }
            this.flowCategoryService.createFlowCategory(category);
            idMap.put(oldId, (Long)category.getId());
        }
        return idMap;
    }

    private Map<Long, Long> importModels(List<FlowModel> models, Map<Long, Long> categoryIdMap) {
        HashMap idMap = MapUtil.newHashMap((int)models.size());
        for (FlowModel model : models) {
            Long oldId = (Long)model.getId();
            this.cleanNotImportDate(model);
            model.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
            model.setStatus(FlowModelStatus.DRAFT);
            model.setFlowCategoryId(categoryIdMap.get(model.getFlowCategoryId()));
            FlowModel existedModel = this.flowModelService.getLastVersionByCodeName(model.getCodeName());
            if (existedModel != null) {
                model.setBaseModelId((Long)existedModel.getId());
                model.setFirstVersionId(CodeUtils.isEmptyId(existedModel.getFirstVersionId()) ? FlowConstant.EMPTY_ID_VALUE : existedModel.getFirstVersionId());
            } else {
                model.setBaseModelId(FlowConstant.EMPTY_ID_VALUE);
                model.setFirstVersionId(FlowConstant.EMPTY_ID_VALUE);
            }
            this.flowModelService.createFlowModel(model);
            idMap.put(oldId, (Long)model.getId());
        }
        return idMap;
    }

    private void importProjects(List<FlowProject> projects, Map<Long, Long> modelIdMap, Map<Long, Long> conditionMatrixIdMap, ImportIdData importIdData) {
        for (FlowProject project : projects) {
            this.cleanNotImportDate(project);
            project.setStatus(FlowProjectStatus.DRAFT);
            project.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
            project.setFlowModelId(modelIdMap.get(project.getFlowModelId()));
            project.setDefinitionId("");
            FlowProject existedProject = this.flowProjectService.getLastVersionFlowProject(project.getCodeName());
            if (existedProject != null && CodeUtils.isEmptyId(existedProject.getFirstVersionId())) {
                this.logger.error("\u5bfc\u5165\u6d41\u7a0b\u65b9\u6848\u7684\u7f16\u7801[{}]\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u65b9\u6848[id:{}]\u4e14\u6ca1\u6709\u9996\u7248\u672cid", (Object)project.getCodeName(), (Object)existedProject.getId());
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_ALREADY_EXISTED);
            }
            if (existedProject != null) {
                project.setBaseProjectId((Long)existedProject.getId());
                project.setFirstVersionId(existedProject.getFirstVersionId());
            } else {
                project.setBaseProjectId(FlowConstant.EMPTY_ID_VALUE);
                project.setFirstVersionId(FlowConstant.EMPTY_ID_VALUE);
            }
            this.fixImportNodesConfig(conditionMatrixIdMap, project, importIdData);
            this.flowProjectService.createFlowProject(project, false);
        }
    }

    private void fixImportNodesConfig(Map<Long, Long> conditionMatrixIdMap, FlowProject project, ImportIdData importIdData) {
        if (StringUtils.isBlank((CharSequence)project.getNodeConfigs())) {
            return;
        }
        boolean changed = false;
        NodesConfigDto nodesConfigDto = (NodesConfigDto)JSON.parseObject((String)project.getNodeConfigs(), NodesConfigDto.class);
        if (!conditionMatrixIdMap.isEmpty() && nodesConfigDto.getApprovalNodes() != null) {
            nodesConfigDto.getApprovalNodes().forEach(a -> {
                a.setConditionMatrixId(conditionMatrixIdMap.getOrDefault(a.getConditionMatrixId(), a.getConditionMatrixId()));
                a.setAssigneeConditionMatrixId(conditionMatrixIdMap.getOrDefault(a.getAssigneeConditionMatrixId(), a.getAssigneeConditionMatrixId()));
            });
            changed = true;
        }
        boolean bl = changed = this.fixImportDataIds(nodesConfigDto, importIdData) || changed;
        if (changed) {
            project.setNodeConfigs(JSON.toJSONString((Object)nodesConfigDto));
        }
    }

    private boolean fixImportDataIds(NodesConfigDto nodesConfigDto, ImportIdData importIdData) {
        if (importIdData.userIdMap.isEmpty() && importIdData.roleIdMap.isEmpty() && importIdData.unitIdMap.isEmpty() && importIdData.dutyIdMap.isEmpty()) {
            return false;
        }
        this.fixImportDataIdsGlobal(nodesConfigDto.getGlobal(), importIdData);
        this.fixImportDataIdsApprovalNodes(nodesConfigDto.getApprovalNodes(), importIdData);
        return true;
    }

    private void changeImportDataId(Map<Long, Long> idMap, Supplier<Long> idGetter, Consumer<Long> idSetter) {
        if (idMap.isEmpty()) {
            return;
        }
        Long id = idGetter.get();
        if (id == null || !idMap.containsKey(id)) {
            return;
        }
        idSetter.accept(idMap.get(id));
    }

    private void fixImportDataIdsGlobal(GlobalConfigDto global, ImportIdData importIdData) {
        if (global == null) {
            return;
        }
        if (global.getNoticeSpecialUsers() != null) {
            global.getNoticeSpecialUsers().forEach(user -> this.changeImportDataId(importIdData.userIdMap, () -> ((IdNameDto)user).getId(), arg_0 -> ((IdNameDto)user).setId(arg_0)));
        }
        this.fixImportDataIdsEvent(global.getEvents(), importIdData);
        this.fixImportDataIdsNotice(global.getNotices(), importIdData);
    }

    private void fixImportDataIdsApprovalNodes(List<ApprovalNodeConfigDto> approvalNodes, ImportIdData importIdData) {
        if (approvalNodes == null || approvalNodes.isEmpty()) {
            return;
        }
        approvalNodes.forEach(approvalNode -> this.fixImportDataIdsApprovalNode((ApprovalNodeConfigDto)approvalNode, importIdData));
    }

    private void fixImportDataIdsApprovalNode(ApprovalNodeConfigDto approvalNode, ImportIdData importIdData) {
        this.fixImportDataIdsNotice(approvalNode.getNotices(), importIdData);
        this.fixImportDataIdsEvent(approvalNode.getEvents(), importIdData);
        this.fixImportDataIdsAssignee(approvalNode.getAssigneeType(), approvalNode.getAssignees(), importIdData);
        this.fixImportDataIdsUser(approvalNode.getAllowTransferUsers(), importIdData);
        this.fixImportDataIdsUser(approvalNode.getAllowCcUsers(), importIdData);
        this.fixImportDataIdsUser(approvalNode.getAllowAddSignUsers(), importIdData);
        this.fixImportDataIdsUser(approvalNode.getAllowAddNodeUsers(), importIdData);
        this.fixImportDataIdsAssignee(approvalNode.getAuditMailCcUserType(), approvalNode.getAuditMailCcUsers(), importIdData);
    }

    private void fixImportDataIdsAssignee(AssigneeType assigneeType, List<IdNameDto> assignees, ImportIdData importIdData) {
        if (assignees == null || assignees.isEmpty()) {
            return;
        }
        switch (assigneeType) {
            case USER: {
                assignees.forEach(assignee -> this.changeImportDataId(importIdData.userIdMap, () -> ((IdNameDto)assignee).getId(), arg_0 -> ((IdNameDto)assignee).setId(arg_0)));
                break;
            }
            case ROLE: {
                assignees.forEach(assignee -> this.changeImportDataId(importIdData.roleIdMap, () -> ((IdNameDto)assignee).getId(), arg_0 -> ((IdNameDto)assignee).setId(arg_0)));
                break;
            }
            case DUTY: {
                assignees.forEach(assignee -> this.changeImportDataId(importIdData.dutyIdMap, () -> ((IdNameDto)assignee).getId(), arg_0 -> ((IdNameDto)assignee).setId(arg_0)));
                break;
            }
            case ORG_UNIT: {
                assignees.forEach(assignee -> this.changeImportDataId(importIdData.unitIdMap, () -> ((IdNameDto)assignee).getId(), arg_0 -> ((IdNameDto)assignee).setId(arg_0)));
                break;
            }
        }
    }

    private void fixImportDataIdsUser(List<IdNameDto> allowTransferUsers, ImportIdData importIdData) {
        if (allowTransferUsers == null || allowTransferUsers.isEmpty()) {
            return;
        }
        allowTransferUsers.forEach(user -> this.changeImportDataId(importIdData.userIdMap, () -> ((IdNameDto)user).getId(), arg_0 -> ((IdNameDto)user).setId(arg_0)));
    }

    private void fixImportDataIdsEvent(List<EventConfigDto> events, ImportIdData importIdData) {
        if (events == null || events.isEmpty()) {
            return;
        }
        events.forEach(event -> {
            AutoCcActionConfig autoCcActionConfig = event.getAutoCcActionConfig();
            if (autoCcActionConfig == null) {
                return;
            }
            if (autoCcActionConfig.getAssigneeType() == null || autoCcActionConfig.getNoticeTargets() == null || autoCcActionConfig.getNoticeTargets().isEmpty()) {
                return;
            }
            switch (autoCcActionConfig.getAssigneeType()) {
                case USER: {
                    autoCcActionConfig.getNoticeTargets().forEach(target -> this.changeImportDataId(importIdData.userIdMap, () -> ((NoticeUserDto)target).getId(), arg_0 -> ((NoticeUserDto)target).setId(arg_0)));
                    break;
                }
                case ROLE: {
                    autoCcActionConfig.getNoticeTargets().forEach(target -> this.changeImportDataId(importIdData.roleIdMap, () -> ((NoticeUserDto)target).getId(), arg_0 -> ((NoticeUserDto)target).setId(arg_0)));
                    break;
                }
                case DUTY: {
                    autoCcActionConfig.getNoticeTargets().forEach(target -> this.changeImportDataId(importIdData.dutyIdMap, () -> ((NoticeUserDto)target).getId(), arg_0 -> ((NoticeUserDto)target).setId(arg_0)));
                    break;
                }
                case ORG_UNIT: {
                    autoCcActionConfig.getNoticeTargets().forEach(target -> this.changeImportDataId(importIdData.unitIdMap, () -> ((NoticeUserDto)target).getId(), arg_0 -> ((NoticeUserDto)target).setId(arg_0)));
                    break;
                }
            }
        });
    }

    private void fixImportDataIdsNotice(List<NoticeConfigDto> notices, ImportIdData importIdData) {
        if (notices == null || notices.isEmpty()) {
            return;
        }
        notices.forEach(notice -> {
            if (notice.getNoticeTargets() == null || notice.getNoticeTargets().isEmpty()) {
                return;
            }
            notice.getNoticeTargets().forEach(target -> {
                if (NoticeTargetType.USER.equals((Object)target.getType())) {
                    this.changeImportDataId(importIdData.userIdMap, () -> ((NoticeTargetDto)target).getId(), arg_0 -> ((NoticeTargetDto)target).setId(arg_0));
                } else if (NoticeTargetType.ROLE.equals((Object)target.getType())) {
                    this.changeImportDataId(importIdData.roleIdMap, () -> ((NoticeTargetDto)target).getId(), arg_0 -> ((NoticeTargetDto)target).setId(arg_0));
                }
            });
        });
    }

    private void cleanNotImportDate(BusinessEntityWithAppInstance entity) {
        entity.setId(null);
        entity.setAppInstanceId(null);
        entity.setBusinessZoneId(null);
        entity.setTenantId(null);
        entity.setCreatedTime(null);
        entity.setCreatedUserId(null);
        entity.setCreatedUserName(null);
        entity.setLastModifiedTime(null);
        entity.setLastModifiedUserId(null);
        entity.setLastModifiedUserName(null);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void enableFlowProject(long id) {
        this.flowProjectService.enableFlowProject(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void disableFlowProject(long id) {
        this.flowProjectService.disableFlowProject(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteFlowProject(long id) {
        this.flowProjectService.deleteFlowProject(id);
    }

    public void releaseFlowProject(long id) {
        FlowProject flowProject = this.flowProjectService.getFlowProject(id);
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        if (!FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_NOT_ALLOW_ACTION);
        }
        this.flowProjectService.releaseFlowProject(flowProject);
    }

    private FlowProjectStatusInfoVo updateSameVersion(FlowProject flowProject, FlowProjectModifyDto dto) {
        flowProject.update((FlowProjectCreateDto)dto);
        this.flowProjectService.modifyFlowProject(flowProject);
        if (Boolean.TRUE.equals(dto.getRelease())) {
            this.flowProjectService.releaseFlowProject(flowProject);
        }
        return flowProject.toFlowProjectStatusInfoVo();
    }

    public List<IdNameVo> listEnabledFirstVersion() {
        return this.flowProjectService.listEnabledFirstVersion(ServiceContext.getContext().getRequestTenantId());
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyProjectForMetadataEntity(List<ModifyEntityProjectDto> dtoList) {
        dtoList.forEach(this::modifyProjectForMetadataEntity);
    }

    private void modifyProjectForMetadataEntity(ModifyEntityProjectDto dto) {
        Optional<EventConfigDto> event;
        NodesConfigDto nodesConfigDto;
        ArrayList<EventConfigDto> events;
        String editFormUrl;
        boolean needNewDraft;
        FlowProject flowProject = this.flowProjectService.findDraftOrEnabled(dto.getFlowProjectCode());
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_NOT_EXISTED);
        }
        boolean bl = needNewDraft = !FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus());
        if (needNewDraft) {
            flowProject = FlowProject.fromOldVersion(flowProject);
        }
        boolean hasChange = false;
        if (!dto.getFormUrl().equals(flowProject.getFormUrl())) {
            flowProject.setFormUrl(dto.getFormUrl());
            hasChange = true;
        }
        if (!(editFormUrl = StringUtils.defaultString((String)dto.getEditFormUrl())).equals(flowProject.getEditFormUrl())) {
            flowProject.setEditFormUrl(editFormUrl);
            hasChange = true;
        }
        if ((events = (nodesConfigDto = (NodesConfigDto)JSON.parseObject((String)flowProject.getNodeConfigs(), NodesConfigDto.class)).getGlobal().getEvents()) == null) {
            events = new ArrayList<EventConfigDto>();
            nodesConfigDto.getGlobal().setEvents(events);
        }
        if ((event = events.stream().filter(e -> this.isMetadataEntityEvent((EventConfigDto)e, dto)).findFirst()).isEmpty()) {
            EventConfigDto eventConfigDto = new EventConfigDto();
            eventConfigDto.setActionType(EventActionType.INTERNAL_HTTP);
            eventConfigDto.setName("\u5143\u6570\u636e\u5b9e\u4f53\u6d41\u7a0b\u529e\u7ed3\u56de\u8c03");
            eventConfigDto.setCallType(ActionCallType.ASYNC);
            InternalHttpActionConfigDto actionConfig = new InternalHttpActionConfigDto();
            actionConfig.setApiPath(dto.getCallbackApiPath());
            actionConfig.setServiceName(dto.getCenterRegisterName());
            actionConfig.setHttpMethod(dto.getHttpActionHttpMethod());
            actionConfig.setSendVariablesJson(Boolean.valueOf(true));
            eventConfigDto.setInternalHttpActionConfig(actionConfig);
            eventConfigDto.setType(EventType.FLOW_COMPLETE);
            events.add(eventConfigDto);
            flowProject.setNodeConfigs(JSON.toJSONString((Object)nodesConfigDto));
            hasChange = true;
        }
        if (hasChange || !needNewDraft) {
            if (needNewDraft) {
                this.flowProjectService.createFlowProject(flowProject, false);
            } else if (hasChange) {
                this.flowProjectService.modifyFlowProject(flowProject);
            }
            if (Boolean.TRUE.equals(dto.getAutoRelease())) {
                this.flowProjectService.releaseFlowProject(flowProject);
            }
        }
    }

    private boolean isMetadataEntityEvent(EventConfigDto eventConfigDto, ModifyEntityProjectDto dto) {
        if (!EventActionType.INTERNAL_HTTP.equals((Object)eventConfigDto.getActionType())) {
            return false;
        }
        InternalHttpActionConfigDto actionConfig = eventConfigDto.getInternalHttpActionConfig();
        return dto.getCallbackApiPath().equals(actionConfig.getApiPath()) && dto.getCenterRegisterName().equals(actionConfig.getServiceName()) && dto.getHttpActionHttpMethod().equals((Object)actionConfig.getHttpMethod());
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long bundleCreateFlowProject(FlowProjectBundleCreateDto dto) {
        if (this.flowProjectService.checkCodeExisted(dto.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_ALREADY_EXISTED);
        }
        if (this.flowModelService.checkCodeExisted(dto.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CODE_ALREADY_EXISTED);
        }
        FlowModelCreateDto flowModelCreateDto = new FlowModelCreateDto();
        flowModelCreateDto.setCodeName(dto.getCodeName());
        flowModelCreateDto.setName(dto.getName());
        flowModelCreateDto.setFlowCategoryId(dto.getFlowCategoryId());
        flowModelCreateDto.setDescription(dto.getDescription());
        FlowModel flowModel = FlowModel.fromFlowModelCreateDto(flowModelCreateDto);
        flowModel.setDesignContent(dto.getDesignContent());
        flowModel.setImageBase64(dto.getImageBase64());
        this.flowModelService.createFlowModel(flowModel);
        FlowProject flowProject = FlowProject.fromFlowProjectBundleCreateDto(dto);
        flowProject.setFlowModelId((Long)flowModel.getId());
        this.flowProjectService.createFlowProject(flowProject, false);
        if (Boolean.TRUE.equals(dto.getRelease())) {
            this.flowProjectService.releaseFlowProject(flowProject);
        }
        return (Long)flowProject.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public FlowProjectStatusInfoVo bundleModifyFlowProject(FlowProjectBundleModifyDto dto) {
        boolean changeCodeName;
        FlowProject flowProject = this.flowProjectService.getFlowProject(dto.getId());
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        FlowModel flowModel = this.flowModelService.getFlowModel(flowProject.getFlowModelId());
        boolean neverReleased = CodeUtils.isEmptyId(flowProject.getFirstVersionId());
        boolean bl = changeCodeName = !flowProject.getCodeName().equals(dto.getCodeName());
        if (!neverReleased && changeCodeName) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_CANT_CHANGE_CODE);
        }
        if (neverReleased && changeCodeName && this.flowProjectService.checkCodeExisted(dto.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_ALREADY_EXISTED);
        }
        boolean modifyModel = this.modifyModel(flowModel, dto);
        if (!FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            flowProject = FlowProject.fromOldVersion(flowProject);
        }
        if (!FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus()) && modifyModel) {
            flowModel = FlowModel.fromOldVersion(flowModel);
        }
        if (modifyModel) {
            flowModel.setCodeName(dto.getCodeName());
            flowModel.setName(dto.getName());
            flowModel.setDescription(dto.getDescription());
            flowModel.setFlowCategoryId(dto.getFlowCategoryId());
            flowModel.setDesignContent(dto.getDesignContent());
            flowModel.setImageBase64(dto.getImageBase64());
            if (flowModel.getId() == null) {
                this.flowModelService.createFlowModel(flowModel);
                flowProject.setFlowModelId((Long)flowModel.getId());
            } else {
                this.flowModelService.modifyFlowModel(flowModel);
            }
        }
        flowProject.updateByFlowProjectCreateBaseDto((FlowProjectCreateBaseDto)dto);
        if (flowProject.getId() == null) {
            this.flowProjectService.createFlowProject(flowProject, false);
        } else {
            this.flowProjectService.modifyFlowProject(flowProject);
        }
        if (Boolean.TRUE.equals(dto.getRelease())) {
            this.flowProjectService.releaseFlowProject(flowProject);
        }
        return flowProject.toFlowProjectStatusInfoVo();
    }

    public Page<FlowProjectBundleListVo> bundleQueryFlowProject(FlowProjectBundlePageDto dto) {
        SimpleFlowProjectQuery simpleFlowProjectQuery = SimpleFlowProjectQuery.fromFlowProjectBundlePageDto(dto);
        long count = this.flowProjectService.countFlowProject(simpleFlowProjectQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<SimpleFlowProject> projects = this.flowProjectService.pageQueryFlowProject(simpleFlowProjectQuery, (PageParam)dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, projects.stream().map(SimpleFlowProject::toFlowProjectBundleListVo).collect(Collectors.toList()));
    }

    public List<FlowProjectBundleVersionVo> bundleListFlowProjectVersions(long id) {
        if (CodeUtils.isEmptyId(id)) {
            return Collections.emptyList();
        }
        FlowProject flowProject = this.flowProjectService.getFlowProject(id);
        SimpleFlowProjectQuery query = new SimpleFlowProjectQuery();
        if (flowProject == null) {
            query.setFirstVersionId(id);
        } else if (CodeUtils.isEmptyId(flowProject.getFirstVersionId())) {
            query.setId(id);
        } else {
            query.setFirstVersionId(flowProject.getFirstVersionId());
        }
        query.setOrderFragment(new OrderFragment("p.created_time", "DESC"));
        List<SimpleFlowProject> list = this.flowProjectService.listFlowProject(query);
        return list.stream().map(SimpleFlowProject::toFlowProjectBundleVersionVo).collect(Collectors.toList());
    }

    public List<FlowProjectBundleVersionVo> bundleListFlowProjectVersionsByCode(String code) {
        SimpleFlowProjectQuery query = new SimpleFlowProjectQuery();
        query.setCodeNameEq(code);
        query.setOrderFragment(new OrderFragment("p.created_time", "DESC"));
        List<SimpleFlowProject> list = this.flowProjectService.listFlowProject(query);
        return list.stream().map(SimpleFlowProject::toFlowProjectBundleVersionVo).collect(Collectors.toList());
    }

    private boolean modifyModel(FlowModel flowModel, FlowProjectBundleModifyDto dto) {
        return !flowModel.getFlowCategoryId().equals(dto.getFlowCategoryId()) || !flowModel.getDesignContent().equals(dto.getDesignContent()) || !flowModel.getImageBase64().equals(dto.getImageBase64()) || !flowModel.getName().equals(dto.getName()) || !flowModel.getDescription().equals(StringUtils.defaultString((String)dto.getDescription()));
    }

    public NodeFormFieldConfigVo loadFirstNodeFormFieldConfig(FirstNodeFormFieldQueryDto dto) {
        FlowInstance flowInstance;
        FlowProject flowProject = null;
        if (dto.getFlowProjectId() != null) {
            flowProject = this.flowProjectService.getFlowProject(dto.getFlowProjectId());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getFlowProjectCode())) {
            flowProject = this.flowProjectService.getLastEnabledVersionFlowProject(dto.getFlowProjectCode());
        } else if (dto.getFlowInstanceId() != null && (flowInstance = this.flowInstanceService.getFlowInstance(dto.getFlowInstanceId())) != null) {
            flowProject = this.flowProjectService.getFlowProject(flowInstance.getFlowProjectId());
        }
        if (flowProject == null) {
            return this.buildEmptyNodeFormFieldConfigVo();
        }
        return this.loadFirstNodeFormFieldConfig(dto, flowProject);
    }

    public FlowProjectSimpleInfoVo getFlowProjectInfoByCode(String code) {
        FlowProject flowProject = this.flowProjectService.getLastEnabledVersionFlowProject(code);
        if (flowProject == null) {
            return null;
        }
        return flowProject.toFlowProjectSimpleInfoVo();
    }

    private NodeFormFieldConfigVo buildEmptyNodeFormFieldConfigVo() {
        return this.buildEmptyNodeFormFieldConfigVo(null);
    }

    private NodeFormFieldConfigVo buildEmptyNodeFormFieldConfigVo(FlowProject flowProject) {
        NodeFormFieldConfigVo vo = new NodeFormFieldConfigVo();
        vo.setFieldConfigs(Collections.emptyMap());
        vo.setFieldGroupConfigs(Collections.emptyMap());
        vo.setSubFormConfigs(Collections.emptyList());
        if (flowProject != null) {
            vo.setEntityCode(flowProject.getFormEntityCode());
        }
        return vo;
    }

    private NodeFormFieldConfigVo loadFirstNodeFormFieldConfig(FirstNodeFormFieldQueryDto dto, FlowProject flowProject) {
        FlowModel flowModel = this.flowModelService.getFlowModel(flowProject.getFlowModelId());
        JSONArray designJson = JSON.parseArray((String)flowModel.getDesignContent());
        FlowUtils.ModelDesignContentInfo designContentInfo = FlowUtils.extractModelDesignContent(designJson);
        if (designContentInfo.getStartNode() == null || !designContentInfo.edgeOutMap.containsKey(designContentInfo.getStartNode().getString(NODE_ID))) {
            return this.buildEmptyNodeFormFieldConfigVo(flowProject);
        }
        NodesConfigDto nodesConfigDto = (NodesConfigDto)JSON.parseObject((String)((String)StringUtils.defaultIfBlank((CharSequence)flowProject.getNodeConfigs(), (CharSequence)"{}")), NodesConfigDto.class);
        JSONObject firstApproveNode = this.findFirstNode(dto, designContentInfo, nodesConfigDto);
        if (firstApproveNode == null) {
            return this.buildEmptyNodeFormFieldConfigVo(flowProject);
        }
        String firstNodeId = firstApproveNode.getString(NODE_ID);
        return this.loadFieldAuthConfig(flowProject, nodesConfigDto, firstNodeId);
    }

    private JSONObject findFirstNode(FirstNodeFormFieldQueryDto dto, FlowUtils.ModelDesignContentInfo designContentInfo, NodesConfigDto nodesConfigDto) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(16);
        if (dto.getStartVariablesMap() != null && !dto.getStartVariablesMap().isEmpty()) {
            attrs.putAll(dto.getStartVariablesMap());
        } else if (dto.getStartVariables() != null && !dto.getStartVariables().isEmpty()) {
            dto.getStartVariables().forEach(v -> FlowUtils.putVariable(attrs, this.objectMapper, v.getVariableType(), v.getKey(), v.getValue()));
        }
        FlowExpressionExecutor expressionExecutor = this.flowEngineService.getFlowExpressionExecutor(attrs, true);
        for (JSONObject edge : designContentInfo.edgeOutMap.get(designContentInfo.getStartNode().getString(NODE_ID))) {
            JSONObject firstApproveNode;
            String targetId = edge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
            JSONObject targetNode = designContentInfo.designNodeMap.get(targetId);
            if (targetNode == null || (firstApproveNode = this.findFirstApproveNode(targetNode, nodesConfigDto, expressionExecutor, designContentInfo)) == null) continue;
            return firstApproveNode;
        }
        return null;
    }

    private JSONObject findFirstApproveNode(JSONObject node, NodesConfigDto nodesConfigDto, FlowExpressionExecutor expressionExecutor, FlowUtils.ModelDesignContentInfo designContentInfo) {
        String nodeShape = node.getString(NODE_SHAPE);
        if (NODE_APPROVAL.equals(nodeShape)) {
            return node;
        }
        String nodeId = node.getString(NODE_ID);
        if (!designContentInfo.edgeOutMap.containsKey(nodeId)) {
            return null;
        }
        HashMap<String, String> lineConfigMap = new HashMap<String, String>(16);
        if (NODE_EXCLUSIVE_GATEWAY.equals(nodeShape)) {
            nodesConfigDto.getGatewayNodes().stream().filter(c -> nodeId.equals(c.getNodeKey()) && c.getLineConfigs() != null).findAny().ifPresent(c -> c.getLineConfigs().forEach(l -> lineConfigMap.put(l.getTargetNodeKey(), l.getFormula())));
        }
        List<JSONObject> edges = designContentInfo.edgeOutMap.get(nodeId);
        for (JSONObject edge : edges) {
            JSONObject firstApproveNode = this.findFirstApproveNodeForEdge(edge, nodesConfigDto, expressionExecutor, designContentInfo, lineConfigMap);
            if (firstApproveNode == null) continue;
            return firstApproveNode;
        }
        return null;
    }

    private JSONObject findFirstApproveNodeForEdge(JSONObject edge, NodesConfigDto nodesConfigDto, FlowExpressionExecutor expressionExecutor, FlowUtils.ModelDesignContentInfo designContentInfo, Map<String, String> lineConfigMap) {
        String targetId = edge.getJSONObject(NODE_TARGET).getString(NODE_CELL);
        JSONObject targetNode = designContentInfo.designNodeMap.get(targetId);
        if (targetNode == null) {
            return null;
        }
        if (lineConfigMap.containsKey(targetId) && !this.executeFormula(expressionExecutor, lineConfigMap.get(targetId))) {
            return null;
        }
        return this.findFirstApproveNode(targetNode, nodesConfigDto, expressionExecutor, designContentInfo);
    }

    private boolean executeFormula(FlowExpressionExecutor expressionExecutor, String formula) {
        Object expressionResult = true;
        try {
            expressionResult = expressionExecutor.execute(formula);
        }
        catch (Exception e) {
            this.logger.info("Execute expression [{}] failed", (Object)formula);
        }
        return Boolean.TRUE.equals(expressionResult);
    }

    private NodeFormFieldConfigVo loadFieldAuthConfig(FlowProject flowProject, NodesConfigDto nodesConfigDto, String firstNodeId) {
        ApprovalNodeConfigDto config = null;
        if (nodesConfigDto.getApprovalNodes() != null) {
            config = nodesConfigDto.getApprovalNodes().stream().filter(c -> firstNodeId.equals(c.getNodeKey())).findAny().orElse(null);
        }
        String entityCode = flowProject.getFormEntityCode();
        return this.roleFieldAuthHelperService.convertNodeFormFieldConfigVo(entityCode, config);
    }

    public List<FlowProjectSimpleInfoVo> listForExportByCodes(Set<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        SimpleFlowProjectQuery query = new SimpleFlowProjectQuery();
        query.setCodeNameIn(codes);
        return this.flowProjectService.listFlowProject(query).stream().collect(Collectors.toMap(SimpleFlowProject::getCodeName, Function.identity(), (a, b) -> {
            if (FlowProjectStatus.ENABLED.equals((Object)a.getStatus())) {
                return a;
            }
            if (FlowProjectStatus.ENABLED.equals((Object)b.getStatus())) {
                return b;
            }
            boolean isDraftA = FlowProjectStatus.DRAFT.equals((Object)a.getStatus());
            boolean isDraftB = FlowProjectStatus.DRAFT.equals((Object)b.getStatus());
            if (isDraftA && !isDraftB) {
                return a;
            }
            if (!isDraftA && isDraftB) {
                return b;
            }
            return a.getId() > b.getId() ? a : b;
        })).values().stream().map(SimpleFlowProject::toSimpleVo).collect(Collectors.toList());
    }

    public String testProject(FlowProjectTestDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getDesignContent())) {
            return dto.getDesignContent();
        }
        JSONArray designJson = JSON.parseArray((String)dto.getDesignContent());
        FlowUtils.ModelDesignContentInfo designContentInfo = FlowUtils.extractModelDesignContent(designJson);
        if (designContentInfo.getStartNode() == null) {
            return dto.getDesignContent();
        }
        List<JSONObject> startOutEdges = designContentInfo.edgeOutMap.get(designContentInfo.getStartNode().getString(NODE_ID));
        if (startOutEdges == null || startOutEdges.isEmpty()) {
            return dto.getDesignContent();
        }
        if (startOutEdges.size() > 1) {
            this.markNodeError(designContentInfo.getStartNode());
            this.putTestFailMsg(designContentInfo.getStartNode(), TEST_FAIL_MULTI_OUT);
            return designJson.toJSONString();
        }
        this.markNodeRun(designContentInfo.getStartNode());
        NodesConfigDto nodeConfigs = dto.getNodeConfigs();
        Map approvalNodeConfigMap = nodeConfigs.getApprovalNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, Function.identity(), (a, b) -> a));
        Map gatewayNodeConfigMap = nodeConfigs.getGatewayNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, Function.identity(), (a, b) -> a));
        JSONObject startOutEdge = startOutEdges.get(0);
        this.markEdgeRun(startOutEdge);
        JSONObject firstNode = designContentInfo.designNodeMap.get(startOutEdge.getJSONObject(NODE_TARGET).getString(NODE_CELL));
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("_START_USER_ID", ObjectUtils.defaultIfNull((Object)dto.getStartUserId(), (Object)ServiceContext.getContext().getRequestUserId()));
        FlowExpressionExecutor executor = this.flowEngineService.getFlowExpressionExecutor(variables, false);
        TestNodeRunParams testNodeRunParams = new TestNodeRunParams();
        testNodeRunParams.designContentInfo = designContentInfo;
        testNodeRunParams.approvalNodeConfigMap = approvalNodeConfigMap;
        testNodeRunParams.gatewayNodeConfigMap = gatewayNodeConfigMap;
        testNodeRunParams.executor = executor;
        this.testNodeRun(firstNode, testNodeRunParams);
        testNodeRunParams.parallelCountMap.forEach((k, v) -> {
            if (v > 0) {
                this.putTestFailMsg(designContentInfo.designNodeMap.get(k), TEST_FAIL_PARALLEL_NOT_ENOUGH_IN);
            }
        });
        this.userHelperService.getUserNameMap(testNodeRunParams.assigneeMap.keySet()).forEach((k, v) -> {
            List<JSONObject> assignees = testNodeRunParams.assigneeMap.get(k);
            assignees.forEach(assignee -> assignee.put("name", v));
        });
        return designJson.toJSONString();
    }

    private void testNodeRun(JSONObject node, TestNodeRunParams testNodeRunParams) {
        String shape = StringUtils.defaultString((String)node.getString(NODE_SHAPE));
        String nodeId = node.getString(NODE_ID);
        List<JSONObject> outEdges = testNodeRunParams.designContentInfo.edgeOutMap.get(nodeId);
        if (NODE_END.equals(shape)) {
            if (outEdges != null && !outEdges.isEmpty()) {
                this.putTestFailMsg(node, TEST_FAIL_END_HAS_OUT);
            }
            testNodeRunParams.finNodeKey.add(nodeId);
            return;
        }
        if (outEdges == null || outEdges.isEmpty()) {
            this.putTestFailMsg(node, TEST_FAIL_NO_OUT);
            return;
        }
        List<JSONObject> runOutEdges = this.testCalRunOutEdges(node, testNodeRunParams, shape, nodeId, outEdges);
        runOutEdges.forEach(edge -> {
            String targetId = this.getEdgeTargetId((JSONObject)edge);
            if (targetId == null) {
                this.putTestFailMsg((JSONObject)edge, TEST_FAIL_LINE_NO_TARGET);
                this.markEdgeError((JSONObject)edge);
                return;
            }
            if (testNodeRunParams.finNodeKey.contains(targetId)) {
                this.putTestFailMsg((JSONObject)edge, TEST_FAIL_CYCLE);
                this.markEdgeError((JSONObject)edge);
                return;
            }
            this.markEdgeRun((JSONObject)edge);
            this.testNodeRun(testNodeRunParams.designContentInfo.designNodeMap.get(targetId), testNodeRunParams);
        });
    }

    private List<JSONObject> testCalRunOutEdges(JSONObject node, TestNodeRunParams testNodeRunParams, String shape, String nodeId, List<JSONObject> outEdges) {
        List<JSONObject> runOutEdges;
        switch (shape) {
            case "exclusive-gateway": {
                GatewayNodeConfigDto gatewayConfig = testNodeRunParams.gatewayNodeConfigMap.get(nodeId);
                runOutEdges = this.testExclusiveGatewayRun(node, outEdges, gatewayConfig, testNodeRunParams.executor);
                break;
            }
            case "parallel-gateway": {
                int inCount = testNodeRunParams.parallelCountMap.computeIfAbsent(nodeId, k -> testNodeRunParams.designContentInfo.edgeInMap.get(k).size());
                if (inCount > 1) {
                    testNodeRunParams.parallelCountMap.put(nodeId, inCount - 1);
                    return Collections.emptyList();
                }
                runOutEdges = testNodeRunParams.designContentInfo.edgeOutMap.get(nodeId);
                this.markNodeRun(node);
                break;
            }
            case "node-approval": {
                ApprovalNodeConfigDto approvalConfig = testNodeRunParams.approvalNodeConfigMap.get(nodeId);
                this.markNodeRun(node);
                this.testCalAssignee(node, approvalConfig, testNodeRunParams);
                if (outEdges.size() > 1) {
                    this.putTestFailMsg(node, TEST_FAIL_MULTI_OUT);
                    testNodeRunParams.finNodeKey.add(nodeId);
                    this.markNodeError(node);
                    return Collections.emptyList();
                }
                runOutEdges = outEdges;
                break;
            }
            default: {
                if (outEdges.size() > 1) {
                    this.putTestFailMsg(node, TEST_FAIL_MULTI_OUT);
                    testNodeRunParams.finNodeKey.add(nodeId);
                    this.markNodeError(node);
                    return Collections.emptyList();
                }
                this.markNodeRun(node);
                runOutEdges = outEdges;
            }
        }
        return runOutEdges;
    }

    private void testCalAssignee(JSONObject node, ApprovalNodeConfigDto approvalConfig, TestNodeRunParams testNodeRunParams) {
        Object expressionResult;
        JSONObject data;
        JSONArray assignees = new JSONArray();
        if (node.containsKey((Object)NODE_DATA)) {
            data = node.getJSONObject(NODE_DATA);
        } else {
            data = new JSONObject();
            node.put(NODE_DATA, (Object)data);
        }
        data.put("assignees", (Object)assignees);
        if (approvalConfig == null || approvalConfig.getAssigneeType() == null) {
            return;
        }
        if (AssigneeType.USER.equals((Object)approvalConfig.getAssigneeType()) && !Boolean.TRUE.equals(approvalConfig.getUseConditionMatrix())) {
            if (approvalConfig.getAssignees() == null) {
                return;
            }
            approvalConfig.getAssignees().forEach(a -> {
                JSONObject assignee = new JSONObject();
                assignee.put(NODE_ID, (Object)a.getId());
                assignee.put("name", (Object)a.getName());
                assignees.add((Object)assignee);
            });
            return;
        }
        String formula = this.flowDefinitionGenerateService.buildAssigneeCollectionExpression(approvalConfig, node.getString(NODE_ID));
        if (StringUtils.isBlank((CharSequence)formula)) {
            return;
        }
        try {
            expressionResult = testNodeRunParams.executor.execute(formula);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage(), (Throwable)e);
            this.putTestFailMsg(node, "\u5ba1\u6279\u4eba\u8868\u8fbe\u5f0f\u8ba1\u7b97\u51fa\u9519, \u9519\u8bef\u4fe1\u606f: " + e.getMessage());
            this.markNodeError(node);
            return;
        }
        if (expressionResult instanceof Collection) {
            ((Collection)expressionResult).forEach(id -> this.convertTestAssignee(node, testNodeRunParams, assignees, id));
        } else if (expressionResult != null) {
            this.convertTestAssignee(node, testNodeRunParams, assignees, expressionResult);
        }
    }

    private void convertTestAssignee(JSONObject node, TestNodeRunParams testNodeRunParams, JSONArray assignees, Object id) {
        try {
            Long longId = Long.parseLong(id.toString());
            JSONObject assignee = new JSONObject();
            assignee.put(NODE_ID, (Object)longId);
            assignees.add((Object)assignee);
            testNodeRunParams.assigneeMap.computeIfAbsent(longId, k -> new ArrayList()).add(assignee);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage(), (Throwable)e);
            this.putTestFailMsg(node, "\u65e0\u6548\u7684\u5ba1\u6279\u7528\u6237ID\u503c: " + id);
            this.markNodeError(node);
        }
    }

    private List<JSONObject> testExclusiveGatewayRun(JSONObject node, List<JSONObject> outEdges, GatewayNodeConfigDto gatewayConfig, FlowExpressionExecutor executor) {
        if (outEdges.size() == 1) {
            return this.testExclusiveGatewayRunSingleLine(node, outEdges, gatewayConfig);
        }
        if (gatewayConfig == null || gatewayConfig.getLineConfigs() == null || gatewayConfig.getLineConfigs().isEmpty()) {
            this.putTestFailMsg(node, TEST_FAIL_NO_GATEWAY_CONFIG);
            this.markNodeError(node);
            return Collections.emptyList();
        }
        Map lineConfigMap = gatewayConfig.getLineConfigs().stream().collect(Collectors.toMap(GatewayLineConfigDto::getTargetNodeKey, Function.identity(), (a, b) -> a));
        ArrayList<JSONObject> runOutEdges = new ArrayList<JSONObject>();
        boolean hasError = false;
        for (JSONObject edge : outEdges) {
            String targetId = this.getEdgeTargetId(edge);
            GatewayLineConfigDto lineConfig = (GatewayLineConfigDto)lineConfigMap.get(targetId);
            if (lineConfig == null || StringUtils.isBlank((CharSequence)lineConfig.getFormula())) {
                this.putTestFailMsg(edge, TEST_FAIL_LINE_NO_CONFIG);
                this.markEdgeError(edge);
                hasError = true;
                continue;
            }
            try {
                Object formulaResult = executor.execute(lineConfig.getFormula());
                if (!Boolean.TRUE.equals(formulaResult)) continue;
                runOutEdges.add(edge);
                this.markEdgeRun(edge);
            }
            catch (Exception e) {
                this.logger.info(e.getMessage(), (Throwable)e);
                hasError = true;
                this.putTestFailMsg(edge, "\u6761\u4ef6\u8868\u8fbe\u5f0f\u6267\u884c\u51fa\u9519, \u9519\u8bef\u6d88\u606f: " + e.getMessage());
                this.markEdgeError(edge);
            }
        }
        if (hasError) {
            this.markNodeError(node);
            return Collections.emptyList();
        }
        if (runOutEdges.isEmpty()) {
            this.putTestFailMsg(node, TEST_FAIL_LINE_NO_MATCH);
            this.markNodeError(node);
        } else {
            if (runOutEdges.size() > 1) {
                this.putTestFailMsg(node, TEST_FAIL_MULTI_OUT);
                this.markNodeError(node);
                return Collections.emptyList();
            }
            this.markNodeRun(node);
        }
        return runOutEdges;
    }

    private List<JSONObject> testExclusiveGatewayRunSingleLine(JSONObject node, List<JSONObject> outEdges, GatewayNodeConfigDto gatewayConfig) {
        if (gatewayConfig == null || gatewayConfig.getLineConfigs() == null || gatewayConfig.getLineConfigs().isEmpty()) {
            return outEdges;
        }
        JSONObject edge = outEdges.get(0);
        String targetId = this.getEdgeTargetId(edge);
        Optional<GatewayLineConfigDto> lineConfig = gatewayConfig.getLineConfigs().stream().filter(c -> c.getTargetNodeKey().equals(targetId)).findAny();
        if (lineConfig.isEmpty() || StringUtils.isBlank((CharSequence)lineConfig.get().getFormula())) {
            return outEdges;
        }
        this.putTestFailMsg(node, TEST_FAIL_GATEWAY_SINGLE_LINE_CONFIG);
        return Collections.emptyList();
    }

    private String getEdgeTargetId(JSONObject edge) {
        JSONObject target = edge.getJSONObject(NODE_TARGET);
        if (target == null) {
            return null;
        }
        return target.getString(NODE_CELL);
    }

    private void markEdgeRun(JSONObject edge) {
        this.changeEdgeColor(edge, FIN_COLOR);
    }

    private void markEdgeError(JSONObject edge) {
        this.changeEdgeColor(edge, ERR_COLOR);
    }

    private void changeEdgeColor(JSONObject edge, String color) {
        edge.getJSONObject("attrs").getJSONObject("line").put("stroke", (Object)color);
    }

    private void markNodeRun(JSONObject node) {
        this.changeNodeTestStatus(node, NODE_TEST_STATUS_RUN);
    }

    private void markNodeError(JSONObject node) {
        this.changeNodeTestStatus(node, NODE_TEST_STATUS_ERR);
    }

    private void changeNodeTestStatus(JSONObject node, String status) {
        JSONObject data;
        if (node.containsKey((Object)NODE_DATA)) {
            data = node.getJSONObject(NODE_DATA);
        } else {
            data = new JSONObject();
            node.put(NODE_DATA, (Object)data);
        }
        data.put(NODE_TEST_STATUS, (Object)status);
    }

    private void putTestFailMsg(JSONObject node, String msg) {
        JSONObject data;
        if (node.containsKey((Object)NODE_DATA)) {
            data = node.getJSONObject(NODE_DATA);
        } else {
            data = new JSONObject();
            node.put(NODE_DATA, (Object)data);
        }
        if (data.containsKey((Object)NODE_TEST_FAIL_MSG)) {
            data.put(NODE_TEST_FAIL_MSG, (Object)(data.getString(NODE_TEST_FAIL_MSG) + "; " + msg));
        } else {
            data.put(NODE_TEST_FAIL_MSG, (Object)msg);
        }
    }

    private static final class ImportIdData {
        private Map<Long, Long> userIdMap;
        private Map<Long, Long> roleIdMap;
        private Map<Long, Long> unitIdMap;
        private Map<Long, Long> dutyIdMap;

        private ImportIdData() {
        }
    }

    private static final class TestNodeRunParams {
        private final Map<String, Integer> parallelCountMap = new HashMap<String, Integer>(16);
        private final Set<String> finNodeKey = new HashSet<String>();
        private final Map<Long, List<JSONObject>> assigneeMap = new HashMap<Long, List<JSONObject>>(16);
        private FlowUtils.ModelDesignContentInfo designContentInfo;
        private Map<String, ApprovalNodeConfigDto> approvalNodeConfigMap;
        private Map<String, GatewayNodeConfigDto> gatewayNodeConfigMap;
        private FlowExpressionExecutor executor;

        private TestNodeRunParams() {
        }
    }
}

