/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.script.FlowScriptApi;
import com.cyberway.mp.flow.api.script.dto.FlowScriptCreateDto;
import com.cyberway.mp.flow.api.script.dto.FlowScriptModifyBaseDto;
import com.cyberway.mp.flow.api.script.dto.FlowScriptModifyDto;
import com.cyberway.mp.flow.api.script.dto.FlowScriptPageDto;
import com.cyberway.mp.flow.api.script.vo.FlowScriptInfoVo;
import com.cyberway.mp.flow.api.script.vo.FlowScriptListVo;
import com.cyberway.mp.flow.domain.script.entity.FlowScript;
import com.cyberway.mp.flow.domain.script.repository.query.FlowScriptQuery;
import com.cyberway.mp.flow.domain.script.service.FlowScriptService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowScriptApplicationService
implements FlowScriptApi {
    private final FlowScriptService flowScriptService;

    public FlowScriptApplicationService(FlowScriptService flowScriptService) {
        this.flowScriptService = flowScriptService;
    }

    public long createFlowScript(FlowScriptCreateDto dto) {
        FlowScript flowScript = FlowScript.fromFlowScriptCreateDto(dto);
        this.flowScriptService.createScript(flowScript);
        return (Long)flowScript.getId();
    }

    public void modifyFlowScript(FlowScriptModifyDto dto) {
        FlowScript flowScript = this.flowScriptService.getFlowScript(dto.getId());
        if (flowScript == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_ID_NOT_EXISTED);
        }
        flowScript.update((FlowScriptModifyBaseDto)dto);
        this.flowScriptService.modifyScript(flowScript);
    }

    public void deleteFlowScript(long id) {
        this.flowScriptService.deleteScript(id);
    }

    public Page<FlowScriptListVo> queryFlowScript(FlowScriptPageDto dto) {
        FlowScriptQuery flowScriptQuery = FlowScriptQuery.fromFlowScriptPageDto(dto);
        long count = this.flowScriptService.countScript(flowScriptQuery);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowScript> flowScripts = this.flowScriptService.pageQueryScript(dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), count, flowScripts.stream().map(FlowScript::toFlowScriptListVo).collect(Collectors.toList()));
    }

    public FlowScriptInfoVo getFlowScript(long id) {
        FlowScript flowScript = this.flowScriptService.getFlowScript(id);
        if (flowScript == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_SCRIPT_ID_NOT_EXISTED);
        }
        return flowScript.toFlowScriptInfoVo();
    }
}

