/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.GetVariablesDto;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.common.vo.BatchActionResultVo;
import com.cyberway.mp.flow.api.common.vo.ErrorInfoVo;
import com.cyberway.mp.flow.api.common.vo.KeyNameVo;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.dto.AttachmentInfo;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtDto;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.log.enums.FlowActionType;
import com.cyberway.mp.flow.api.log.enums.UrgeLogType;
import com.cyberway.mp.flow.api.log.enums.UrgeSourceType;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventTemplateDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.OpinionCheckActionDto;
import com.cyberway.mp.flow.api.project.enums.OpinionValidationType;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.api.task.FlowTaskApi;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddSignDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminAddNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminAddSignDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminTargetNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminTransferDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAdminUrgeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskChangeDueTimeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskDuePageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskHandledPageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskInfoListDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskInfoPageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTargetNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTodoPageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTransferDto;
import com.cyberway.mp.flow.api.task.dto.FlowUrgeDto;
import com.cyberway.mp.flow.api.task.dto.MdmFlowTaskInfoPageDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowUrgeType;
import com.cyberway.mp.flow.api.task.enums.MdmFlowTaskQueryTypeEnum;
import com.cyberway.mp.flow.api.task.vo.FlowTaskAllowActionVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskBaseVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskDueVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskHandledPageVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskInfoVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskTodoPageVo;
import com.cyberway.mp.flow.api.task.vo.MdmFlowTaskInfoVo;
import com.cyberway.mp.flow.api.task.vo.NodeFormFieldConfigVo;
import com.cyberway.mp.flow.domain.his.service.FlowHisService;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExt;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExtArray;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.log.entity.FlowLog;
import com.cyberway.mp.flow.domain.log.entity.FlowUrgeLog;
import com.cyberway.mp.flow.domain.log.service.FlowLogService;
import com.cyberway.mp.flow.domain.opinion.service.OpinionAssociationService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.repository.query.FlowTaskQuery;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.infra.config.FlowBaseContextProperties;
import com.cyberway.mp.flow.infra.dto.TaskBatchCompleteParam;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.RoleFieldAuthHelperService;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.flow.infra.util.OpinionUtils;
import com.cyberway.mp.mc.api.push.dto.EventPushDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Validated
public class FlowTaskApplicationService
implements FlowTaskApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowInstanceService flowInstanceService;
    private final FlowTaskService flowTaskService;
    private final FlowLogService flowLogService;
    private final FlowHisService flowHisService;
    private final FlowDataHelperService flowDataHelperService;
    private final FlowEngineService flowEngineService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FrameworkEventService frameworkEventService;
    private final FlowBaseContextProperties flowBaseContextProperties;
    private final UserHelperService userHelperService;
    private final RoleFieldAuthHelperService roleFieldAuthHelperService;
    private final OpinionAssociationService opinionAssociationService;

    public FlowTaskApplicationService(FlowInstanceService flowInstanceService, FlowTaskService flowTaskService, FlowLogService flowLogService, FlowHisService flowHisService, FlowDataHelperService flowDataHelperService, FlowEngineService flowEngineService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FrameworkEventService frameworkEventService, FlowBaseContextProperties flowBaseContextProperties, UserHelperService userHelperService, RoleFieldAuthHelperService roleFieldAuthHelperService, OpinionAssociationService opinionAssociationService) {
        this.flowInstanceService = flowInstanceService;
        this.flowTaskService = flowTaskService;
        this.flowLogService = flowLogService;
        this.flowHisService = flowHisService;
        this.flowDataHelperService = flowDataHelperService;
        this.flowEngineService = flowEngineService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.frameworkEventService = frameworkEventService;
        this.flowBaseContextProperties = flowBaseContextProperties;
        this.userHelperService = userHelperService;
        this.roleFieldAuthHelperService = roleFieldAuthHelperService;
        this.opinionAssociationService = opinionAssociationService;
    }

    private FlowTask getRunningFlowTask(long id) {
        FlowTask flowTask = this.flowTaskService.getFlowTask(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        if (!FlowTaskStatus.RUNNING.equals((Object)flowTask.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_NOT_RUNNING);
        }
        return flowTask;
    }

    private FlowTaskWithProject getRunningFlowTaskWithProject(long id) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        if (!FlowTaskStatus.RUNNING.equals((Object)flowTask.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_NOT_RUNNING);
        }
        return flowTask;
    }

    private void opinionVerification(FlowTaskActionDto dto, Function<OpinionCheckActionDto, Boolean> getConfigFunction) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowTask.getFlowProjectId());
        if (globalConfig == null || globalConfig.getUseOpinionCheck() == null || globalConfig.getOpinionValidationType() == null) {
            return;
        }
        Boolean isCheck = globalConfig.getUseOpinionCheck();
        if (!Boolean.TRUE.equals(isCheck) || OpinionValidationType.ALL_NOT_REQUIRED.equals((Object)globalConfig.getOpinionValidationType())) {
            return;
        }
        if (OpinionValidationType.ALL_REQUIRED.equals((Object)globalConfig.getOpinionValidationType()) && StringUtils.isBlank((CharSequence)dto.getOpinion())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_OPINION_CHECK);
        }
        if (OpinionValidationType.CONDITIONAL_REQUIRED.equals((Object)globalConfig.getOpinionValidationType())) {
            if (globalConfig.getOpinionCheckAction() == null || getConfigFunction == null) {
                return;
            }
            Boolean isAssigneeApproveRequired = getConfigFunction.apply(globalConfig.getOpinionCheckAction());
            if (StringUtils.isBlank((CharSequence)dto.getOpinion()) && Boolean.TRUE.equals(isAssigneeApproveRequired)) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_OPINION_CHECK);
            }
        }
    }

    public void completeTask(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeApprove);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeApprove);
        this.doCompleteTask(flowTask, dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    private void doCompleteTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto) {
        this.flowEngineService.completeTask(flowTask, dto, false);
    }

    public BatchActionResultVo batchCompleteTask(List<FlowTaskActionDto> dtoList) {
        Map<Long, FlowTaskActionDto> dtoMap = dtoList.stream().collect(Collectors.toMap(FlowTaskActionDto::getFlowTaskId, dto -> dto));
        ArrayList<TaskBatchCompleteParam> params = new ArrayList<TaskBatchCompleteParam>();
        HashSet<Long> notExistedIds = new HashSet<Long>(dtoMap.keySet());
        HashSet<Long> statusErrorIds = new HashSet<Long>();
        BatchActionResultVo paramInitResultVo = this.initBatchCompleteParams(params, dtoMap, notExistedIds, statusErrorIds, ApprovalNodeConfigDto::getAssigneeApprove);
        if (params.isEmpty()) {
            return paramInitResultVo;
        }
        for (FlowTaskActionDto dto2 : dtoList) {
            this.opinionVerification(dto2, OpinionCheckActionDto::getAssigneeApprove);
            OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto2.getOpinion(), dto2.getSavaOpinion());
        }
        BatchActionResultVo batchActionResultVo = this.flowEngineService.batchCompleteTask(params);
        batchActionResultVo.getErrorInfoMap().putAll(paramInitResultVo.getErrorInfoMap());
        batchActionResultVo.setFailCount(Integer.valueOf(paramInitResultVo.getErrorInfoMap().size()));
        return batchActionResultVo;
    }

    private BatchActionResultVo initBatchCompleteParams(List<TaskBatchCompleteParam> params, Map<Long, FlowTaskActionDto> dtoMap, Set<Long> notExistedIds, Set<Long> statusErrorIds, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        BatchActionResultVo batchActionResultVo = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        batchActionResultVo.setErrorInfoMap(errorInfoMap);
        List<FlowTaskWithProject> flowTasks = this.flowTaskService.batchGetFlowTaskWithProject(notExistedIds);
        flowTasks = this.batchCheckOperatePermit(flowTasks, batchActionResultVo, loadConfigFunction);
        for (FlowTaskWithProject flowTask : flowTasks) {
            notExistedIds.remove(flowTask.getId());
            if (!FlowTaskStatus.RUNNING.equals((Object)flowTask.getStatus())) {
                statusErrorIds.add((Long)flowTask.getId());
                continue;
            }
            params.add(new TaskBatchCompleteParam(flowTask, dtoMap.get(flowTask.getId())));
        }
        for (Long id : notExistedIds) {
            errorInfoMap.put(id, new ErrorInfoVo(FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED));
        }
        for (Long id : statusErrorIds) {
            errorInfoMap.put(id, new ErrorInfoVo(FlowErrorCode.FLOW_TASK_NOT_RUNNING));
        }
        batchActionResultVo.setFailCount(Integer.valueOf(errorInfoMap.size()));
        return batchActionResultVo;
    }

    private List<FlowTaskWithProject> batchCheckOperatePermit(List<FlowTaskWithProject> flowTasks, BatchActionResultVo batchActionResultVo, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        if (this.flowBaseContextProperties.isSkipUserPermitCheck() && this.flowBaseContextProperties.isSkipActionPermitCheck()) {
            return flowTasks;
        }
        ArrayList<FlowTaskWithProject> passTasks = new ArrayList<FlowTaskWithProject>();
        for (FlowTaskWithProject task : flowTasks) {
            if (!this.checkOperatePermit(task, loadConfigFunction)) {
                batchActionResultVo.getErrorInfoMap().put((Long)task.getId(), new ErrorInfoVo(FlowErrorCode.OPERATE_HAS_NOT_AUTHORIZED));
                continue;
            }
            passTasks.add(task);
        }
        return passTasks;
    }

    public void rejectTask(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeReject);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeReject);
        this.doRejectTask(flowTask, dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    private void doRejectTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto) {
        this.flowEngineService.rejectTask(flowTask, dto, false);
    }

    public BatchActionResultVo batchRejectTask(List<FlowTaskActionDto> dtoList) {
        Map<Long, FlowTaskActionDto> dtoMap = dtoList.stream().collect(Collectors.toMap(FlowTaskActionDto::getFlowTaskId, dto -> dto));
        HashSet<Long> notExistedIds = new HashSet<Long>(dtoMap.keySet());
        HashSet<Long> statusErrorIds = new HashSet<Long>();
        ArrayList<TaskBatchCompleteParam> params = new ArrayList<TaskBatchCompleteParam>();
        BatchActionResultVo paramInitResultVo = this.initBatchCompleteParams(params, dtoMap, notExistedIds, statusErrorIds, ApprovalNodeConfigDto::getAssigneeReject);
        if (params.isEmpty()) {
            return paramInitResultVo;
        }
        for (FlowTaskActionDto dto2 : dtoList) {
            this.opinionVerification(dto2, OpinionCheckActionDto::getAssigneeReject);
            OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto2.getOpinion(), dto2.getSavaOpinion());
        }
        BatchActionResultVo batchActionResultVo = this.flowEngineService.batchRejectTask(params);
        batchActionResultVo.setFailCount(Integer.valueOf(paramInitResultVo.getFailCount() + batchActionResultVo.getFailCount()));
        batchActionResultVo.getErrorInfoMap().putAll(paramInitResultVo.getErrorInfoMap());
        return batchActionResultVo;
    }

    public void withdrawalApproval(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getFinAssigneeCancelAction);
        this.opinionVerification(dto, OpinionCheckActionDto::getStarterCancel);
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        this.flowEngineService.withdrawalApproval(flowTask.getTaskId(), dto, TaskExecuteType.SEQUENTIAL.equals((Object)approvalNodeConfig.getTaskExecuteType()));
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminWithdrawalApproval(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        this.flowEngineService.withdrawalApproval(flowTask.getTaskId(), (FlowTaskActionDto)dto, TaskExecuteType.SEQUENTIAL.equals((Object)approvalNodeConfig.getTaskExecuteType()));
    }

    public void addSign(FlowTaskAddSignDto param) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(param.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeAdd);
        FlowTaskActionDto dto = new FlowTaskActionDto();
        dto.setFlowTaskId(param.getFlowTaskId());
        dto.setOpinion(param.getOpinion());
        dto.setSavaOpinion(param.getSavaOpinion());
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeAdd);
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId());
        this.checkAddSign(flowTask, param.getAssigneeUserIds());
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        this.flowEngineService.addSign(flowInstance.getProcessInstanceId(), flowTask.getNodeKey(), TaskExecuteType.SEQUENTIAL.equals((Object)approvalNodeConfig.getTaskExecuteType()), param);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, param.getOpinion(), param.getSavaOpinion());
    }

    public void adminAddSign(FlowTaskAdminAddSignDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId());
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        this.flowEngineService.addSign(flowInstance.getProcessInstanceId(), flowTask.getNodeKey(), TaskExecuteType.SEQUENTIAL.equals((Object)approvalNodeConfig.getTaskExecuteType()), (FlowTaskAddSignDto)dto);
    }

    public List<IdNameDto> allowAddSignUsers(long id) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (approvalNodeConfig == null || approvalNodeConfig.getAllowAddSignUsers() == null) {
            return Collections.emptyList();
        }
        return approvalNodeConfig.getAllowAddSignUsers();
    }

    private void checkAddSign(FlowTaskWithProject flowTask, List<Long> assigneeUserIds) {
        ApprovalNodeConfigDto approvalNodeConfigDto = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (null == approvalNodeConfigDto) {
            this.logger.warn("approvalNodeConfigDto not found for flow task [{}]", (Object)flowTask.getId());
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ADD_ASSIGNEE_USER_NOT_IN);
        }
        List allowAssigneeUserIds = approvalNodeConfigDto.getAllowAddSignUsers();
        if (CollectionUtils.isEmpty((Collection)allowAssigneeUserIds)) {
            return;
        }
        Set userIdSet = allowAssigneeUserIds.stream().map(IdNameDto::getId).collect(Collectors.toSet());
        if (!userIdSet.containsAll(assigneeUserIds)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ADD_ASSIGNEE_USER_NOT_IN);
        }
        this.logger.info("\u52a0\u7b7e\u6821\u9a8c\u6210\u529f\uff1a{}", assigneeUserIds);
    }

    public void rollbackTaskToSpecial(FlowTaskTargetNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeRollbackTo);
        this.opinionVerification((FlowTaskActionDto)dto, OpinionCheckActionDto::getAssigneeRollbackTo);
        this.flowEngineService.rollbackTaskToSpecial(flowTask.getTaskId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminRollbackTaskToSpecial(FlowTaskAdminTargetNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.flowEngineService.rollbackTaskToSpecial(flowTask.getTaskId(), (FlowTaskTargetNodeDto)dto);
    }

    public void rollbackTaskToPrev(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeRollbackPrev);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeRollbackPrev);
        this.flowEngineService.rollbackTaskToPrev(flowTask.getTaskId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminRollbackTaskToPrev(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.flowEngineService.rollbackTaskToPrev(flowTask.getTaskId(), (FlowTaskActionDto)dto);
    }

    public void rollbackTaskToStart(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeRollbackStart);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeRollbackStart);
        this.flowEngineService.rollbackTaskToStart(flowTask.getTaskId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminRollbackTaskToStart(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.flowEngineService.rollbackTaskToStart(flowTask.getTaskId(), (FlowTaskActionDto)dto);
    }

    public List<KeyNameVo> getAllowJumpNodes(long id) {
        FlowTaskWithProject flowTaskWithProject = this.getRunningFlowTaskWithProject(id);
        return this.flowEngineService.getAllowJumpNodes((long)flowTaskWithProject.getFlowInstanceId(), (long)flowTaskWithProject.getFlowProjectId(), flowTaskWithProject.getNodeKey());
    }

    public List<KeyNameVo> getAllowRollbackNodes(long id) {
        FlowTaskWithProject flowTaskWithProject = this.getRunningFlowTaskWithProject(id);
        return this.flowEngineService.getAllowRollbackNodes(flowTaskWithProject.getFlowInstanceId(), flowTaskWithProject.getFlowProjectId(), flowTaskWithProject.getNodeKey());
    }

    public void jumpTask(FlowTaskTargetNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeJump);
        this.opinionVerification((FlowTaskActionDto)dto, OpinionCheckActionDto::getAssigneeJump);
        this.flowEngineService.jump(flowTask.getTaskId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminJumpTask(FlowTaskAdminTargetNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.flowEngineService.jump(flowTask.getTaskId(), (FlowTaskTargetNodeDto)dto);
    }

    public List<IdNameDto> allowTransferUsers(long id) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (approvalNodeConfig == null || approvalNodeConfig.getAllowTransferUsers() == null) {
            return Collections.emptyList();
        }
        return approvalNodeConfig.getAllowTransferUsers();
    }

    public void transferTaskInstance(FlowTaskTransferDto dto) {
        FlowTaskWithProject runningFlowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(runningFlowTask, ApprovalNodeConfigDto::getAssigneeChange);
        this.checkTransferTaskInstance(runningFlowTask, dto.getNewAssigneeUserId());
        this.opinionVerification((FlowTaskActionDto)dto, OpinionCheckActionDto::getAssigneeChange);
        this.flowEngineService.transferTaskInstance(runningFlowTask, dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public List<IdNameDto> allowCcUsers(long id) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(id);
        if (Objects.isNull((Object)flowTask)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        ApprovalNodeConfigDto approvalNodeConfigDto = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (approvalNodeConfigDto == null || approvalNodeConfigDto.getAllowCcUsers() == null) {
            return Collections.emptyList();
        }
        return approvalNodeConfigDto.getAllowCcUsers();
    }

    public void ccToUsers(FlowTaskCcDto dto) {
        FlowTaskWithProject runningFlowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(runningFlowTask, ApprovalNodeConfigDto::getAssigneeCc);
        this.checkCcTaskInstance(runningFlowTask, dto.getUsers());
        FlowTaskActionDto flowTaskActionDto = new FlowTaskActionDto();
        flowTaskActionDto.setFlowTaskId(dto.getFlowTaskId());
        flowTaskActionDto.setOpinion(dto.getNote());
        this.opinionVerification(flowTaskActionDto, OpinionCheckActionDto::getAssigneeCc);
        this.flowEngineService.ccTask(runningFlowTask, dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getNote(), dto.getSavaOpinion());
    }

    private void checkCcTaskInstance(FlowTaskWithProject flowTask, List<IdNameDto> ccUsers) {
        ApprovalNodeConfigDto approvalNodeConfigDto = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (null == approvalNodeConfigDto) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_CC_USER_NOT_IN);
        }
        List allowCcUsers = approvalNodeConfigDto.getAllowCcUsers();
        if (CollectionUtils.isEmpty((Collection)allowCcUsers)) {
            return;
        }
        ccUsers.forEach(user -> {
            if (!allowCcUsers.contains(user)) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_CC_USER_NOT_IN);
            }
        });
    }

    public void adminCompleteTask(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.doCompleteTask(flowTask, (FlowTaskActionDto)dto);
    }

    public void adminRejectTask(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.doRejectTask(flowTask, (FlowTaskActionDto)dto);
    }

    public void adminTransferTaskInstance(FlowTaskAdminTransferDto dto) {
        FlowTaskWithProject runningFlowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkTransferTaskInstance(runningFlowTask, dto.getNewAssigneeUserId());
        this.flowEngineService.transferTaskInstance(runningFlowTask, (FlowTaskTransferDto)dto);
    }

    public void changeDueTime(FlowTaskChangeDueTimeDto dto) {
        if (dto.getNewDueTime() != null && dto.getNewDueTime().before(new Date())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DUE_TIME_BEFORE_NOW);
        }
        FlowTask flowTask = this.getRunningFlowTask(dto.getFlowTaskId());
        if (dto.getNewDueTime() == null) {
            flowTask.setDueTime(FlowConstant.EMPTY_MAX_TIME);
        } else {
            flowTask.setDueTime(dto.getNewDueTime());
        }
        this.flowTaskService.modifyFlowTask(flowTask);
    }

    private void checkTransferTaskInstance(FlowTaskWithProject flowTask, Long newAssigneeUserId) {
        ApprovalNodeConfigDto approvalNodeConfigDto = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (null == approvalNodeConfigDto) {
            this.logger.warn("approvalNodeConfigDto\u627e\u4e0d\u5230");
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_TRANSFER_USER_NOT_IN);
        }
        List allowTransferUsers = approvalNodeConfigDto.getAllowTransferUsers();
        if (CollectionUtils.isEmpty((Collection)allowTransferUsers)) {
            return;
        }
        if (allowTransferUsers.stream().noneMatch(user -> user.getId().equals(newAssigneeUserId))) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_TRANSFER_USER_NOT_IN);
        }
    }

    public List<FlowTaskInfoVo> listFlowTaskInfo(FlowTaskInfoListDto dto) {
        List<FlowTaskWithBusinessKey> tasks = this.flowTaskService.listFlowTaskWithBusinessKey(FlowTaskQuery.fromFlowTaskInfoListDto(dto));
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        boolean loadAllVar = Boolean.TRUE.equals(dto.getLoadAllVar());
        if (loadAllVar || !CollectionUtils.isEmpty((Collection)dto.getLoadVarKeys())) {
            Set filterVarNames;
            Set<Long> flowInstanceIds = tasks.stream().map(FlowTask::getFlowInstanceId).collect(Collectors.toSet());
            HashSet<Long> notHandleFlowInstanceIds = new HashSet<Long>();
            List<FlowInstance> flowInstances = this.flowInstanceService.batchGetFlowInstance(flowInstanceIds);
            ArrayList<Long> finFlowInstanceIds = new ArrayList<Long>();
            HashMap flowToProcessMap = MapUtil.newHashMap((int)flowInstances.size());
            HashMap processToFlowMap = MapUtil.newHashMap((int)flowInstances.size());
            for (FlowInstance flowInstance : flowInstances) {
                if (flowInstance.alreadyFinish()) {
                    finFlowInstanceIds.add((Long)flowInstance.getId());
                }
                notHandleFlowInstanceIds.add((Long)flowInstance.getId());
                flowToProcessMap.put((Long)flowInstance.getId(), flowInstance.getProcessInstanceId());
                processToFlowMap.put(flowInstance.getProcessInstanceId(), (Long)flowInstance.getId());
            }
            HashMap varMaps = MapUtil.newHashMap((int)flowInstanceIds.size());
            Set set = filterVarNames = loadAllVar ? null : dto.getLoadVarKeys();
            if (!finFlowInstanceIds.isEmpty()) {
                finFlowInstanceIds.forEach(notHandleFlowInstanceIds::remove);
                varMaps.putAll(this.flowHisService.getVariableMapByFlowInstanceIds(finFlowInstanceIds, filterVarNames));
            }
            if (!notHandleFlowInstanceIds.isEmpty()) {
                Set<String> processIds = notHandleFlowInstanceIds.stream().map(flowToProcessMap::get).collect(Collectors.toSet());
                this.flowEngineService.batchGetVarByProcessInstances(processIds, filterVarNames).forEach((k, v) -> varMaps.put((Long)processToFlowMap.get(k), v));
            }
            return tasks.stream().map(t -> t.toFlowTaskInfoVo(varMaps)).collect(Collectors.toList());
        }
        List<FlowTaskInfoVo> list = tasks.stream().map(FlowTaskWithBusinessKey::toFlowTaskInfoVo).collect(Collectors.toList());
        this.setExtInfo(list);
        return list;
    }

    public Page<FlowTaskInfoVo> pageFlowTaskInfo(FlowTaskInfoPageDto dto) {
        FlowTaskQuery query = FlowTaskQuery.fromFlowTaskInfoPageDto(dto);
        return this.pageQueryFlowTask(query, (PageParam)dto, FlowTaskWithBusinessKey::toFlowTaskInfoVo);
    }

    public Page<FlowTaskDueVo> pageDueFlowTask(FlowTaskDuePageDto dto) {
        FlowTaskQuery query = FlowTaskQuery.fromFlowTaskDuePageDto(dto);
        long now = System.currentTimeMillis();
        return this.pageQueryFlowTask(query, (PageParam)dto, t -> t.toFlowTaskDueVo(now));
    }

    private <R extends FlowTaskBaseVo> Page<R> pageQueryFlowTask(FlowTaskQuery query, PageParam pageParam, Function<FlowTaskWithBusinessKey, R> toVoFunction) {
        long count = this.flowTaskService.countFlowTaskWithBusinessKey(query);
        if (count < 1L) {
            return new Page(0, pageParam.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowTaskWithBusinessKey> tasks = this.flowTaskService.pageQueryFlowTaskWithBusinessKey(query, pageParam);
        List list = tasks.stream().map(toVoFunction).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(pageParam.getCurrent(), pageParam.getPageSize(), count, list);
    }

    public Page<MdmFlowTaskInfoVo> pageMdmFlowTaskInfo(MdmFlowTaskInfoPageDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        if (MdmFlowTaskQueryTypeEnum.MY_TODO.getCode().equals(dto.getQueryType())) {
            dto.setApproveUserId(requestUserId);
            dto.setStatus(List.of(FlowTaskStatus.RUNNING));
        } else if (MdmFlowTaskQueryTypeEnum.MY_PROCESSED.getCode().equals(dto.getQueryType())) {
            dto.setActionUserId(requestUserId);
            List<FlowTaskStatus> statusList = dto.getStatus();
            if (CollectionUtils.isEmpty((Collection)statusList)) {
                statusList = Arrays.asList(FlowTaskStatus.CANCEL_FLOW, FlowTaskStatus.COMPLETED, FlowTaskStatus.REJECTED, FlowTaskStatus.WAIVER, FlowTaskStatus.ROLLBACK_PREV, FlowTaskStatus.ROLLBACK_START, FlowTaskStatus.ROLLBACK, FlowTaskStatus.JUMPED, FlowTaskStatus.ADD_PREV_NODE);
            }
            dto.setStatus((List)statusList);
        } else {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        FlowTaskQuery query = FlowTaskQuery.fromMdmFlowTaskInfoPageDto(dto);
        long count = this.flowTaskService.countFlowTaskWithBusinessKey(query);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<FlowTaskWithBusinessKey> tasks = this.flowTaskService.pageQueryMdmFlowTaskWithBusinessKey(dto);
        Page page = new Page(dto.getCurrent(), dto.getPageSize(), count, tasks.stream().map(FlowTaskWithBusinessKey::toMdmFlowTaskInfoVo).collect(Collectors.toList()));
        this.setExtInfo(page.getDatas());
        return page;
    }

    private void setExtInfo(List<? extends FlowTaskBaseVo> flowTaskInfoVos) {
        if (flowTaskInfoVos == null || flowTaskInfoVos.isEmpty()) {
            return;
        }
        Set<Long> flowInstanceIds = flowTaskInfoVos.stream().map(FlowTaskBaseVo::getFlowInstanceId).collect(Collectors.toSet());
        List<FlowInstanceExt> extList = this.flowInstanceService.getExtFieldsByFlowInstanceIds(flowInstanceIds);
        Map<Long, List<FlowInstanceExtArray>> extArrayMap = this.flowInstanceService.getExtArrayFieldsByFlowInstanceIds(flowInstanceIds).stream().collect(Collectors.groupingBy(FlowInstanceExtArray::getFlowInstanceId));
        Map<Long, FlowInstanceExtDto> extMap = extList.stream().collect(Collectors.toMap(FlowInstanceExt::getFlowInstanceId, e -> e.toFlowInstanceExtDto((List)extArrayMap.get(e.getFlowInstanceId())), (a, b) -> a));
        flowTaskInfoVos.forEach(flowTaskInfoVo -> {
            flowTaskInfoVo.setExtFields((FlowInstanceExtDto)extMap.get(flowTaskInfoVo.getFlowInstanceId()));
            if (FlowTaskStatus.RUNNING.equals((Object)flowTaskInfoVo.getStatus()) && Boolean.TRUE.equals(flowTaskInfoVo.getReSubmit())) {
                flowTaskInfoVo.setEnableEdit(Boolean.TRUE);
                flowTaskInfoVo.setEnableApproval(Boolean.FALSE);
            } else if (FlowTaskStatus.RUNNING.equals((Object)flowTaskInfoVo.getStatus())) {
                flowTaskInfoVo.setEnableEdit(Boolean.FALSE);
                flowTaskInfoVo.setEnableApproval(Boolean.TRUE);
            } else {
                flowTaskInfoVo.setEnableEdit(Boolean.FALSE);
                flowTaskInfoVo.setEnableApproval(Boolean.FALSE);
            }
        });
    }

    public FlowTaskInfoVo getFlowTaskInfo(long id) {
        FlowTaskWithBusinessKey flowTask = this.flowTaskService.getFlowTaskWithBusinessKey(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        this.flowDataHelperService.validateViewPermission(flowTask);
        FlowTaskInfoVo flowTaskInfoVo = flowTask.toFlowTaskInfoVo();
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (approvalNodeConfig == null || approvalNodeConfig.getFormViewConfigs() == null) {
            flowTaskInfoVo.setFormViewConfigs(Collections.emptyList());
        } else {
            flowTaskInfoVo.setFormViewConfigs(approvalNodeConfig.getFormViewConfigs());
        }
        this.setExtInfo(Collections.singletonList(flowTaskInfoVo));
        return flowTaskInfoVo;
    }

    public FlowTaskAllowActionVo getFlowTaskWithAllowAction(long id) {
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (userId == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        return this.getFlowTaskWithAllowActionForUser(id, userId);
    }

    public FlowTaskAllowActionVo getFlowTaskWithAllowActionForUser(long id, long userId) {
        FlowTaskWithBusinessKey flowTask = this.flowTaskService.getFlowTaskWithBusinessKey(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        this.flowDataHelperService.validateViewPermission(flowTask);
        FlowTaskAllowActionVo vo = flowTask.toFlowTaskAllowActionVo();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId());
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInstance.getFlowProjectId());
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        boolean isAssignee = flowTask.getAssigneeUserId().equals(userId);
        boolean isOldAssignee = this.flowTaskService.isOldAssignee(flowTask.getFlowInstanceId(), userId);
        if (FlowInstanceStatus.RUNNING.equals((Object)flowInstance.getStatus())) {
            if (FlowTaskStatus.RUNNING.equals((Object)flowTask.getStatus())) {
                this.calRunningTaskAllowAction(isOldAssignee, vo, flowInstance, globalConfig, approvalNodeConfig, userId, isAssignee);
            } else if (isOldAssignee && Boolean.TRUE.equals(approvalNodeConfig.getFinAssigneeCancelAction()) && Set.of(FlowTaskStatus.COMPLETED, FlowTaskStatus.REJECTED, FlowTaskStatus.WAIVER).contains(flowTask.getStatus()) && !FlowConstant.SIGN_TYPE_SINGER_SIGN.equals(approvalNodeConfig.getSignType())) {
                vo.setFinAssigneeCancelAction(this.flowEngineService.stillAtTaskNode(flowTask.getTaskId()));
                vo.setFinAssigneeCancelActionActionName(approvalNodeConfig.getFinAssigneeCancelActionActionName());
            }
        } else if (FlowInstanceStatus.SUSPENDED.equals((Object)flowInstance.getStatus())) {
            vo.setAssigneeResume(isAssignee && Boolean.TRUE.equals(approvalNodeConfig.getAssigneeResume()));
            vo.setAssigneeResumeActionName(approvalNodeConfig.getAssigneeResumeActionName());
        }
        if (approvalNodeConfig == null || approvalNodeConfig.getFormViewConfigs() == null) {
            vo.setFormViewConfigs(Collections.emptyList());
        } else {
            vo.setFormViewConfigs(approvalNodeConfig.getFormViewConfigs());
        }
        vo.setInstanceCode(flowInstance.getInstanceCode());
        this.setExtInfo(Collections.singletonList(vo));
        if (approvalNodeConfig != null) {
            vo.setCommonApprovalOpinion(Boolean.TRUE.equals(approvalNodeConfig.getCommonApprovalOpinion()));
        }
        vo.setAddNode(this.flowInstanceService.listAddNodes(flowTask.getFlowInstanceId()).stream().anyMatch(n -> n.getNodeKey().equals(flowTask.getNodeKey())));
        return vo;
    }

    private void calRunningTaskAllowAction(boolean isOldAssignee, FlowTaskAllowActionVo vo, FlowInstance flowInstance, GlobalConfigDto globalConfig, ApprovalNodeConfigDto approvalNodeConfig, long userId, boolean isAssignee) {
        boolean isStarter = flowInstance.getStartUserId().equals(userId);
        vo.setAllowComment(Boolean.valueOf(Boolean.TRUE.equals(globalConfig.getAllowComment())));
        if (isStarter) {
            if (Boolean.TRUE.equals(approvalNodeConfig.getUseGlobalStarterConfig())) {
                vo.setStarterUrge(Boolean.TRUE.equals(globalConfig.getStarterUrge()));
                vo.setStarterUrgeActionName(globalConfig.getStarterUrgeActionName());
                vo.setStarterCancel(Boolean.TRUE.equals(globalConfig.getStarterCancel()));
                vo.setStarterCancelActionName(globalConfig.getStarterCancelActionName());
                vo.setStarterRollback(Boolean.TRUE.equals(globalConfig.getStarterRollback()));
                vo.setStarterRollbackActionName(globalConfig.getStarterRollbackActionName());
            } else {
                vo.setStarterUrge(Boolean.TRUE.equals(approvalNodeConfig.getStarterUrge()));
                vo.setStarterUrgeActionName(approvalNodeConfig.getStarterUrgeActionName());
                vo.setStarterCancel(Boolean.TRUE.equals(approvalNodeConfig.getStarterCancel()));
                vo.setStarterCancelActionName(approvalNodeConfig.getStarterCancelActionName());
                vo.setStarterRollback(Boolean.TRUE.equals(approvalNodeConfig.getStarterRollback()));
                vo.setStarterRollbackActionName(approvalNodeConfig.getStarterRollbackActionName());
            }
        }
        if (isOldAssignee) {
            vo.setFinAssigneeUrge(Boolean.TRUE.equals(approvalNodeConfig.getFinAssigneeUrge()));
            vo.setFinAssigneeUrgeActionName(approvalNodeConfig.getFinAssigneeUrgeActionName());
        }
        if (isAssignee) {
            vo.setAssigneeApprove(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeApprove()));
            vo.setAssigneeApproveActionName(approvalNodeConfig.getAssigneeApproveActionName());
            vo.setAssigneeReject(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeReject()));
            vo.setAssigneeRejectActionName(approvalNodeConfig.getAssigneeRejectActionName());
            vo.setAssigneeCancel(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeCancel()));
            vo.setAssigneeCancelActionName(approvalNodeConfig.getAssigneeCancelActionName());
            vo.setAssigneeAdd(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeAdd()));
            vo.setAssigneeAddActionName(approvalNodeConfig.getAssigneeAddActionName());
            vo.setAssigneeAddNode(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeAddNode()));
            vo.setAssigneeAddNodeActionName(approvalNodeConfig.getAssigneeAddNodeActionName());
            vo.setAssigneeChange(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeChange()));
            vo.setAssigneeChangeActionName(approvalNodeConfig.getAssigneeChangeActionName());
            vo.setAssigneeJump(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeJump()));
            vo.setAssigneeJumpActionName(approvalNodeConfig.getAssigneeJumpActionName());
            vo.setAssigneePause(Boolean.TRUE.equals(approvalNodeConfig.getAssigneePause()));
            vo.setAssigneePauseActionName(approvalNodeConfig.getAssigneePauseActionName());
            vo.setAssigneeRollbackPrev(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeRollbackPrev()));
            vo.setAssigneeRollbackPrevActionName(approvalNodeConfig.getAssigneeRollbackPrevActionName());
            vo.setAssigneeRollbackStart(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeRollbackStart()));
            vo.setAssigneeRollbackStartActionName(approvalNodeConfig.getAssigneeRollbackStartActionName());
            vo.setAssigneeRollbackTo(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeRollbackTo()));
            vo.setAssigneeRollbackToActionName(approvalNodeConfig.getAssigneeRollbackToActionName());
            vo.setAssigneeStarterFill(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeStarterFill()));
            vo.setAssigneeStarterFillActionName(approvalNodeConfig.getAssigneeStarterFillActionName());
            vo.setAssigneeCc(Boolean.TRUE.equals(approvalNodeConfig.getAssigneeCc()));
            vo.setAssigneeCcActionName(approvalNodeConfig.getAssigneeCcActionName());
        }
    }

    public void signWaiver(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeWaiver);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeWaiver);
        this.flowEngineService.signWaiver(flowTask.getTaskId(), dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminSignWaiver(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        this.flowEngineService.signWaiver(flowTask.getTaskId(), (FlowTaskActionDto)dto);
    }

    public void starterUrge(FlowUrgeDto flowUrgeDto) {
        ArrayList<FlowTask> flowTasks = new ArrayList<FlowTask>();
        ArrayList<FlowInstance> flowInstances = new ArrayList<FlowInstance>();
        this.prepareFlowUrge(flowUrgeDto, flowTasks, flowInstances);
        this.doFlowUrge(flowTasks, flowInstances, FlowUrgeType.STARTER_URGE.getType(), flowUrgeDto.getOpinion(), flowUrgeDto.getAttachmentInfoList());
    }

    public void finAssigneeUrge(FlowUrgeDto flowUrgeDto) {
        ArrayList<FlowTask> flowTasks = new ArrayList<FlowTask>();
        ArrayList<FlowInstance> flowInstances = new ArrayList<FlowInstance>();
        this.prepareFlowUrge(flowUrgeDto, flowTasks, flowInstances);
        this.doFlowUrge(flowTasks, flowInstances, FlowUrgeType.FIN_ASSIGNEE_URGE.getType(), flowUrgeDto.getOpinion(), flowUrgeDto.getAttachmentInfoList());
    }

    public void adminUrge(FlowTaskAdminUrgeDto dto) {
        boolean emptyStarterTemplate;
        boolean urgeAssignee = Boolean.TRUE.equals(dto.getUrgeAssignee());
        boolean urgeStarter = Boolean.TRUE.equals(dto.getUrgeStarter());
        boolean emptyAssigneeTemplate = urgeAssignee && (dto.getAssigneeTemplateDtoList() == null || dto.getAssigneeTemplateDtoList().isEmpty());
        boolean bl = emptyStarterTemplate = urgeStarter && (dto.getStarterTemplateDtoList() == null || dto.getStarterTemplateDtoList().isEmpty());
        if (emptyAssigneeTemplate || emptyStarterTemplate) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_URGE_TEMPLATE_EMPTY);
        }
        FlowTask flowTask = this.getRunningFlowTask(dto.getFlowTaskId());
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId());
        this.doUrge(flowTask, flowInstance, dto.getAssigneeTemplateDtoList(), dto.getStarterTemplateDtoList(), UrgeSourceType.ADMIN, urgeAssignee, urgeStarter, true, dto.getOpinion(), dto.getAttachmentInfoList());
    }

    private void prepareFlowUrge(FlowUrgeDto flowUrgeDto, List<FlowTask> flowTasks, List<FlowInstance> flowInstances) {
        Long flowInstanceId = flowUrgeDto.getFlowInstanceId();
        Long flowTaskId = flowUrgeDto.getFlowTaskId();
        if (null != flowTaskId) {
            tempFlowTasks = this.flowTaskService.findByIdAndStatus(flowTaskId, FlowTaskStatus.RUNNING.name());
            flowTasks.addAll(tempFlowTasks);
        } else if (null != flowInstanceId) {
            tempFlowTasks = this.flowTaskService.findByFlowInstanceIdAndStatus(flowInstanceId, FlowTaskStatus.RUNNING.name());
            flowTasks.addAll(tempFlowTasks);
        }
        if (CollectionUtils.isEmpty(flowTasks)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_NOT_RUNNING);
        }
        List<Long> flowInstanceIds = flowTasks.stream().map(FlowTask::getFlowInstanceId).collect(Collectors.toList());
        List<FlowInstance> tempFlowInstances = this.flowInstanceService.batchGetFlowInstanceByStatus(flowInstanceIds, FlowTaskStatus.RUNNING.name());
        if (CollectionUtils.isEmpty(tempFlowInstances)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_NOT_RUNNING);
        }
        flowInstances.addAll(tempFlowInstances);
    }

    private void doFlowUrge(List<FlowTask> flowTasks, List<FlowInstance> flowInstances, String flowUrgeType, String opinion, List<AttachmentInfo> attachmentInfo) {
        if (flowTasks.isEmpty()) {
            return;
        }
        Map<Long, FlowInstance> flowInstanceMap = flowInstances.stream().collect(Collectors.toMap(Entity::getId, o -> o));
        HashSet successPushSet = new HashSet();
        StringBuilder stringBuilder = new StringBuilder();
        flowTasks.forEach(task -> {
            String result = this.doUrgeTask(flowUrgeType, flowInstanceMap, (FlowTask)((Object)task), opinion, attachmentInfo);
            if (result == null) {
                successPushSet.add((Long)task.getId());
            } else {
                stringBuilder.append(result);
            }
        });
        if (successPushSet.isEmpty()) {
            throw new BaseI18nException(FlowErrorCode.FLOW_PROJECT_URGE_FAIL.getCode(), stringBuilder.toString());
        }
    }

    private String doUrgeTask(String flowUrgeType, Map<Long, FlowInstance> flowInstanceMap, FlowTask task, String opinion, List<AttachmentInfo> attachmentInfo) {
        List templateDtoList;
        Boolean canUrge;
        UrgeSourceType urgeSourceType;
        FlowInstance flowInstance = flowInstanceMap.get(task.getFlowInstanceId());
        if (null == flowInstance) {
            this.logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6b63\u5728\u8fd0\u884c\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff01id:{}, taskId:{},flowInstanceId:{}", new Object[]{task.getId(), task.getTaskId(), task.getFlowInstanceId()});
            return "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6b63\u5728\u8fd0\u884c\u7684\u6d41\u7a0b\u5b9e\u4f8b";
        }
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task, flowInstance.getFlowProjectId());
        if (FlowUrgeType.STARTER_URGE.getType().equals(flowUrgeType)) {
            urgeSourceType = UrgeSourceType.STARTER;
            canUrge = approvalNodeConfig.getStarterUrge();
            templateDtoList = approvalNodeConfig.getStarterUrgeTemplate();
            if (templateDtoList == null || templateDtoList.isEmpty()) {
                this.logger.warn("\u8282\u70b9\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u9009\u62e9\u201c\u521b\u5efa\u4eba\u50ac\u529e\u6d88\u606f\u4e8b\u4ef6\u6a21\u677f\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\uff01id:{}, taskId:{},flowInstanceId:{}", new Object[]{task.getId(), task.getTaskId(), task.getFlowInstanceId()});
                return "\u8282\u70b9[" + task.getNodeKey() + "]\u7684\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u586b\u5199\u201c\u521b\u5efa\u4eba\u50ac\u529e\u6d88\u606f\u4e8b\u4ef6\u7f16\u7801\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e;";
            }
        } else {
            urgeSourceType = UrgeSourceType.FIN_ASSIGNEE;
            canUrge = approvalNodeConfig.getFinAssigneeUrge();
            templateDtoList = approvalNodeConfig.getFinAssigneeUrgeTemplate();
            if (templateDtoList == null || templateDtoList.isEmpty()) {
                this.logger.warn("\u8282\u70b9\u7684\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u9009\u62e9\u201c\u5df2\u5ba1\u6279\u4eba\u50ac\u529e\u6d88\u606f\u4e8b\u4ef6\u6a21\u677f\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\uff01id:{}, taskId:{},flowInstanceId:{}", new Object[]{task.getId(), task.getTaskId(), task.getFlowInstanceId()});
                return "\u8282\u70b9[" + task.getNodeKey() + "]\u7684\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u586b\u5199\u201c\u5df2\u5ba1\u6279\u4eba\u50ac\u529e\u6d88\u606f\u4e8b\u4ef6\u7f16\u7801\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e;";
            }
        }
        if (null == canUrge || !canUrge.booleanValue()) {
            this.logger.warn("\u8282\u70b9\u7684\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u5426\u52fe\u9009\u5bf9\u5e94\u7684\u50ac\u529e\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\uff01id:{}, taskId:{},flowInstanceId:{}", new Object[]{task.getId(), task.getTaskId(), task.getFlowInstanceId()});
            return "\u8282\u70b9[" + task.getNodeKey() + "]\u7684\u5ba1\u6279\u914d\u7f6e\u5185\u672a\u5426\u52fe\u9009\u5bf9\u5e94\u7684\u50ac\u529e\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e;";
        }
        this.doUrge(task, flowInstance, templateDtoList, templateDtoList, urgeSourceType, true, false, false, opinion, attachmentInfo);
        return null;
    }

    private void doUrge(FlowTask task, FlowInstance flowInstance, List<EventTemplateDto> assigneeTemplateDtoList, List<EventTemplateDto> starterTemplateDtoList, UrgeSourceType urgeSourceType, boolean urgeAssignee, boolean urgeStarter, boolean adminUrge, String opinion, List<AttachmentInfo> attachmentInfo) {
        List messageTemplateCodes;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByTaskId(task.getTaskId()));
        paramsMap.put("flowTask", (Object)task);
        EventPushDto eventPushDto = new EventPushDto();
        eventPushDto.setTenantId(task.getTenantId());
        eventPushDto.setInstanceId(task.getAppInstanceId());
        eventPushDto.setEventCode("FLOW_URGE");
        eventPushDto.setParamsMap(paramsMap);
        StringBuilder messageTemplateCodesBuilder = new StringBuilder();
        if (urgeAssignee) {
            messageTemplateCodes = assigneeTemplateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
            eventPushDto.setMessageTemplateCodes(messageTemplateCodes);
            eventPushDto.setUserId(task.getAssigneeUserId());
            eventPushDto.setUserName(task.getAssigneeUserName());
            this.frameworkEventService.pushEvent((FrameworkEvent)eventPushDto);
            messageTemplateCodesBuilder.append(String.join((CharSequence)",", messageTemplateCodes));
        }
        if (urgeStarter) {
            messageTemplateCodes = starterTemplateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
            eventPushDto.setMessageTemplateCodes(messageTemplateCodes);
            eventPushDto.setUserId(flowInstance.getStartUserId());
            eventPushDto.setUserName(flowInstance.getStartUserName());
            this.frameworkEventService.pushEvent((FrameworkEvent)eventPushDto);
            if (messageTemplateCodesBuilder.length() > 0) {
                messageTemplateCodesBuilder.append("|");
            }
            messageTemplateCodesBuilder.append(String.join((CharSequence)",", messageTemplateCodes));
        }
        FlowUrgeLog flowUrgeLog = new FlowUrgeLog();
        flowUrgeLog.setFlowInstanceId(task.getFlowInstanceId());
        flowUrgeLog.setFlowTaskId((Long)task.getId());
        flowUrgeLog.setLogType(UrgeLogType.TASK);
        flowUrgeLog.setSourceType(urgeSourceType);
        flowUrgeLog.setTemplateCodes(messageTemplateCodesBuilder.toString());
        flowUrgeLog.setUrgeAssignee(urgeAssignee);
        if (urgeAssignee) {
            flowUrgeLog.setAssigneeId(task.getAssigneeUserId());
            flowUrgeLog.setAssigneeName(task.getAssigneeUserName());
        } else {
            flowUrgeLog.setAssigneeId(FlowConstant.EMPTY_ID_VALUE);
            flowUrgeLog.setAssigneeName("");
        }
        flowUrgeLog.setUrgeStarter(urgeStarter);
        if (urgeStarter) {
            flowUrgeLog.setStarterId(flowInstance.getStartUserId());
            flowUrgeLog.setStarterName(flowInstance.getStartUserName());
        } else {
            flowUrgeLog.setStarterId(FlowConstant.EMPTY_ID_VALUE);
            flowUrgeLog.setStarterName("");
        }
        flowUrgeLog.setUrgeSpecialUser(false);
        flowUrgeLog.setSpecialUsers("");
        flowUrgeLog.setOpinion(opinion);
        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
        FlowLog flowLog = new FlowLog();
        flowLog.taskInit(task);
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.URGE_TASK);
        flowLog.setOpinion(opinion);
        flowLog.setAttachmentInfoByList(attachmentInfo);
        flowLog.setAdminFlag(adminUrge);
        this.flowLogService.createFlowLog(flowLog);
        this.flowTaskService.addUrgeTimes((Long)task.getId());
    }

    public void suspendFlowInstance(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneePause);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneePause);
        Long flowInstanceId = flowTask.getFlowInstanceId();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId);
        switch (flowInstance.getStatus()) {
            case RUNNING: {
                this.flowEngineService.suspendProcessInstance(flowInstance, dto);
                OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
                break;
            }
            case SUSPENDED: {
                break;
            }
            default: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
            }
        }
    }

    public void activeFlowInstance(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeResume);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeResume);
        Long flowInstanceId = flowTask.getFlowInstanceId();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId);
        switch (flowInstance.getStatus()) {
            case RUNNING: {
                break;
            }
            case SUSPENDED: {
                this.flowEngineService.activeProcessInstance(flowInstance, dto);
                OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
                break;
            }
            default: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_STATUS_ERROR);
            }
        }
    }

    public void cancelFlowInstance(FlowTaskActionDto dto) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeCancel);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeCancel);
        this.flowEngineService.cancelProcessInstanceByTask(flowTask, dto.getOpinion(), dto.getVariables(), dto.getAttachmentInfo());
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public Map<String, Object> getVariables(GetVariablesDto dto) {
        FlowInstance flowInstance;
        FlowTask flowTask = this.flowTaskService.getFlowTask(dto.getId());
        if (flowTask == null) {
            return Collections.emptyMap();
        }
        Map variables = Collections.emptyMap();
        if (flowTask.alreadyFinish() && (flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId())).alreadyFinish()) {
            variables = this.flowHisService.getVariableMapByFlowInstanceId(flowTask.getFlowInstanceId(), (Long)flowTask.getId());
        }
        if (variables.isEmpty()) {
            variables = this.flowEngineService.getVariablesByTaskId(flowTask.getTaskId());
        }
        if (!dto.getKeys().isEmpty()) {
            variables = variables.entrySet().stream().filter(entry -> dto.getKeys().contains(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        }
        return variables;
    }

    public void addNode(FlowTaskAddNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(flowTask, ApprovalNodeConfigDto::getAssigneeAddNode);
        FlowTaskActionDto flowTaskActionDto = new FlowTaskActionDto();
        flowTaskActionDto.setFlowTaskId(dto.getFlowTaskId());
        flowTaskActionDto.setOpinion(dto.getOpinion());
        this.opinionVerification(flowTaskActionDto, OpinionCheckActionDto::getAssigneeAddNode);
        this.calAddNodeAssignees(dto);
        this.checkAddNode(flowTask, dto.getAssigneeUsers().stream().map(IdNameDto::getId).collect(Collectors.toList()));
        if (FlowConstant.ADD_NODE_TYPE_PREV.equals(dto.getAddType())) {
            this.flowEngineService.addPrevNode(flowTask.getTaskId(), dto);
        } else if (FlowConstant.ADD_NODE_TYPE_NEXT.equals(dto.getAddType())) {
            this.flowEngineService.addNextNode(flowTask.getTaskId(), dto);
        }
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    private void calAddNodeAssignees(FlowTaskAddNodeDto dto) {
        boolean hasUser;
        boolean bl = hasUser = dto.getAssigneeUsers() != null && !dto.getAssigneeUsers().isEmpty();
        if (!hasUser) {
            boolean hasUserId;
            boolean bl2 = hasUserId = dto.getAssigneeUserIds() != null && !dto.getAssigneeUserIds().isEmpty();
            if (!hasUserId) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ADD_NODE_USER_EMPTY);
            }
            Map<Long, String> userNameMap = this.userHelperService.getUserNameMap(new HashSet<Long>(dto.getAssigneeUserIds()));
            dto.setAssigneeUsers(dto.getAssigneeUserIds().stream().map(id -> new IdNameDto(id, userNameMap.getOrDefault(id, ""))).collect(Collectors.toList()));
        }
    }

    public void adminAddNode(FlowTaskAdminAddNodeDto dto) {
        FlowTaskWithProject flowTask = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.calAddNodeAssignees((FlowTaskAddNodeDto)dto);
        if (FlowConstant.ADD_NODE_TYPE_PREV.equals(dto.getAddType())) {
            this.flowEngineService.addPrevNode(flowTask.getTaskId(), (FlowTaskAddNodeDto)dto);
        } else if (FlowConstant.ADD_NODE_TYPE_NEXT.equals(dto.getAddType())) {
            this.flowEngineService.addNextNode(flowTask.getTaskId(), (FlowTaskAddNodeDto)dto);
        }
    }

    public List<IdNameDto> allowAddNodeUsers(long id) {
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskWithProject(id);
        if (flowTask == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ID_NOT_EXISTED);
        }
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (approvalNodeConfig == null || approvalNodeConfig.getAllowAddNodeUsers() == null) {
            return Collections.emptyList();
        }
        return approvalNodeConfig.getAllowAddNodeUsers();
    }

    private void checkAddNode(FlowTaskWithProject flowTask, List<Long> assigneeUserIds) {
        ApprovalNodeConfigDto approvalNodeConfigDto = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        if (null == approvalNodeConfigDto) {
            this.logger.warn("approvalNodeConfigDto\u627e\u4e0d\u5230");
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ADD_NODE_USER_NOT_IN);
        }
        List allowAssigneeUserIds = approvalNodeConfigDto.getAllowAddNodeUsers();
        if (CollectionUtils.isEmpty((Collection)allowAssigneeUserIds)) {
            return;
        }
        Set userIdSet = allowAssigneeUserIds.stream().map(IdNameDto::getId).collect(Collectors.toSet());
        if (!userIdSet.containsAll(assigneeUserIds)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_TASK_ADD_NODE_USER_NOT_IN);
        }
    }

    private void checkOperatePermitThrowException(FlowTaskWithProject flowTask, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        this.checkOperatePermitThrowException(flowTask, approvalNodeConfig, loadConfigFunction);
    }

    private void checkOperatePermitThrowException(FlowTask flowTask, ApprovalNodeConfigDto approvalNodeConfigDto, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        if (!this.checkOperatePermit(flowTask, approvalNodeConfigDto, loadConfigFunction)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPERATE_HAS_NOT_AUTHORIZED);
        }
    }

    private boolean checkOperatePermit(FlowTaskWithProject flowTask, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask);
        return this.checkOperatePermit(flowTask, approvalNodeConfig, loadConfigFunction);
    }

    private boolean checkOperatePermit(FlowTask flowTask, ApprovalNodeConfigDto approvalNodeConfigDto, Function<ApprovalNodeConfigDto, Boolean> loadConfigFunction) {
        if (!this.flowBaseContextProperties.isSkipUserPermitCheck()) {
            Long currentUserId = ServiceContext.getContext().getRequestUserId();
            if (currentUserId == null) {
                return false;
            }
            Long assigneeUserId = flowTask.getAssigneeUserId();
            Long ownerUserId = flowTask.getOwnerUserId();
            boolean allowOwnerApprove = Boolean.TRUE.equals(flowTask.getAllowOwnerApprove());
            if (!(currentUserId.equals(assigneeUserId) || allowOwnerApprove && currentUserId.equals(ownerUserId))) {
                return false;
            }
        }
        if (this.flowBaseContextProperties.isSkipActionPermitCheck()) {
            return true;
        }
        if (approvalNodeConfigDto == null) {
            return false;
        }
        return Boolean.TRUE.equals(loadConfigFunction.apply(approvalNodeConfigDto));
    }

    public Page<FlowTaskTodoPageVo> myTodo(FlowTaskTodoPageDto dto) {
        Date now = new Date();
        FlowTaskQuery query = FlowTaskQuery.fromFlowTaskTodoPageDto(dto);
        Long loginUserId = ServiceContext.getContext().getRequestUserId();
        query.setApproveUserId(loginUserId);
        long countResult = this.flowTaskService.countFlowTaskWithBusinessKey(query);
        if (countResult < 1L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List list = this.flowTaskService.pageQueryFlowTaskWithBusinessKey(query, (PageParam)dto).stream().map(t -> t.toFlowTaskTodoPageVo(now)).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(dto.getCurrent(), dto.getPageSize(), countResult, list);
    }

    public Page<FlowTaskTodoPageVo> myDraft(FlowTaskTodoPageDto dto) {
        Date now = new Date();
        FlowTaskQuery query = FlowTaskQuery.fromFlowTaskDraftPageDto(dto, ServiceContext.getContext().getRequestUserId());
        long countResult = this.flowTaskService.countFlowTaskWithBusinessKey(query);
        if (countResult < 1L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List list = this.flowTaskService.pageQueryFlowTaskWithBusinessKey(query, (PageParam)dto).stream().map(t -> t.toFlowTaskTodoPageVo(now)).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(dto.getCurrent(), dto.getPageSize(), countResult, list);
    }

    public Page<FlowTaskHandledPageVo> myHandled(FlowTaskHandledPageDto dto) {
        Date now = new Date();
        FlowTaskQuery query = FlowTaskQuery.fromFlowTaskHandledPageDto(dto);
        Long loginUserId = ServiceContext.getContext().getRequestUserId();
        query.setActionUserId(loginUserId);
        long countResult = this.flowTaskService.countFlowTaskWithBusinessKey(query);
        if (countResult < 1L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List list = this.flowTaskService.pageQueryFlowTaskWithBusinessKey(query, (PageParam)dto).stream().map(t -> t.toFlowTaskHandledPageVo(now)).collect(Collectors.toList());
        this.setExtInfo(list);
        return new Page(dto.getCurrent(), dto.getPageSize(), countResult, list);
    }

    public NodeFormFieldConfigVo loadFormFieldConfig(long taskId) {
        FlowTaskWithProject flowTaskWithProject = this.flowTaskService.getFlowTaskWithProject(taskId);
        if (flowTaskWithProject == null || StringUtils.isBlank((CharSequence)flowTaskWithProject.getFormEntityCode())) {
            NodeFormFieldConfigVo vo = new NodeFormFieldConfigVo();
            vo.setFieldConfigs(Collections.emptyMap());
            vo.setFieldGroupConfigs(Collections.emptyMap());
            vo.setSubFormConfigs(Collections.emptyList());
            return vo;
        }
        String entityCode = flowTaskWithProject.getFormEntityCode();
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTaskWithProject);
        return this.roleFieldAuthHelperService.convertNodeFormFieldConfigVo(entityCode, approvalNodeConfig);
    }

    public void starterFill(FlowTaskActionDto dto) {
        FlowTaskWithProject task = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.checkOperatePermitThrowException(task, ApprovalNodeConfigDto::getAssigneeStarterFill);
        this.opinionVerification(dto, OpinionCheckActionDto::getAssigneeStarterFill);
        this.flowEngineService.starterFill(task, dto);
        OpinionUtils.savaSelfOpinion(this.opinionAssociationService, dto.getOpinion(), dto.getSavaOpinion());
    }

    public void adminStarterFill(FlowTaskAdminActionDto dto) {
        FlowTaskWithProject task = this.getRunningFlowTaskWithProject(dto.getFlowTaskId());
        this.flowEngineService.starterFill(task, (FlowTaskActionDto)dto);
    }
}

