/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.application.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.BeanUtils;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.opinion.OpinionPoolApi;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolCreateDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolModifyDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolPageDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionSelfCreateDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionSelfModifyDto;
import com.cyberway.mp.flow.api.opinion.enums.OpinionPoolStatus;
import com.cyberway.mp.flow.api.opinion.vo.OpinionAssociationVo;
import com.cyberway.mp.flow.api.opinion.vo.OpinionPoolDetailsVo;
import com.cyberway.mp.flow.api.opinion.vo.OpinionPoolVo;
import com.cyberway.mp.flow.domain.category.service.FlowCategoryService;
import com.cyberway.mp.flow.domain.opinion.entity.OpinionAssociation;
import com.cyberway.mp.flow.domain.opinion.entity.OpinionPool;
import com.cyberway.mp.flow.domain.opinion.repository.query.OpinionPoolQuery;
import com.cyberway.mp.flow.domain.opinion.service.OpinionAssociationService;
import com.cyberway.mp.flow.domain.opinion.service.OpinionPoolService;
import io.seata.spring.annotation.GlobalTransactional;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class OpinionPoolApplicationService
implements OpinionPoolApi {
    private final OpinionPoolService opinionPoolService;
    private final OpinionAssociationService opinionAssociationService;
    private final FlowCategoryService flowCategoryService;

    public OpinionPoolApplicationService(OpinionPoolService opinionPoolService, OpinionAssociationService opinionAssociationService, FlowCategoryService flowCategoryService) {
        this.opinionPoolService = opinionPoolService;
        this.opinionAssociationService = opinionAssociationService;
        this.flowCategoryService = flowCategoryService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createOpinionPool(@Valid OpinionPoolCreateDto dto) {
        OpinionPool entity = OpinionPool.fromOpinionPoolCreateDto(dto);
        List<OpinionPool> opinionPoolList = this.opinionPoolService.findByNameOrOpinionPoolCode(dto.getName(), dto.getOpinionPoolCode());
        for (OpinionPool pool : opinionPoolList) {
            if (pool.getOpinionPoolCode().equals(dto.getOpinionPoolCode())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_CODE_ALREADY_EXISTS);
            }
            if (!pool.getName().equals(dto.getName())) continue;
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_NAME_ALREADY_EXISTS);
        }
        entity.setStatus(OpinionPoolStatus.ENABLED.name());
        entity.setOpinionNumber(dto.getOpinionList().size());
        this.opinionPoolService.createOpinionPool(entity);
        this.opinionAssociationService.batchSaveOpinions((Long)entity.getId(), dto.getOpinionList());
        return (Long)entity.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void modifyOpinionPool(@Valid OpinionPoolModifyDto dto) {
        OpinionPool entity = this.opinionPoolService.getOpinionPool(dto.getId());
        if (entity == null) {
            throw new BaseException("00000001", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List<OpinionPool> opinionPoolList = this.opinionPoolService.findByIdNotAndNameOrOpinionPoolCodeAndIdNot(dto.getId(), dto.getName(), dto.getOpinionPoolCode());
        for (OpinionPool pool : opinionPoolList) {
            if (pool.getOpinionPoolCode().equals(dto.getOpinionPoolCode())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_CODE_ALREADY_EXISTS);
            }
            if (!pool.getName().equals(dto.getName())) continue;
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_NAME_ALREADY_EXISTS);
        }
        entity.update(dto);
        entity.setOpinionNumber(dto.getOpinionList().size());
        this.opinionPoolService.modifyOpinionPool(entity);
        this.opinionAssociationService.batchModifyOpinions((Long)entity.getId(), dto.getOpinionList());
    }

    public OpinionPoolDetailsVo getOpinionPool(long id) {
        OpinionPool entity = this.opinionPoolService.getOpinionPool(id);
        if (entity == null) {
            return null;
        }
        List<OpinionAssociation> opinionAssociationList = this.opinionAssociationService.getOpinionAssociation(id);
        ArrayList<OpinionAssociationVo> list = new ArrayList<OpinionAssociationVo>();
        for (OpinionAssociation opinionAssociation : opinionAssociationList) {
            OpinionAssociationVo opinionAssociationVo = new OpinionAssociationVo();
            BeanUtils.copyProperties((Object)opinionAssociationVo, (Object)((Object)opinionAssociation));
            opinionAssociationVo.setId((Long)opinionAssociation.getId());
            list.add(opinionAssociationVo);
        }
        OpinionPoolDetailsVo opinionPoolDetailsVo = entity.toOpinionPoolDetailsVo();
        opinionPoolDetailsVo.setOpinionList(list);
        return opinionPoolDetailsVo;
    }

    public Page<OpinionPoolVo> queryOpinionPool(OpinionPoolPageDto dto) {
        OpinionPoolQuery query = OpinionPoolQuery.fromOpinionPoolPageDto(dto);
        long count = this.opinionPoolService.countOpinionPool(query);
        if (count < 1L) {
            return new Page(0, dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<OpinionPool> entityList = this.opinionPoolService.pageQueryOpinionPool(query, (PageParam)dto);
        List voList = entityList.stream().map(OpinionPool::toOpinionPoolVo).collect(Collectors.toList());
        this.flowCategoryService.batchGetFlowCategory(entityList.stream().map(OpinionPool::getFlowCategory).collect(Collectors.toList())).forEach(flowCategory -> {
            for (OpinionPoolVo opinionPoolVo : voList) {
                if (!((Long)flowCategory.getId()).equals(opinionPoolVo.getFlowCategory())) continue;
                opinionPoolVo.setFlowCategoryName(flowCategory.getName());
            }
        });
        return new Page(dto.getCurrent(), dto.getPageSize(), count, voList);
    }

    public List<OpinionPoolDetailsVo> getCommonOpinion(long flowCategoryId) {
        List<OpinionPool> opinionPoolList = this.opinionPoolService.findByStatusAndFlowCategoryOrderByDisplayOrderDesc(flowCategoryId);
        if (opinionPoolList == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_ANY_NOT_EXIST);
        }
        List<OpinionPoolDetailsVo> list = opinionPoolList.stream().map(opinionPool -> {
            OpinionPoolDetailsVo vo = new OpinionPoolDetailsVo();
            List opinionVoList = this.opinionAssociationService.getOpinionAssociation((Long)opinionPool.getId()).stream().map(opinionAssociation -> {
                OpinionAssociationVo opinionAssociationVo = new OpinionAssociationVo();
                BeanUtils.copyProperties((Object)opinionAssociationVo, (Object)opinionAssociation);
                opinionAssociationVo.setId((Long)opinionAssociation.getId());
                return opinionAssociationVo;
            }).collect(Collectors.toList());
            vo.setOpinionList(opinionVoList);
            BeanUtils.copyProperties((Object)vo, (Object)opinionPool);
            vo.setId((Long)opinionPool.getId());
            return vo;
        }).collect(Collectors.toList());
        this.flowCategoryService.batchGetFlowCategory(list.stream().map(OpinionPoolVo::getFlowCategory).collect(Collectors.toList())).forEach(flowCategory -> {
            for (OpinionPoolDetailsVo opinionPoolVo : list) {
                if (!((Long)flowCategory.getId()).equals(opinionPoolVo.getFlowCategory())) continue;
                opinionPoolVo.setFlowCategoryName(flowCategory.getName());
            }
        });
        OpinionPoolDetailsVo vo = new OpinionPoolDetailsVo();
        vo.setId(Long.valueOf(0L));
        vo.setFlowCategoryName("\u4e2a\u4eba\u610f\u89c1");
        vo.setOpinionList(this.getOpinionSelf());
        list.add(0, vo);
        return list;
    }

    public List<OpinionAssociationVo> getOpinionSelf() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        List<OpinionAssociation> list = this.opinionAssociationService.findByUserIdOrderByDisplayOrderDesc(userId);
        return list.stream().map(entity -> {
            OpinionAssociationVo vo = new OpinionAssociationVo();
            BeanUtils.copyProperties((Object)vo, (Object)entity);
            vo.setId((Long)entity.getId());
            return vo;
        }).collect(Collectors.toList());
    }

    public void modifyOpinionSelf(OpinionSelfModifyDto dto) {
        OpinionAssociation entity = this.opinionAssociationService.getOpinionSelf(dto.getId());
        if (entity == null) {
            throw new BaseException("00000001", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        entity.update(dto);
        this.opinionAssociationService.modifyOpinionAssociation(entity);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteOpinionSelf(long id) {
        this.opinionAssociationService.deleteOpinion(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public long createOpinionSelf(OpinionSelfCreateDto dto) {
        Long userId = ServiceContext.getContext().getRequestUserId();
        OpinionAssociation entity = new OpinionAssociation();
        entity.setOpinion(dto.getOpinion());
        entity.setOpinionPoolId(0L);
        entity.setDisplayOrder(0);
        entity.setUserId(userId);
        this.opinionAssociationService.createOpinionAssociation(entity);
        return (Long)entity.getId();
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void deleteOpinionPool(long id) {
        this.opinionPoolService.deleteOpinionPool(id);
        this.opinionAssociationService.deleteOpinionAssociation(id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void enableOpinionPool(long id) {
        OpinionPool opinionPool = this.opinionPoolService.getOpinionPool(id);
        if (!Objects.equals(opinionPool.getStatus(), OpinionPoolStatus.DISABLED.name())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_ALREADY_ENABLED);
        }
        opinionPool.setStatus(OpinionPoolStatus.ENABLED.name());
        this.opinionPoolService.enableOpinionPool(opinionPool, id);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public void disableOpinionPool(long id) {
        OpinionPool opinionPool = this.opinionPoolService.getOpinionPool(id);
        if (!Objects.equals(opinionPool.getStatus(), OpinionPoolStatus.ENABLED.name())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.OPINION_POOL_ALREADY_DISABLED);
        }
        opinionPool.setStatus(OpinionPoolStatus.DISABLED.name());
        this.opinionPoolService.disableOpinionPool(opinionPool, id);
    }
}

