/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.category.entity;

import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryCreateDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryModifyBaseDto;
import com.cyberway.mp.flow.api.category.vo.FlowCategoryListVo;
import com.cyberway.mp.flow.api.category.vo.FlowCategoryTreeVo;
import java.util.ArrayList;

@Table(name="fc_flow_category")
public class FlowCategory
extends BusinessEntityWithAppInstance {
    private String codeName;
    private String name;
    private String description;
    private Long parentId;
    private String allParentId;
    private Integer sortOrder;

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getAllParentId() {
        return this.allParentId;
    }

    public void setAllParentId(String allParentId) {
        this.allParentId = allParentId;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public static FlowCategory fromFlowCategoryCreateDto(FlowCategoryCreateDto dto) {
        FlowCategory flowCategory = new FlowCategory();
        flowCategory.setCodeName(dto.getCodeName());
        flowCategory.setName(dto.getName());
        flowCategory.setDescription(dto.getDescription());
        flowCategory.setParentId(dto.getParentId());
        if (dto.getSortOrder() == null) {
            flowCategory.setSortOrder(999);
        } else {
            flowCategory.setSortOrder(dto.getSortOrder());
        }
        return flowCategory;
    }

    public void update(FlowCategoryModifyBaseDto dto) {
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setParentId(dto.getParentId());
        this.setSortOrder(dto.getSortOrder());
    }

    public FlowCategoryTreeVo toFlowCategoryTreeVo() {
        FlowCategoryTreeVo vo = new FlowCategoryTreeVo();
        vo.setId((Long)this.getId());
        vo.setCodeName(this.getCodeName());
        vo.setName(this.getName());
        vo.setSortOrder(this.getSortOrder());
        vo.setChildren(new ArrayList());
        return vo;
    }

    public FlowCategoryListVo toFlowCategoryListVo() {
        FlowCategoryListVo vo = new FlowCategoryListVo();
        vo.setId((Long)this.getId());
        vo.setCodeName(this.getCodeName());
        vo.setName(this.getName());
        vo.setParentId(this.getParentId());
        vo.setDescription(this.getDescription());
        vo.setSortOrder(this.getSortOrder());
        vo.setChildren(new ArrayList());
        return vo;
    }
}

